/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoaderContext {
    private static final Logger LOG = Logger.getInstance(LoaderContext.class);
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private ErrorHandler myErrorHandler;
    private final THashSet<Object> mySelection;
    private Object mySelectedElement;
    private boolean myNamespacesOnly;
    private final IntrospectionScopeUpdater myScopeUpdater;

    public static LoaderContext loadAll(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(1);
        }
        return new LoaderContext(project, dataSource).includeAllSchemas();
    }

    public LoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(2);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(3);
        }
        this.myErrorHandler = new ErrorHandler();
        this.mySelection = new THashSet();
        this.myNamespacesOnly = false;
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myProject = project;
        this.myDataSource = dataSource;
    }

    @NotNull
    public LoaderContext merge(@NotNull LoaderContext context) {
        if (context == null) {
            LoaderContext.$$$reportNull$$$0(4);
        }
        if (this.myProject != context.myProject || this.myDataSource != context.myDataSource) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Merging different contexts");
            } else {
                LOG.warn("Merging different contexts");
            }
        }
        LoaderContext result2 = new LoaderContext(this.myProject, this.myDataSource);
        result2.mySelection.addAll(this.mySelection);
        result2.mySelection.addAll(context.mySelection);
        result2.mySelectedElement = ObjectUtils.chooseNotNull((Object)this.mySelectedElement, (Object)context.mySelectedElement);
        result2.myNamespacesOnly = this.myNamespacesOnly && context.myNamespacesOnly;
        result2.myScopeUpdater.addAll(this.myScopeUpdater).addAll(context.myScopeUpdater);
        LoaderContext loaderContext = result2;
        if (loaderContext == null) {
            LoaderContext.$$$reportNull$$$0(5);
        }
        return loaderContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public IntrospectionScopeUpdater getScopeUpdater() {
        IntrospectionScopeUpdater introspectionScopeUpdater = this.myScopeUpdater;
        if (introspectionScopeUpdater == null) {
            LoaderContext.$$$reportNull$$$0(7);
        }
        return introspectionScopeUpdater;
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            LoaderContext.$$$reportNull$$$0(8);
        }
        return localDataSource;
    }

    public DatabaseFamilyId getFamilyId() {
        return this.myDataSource.getFamilyId();
    }

    public Set<Object> getSelection() {
        return this.mySelection;
    }

    public LoaderContext setErrorHandler(ErrorHandler handler) {
        this.myErrorHandler = handler;
        return this;
    }

    public LoaderContext setNamespacesOnly(boolean namespacesOnly) {
        this.myNamespacesOnly = namespacesOnly;
        return this;
    }

    public boolean isSchemaListOnly() {
        return this.myNamespacesOnly;
    }

    public LoaderContext include(@Nullable ObjectPath o) {
        if (o != null) {
            this.mySelection.add((Object)LoaderContext.getScope(JdbcUrlParserUtil.getObjectItem(o, ObjectKind.DATABASE), JdbcUrlParserUtil.getObjectItem(o, ObjectKind.SCHEMA)));
        }
        return this;
    }

    public LoaderContext include(@Nullable Object o) {
        if (o == null) {
            return this;
        }
        if (o instanceof DasNamespace) {
            this.includeNamespace((DasNamespace)o);
        } else {
            this.mySelection.add(o instanceof DbElement ? ((DbElement)o).getDelegate() : o);
        }
        return this;
    }

    @Deprecated
    public LoaderContext includeSchema(String catalog, String schema) {
        this.mySelection.add((Object)LoaderContext.getScope(catalog, schema));
        return this;
    }

    public LoaderContext includeNamespace(@NotNull DasNamespace namespace) {
        if (namespace == null) {
            LoaderContext.$$$reportNull$$$0(9);
        }
        this.mySelection.add((Object)LoaderContext.getScopeFor(namespace, this.getFamilyId()));
        return this;
    }

    @NotNull
    public static String getScopeFor(@NotNull DasNamespace namespace, DatabaseFamilyId familyId) {
        String pattern;
        ObjectKind namespaceKind;
        if (namespace == null) {
            LoaderContext.$$$reportNull$$$0(10);
        }
        if ((namespaceKind = namespace.getKind()) == ObjectKind.DATABASE) {
            pattern = LoaderContext.getScope(namespace.getName(), null);
        } else if (DbImplUtil.isSchema(namespaceKind)) {
            DasObject parent = namespace.getDasParent();
            pattern = familyId.isOracle() ? LoaderContext.getScope(null, namespace.getName()) : (parent != null && parent.getKind() == ObjectKind.DATABASE ? LoaderContext.getScope(parent.getName(), namespace.getName()) : LoaderContext.getScope(null, namespace.getName()));
        } else {
            throw new IllegalArgumentException("Strange kind of the given namespace: " + namespaceKind.name());
        }
        String string = pattern;
        if (string == null) {
            LoaderContext.$$$reportNull$$$0(11);
        }
        return string;
    }

    public LoaderContext includeAllSchemas() {
        this.mySelection.add((Object)LoaderContext.getScope(null, null));
        return this;
    }

    public boolean loadNothing() {
        return this.mySelection.isEmpty() && !this.myNamespacesOnly;
    }

    public boolean load(Object o) {
        return this.mySelection.contains(o);
    }

    public boolean load(String catalog, String schema) {
        return this.mySelection.contains((Object)LoaderContext.getScope(catalog, schema)) || this.mySelection.contains((Object)LoaderContext.getScope(catalog, null)) || this.mySelection.contains((Object)LoaderContext.getScope(null, null));
    }

    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public Object getElementToFocus() {
        return this.mySelectedElement;
    }

    public void setElementToFocus(@Nullable Object selectedElement) {
        this.mySelectedElement = selectedElement;
    }

    @NotNull
    public static String getScope(@Nullable String catalog, @Nullable String schema) {
        if (StringUtil.isNotEmpty((String)catalog)) {
            if (StringUtil.isNotEmpty((String)schema)) {
                String string = catalog + ":" + schema;
                if (string == null) {
                    LoaderContext.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = catalog + ":*";
            if (string == null) {
                LoaderContext.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)schema)) {
            String string = "*:" + schema;
            if (string == null) {
                LoaderContext.$$$reportNull$$$0(14);
            }
            return string;
        }
        if ("*" == null) {
            LoaderContext.$$$reportNull$$$0(15);
        }
        return "*";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/LoaderContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/LoaderContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeUpdater";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeFor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadAll";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "includeNamespace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

