/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.dialects.DatabaseFamilyBean;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialects {
    private static final Logger LOG = Logger.getInstance(SqlDialects.class);

    private static void initSqlDialects() {
        DatabaseFamilyBean[] extensions = DatabaseFamilyBean.getExtensions();
        if (extensions == null) {
            LOG.error("No database families found");
            return;
        }
        HashSet<Object> families = new HashSet<Object>();
        for (DatabaseFamilyBean familyBean : extensions) {
            try {
                LanguageParserDefinitions.INSTANCE.forLanguage((Language)familyBean.language.getValue());
                families.add(familyBean.family.getValue());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (!families.containsAll(Arrays.asList(DatabaseFamilyId.MYSQL, DatabaseFamilyId.ORACLE, DatabaseFamilyId.POSTGRES, DatabaseFamilyId.SQLITE, DatabaseFamilyId.UNKNOWN))) {
            LOG.error("Required SQL dialects not found among: " + families);
        }
    }

    @Nullable
    public static SqlLanguageDialect findDialectById(@NotNull String id) {
        if (id == null) {
            SqlDialects.$$$reportNull$$$0(0);
        }
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)id), SqlLanguageDialect.class);
    }

    @NotNull
    public static List<SqlLanguageDialect> getSqlDialects() {
        List list = JBIterable.from((Iterable)SqlLanguage.INSTANCE.getDialects()).filter(SqlLanguageDialect.class).toList();
        if (list == null) {
            SqlDialects.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<SqlLanguageDialect> getTopLevelSqlDialects() {
        List list = JBIterable.from((Iterable)SqlLanguage.INSTANCE.getDialects()).filter(SqlLanguageDialect.class).filter(o -> !(o instanceof InjectableLanguage)).toList();
        if (list == null) {
            SqlDialects.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)SqlDialects.findDialectById("GenericSQL"));
        if (sqlLanguageDialect == null) {
            SqlDialects.$$$reportNull$$$0(3);
        }
        return sqlLanguageDialect;
    }

    public static void ensureSqlDialectsLoaded() {
        SqlDialects.getGenericDialect();
    }

    static {
        SqlDialects.initSqlDialects();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/SqlDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/SqlDialects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSqlDialects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDialectById";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

