/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public class OracleDefinitionProvider
extends DefinitionProviderImpl {
    public static final OracleDefinitionProvider INSTANCE = new OracleDefinitionProvider();
    private static final String DBMS_METADATA_STMT = "SELECT DBMS_METADATA.GET_DDL(?, ?, ?) FROM SYS.DUAL";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(0);
        }
        return ((kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.TABLE || kind == ObjectKind.ROUTINE || kind == ObjectKind.INDEX || kind == ObjectKind.CLUSTER || kind == ObjectKind.SYNONYM || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || kind == ObjectKind.MAT_VIEW || kind == ObjectKind.TRIGGER || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.SEQUENCE) && OracleDefinitionProvider.getKindName(object) != null;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(3);
        }
        try (ReusableSmartStatement<ParameterizedStatementDecoration> statement = SmartStatements.poweredBy(connection).parameterized().reuse(DBMS_METADATA_STMT);){
            for (DasObject dasObject : objects) {
                ParameterizedStatementDecoration data = new StatementParameters().text(OracleDefinitionProvider.getKindName(dasObject)).text(dasObject.getName()).text(DasUtil.getSchema((DasObject)dasObject)).asDecoration();
                consumer2.consume((Object)dasObject, statement.execute(data, StandardResultsProcessors.FIRST_STRING).any());
            }
        }
    }

    private static String getKindName(DasObject obj) {
        ObjectKind kind = obj.getKind();
        if (kind == ObjectKind.ROUTINE) {
            if (DasUtil.getKind((DasObject)obj.getDasParent()) != ObjectKind.SCHEMA) {
                return null;
            }
            if (obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.FUNCTION) {
                return "FUNCTION";
            }
            return "PROCEDURE";
        }
        if (kind == ObjectKind.CHECK) {
            return "CONSTRAINT";
        }
        if (kind == ObjectKind.MAT_VIEW) {
            return "MATERIALIZED_VIEW";
        }
        if (kind == ObjectKind.PACKAGE) {
            return "PACKAGE_SPEC";
        }
        if (kind == ObjectKind.BODY && DasUtil.getKind((DasObject)obj.getDasParent()) == ObjectKind.PACKAGE) {
            return "PACKAGE_BODY";
        }
        if (kind == ObjectKind.OBJECT_TYPE) {
            return "TYPE_SPEC";
        }
        if (kind == ObjectKind.COLLECTION_TYPE) {
            return "TYPE";
        }
        if (kind == ObjectKind.BODY && DasUtil.getKind((DasObject)obj.getDasParent()) == ObjectKind.OBJECT_TYPE) {
            return "TYPE_BODY";
        }
        return kind.name();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/oracle/OracleDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

