/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.vendors.oracle.OracleConsoleUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class OracleProcessDbmsOutputAction
extends ToggleAction {
    private static final Key<MyDataAuditor> DBMS_LISTENER = Key.create((String)"DBMS_LISTENER");
    private static final int BYTES_TO_LOAD = 0x100000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OracleProcessDbmsOutputAction.$$$reportNull$$$0(0);
        }
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        e.getPresentation().setEnabledAndVisible(console != null);
        if (console != null) {
            super.update(e);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        Content content = console == null ? null : console.getContent();
        return content != null && content.getUserData(DBMS_LISTENER) != null;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Content content;
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        Content content2 = content = console == null ? null : console.getContent();
        if (content == null) {
            return;
        }
        if (state) {
            MyDataAuditor listener = new MyDataAuditor(console);
            Disposer.register((Disposable)console, (Disposable)listener);
            console.getMessageBus().addAuditor(listener);
            content.putUserData(DBMS_LISTENER, (Object)listener);
        } else {
            MyDataAuditor listener = (MyDataAuditor)content.getUserData(DBMS_LISTENER);
            if (listener != null) {
                content.putUserData(DBMS_LISTENER, null);
                Disposer.dispose((Disposable)listener);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction", "update"));
    }

    private static class MyDataAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private final JdbcConsole myConsole;

        MyDataAuditor(JdbcConsole console) {
            this.myConsole = console;
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            DatabaseConnection connection;
            if (context == null) {
                MyDataAuditor.$$$reportNull$$$0(0);
            }
            if ((connection = OracleConsoleUtils.getConnection(context)) == null) {
                return;
            }
            this.execute(context, SmartStatements.poweredBy(connection), "{call sys.dbms_output.enable(1048576)}");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            DatabaseConnection connection;
            if (context == null) {
                MyDataAuditor.$$$reportNull$$$0(1);
            }
            if ((connection = OracleConsoleUtils.getConnection(context)) == null) {
                return;
            }
            String sql = "{call sys.dbms_output.get_line(?, ?)}";
            CallableStatementBasis data = new StatementParameters().parameter(1, 12).parameter(2, 4).asCallBasis(sql);
            SmartStatements statements2 = SmartStatements.poweredBy(connection);
            try (ReusableSmartStatement<ParameterizedStatementDecoration> call2 = statements2.call().reuse(data);){
                int status;
                do {
                    try (ClosableResultsProducer producer = call2.noisy().execute(StatementParameters.getEmpty(), StandardExecutionMode.GENERIC);){
                        Object first = producer.getParameterValue(1);
                        if (first instanceof String) {
                            this.myConsole.getHistoryLogger().warn(context, (String)first);
                        }
                        Object second = producer.getParameterValue(2);
                        status = (Integer)second;
                    }
                } while (status == 0);
            }
            catch (SQLException call2) {
            }
            catch (Exception e) {
                context.reportException(e, null);
            }
            finally {
                this.execute(context, statements2, "{call sys.dbms_output.disable()}");
            }
        }

        protected void execute(@NotNull DataRequest.Context context, @NotNull SmartStatements statements2, @NotNull String statement) {
            if (context == null) {
                MyDataAuditor.$$$reportNull$$$0(2);
            }
            if (statements2 == null) {
                MyDataAuditor.$$$reportNull$$$0(3);
            }
            if (statement == null) {
                MyDataAuditor.$$$reportNull$$$0(4);
            }
            try {
                statements2.simple().barren().quiet().execute(statement);
            }
            catch (Exception e) {
                context.reportException(e, null);
            }
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction$MyDataAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

