/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.vendors.oracle.ObjectInfo;
import com.intellij.database.vendors.oracle.OracleStatementAnalysis;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0014"}, d2={"catalogName", "", "Lcom/intellij/sql/psi/SqlDefinition;", "getCatalogName", "(Lcom/intellij/sql/psi/SqlDefinition;)Ljava/lang/String;", "Lcom/intellij/sql/psi/SqlNameElement;", "(Lcom/intellij/sql/psi/SqlNameElement;)Ljava/lang/String;", "getOracleTypeLikeConditionFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "parseAffectedObjectInfo", "Lcom/intellij/database/vendors/oracle/ObjectInfo;", "text", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "parseStatementForAffectedObjectInfo", "element", "Lcom/intellij/sql/psi/SqlElement;", "intellij.database.impl"})
@JvmName(name="OracleStatementAnalysis")
public final class OracleStatementAnalysis {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ObjectInfo parseAffectedObjectInfo(@NotNull String text2, @NotNull SqlLanguageDialect dialect, @NotNull Project project) {
        Object v2;
        block1: {
            void $receiver$iv;
            SqlFile psiFile;
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)project);
            SqlFile sqlFile = psiFile = psiFacade.createROFile(dialect, (CharSequence)text2);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFile, (String)"psiFile");
            List list = sqlFile.getDdl();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"psiFile.ddl");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)parseAffectedObjectInfo.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                ObjectInfo it = (ObjectInfo)element$iv;
                if (!(it != null)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final ObjectInfo parseStatementForAffectedObjectInfo(SqlElement element) {
        ObjectKind objectKind = ObjectKind.NONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"NONE");
        ObjectKind kind = objectKind;
        String schemaName = null;
        String objectName = null;
        SqlElement sqlElement = element;
        if (sqlElement instanceof SqlCreateStatement) {
            SqlExpression sqlExpression;
            SqlExpression q;
            ObjectKind objectKind2 = ((SqlCreateStatement)element).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"element.kind");
            kind = objectKind2;
            objectName = OracleStatementAnalysis.getCatalogName((SqlDefinition)element);
            SqlNameElement sqlNameElement = ((SqlCreateStatement)element).getNameElement();
            if (!(sqlNameElement instanceof SqlReferenceExpression)) {
                sqlNameElement = null;
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlNameElement;
            Object object = q = sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.BODY)) {
                SqlExpression sqlExpression2 = q;
                if (!(sqlExpression2 instanceof SqlReferenceExpression)) {
                    sqlExpression2 = null;
                }
                SqlReferenceExpression sqlReferenceExpression2 = (SqlReferenceExpression)sqlExpression2;
                q = sqlReferenceExpression2 != null ? sqlReferenceExpression2.getQualifierExpression() : null;
            }
            if (!((sqlExpression = q) instanceof SqlNameElement)) {
                sqlExpression = null;
            }
            SqlNameElement sqlNameElement2 = (SqlNameElement)sqlExpression;
            schemaName = sqlNameElement2 != null ? OracleStatementAnalysis.getCatalogName(sqlNameElement2) : null;
        } else if (sqlElement instanceof SqlAlterStatement) {
            SqlReferenceExpression ref;
            SqlReferenceExpression sqlReferenceExpression = ((SqlAlterStatement)element).getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return null;
            }
            SqlReferenceExpression sqlReferenceExpression3 = ref = sqlReferenceExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression3, (String)"ref");
            SqlReferenceElementType sqlReferenceElementType = sqlReferenceExpression3.getReferenceElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"ref.referenceElementType");
            ObjectKind objectKind3 = sqlReferenceElementType.getTargetKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"ref.referenceElementType.targetKind");
            kind = objectKind3;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW)) {
                ObjectKind objectKind4 = ObjectKind.VIEW;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"VIEW");
                kind = objectKind4;
            }
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PACKAGE)) {
                SqlAlterInstruction instruction;
                Object[] objectArray = ((SqlAlterStatement)element).getAlterInstructions();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"element.alterInstructions");
                SqlAlterInstruction sqlAlterInstruction = instruction = (SqlAlterInstruction)ArraysKt.firstOrNull((Object[])objectArray);
                if (Intrinsics.areEqual((Object)(sqlAlterInstruction != null ? sqlAlterInstruction.getInstructionType() : null), (Object)SqlCommonKeywords.SQL_COMPILE)) {
                    SqlAlterInstruction sqlAlterInstruction2 = instruction;
                    if (sqlAlterInstruction2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (sqlAlterInstruction2.getNode().findChildByType((IElementType)SqlCommonKeywords.SQL_BODY) != null) {
                        ObjectKind objectKind5 = ObjectKind.BODY;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind5, (String)"BODY");
                        kind = objectKind5;
                    }
                }
            }
            objectName = OracleStatementAnalysis.getCatalogName((SqlNameElement)ref);
            SqlExpression q = ref.getQualifierExpression();
            SqlExpression sqlExpression = q;
            if (!(sqlExpression instanceof SqlNameElement)) {
                sqlExpression = null;
            }
            SqlNameElement sqlNameElement = (SqlNameElement)sqlExpression;
            schemaName = sqlNameElement != null ? OracleStatementAnalysis.getCatalogName(sqlNameElement) : null;
        }
        return objectName != null ? new ObjectInfo(kind, schemaName, objectName) : null;
    }

    private static final String getCatalogName(@NotNull SqlDefinition $receiver) {
        SqlNameElement sqlNameElement = $receiver.getNameElement();
        return sqlNameElement != null ? OracleStatementAnalysis.getCatalogName(sqlNameElement) : null;
    }

    private static final String getCatalogName(@NotNull SqlNameElement $receiver) {
        String name;
        String string = name = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        CharSequence charSequence = string;
        if (charSequence.length() == 0) {
            return null;
        }
        if ($receiver.isQuotedIdentifier()) {
            name = StringsKt.replace$default((String)name, (String)"\"\"", (String)"\"", (boolean)false, (int)4, null);
        } else {
            charSequence = name;
            String string2 = ((String)charSequence).toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            name = string2;
        }
        return name;
    }

    @NotNull
    public static final String getOracleTypeLikeConditionFor(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? "like '%VIEW'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW) ? "like '%VIEW'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY) ? "like '%BODY'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? "= 'TYPE'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE) ? "= 'TYPE'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? "in ('PROCEDURE','FUNCTION')" : "= '" + kind.name() + '\'')))));
    }

    @Nullable
    public static final /* synthetic */ ObjectInfo access$parseStatementForAffectedObjectInfo(@NotNull SqlElement element) {
        return OracleStatementAnalysis.parseStatementForAffectedObjectInfo(element);
    }
}

