/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialogsHelper {
    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(1);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(2);
        }
        EditorTextField editorTextField = DatabaseDialogsHelper.createLanguageEditorArea(project, DbImplUtil.getDatabaseDialect((DbElement)dataSource), dataSource, searchPath, query);
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(3);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull DatabaseEditorContext context, @Nullable SearchPath searchPath, @NotNull String query) {
        if (context == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(4);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(5);
        }
        EditorTextField editorTextField = DatabaseDialogsHelper.createLanguageEditorArea((Project)ObjectUtils.assertNotNull((Object)context.getProject()), context.getDialect(), context.getDataSource(), searchPath, query);
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(6);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(8);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(9);
        }
        SqlLanguageDialect language = dataSource != null ? DbSqlUtil.getSqlDialect((DbElement)dataSource) : DbSqlUtil.getSqlDialect(dialect);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)query);
        psiFile.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)dataSource);
        psiFile.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)searchPath);
        EditorTextField area = DatabaseDialogsHelper.createEditorTextField(psiFile, false);
        area.setFontInheritedFromLAF(false);
        area.addSettingsProvider(editor -> {
            editor.getSettings().setWheelFontChangeEnabled(true);
            editor.getSettings().setFoldingOutlineShown(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            editor.getSettings().setUseSoftWraps(true);
        });
        EditorTextField editorTextField = area;
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(10);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorField(PsiFile psiFile) {
        EditorTextField editorTextField = DatabaseDialogsHelper.createEditorTextField(psiFile, true);
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(11);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createEditorTextField(PsiFile psiFile, boolean oneLine) {
        Project project = psiFile.getProject();
        Language dialect = psiFile.getLanguage();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        EditorTextField textField = new EditorTextField(document, project, psiFile.getFileType(), false, oneLine);
        textField.addSettingsProvider(editor -> {
            DatabaseDialogsHelper.setSpecificSyntaxHighlighter(psiFile, project, dialect, editor);
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.getSettings().setLineNumbersShown(false);
        });
        EditorTextField editorTextField = textField;
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(12);
        }
        return editorTextField;
    }

    public static void setSpecificSyntaxHighlighter(PsiFile psiFile, Project project, Language dialect, EditorEx editor) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)project, (VirtualFile)psiFile.getVirtualFile());
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
    }

    public static String concatQueries(DdlBuilder builder) {
        List<String> statements2 = builder.getStatements();
        DatabaseDialectEx dialect = builder.getDialect();
        if (statements2.isEmpty()) {
            return "";
        }
        boolean noSemi = dialect.getFamilyId().isTransactSql();
        String join = StringUtil.join(statements2, (String)(noSemi ? "\n" : ";\n"));
        return noSemi || StringUtil.endsWith((CharSequence)join, (CharSequence)";") ? join : join + ";";
    }

    public static DdlBuilder createDdlBuilder(@NotNull DatabaseEditorContext context, boolean forCreate) {
        if (context == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(13);
        }
        return DatabaseDialogsHelper.createDdlBuilder(context.getProject(), context.getDialect(), (CasingProvider)context.getModel(), forCreate).pushDefaultSchema(SearchPath.getCurrent((SearchPath)context.getSearchPath()));
    }

    public static DdlBuilder createDdlBuilder(@Nullable Project project, @NotNull DatabaseDialectEx dialect, @NotNull CasingProvider provider, boolean forCreate) {
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(14);
        }
        if (provider == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(15);
        }
        return DatabaseDialogsHelper.createDdlBuilder(forCreate).withDialect(dialect).applyCodeStyle(project).withCasing(provider);
    }

    public static DdlBuilder createDdlBuilder(@NotNull DbElement source, boolean forCreate) {
        if (source == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(16);
        }
        return DatabaseDialogsHelper.createDdlBuilder(forCreate).configureFor(source).pushDefaultSchema(ObjectPaths.of((DasObject)DbImplUtil.getSearchPathObject(source)));
    }

    public static DdlBuilder createDdlBuilderForExec(@NotNull DbElement source, boolean forCreate) {
        if (source == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(17);
        }
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(forCreate).configureFor(source);
        LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)source.getDataSource());
        if (dataSource == null) {
            return builder;
        }
        DasNamespace obj = DbImplUtil.getSearchPathObjectForSwitch(source);
        return obj == null ? builder : builder.pushDefaultSchema(ObjectPaths.of((DasObject)obj));
    }

    public static DdlBuilder createDdlBuilder(final boolean forCreate) {
        return new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder newName(@NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.newName(newName);
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v0;
            }

            @Override
            @NotNull
            public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name) {
                boolean suppress;
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                boolean bl = suppress = object != null && this.isNameModifiedOrNew(object, name);
                if (suppress) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.identifier(object, name);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v1 = this;
                if (v1 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return v1;
            }

            @Override
            @NotNull
            public DdlBuilder constraintRef(@NotNull DasObject object) {
                boolean suppress;
                if (object == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (suppress = this.isNameModifiedOrNew(object, object.getName())) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.constraintRef(object);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return v0;
            }

            private boolean isNameModifiedOrNew(@Nullable DasObject obj, @NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (obj != null && !name.equals(obj.getName())) {
                    return true;
                }
                DeObject object = (DeObject)ObjectUtils.tryCast((Object)obj, DeObject.class);
                if (object == null) {
                    return false;
                }
                return object.editedObject == null || !object.name.equals(object.editedObject.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelper$1";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "newName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "identifier";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "constraintRef";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "newName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "identifier";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "constraintRef";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "isNameModifiedOrNew";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.qualifyReferences(true).splitStatements(true).suppressQuoteIdentifiers(forCreate);
    }

    @NotNull
    public static Function<Runnable, ActionCallback> createAsyncProcessor(@NotNull Project project, @NotNull String text2, @NotNull Runnable onOk) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(19);
        }
        if (onOk == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(20);
        }
        Function function = runnable -> {
            if (text2 == null) {
                DatabaseDialogsHelper.$$$reportNull$$$0(22);
            }
            if (project == null) {
                DatabaseDialogsHelper.$$$reportNull$$$0(23);
            }
            if (onOk == null) {
                DatabaseDialogsHelper.$$$reportNull$$$0(24);
            }
            ActionCallback res = new ActionCallback(text2);
            DataSourceUiUtil.runAsyncWithCorrectModality(new Task.Backgroundable(project, text2, true, (Runnable)runnable, res, onOk){
                final /* synthetic */ Runnable val$runnable;
                final /* synthetic */ ActionCallback val$res;
                final /* synthetic */ Runnable val$onOk;
                {
                    this.val$runnable = runnable;
                    this.val$res = actionCallback;
                    this.val$onOk = runnable2;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.val$runnable.run();
                }

                public void onCancel() {
                    this.val$res.setRejected();
                }

                public void onSuccess() {
                    this.val$res.setDone();
                    DbUIUtil.invokeLaterIfNeeded(this.val$onOk);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/DatabaseDialogsHelper$2", "run"));
                }
            });
            return res;
        };
        if (function == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(21);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onOk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageEditorArea";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageEditorField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorTextField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createAsyncProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageEditorArea";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDdlBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDdlBuilderForExec";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncProcessor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAsyncProcessor$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DocAdapter
    implements javax.swing.event.DocumentListener,
    ItemListener,
    DocumentListener {
        public abstract void processChangeImpl();

        private void processChange() {
            ApplicationManager.getApplication().invokeLater(() -> this.processChangeImpl());
        }

        public void documentChanged(DocumentEvent event) {
            this.processChange();
        }

        @Override
        public void insertUpdate(@NotNull javax.swing.event.DocumentEvent e) {
            if (e == null) {
                DocAdapter.$$$reportNull$$$0(0);
            }
            this.processChange();
        }

        @Override
        public void removeUpdate(@NotNull javax.swing.event.DocumentEvent e) {
            if (e == null) {
                DocAdapter.$$$reportNull$$$0(1);
            }
            this.processChange();
        }

        @Override
        public void changedUpdate(@NotNull javax.swing.event.DocumentEvent e) {
            if (e == null) {
                DocAdapter.$$$reportNull$$$0(2);
            }
            this.processChange();
        }

        @Override
        public void itemStateChanged(@NotNull ItemEvent e) {
            if (e == null) {
                DocAdapter.$$$reportNull$$$0(3);
            }
            this.processChange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper$DocAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertUpdate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeUpdate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changedUpdate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemStateChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

