/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.actions.DdlActions;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNavBarExtension
extends AbstractNavBarModelExtension {
    @Nullable
    public String getPopupMenuGroup(@NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(0);
        }
        if (!DatabaseStructure.isDatabaseObject(object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider))) {
            return null;
        }
        return "DatabaseViewPopupMenu";
    }

    @Nullable
    public Object getData(String dataId, @NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(1);
        }
        if ((object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider)) instanceof DatabaseStructure.DbRootGroup) {
            return null;
        }
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            List<PsiElement> c = Collections.singletonList(object);
            if (JBIterable.from(c).filter(DbDataSource.class).size() == c.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        return DbNodeDescriptor.getData(dataId, object.getProject(), object);
    }

    @Nullable
    public String getPresentableText(Object object) {
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        return object instanceof DbElement ? DbPresentation.getPresentableName((DasObject)((DbElement)object), true) : (object instanceof PsiNamedElement ? ((PsiNamedElement)object).getName() : null);
    }

    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        if (!DatabaseStructure.isDatabaseObject(psiElement)) {
            return null;
        }
        DatabaseViewOptions options = DatabaseView.getDatabaseView(psiElement.getProject()).getViewOptions();
        return DatabaseStructure.getParentImpl(psiElement, options);
    }

    @Nullable
    public PsiElement adjustElement(PsiElement psiElement) {
        if (psiElement instanceof DbElement || psiElement instanceof DatabaseStructure.Group) {
            return psiElement;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement element = DbImplUtil.findElement(psiElement.getProject(), file);
            if (element != null) {
                return element;
            }
        } else {
            DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(psiElement);
            if (dataGrid != null) {
                return (PsiElement)CommonDataKeys.PSI_FILE.getData(DataManager.getInstance().getDataContext((Component)dataGrid.getComponent()));
            }
        }
        return psiElement;
    }

    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor) {
        Object adjusted;
        if (!(object instanceof PsiElement) || !((PsiElement)object).isValid()) {
            return true;
        }
        Object object2 = adjusted = object instanceof DbElement && !(object instanceof DbDataSource) ? ((DbElement)object).getDelegate() : object;
        if (!DatabaseStructure.isDatabaseObject(adjusted)) {
            return true;
        }
        if (DatabaseStructure.isAlwaysLeafImpl(adjusted)) {
            return true;
        }
        Project project = ((PsiElement)object).getProject();
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        DbDataSource dataSource = object instanceof DbElement ? ((DbElement)object).getDataSource() : (object instanceof DatabaseStructure.FamilyGroup ? ((DatabaseStructure.FamilyGroup)((Object)object)).dataSource : null);
        DatabaseViewOptions options = DatabaseView.getDatabaseView(project).getViewOptions();
        JBIterable children2 = DatabaseStructure.getChildrenImpl(adjusted, options, facade).filterMap(o -> o instanceof DbDataSource ? o : (o instanceof DasObject ? DbImplUtil.findElement(dataSource, (DasObject)o) : o));
        return ContainerUtil.process((Iterable)children2, processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "provider";
        objectArray2[1] = "com/intellij/database/view/DatabaseNavBarExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupMenuGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

