/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DatabaseRefactoringHandler
extends AbstractDatabaseModifier {
    private static final String INDICATOR_TITLE = "Updating Database...";
    @NotNull
    private final RefactoringExecutor myRefactoringExecutor;

    public DatabaseRefactoringHandler(@NotNull DbDataSource dataSource, @Nullable SearchPath searchPath) {
        if (dataSource == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(0);
        }
        super(DGDepartment.REFACTORING, dataSource, searchPath, INDICATOR_TITLE);
        this.myRefactoringExecutor = new RefactoringExecutor(dataSource);
    }

    @NotNull
    public DatabaseRefactoringHandler setStatement(@NotNull String statement) {
        if (statement == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(1);
        }
        this.myRefactoringExecutor.setStatement(statement);
        DatabaseRefactoringHandler databaseRefactoringHandler = this;
        if (databaseRefactoringHandler == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(2);
        }
        return databaseRefactoringHandler;
    }

    @NotNull
    public String getStatement() {
        String string = this.myRefactoringExecutor.getStatement();
        if (string == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        RefactoringExecutor refactoringExecutor = this.myRefactoringExecutor;
        if (refactoringExecutor == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(4);
        }
        return refactoringExecutor;
    }

    private static int executeQueries(@NotNull Project project, @NotNull DatabaseConnection connection, @NotNull List<String> queries, @NotNull ErrorHandler errorHandler, @NotNull Processor<String> errorChecker, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(6);
        }
        if (queries == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(7);
        }
        if (errorHandler == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(8);
        }
        if (errorChecker == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(10);
        }
        int totalCount = queries.size();
        int count2 = 0;
        try (ReusableSmartStatement<String> statement = SmartStatements.poweredBy(connection).simple().reuse();){
            for (String query : queries) {
                if (StringUtil.isEmptyOrSpaces((String)query)) {
                    ++count2;
                    continue;
                }
                indicator.checkCanceled();
                try {
                    statement.barren().execute(query, StandardExecutionMode.UPDATE);
                    if (!errorChecker.process((Object)query)) {
                        DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.ERROR).notify(project);
                        int n = count2;
                        return n;
                    }
                    DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.INFO).notify(project);
                    indicator.setFraction((double)(++count2) / (double)totalCount);
                }
                catch (Exception e) {
                    DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.ERROR).notify(project);
                    errorHandler.addError(null, e);
                    int n = count2;
                    return n;
                }
            }
        }
        return count2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorChecker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RefactoringExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private String myStatement;
        @NotNull
        private final DbDataSource myDataSource;

        public RefactoringExecutor(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                RefactoringExecutor.$$$reportNull$$$0(0);
            }
            this.myStatement = "";
            this.myDataSource = dataSource;
        }

        public void setStatement(@NotNull String statement) {
            if (statement == null) {
                RefactoringExecutor.$$$reportNull$$$0(1);
            }
            this.myStatement = statement;
        }

        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                RefactoringExecutor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public Promise<Void> execute(final @NotNull ProgressIndicator indicator, final @NotNull DataRequest.OwnerEx ownerEx, @NotNull DataProducer producer, final @NotNull ErrorHandler errorHandler) {
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(3);
            }
            if (ownerEx == null) {
                RefactoringExecutor.$$$reportNull$$$0(4);
            }
            if (producer == null) {
                RefactoringExecutor.$$$reportNull$$$0(5);
            }
            if (errorHandler == null) {
                RefactoringExecutor.$$$reportNull$$$0(6);
            }
            DataRequest.RawRequest request = new DataRequest.RawRequest(ownerEx){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnection connection) {
                    indicator.setText("Updating database...");
                    DataAuditor obtainer = this.createObtainer(ownerEx);
                    try {
                        Processor errorChecker = obtainer instanceof JdbcConsole.RawErrorsObtainer ? q -> ((JdbcConsole.RawErrorsObtainer)obtainer).obtainErrors(context, (String)q) : q -> true;
                        this.execute(indicator, connection, (Processor<String>)errorChecker, errorHandler);
                    }
                    finally {
                        if (obtainer instanceof Disposable) {
                            Disposer.dispose((Disposable)((Disposable)obtainer));
                        }
                    }
                }
            };
            producer.processRequest(request);
            return request.getPromise();
        }

        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseConnection connection, @NotNull Processor<String> errorChecker, @NotNull ErrorHandler errorHandler) {
            List<String> queries;
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(7);
            }
            if (connection == null) {
                RefactoringExecutor.$$$reportNull$$$0(8);
            }
            if (errorChecker == null) {
                RefactoringExecutor.$$$reportNull$$$0(9);
            }
            if (errorHandler == null) {
                RefactoringExecutor.$$$reportNull$$$0(10);
            }
            return (queries = DbSqlUtil.getQueries(this.myStatement, this.myDataSource.getProject(), (Language)DbSqlUtil.getSqlDialect((DbElement)this.myDataSource))).size() == DatabaseRefactoringHandler.executeQueries(this.myDataSource.getProject(), connection, queries, errorHandler, (Processor<String>)errorChecker, indicator);
        }

        @Nullable
        public DataAuditor createObtainer(@NotNull DataRequest.OwnerEx owner) {
            DataAuditor auditor;
            LocalDataSource localDataSource;
            Project project;
            DataAuditor obtainer;
            if (owner == null) {
                RefactoringExecutor.$$$reportNull$$$0(11);
            }
            if ((obtainer = JdbcConsole.createAdvancedErrorsObtainer(project = this.myDataSource.getProject(), localDataSource = DbImplUtil.getLocalDataSource((DasDataSource)this.myDataSource), auditor = DataBus.shortCircuit(owner.getMessageBus()).getDataAuditor())) != null) {
                owner.getMessageBus().addAuditor(obtainer);
            }
            return obtainer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerEx";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorChecker";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setStatement";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createObtainer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

