/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof DbElement)) {
            return null;
        }
        if (DatabaseSettings.getSettings().navigateToSchema) {
            return DatabaseTargetElementEvaluator.createToDatabaseViewNavigatable((DbElement)element);
        }
        return DatabaseTargetElementEvaluator.createToSourceNavigatable((DbElement)element);
    }

    @NotNull
    public static PsiElement createToDatabaseViewNavigatable(final @NotNull DbElement element) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        final Project project = element.getProject();
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new PomTarget(){

            public boolean isValid() {
                return element.isValid();
            }

            public void navigate(boolean requestFocus) {
                DatabaseView.select(project, requestFocus, Collections.singleton(element));
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
        if (psiElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createToSourceNavigatable(final @NotNull DbElement element) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new PomTarget(){

            public boolean isValid() {
                return element.isValid();
            }

            public void navigate(boolean requestFocus) {
                DatabaseTargetElementEvaluator.navigateToSource(element, requestFocus);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
        if (psiElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public static void navigateToSource(@NotNull DbElement dbElement, boolean requestFocus) {
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(6);
        }
        if (DatabaseTargetElementEvaluator.navigateToSqlElement(dbElement, requestFocus)) {
            return;
        }
        if (DatabaseTargetElementEvaluator.navigateToDataSource(dbElement, requestFocus)) {
            return;
        }
        DbElement navigateTo = DatabaseTargetElementEvaluator.adjustForNavigation(dbElement);
        VirtualFile file = DbImplUtil.findSourceVirtualFile(navigateTo, true);
        if (file != null) {
            Project project = dbElement.getProject();
            Runnable runnable = () -> {
                if (dbElement == null) {
                    DatabaseTargetElementEvaluator.$$$reportNull$$$0(25);
                }
                int offset = DatabaseTargetElementEvaluator.calcTargetOffset(project, file, (DasObject)dbElement);
                new OpenFileDescriptor(project, file, offset).navigate(requestFocus);
            };
            if (file instanceof DatabaseElementVirtualFileImpl) {
                DatabaseEditorHelper.reloadIfNeeded(project, (DatabaseElementVirtualFileImpl)file).onSuccess(unused -> ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed()));
            } else {
                runnable.run();
            }
        } else {
            DatabaseView.select((PsiElement)dbElement, requestFocus);
        }
    }

    private static boolean navigateToDataSource(@NotNull DbElement element, boolean requestFocus) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(7);
        }
        if (element instanceof DbDataSource) {
            VirtualFile virtualFile;
            DatabaseSystem delegate = ((DbDataSource)element).getDelegate();
            if (delegate instanceof SqlDataSource) {
                virtualFile = (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles());
            } else {
                virtualFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)delegate);
                if (virtualFile == null) {
                    virtualFile = DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)delegate);
                }
            }
            if (virtualFile != null) {
                new OpenFileDescriptor(element.getProject(), virtualFile).navigate(requestFocus);
            } else {
                String message = delegate instanceof SqlDataSource ? "No source for DDL data source" : "No console for data source";
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), null, (String)message, (String)"Unable to navigate", null);
            }
            return true;
        }
        if (element instanceof DasNamespace && DbImplUtil.canConnectTo((DbElement)element.getDataSource())) {
            VirtualFile virtualFile = DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)element.getDataSource().getDelegate());
            if (virtualFile != null) {
                DatabaseEditorHelper.openConsoleForFile(element.getProject(), (DasNamespace)element.getDelegate(), virtualFile);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), null, (String)"No console for data source", (String)"Unable to navigate", null);
            }
            return true;
        }
        return false;
    }

    private static boolean navigateToSqlElement(@NotNull DbElement dbElement, boolean requestFocus) {
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(8);
        }
        if (!DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        SqlElement sqlElement = DbSqlUtil.getSqlElement(dbElement);
        if (sqlElement != null) {
            sqlElement.navigate(requestFocus);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)dbElement.getProject(), null, (String)"No code for item", (String)"Unable to navigate", null);
        }
        return true;
    }

    @NotNull
    public static DbElement adjustForNavigation(@NotNull DbElement element) {
        DatabaseFamilyId familyId;
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(9);
        }
        DbElement parent = element.getParent();
        DbElement adjusted = element;
        if (parent instanceof DbTable) {
            if (!(element instanceof DbTrigger) && !(element instanceof DbIndex)) {
                adjusted = parent;
            }
        } else if (parent instanceof DbPackage && !(familyId = DbImplUtil.getDatabaseDialect(element).getFamilyId()).isSybase()) {
            if (element.getKind() == ObjectKind.ROUTINE) {
                DbElement body2 = (DbElement)parent.getDasChildren(ObjectKind.BODY).first();
                adjusted = (DbElement)ObjectUtils.chooseNotNull((Object)body2, (Object)parent);
            } else {
                adjusted = parent;
            }
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(10);
        }
        return dbElement;
    }

    public static int calcTargetOffset(@NotNull Project project, @NotNull VirtualFile file, final @NotNull DasObject template) {
        if (project == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(11);
        }
        if (file == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(12);
        }
        if (template == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(13);
        }
        ObjectKind kind = template.getKind();
        ObjectKind parentKind = DasUtil.getKind((DasObject)template.getDasParent());
        if (kind == ObjectKind.BODY) {
            kind = ObjectKind.PACKAGE;
        } else if (kind == ObjectKind.PACKAGE) {
            kind = ObjectKind.BODY;
        } else if (kind == ObjectKind.ALIAS_TYPE && parentKind == ObjectKind.PACKAGE) {
            kind = ObjectKind.OBJECT_TYPE;
        }
        String name = template.getName();
        Condition condition = DatabaseTargetElementEvaluator.matchObject(name, DbSqlUtil.isQuoted(template), kind, DatabaseTargetElementEvaluator.getCasingProvider(project, template, file));
        if (kind == ObjectKind.ROUTINE) {
            condition = Conditions.and2(condition, (Condition)new Condition<DasObject>(){

                public boolean value(DasObject object) {
                    Iterator it1 = this.getRoutineArgs(template).iterator();
                    Iterator it2 = this.getRoutineArgs(object).iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        DasTypedObject o1 = (DasTypedObject)it1.next();
                        DasTypedObject o2 = (DasTypedObject)it2.next();
                        if (o1.getKind() != o2.getKind()) {
                            return false;
                        }
                        if (!Comparing.equal((String)o1.getName(), (String)o2.getName(), (boolean)false)) {
                            return false;
                        }
                        if (Comparing.equal((String)o1.getDataType().getSpecification(), (String)o2.getDataType().getSpecification(), (boolean)false)) continue;
                        return false;
                    }
                    return it1.hasNext() == it2.hasNext();
                }

                JBIterable<DasTypedObject> getRoutineArgs(DasObject template2) {
                    if (!(template2 instanceof DasRoutine)) {
                        return JBIterable.empty();
                    }
                    DasRoutine r = (DasRoutine)template2;
                    return JBIterable.from((Iterable)DasUtil.getParameters((DasRoutine)r)).append((Object)r.getReturnArgument()).filter(DasTypedObject.class);
                }
            });
        }
        return DatabaseTargetElementEvaluator.calcTargetOffset(project, file, condition);
    }

    @NotNull
    private static CasingProvider getCasingProvider(@NotNull Project project, @NotNull DasObject object, @NotNull VirtualFile file) {
        SqlLanguageDialect dialect;
        if (project == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(14);
        }
        if (object == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(15);
        }
        if (file == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(16);
        }
        if (object instanceof DbElement) {
            DasModel dasModel = ((DbElement)object).getDataSource().getModel();
            if (dasModel == null) {
                DatabaseTargetElementEvaluator.$$$reportNull$$$0(17);
            }
            return dasModel;
        }
        SqlLanguageDialect sqlLanguageDialect = dialect = object instanceof PsiElement ? DbSqlUtil.getSqlDialect((PsiElement)object) : null;
        if (dialect == null) {
            dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file), SqlLanguageDialect.class);
        }
        DatabaseDialectEx databaseDialectEx = dialect != null ? (DatabaseDialectEx)dialect.getDatabaseDialect() : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(18);
        }
        return databaseDialectEx;
    }

    public static Condition<DasObject> matchObject(String name, boolean quoted, ObjectKind kind, CasingProvider provider) {
        return Conditions.and2((Condition)DasUtil.byKind((ObjectKind)kind), DbSqlUtil.byName(name, quoted, null, provider));
    }

    private static int calcTargetOffset(@NotNull Project project, @NotNull VirtualFile file, @NotNull Condition<? super DasObject> equality) {
        if (project == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(19);
        }
        if (file == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(20);
        }
        if (equality == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(21);
        }
        return (Integer)ReadAction.compute(() -> {
            PsiFile psiFile;
            if (file == null) {
                DatabaseTargetElementEvaluator.$$$reportNull$$$0(22);
            }
            if (project == null) {
                DatabaseTargetElementEvaluator.$$$reportNull$$$0(23);
            }
            if (equality == null) {
                DatabaseTargetElementEvaluator.$$$reportNull$$$0(24);
            }
            PsiFile psiFile2 = psiFile = !file.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof SqlFile)) {
                return -1;
            }
            DasObject first = (DasObject)((SqlFile)psiFile).traverser().traverse().filter(equality).first();
            return first instanceof SqlDefinition ? ((SqlDefinition)first).getTextOffset() : -1;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 6: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 11: 
            case 14: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToDatabaseViewNavigatable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToSourceNavigatable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForNavigation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementByReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToDatabaseViewNavigatable";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToSourceNavigatable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSqlElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adjustForNavigation";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calcTargetOffset";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calcTargetOffset$2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$navigateToSource$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

