/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseScriptDialog
extends DialogWrapper {
    protected final Project myProject;
    protected final DbDataSource mySource;
    protected final SearchPath mySearchPath;
    protected final SqlPreviewPanel myPreviewPanel;

    public DatabaseScriptDialog(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String title) {
        if (project == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource;
        this.mySearchPath = searchPath;
        this.myPreviewPanel = new SqlPreviewPanel(this.myProject, this.mySource, this.mySearchPath, "", this.getDimensionServiceKey(), () -> this.close(1));
        this.setTitle(title);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPreviewPanel;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    protected void doOKAction() {
        this.runScript();
        super.doOKAction();
    }

    @NotNull
    public CompletionStage<Void> runScript() {
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.mySource, this.mySearchPath).setStatement(this.getStatement());
        this.fillContext(handler);
        CompletionStage<Void> completionStage = handler.runStatements(false);
        if (completionStage == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(4);
        }
        return completionStage;
    }

    protected void fillContext(DatabaseRefactoringHandler handler) {
    }

    protected void updateText(ScriptingResult script) {
        this.myPreviewPanel.setQuery(script.getScriptText());
    }

    public void initAndShow() {
        this.init();
        this.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

