/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.codeInsight.folding.impl.actions.ExpandAllToLevel1Action;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreviewPanel
extends JPanel {
    private final EditorTextField myPreviewEditor;
    private final EventDispatcher<OpenInConsoleListener> myDispatcher;

    private SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, @NotNull String propertyKey) {
        if (project == null) {
            SqlPreviewPanel.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            SqlPreviewPanel.$$$reportNull$$$0(1);
        }
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(2);
        }
        if (propertyKey == null) {
            SqlPreviewPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myDispatcher = EventDispatcher.create(OpenInConsoleListener.class);
        this.myPreviewEditor = DatabaseDialogsHelper.createLanguageEditorArea(project, dataSource, searchPath, query);
        final String expansionProperty = propertyKey + ".previewExpanded";
        boolean isExpanded = PropertiesComponent.getInstance().getBoolean(expansionProperty, true);
        JComponent open = this.openInConsole(dataSource);
        HideableDecorator decorator = new HideableDecorator(this, "S&QL Preview", true, open){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(expansionProperty, this.isExpanded());
            }
        };
        decorator.setContentComponent((JComponent)this.myPreviewEditor);
        decorator.setOn(isExpanded);
    }

    public SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, @NotNull String propertyKey, final @NotNull Runnable closeDialog) {
        if (project == null) {
            SqlPreviewPanel.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            SqlPreviewPanel.$$$reportNull$$$0(5);
        }
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(6);
        }
        if (propertyKey == null) {
            SqlPreviewPanel.$$$reportNull$$$0(7);
        }
        if (closeDialog == null) {
            SqlPreviewPanel.$$$reportNull$$$0(8);
        }
        this(project, dataSource, searchPath, query, propertyKey);
        this.subscribeOpenInConsole(new OpenInConsoleListener(){

            @Override
            public void open() {
                closeDialog.run();
            }
        });
    }

    public void subscribeOpenInConsole(@NotNull OpenInConsoleListener listener) {
        if (listener == null) {
            SqlPreviewPanel.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Nullable
    public JComponent openInConsole(final @NotNull DbDataSource delegate) {
        if (delegate == null) {
            SqlPreviewPanel.$$$reportNull$$$0(10);
        }
        String title = "Open query in console";
        JBLabel openInConsole = new JBLabel(AllIcons.Actions.MoveTo2);
        openInConsole.setToolTipText(title);
        openInConsole.setBorder((Border)JBUI.Borders.empty());
        openInConsole.setCursor(Cursor.getPredefinedCursor(12));
        openInConsole.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                String query;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (DbUIUtil.openInConsole(delegate, (DbElement)delegate, query = SqlPreviewPanel.this.getQuery(), true) == null) {
                    DbUIUtil.openInConsole(delegate, (DbElement)delegate, query, false);
                }
                ((OpenInConsoleListener)SqlPreviewPanel.this.myDispatcher.getMulticaster()).open();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/SqlPreviewPanel$3", "mouseClicked"));
            }
        });
        return openInConsole;
    }

    public String getQuery() {
        return this.myPreviewEditor.getText();
    }

    public void setQuery(@NotNull String query) {
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(11);
        }
        this.myPreviewEditor.setText(query);
    }

    public void foldToStatements() {
        this.myPreviewEditor.addSettingsProvider(editor -> {
            FoldingModelEx model = editor.getFoldingModel();
            final Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), (Disposable)disposable);
            model.addListener(new FoldingListener(){

                public void onFoldRegionStateChange(@NotNull FoldRegion region) {
                    if (region == null) {
                        4.$$$reportNull$$$0(0);
                    }
                }

                public void onFoldProcessingEnd() {
                    Disposer.dispose((Disposable)disposable);
                    TransactionGuard.getInstance().submitTransactionLater(Disposer.newDisposable(), () -> new ExpandAllToLevel1Action().getHandler().execute((Editor)editor, null, null));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/database/view/ui/SqlPreviewPanel$4", "onFoldRegionStateChange"));
                }
            }, disposable);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/ui/SqlPreviewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeOpenInConsole";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "openInConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setQuery";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface OpenInConsoleListener
    extends EventListener {
        public void open();
    }
}

