/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text2) {
        SqlStringLiteralManipulator.LiteralType type = SqlStringLiteralManipulator.LiteralType.QUOTED;
        for (int i2 = 0; i2 < startOffsets.length && type != null; ++i2) {
            int startOffset = startOffsets[i2];
            PsiElement element = SqlStringLiteralManipulator.getStringElement(file.findElementAt(startOffset));
            TextRange range = element == null ? null : element.getTextRange();
            type = range != null && startOffset >= range.getStartOffset() && endOffsets[i2] <= range.getEndOffset() ? SqlStringLiteralManipulator.getStringLiteralType(element) : null;
        }
        return type == null ? null : SqlStringLiteralManipulator.unescapeSqlStringCharacters(text2, type);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text2, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement element = SqlStringLiteralManipulator.getStringElement(file.findElementAt(caretOffset));
        if (element != null && caretOffset > element.getTextOffset()) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    SqlCopyPasteProcessor.$$$reportNull$$$0(0);
                }
                return string;
            }
            SqlStringLiteralManipulator.LiteralType type = SqlStringLiteralManipulator.getStringLiteralType(element);
            text2 = SqlStringLiteralManipulator.escapeSqlStringCharacters(text2, type);
        }
        String string = text2;
        if (string == null) {
            SqlCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlCopyPasteProcessor", "preprocessOnPaste"));
    }
}

