/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.sql.SqlGeneralExecutionFlowAnalyzer$sam$java_util_concurrent_Callable$0;
import com.intellij.sql.SqlRoutineIndex;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myDdlAnalyzer", "Lcom/intellij/sql/psi/SqlDdlStatement;", "myDmlAnalyzer", "Lcom/intellij/sql/psi/SqlDmlStatement;", "myRoutineAnalyzer", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "analyze", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "DdlAnalyzer", "DmlAnalyzer", "RoutineFlowAnalyzer", "SimpleFlow", "UnknownFlow", "intellij.database.sql.impl"})
public final class SqlGeneralExecutionFlowAnalyzer
implements SqlExecutionFlowAnalyzer<PsiElement> {
    private final SqlExecutionFlowAnalyzer<SqlFunctionCallExpression> myRoutineAnalyzer;
    private final SqlExecutionFlowAnalyzer<SqlDmlStatement> myDmlAnalyzer;
    private final SqlExecutionFlowAnalyzer<SqlDdlStatement> myDdlAnalyzer;

    @NotNull
    public SqlExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element) {
        SqlExecutionFlowAnalyzer.Flow flow;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (this.myRoutineAnalyzer.isAcceptable(element)) {
            SqlExecutionFlowAnalyzer.Flow flow2 = this.myRoutineAnalyzer.analyze((PsiElement)((SqlFunctionCallExpression)element));
            flow = flow2;
            Intrinsics.checkExpressionValueIsNotNull((Object)flow2, (String)"myRoutineAnalyzer.analyz\u2026qlFunctionCallExpression)");
        } else if (this.myDdlAnalyzer.isAcceptable(element)) {
            SqlExecutionFlowAnalyzer.Flow flow3 = this.myDdlAnalyzer.analyze((PsiElement)((SqlDdlStatement)element));
            flow = flow3;
            Intrinsics.checkExpressionValueIsNotNull((Object)flow3, (String)"myDdlAnalyzer.analyze(element as SqlDdlStatement)");
        } else if (this.myDmlAnalyzer.isAcceptable(element)) {
            SqlExecutionFlowAnalyzer.Flow flow4 = this.myDmlAnalyzer.analyze((PsiElement)((SqlDmlStatement)element));
            flow = flow4;
            Intrinsics.checkExpressionValueIsNotNull((Object)flow4, (String)"myDmlAnalyzer.analyze(element as SqlDmlStatement)");
        } else {
            flow = UnknownFlow.INSTANCE;
        }
        return flow;
    }

    public boolean isAcceptable(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.myRoutineAnalyzer.isAcceptable(element) || this.myDdlAnalyzer.isAcceptable(element) || this.myDmlAnalyzer.isAcceptable(element);
    }

    public SqlGeneralExecutionFlowAnalyzer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.myRoutineAnalyzer = new RoutineFlowAnalyzer(project);
        this.myDmlAnalyzer = new DmlAnalyzer();
        this.myDdlAnalyzer = new DdlAnalyzer();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DmlAnalyzer;", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlDmlStatement;", "()V", "analyze", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "Lcom/intellij/psi/PsiElement;", "DmlFlow", "intellij.database.sql.impl"})
    private static final class DmlAnalyzer
    implements SqlExecutionFlowAnalyzer<SqlDmlStatement> {
        @NotNull
        public SqlExecutionFlowAnalyzer.Flow analyze(@NotNull SqlDmlStatement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return DmlFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return e instanceof SqlDmlStatement;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DmlAnalyzer$DmlFlow;", "Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SimpleFlow;", "()V", "transform", "T", "transformer", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.impl"})
        public static final class DmlFlow
        extends SimpleFlow {
            public static final DmlFlow INSTANCE;

            public <T> T transform(@NotNull SqlExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
                return (T)transformer.dml();
            }

            private DmlFlow() {
                super(ThreeState.NO);
            }

            static {
                DmlFlow dmlFlow;
                INSTANCE = dmlFlow = new DmlFlow();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DdlAnalyzer;", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlDdlStatement;", "()V", "analyze", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "Lcom/intellij/psi/PsiElement;", "DdlFlow", "intellij.database.sql.impl"})
    private static final class DdlAnalyzer
    implements SqlExecutionFlowAnalyzer<SqlDdlStatement> {
        @NotNull
        public SqlExecutionFlowAnalyzer.Flow analyze(@NotNull SqlDdlStatement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return DdlFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return e instanceof SqlDdlStatement;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DdlAnalyzer$DdlFlow;", "Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SimpleFlow;", "()V", "transform", "T", "transformer", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.impl"})
        public static final class DdlFlow
        extends SimpleFlow {
            public static final DdlFlow INSTANCE;

            public <T> T transform(@NotNull SqlExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
                return (T)transformer.ddl();
            }

            private DdlFlow() {
                super(ThreeState.NO);
            }

            static {
                DdlFlow ddlFlow;
                INSTANCE = ddlFlow = new DdlFlow();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019*\u00020\u001aH\u0002R*\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myCachedValues", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/psi/DbRoutine;", "kotlin.jvm.PlatformType", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "myExecutor", "Ljava/util/concurrent/ExecutorService;", "myProject", "analyze", "call", "dispose", "", "inTests", "", "isAcceptable", "value", "Lcom/intellij/psi/PsiElement;", "dbResolve", "", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "FlowEvaluator", "RoutineFlow", "intellij.database.sql.impl"})
    private static final class RoutineFlowAnalyzer
    implements SqlExecutionFlowAnalyzer<SqlFunctionCallExpression>,
    Disposable {
        private final ConcurrentMap<DbRoutine, SqlExecutionFlowAnalyzer.Flow> myCachedValues;
        private final Project myProject;
        private final ExecutorService myExecutor;

        @NotNull
        public SqlExecutionFlowAnalyzer.Flow analyze(@NotNull SqlFunctionCallExpression call) {
            SqlExecutionFlowAnalyzer.Flow flow;
            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
            Object object = call.getNameElement();
            if (object == null || (object = this.dbResolve((SqlReferenceExpression)object)) == null) {
                return UnknownFlow.INSTANCE;
            }
            Object routines = object;
            if (routines.isEmpty()) {
                return UnknownFlow.INSTANCE;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DbRoutine)CollectionsKt.first((List)routines)).getDataSource());
            if (localDataSource == null) {
                return UnknownFlow.INSTANCE;
            }
            LocalDataSource dataSource = localDataSource;
            Function0 evaluator2 = (Function0)new Function0<SqlExecutionFlowAnalyzer.Flow>(this, (List)routines, call, dataSource){
                final /* synthetic */ RoutineFlowAnalyzer this$0;
                final /* synthetic */ List $routines;
                final /* synthetic */ SqlFunctionCallExpression $call;
                final /* synthetic */ LocalDataSource $dataSource;

                @NotNull
                public final SqlExecutionFlowAnalyzer.Flow invoke() {
                    Project project = RoutineFlowAnalyzer.access$getMyProject$p(this.this$0);
                    SqlElement sqlElement = (SqlElement)this.$call;
                    LocalDataSource localDataSource = this.$dataSource;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"dataSource");
                    return this.this$0.new FlowEvaluator(project, this.$routines, sqlElement, localDataSource).evaluate();
                }
                {
                    this.this$0 = routineFlowAnalyzer;
                    this.$routines = list;
                    this.$call = sqlFunctionCallExpression;
                    this.$dataSource = localDataSource;
                    super(0);
                }
            };
            if (this.inTests()) {
                flow = (SqlExecutionFlowAnalyzer.Flow)evaluator2.invoke();
            } else {
                ExecutorService executorService = this.myExecutor;
                if (executorService == null) {
                    Intrinsics.throwNpe();
                }
                Function0 function0 = evaluator2;
                Object t = executorService.submit(new SqlGeneralExecutionFlowAnalyzer$sam$java_util_concurrent_Callable$0(function0)).get();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"myExecutor!!.submit<SqlE\u2026er.Flow>(evaluator).get()");
                flow = (SqlExecutionFlowAnalyzer.Flow)t;
            }
            return flow;
        }

        public void dispose() {
            if (!this.inTests()) {
                ExecutorService executorService = this.myExecutor;
                if (executorService == null) {
                    Intrinsics.throwNpe();
                }
                executorService.shutdown();
            }
        }

        private final boolean inTests() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            return application.isUnitTestMode();
        }

        public boolean isAcceptable(@NotNull PsiElement value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value instanceof SqlFunctionCallExpression;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DbRoutine> dbResolve(@NotNull SqlReferenceExpression $receiver) {
            void $receiver$iv$iv;
            ResolveResult[] $receiver$iv;
            ResolveResult[] resolveResultArray = $receiver.multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"multiResolve(false)");
            ResolveResult[] resolveResultArray2 = $receiver$iv = resolveResultArray;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            int n = ((void)$receiver$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                DbRoutine dbRoutine;
                void element$iv$iv$iv;
                void element$iv$iv;
                void it;
                void v1 = it = (element$iv$iv = (element$iv$iv$iv = $receiver$iv$iv$iv[j]));
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                PsiElement psiElement = v1.getElement();
                if (!(psiElement instanceof DbRoutine)) {
                    psiElement = null;
                }
                if ((DbRoutine)psiElement == null) continue;
                DbRoutine it$iv$iv = dbRoutine;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public RoutineFlowAnalyzer(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.myCachedValues = ContainerUtil.createConcurrentSoftMap();
            this.myProject = project;
            this.myExecutor = this.inTests() ? null : (ExecutorService)ConcurrencyUtil.newSingleThreadExecutor((String)"SqlRoutineFlowAnalyzer");
            project.getMessageBus().connect((Disposable)project).subscribe(SqlRoutineIndex.Companion.getTopic(), (Object)new SqlRoutineIndex.SqlRoutineIndexListener(){

                @Override
                public void built() {
                    if (this.inTests()) {
                        myCachedValues.clear();
                        return;
                    }
                    ExecutorService executorService = myExecutor;
                    if (executorService == null) {
                        Intrinsics.throwNpe();
                    }
                    executorService.submit(new Runnable(this){
                        final /* synthetic */ 1 this$0;

                        public final void run() {
                            RoutineFlowAnalyzer.access$getMyCachedValues$p(this.this$0.this).clear();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            });
            Disposer.register((Disposable)((Disposable)project), (Disposable)this);
        }

        @NotNull
        public static final /* synthetic */ Project access$getMyProject$p(RoutineFlowAnalyzer $this) {
            return $this.myProject;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005*\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00060\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$FlowEvaluator;", "", "project", "Lcom/intellij/openapi/project/Project;", "routines", "", "Lcom/intellij/database/psi/DbRoutine;", "context", "Lcom/intellij/sql/psi/SqlElement;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/sql/psi/SqlElement;Lcom/intellij/database/dataSource/LocalDataSource;)V", "myDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "myVisited", "Lgnu/trove/THashSet;", "kotlin.jvm.PlatformType", "analyze", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "analyzeRoutine", "routine", "analyzeValue", "value", "Lcom/intellij/sql/SqlRoutineIndex$Value;", "evaluate", "mergeFlows", "flows", "asReference", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Lcom/intellij/sql/SqlRoutineIndex$Call;", "dialect", "getValues", "Lcom/intellij/sql/SqlRoutineIndex$IdentifiablePath;", "intellij.database.sql.impl"})
        private final class FlowEvaluator {
            private final SqlLanguageDialect myDialect;
            private final THashSet<DbRoutine> myVisited;
            private final Project project;
            private final List<DbRoutine> routines;
            private final SqlElement context;

            @NotNull
            public final SqlExecutionFlowAnalyzer.Flow evaluate() {
                Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this){
                    final /* synthetic */ FlowEvaluator this$0;

                    @NotNull
                    public final SqlExecutionFlowAnalyzer.Flow compute() {
                        return FlowEvaluator.access$analyze(this.this$0, FlowEvaluator.access$getRoutines$p(this.this$0));
                    }
                    {
                        this.this$0 = flowEvaluator;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ReadAction.compute<SqlEx\u2026on> { analyze(routines) }");
                return (SqlExecutionFlowAnalyzer.Flow)object;
            }

            /*
             * WARNING - void declaration
             */
            private final SqlExecutionFlowAnalyzer.Flow analyze(List<? extends DbRoutine> routines) {
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = routines;
                FlowEvaluator flowEvaluator = this;
                void var3_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    SqlExecutionFlowAnalyzer.Flow flow;
                    Object element$iv$iv = element$iv$iv$iv;
                    DbRoutine it = (DbRoutine)element$iv$iv;
                    if (this.analyzeRoutine(it) == null) continue;
                    SqlExecutionFlowAnalyzer.Flow it$iv$iv = flow;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return flowEvaluator.mergeFlows(list);
            }

            /*
             * WARNING - void declaration
             */
            private final SqlExecutionFlowAnalyzer.Flow analyzeRoutine(DbRoutine routine) {
                SqlExecutionFlowAnalyzer.Flow flow;
                Object object;
                SqlExecutionFlowAnalyzer.Flow flow2;
                Object dataSource;
                Object object2;
                SqlExecutionFlowAnalyzer.Flow cached = (SqlExecutionFlowAnalyzer.Flow)RoutineFlowAnalyzer.this.myCachedValues.get(routine);
                if (cached != null) {
                    return cached;
                }
                if (this.myVisited.contains((Object)routine)) {
                    return null;
                }
                this.myVisited.add((Object)routine);
                DasObject dasObject = (DasObject)routine;
                DbDataSource dbDataSource = routine.getDataSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource, (String)"routine.dataSource");
                ObjectPath path = ObjectPaths.of(dasObject, (CasingProvider)dbDataSource.getModel());
                DbDataSource dbDataSource2 = routine.getDataSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource2, (String)"routine.dataSource");
                DatabaseSystem databaseSystem = dbDataSource2.getDelegate();
                if (!(databaseSystem instanceof LocalDataSource)) {
                    databaseSystem = null;
                }
                if ((object2 = (LocalDataSource)databaseSystem) == null || (object2 = ((AbstractDataSource)((Object)object2)).getUniqueId()) == null) {
                    return null;
                }
                Object object3 = dataSource = object2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"dataSource");
                ObjectPath objectPath = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"path");
                List<SqlRoutineIndex.Value> values2 = this.getValues(new SqlRoutineIndex.IdentifiablePath((String)object3, objectPath), this.project);
                if (values2.isEmpty()) {
                    flow2 = RoutineFlow.PURE;
                } else {
                    Collection<SqlExecutionFlowAnalyzer.Flow> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    object = values2;
                    FlowEvaluator flowEvaluator = this;
                    flow = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        SqlRoutineIndex.Value value = (SqlRoutineIndex.Value)item$iv$iv;
                        collection = destination$iv$iv;
                        SqlExecutionFlowAnalyzer.Flow flow3 = this.analyzeValue((SqlRoutineIndex.Value)it);
                        collection.add(flow3);
                    }
                    collection = (List)destination$iv$iv;
                    flow2 = flowEvaluator.mergeFlows((List<? extends SqlExecutionFlowAnalyzer.Flow>)collection);
                }
                SqlExecutionFlowAnalyzer.Flow flow4 = flow2;
                ConcurrentMap concurrentMap = RoutineFlowAnalyzer.this.myCachedValues;
                Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"myCachedValues");
                object = concurrentMap;
                flow = flow4;
                object.put(routine, flow);
                return flow4;
            }

            private final SqlExecutionFlowAnalyzer.Flow analyzeValue(SqlRoutineIndex.Value value) {
                if (!value.getPure()) {
                    return RoutineFlow.NOT_PURE;
                }
                SqlRoutineIndex.Call[] callArray = value.getCalls();
                if (callArray.length == 0) {
                    return RoutineFlow.PURE;
                }
                for (SqlRoutineIndex.Call call : value.getCalls()) {
                    SqlReferenceExpression reference;
                    if (this.asReference(call, this.context, this.myDialect) == null) {
                        continue;
                    }
                    List resolved = RoutineFlowAnalyzer.this.dbResolve(reference);
                    if (resolved.isEmpty()) {
                        return RoutineFlow.UNSURE;
                    }
                    SqlExecutionFlowAnalyzer.Flow result2 = this.analyze(resolved);
                    if (result2.isPure() != ThreeState.NO && result2.isPure() != ThreeState.UNSURE) continue;
                    return result2;
                }
                return RoutineFlow.PURE;
            }

            private final SqlExecutionFlowAnalyzer.Flow mergeFlows(List<? extends SqlExecutionFlowAnalyzer.Flow> flows) {
                SqlExecutionFlowAnalyzer.Flow flow;
                SqlExecutionFlowAnalyzer.Flow it;
                boolean bl;
                Iterable $receiver$iv;
                block8: {
                    $receiver$iv = flows;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            it = (SqlExecutionFlowAnalyzer.Flow)element$iv;
                            if (it.isPure() == ThreeState.YES) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    flow = RoutineFlow.PURE;
                } else {
                    boolean bl2;
                    block9: {
                        $receiver$iv = flows;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $receiver$iv) {
                                it = (SqlExecutionFlowAnalyzer.Flow)element$iv;
                                if (it.isPure() == ThreeState.NO) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    }
                    flow = bl2 ? (SqlExecutionFlowAnalyzer.Flow)RoutineFlow.NOT_PURE : (SqlExecutionFlowAnalyzer.Flow)RoutineFlow.UNSURE;
                }
                return flow;
            }

            private final SqlReferenceExpression asReference(@NotNull SqlRoutineIndex.Call $receiver, SqlElement context, SqlLanguageDialect dialect) {
                return SqlPsiElementFactory.createReferenceFromText($receiver.getText(), dialect, $receiver.getType(), (PsiElement)context);
            }

            private final List<SqlRoutineIndex.Value> getValues(@NotNull SqlRoutineIndex.IdentifiablePath $receiver, Project project) {
                ID<SqlRoutineIndex.IdentifiablePath, List<SqlRoutineIndex.Value>> id = SqlRoutineIndex.Companion.getIndexId();
                List list = FileBasedIndex.getInstance().getValues(id, (Object)$receiver, GlobalSearchScope.projectScope((Project)project));
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"FileBasedIndex.getInstan\u2026pe.projectScope(project))");
                return CollectionsKt.flatten((Iterable)list);
            }

            public FlowEvaluator(@NotNull Project project, @NotNull List<? extends DbRoutine> routines, @NotNull SqlElement context, LocalDataSource dataSource) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull(routines, (String)"routines");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
                this.project = project;
                this.routines = routines;
                this.context = context;
                SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource);
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
                this.myDialect = sqlLanguageDialect;
                this.myVisited = ContainerUtil.newIdentityTroveSet();
            }

            @NotNull
            public static final /* synthetic */ SqlExecutionFlowAnalyzer.Flow access$analyze(FlowEvaluator $this, @NotNull List routines) {
                return $this.analyze(routines);
            }

            @NotNull
            public static final /* synthetic */ List access$getRoutines$p(FlowEvaluator $this) {
                return $this.routines;
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016J!\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$RoutineFlow;", "", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "pure", "Lcom/intellij/util/ThreeState;", "(Ljava/lang/String;ILcom/intellij/util/ThreeState;)V", "isPure", "transform", "T", "transformer", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "PURE", "NOT_PURE", "UNSURE", "intellij.database.sql.impl"})
        private static final class RoutineFlow
        extends Enum<RoutineFlow>
        implements SqlExecutionFlowAnalyzer.Flow {
            public static final /* enum */ RoutineFlow PURE;
            public static final /* enum */ RoutineFlow NOT_PURE;
            public static final /* enum */ RoutineFlow UNSURE;
            private static final /* synthetic */ RoutineFlow[] $VALUES;
            private final ThreeState pure;

            static {
                RoutineFlow[] routineFlowArray = new RoutineFlow[3];
                RoutineFlow[] routineFlowArray2 = routineFlowArray;
                routineFlowArray[0] = PURE = new RoutineFlow(ThreeState.YES);
                routineFlowArray[1] = NOT_PURE = new RoutineFlow(ThreeState.NO);
                routineFlowArray[2] = UNSURE = new RoutineFlow(ThreeState.UNSURE);
                $VALUES = routineFlowArray;
            }

            @NotNull
            public ThreeState isPure() {
                return this.pure;
            }

            public <T> T transform(@NotNull SqlExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
                return (T)transformer.routine();
            }

            protected RoutineFlow(ThreeState pure2) {
                Intrinsics.checkParameterIsNotNull((Object)pure2, (String)"pure");
                this.pure = pure2;
            }

            public static RoutineFlow[] values() {
                return (RoutineFlow[])$VALUES.clone();
            }

            public static RoutineFlow valueOf(String string) {
                return Enum.valueOf(RoutineFlow.class, string);
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$UnknownFlow;", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "()V", "isPure", "Lcom/intellij/util/ThreeState;", "transform", "", "T", "transformer", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$FlowTransformer;", "intellij.database.sql.impl"})
    public static final class UnknownFlow
    implements SqlExecutionFlowAnalyzer.Flow {
        public static final UnknownFlow INSTANCE;

        @NotNull
        public ThreeState isPure() {
            return ThreeState.YES;
        }

        @Nullable
        public <T> Void transform(@NotNull SqlExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
            Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
            return null;
        }

        private UnknownFlow() {
        }

        static {
            UnknownFlow unknownFlow;
            INSTANCE = unknownFlow = new UnknownFlow();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SimpleFlow;", "Lcom/intellij/sql/psi/SqlExecutionFlowAnalyzer$Flow;", "pure", "Lcom/intellij/util/ThreeState;", "(Lcom/intellij/util/ThreeState;)V", "isPure", "intellij.database.sql.impl"})
    private static abstract class SimpleFlow
    implements SqlExecutionFlowAnalyzer.Flow {
        private final ThreeState pure;

        @NotNull
        public ThreeState isPure() {
            return this.pure;
        }

        public SimpleFlow(@NotNull ThreeState pure2) {
            Intrinsics.checkParameterIsNotNull((Object)pure2, (String)"pure");
            this.pure = pure2;
        }
    }
}

