/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.AbstractSqlBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlElementTypes;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J \u0010#\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/intellij/sql/com/intellij/sql/formatter/BaseSqlBlock;", "Lcom/intellij/sql/formatter/AbstractSqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;)V", "custom", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "getCustom", "()Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "buildBlocks", "", "blockNode", "builtBlocks", "Ljava/util/ArrayList;", "Lcom/intellij/formatting/Block;", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "isLeaf", "", "makeBlock", "element", "Lcom/intellij/psi/PsiElement;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "whetherToFlatten", "intellij.database.sql.impl"})
public class BaseSqlBlock
extends AbstractSqlBlock {
    @Override
    protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)blockNode, (String)"blockNode");
        Intrinsics.checkParameterIsNotNull(builtBlocks, (String)"builtBlocks");
        for (ASTNode node = blockNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type;
            PsiElement element;
            block6: {
                block5: {
                    element = node.getPsi();
                    type = node.getElementType();
                    if (SqlFormatting.isWhitespace(node)) continue;
                    if (type == SqlElementTypes.SQL_DUMMY_BLOCK) break block5;
                    PsiElement psiElement = element;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element");
                    IElementType iElementType = type;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"type");
                    if (!this.whetherToFlatten(node, psiElement, iElementType)) break block6;
                }
                this.buildBlocks(node, builtBlocks);
                continue;
            }
            if (element instanceof IsExternal) {
                builtBlocks.add((Block)new SqlFormattingBlock.ReadOnlyBlock(node));
                continue;
            }
            SqlBlock block = this.makeBlock(node, element, type);
            builtBlocks.add((Block)block);
        }
    }

    protected boolean whetherToFlatten(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        return false;
    }

    @NotNull
    protected SqlBlock makeBlock(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        SqlFormattingContext sqlFormattingContext = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
        return SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, null, null, null, false, 32, null);
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        SqlFormattingContext sqlFormattingContext = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
        Spacing spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
        if (spacing == null) {
            spacing = SqlFormatting.makeSafeSpace$default(false, 1, null);
        }
        return spacing;
    }

    public boolean isLeaf() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        return !SqlFormatting.isComplex(aSTNode);
    }

    @NotNull
    public final SqlCodeStyleSettings getCustom() {
        SqlCodeStyleSettings sqlCodeStyleSettings = this.getContext().customSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCodeStyleSettings, (String)"context.customSettings");
        return sqlCodeStyleSettings;
    }

    public BaseSqlBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(node, context, wrap, alignment, indent);
    }
}

