/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlCortegeBlock;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.SlqStringLiteralConcatenationBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlBlockCommentBlock;
import com.intellij.sql.formatter.SqlBlockQuery;
import com.intellij.sql.formatter.SqlBlockSubquery;
import com.intellij.sql.formatter.SqlExpressionBlock;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlIdentifierWord;
import com.intellij.sql.formatter.SqlLineCommentBlock;
import com.intellij.sql.formatter.SqlQueryCategory;
import com.intellij.sql.formatter.SqlSymbol;
import com.intellij.sql.formatter.SqlTerminal;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.Function;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0003\u001a \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a@\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007\u001a\u0006\u0010\u001c\u001a\u00020\u000b\u001a\u0010\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001b\u001a\u0010\u0010\u001f\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001b\u001a\u001a\u0010 \u001a\u00020\u000b2\b\b\u0002\u0010!\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u001b\u001a\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u001e\u001a\u00020\u001b\u001a\u0006\u0010$\u001a\u00020\u000b\u001a\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001b\u001a\u001a\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010)\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010\"\u001a\u00020#\u001a\u0014\u0010*\u001a\u0004\u0018\u00010\u0007*\u00020\u00132\u0006\u0010\"\u001a\u00020#\u001a\u001c\u0010+\u001a\u00020\u0015*\u0004\u0018\u00010\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001b\u001a\u0014\u0010/\u001a\u00020\u001b*\u00020\u00132\u0006\u00100\u001a\u00020#H\u0000\u001a\n\u00101\u001a\u00020\u001b*\u00020\u0013\u001a\f\u00102\u001a\u00020\u001b*\u0004\u0018\u00010\u0013\u001a\u0014\u00102\u001a\u00020\u001b*\u0004\u0018\u00010\u00132\u0006\u00103\u001a\u000204\u001a\f\u00105\u001a\u00020\u001b*\u0004\u0018\u00010\u0013\u001a\f\u00106\u001a\u00020\u001b*\u0004\u0018\u00010\u0013\u001a\u0018\u00106\u001a\u00020\u001b*\u0004\u0018\u00010\u00132\n\u00107\u001a\u000208\"\u000209\u001a\f\u00106\u001a\u00020\u001b*\u000209H\u0002\u001a\n\u0010:\u001a\u00020\u001b*\u00020\u0013\u001a\n\u0010;\u001a\u00020\u001b*\u00020\u0013\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00070\u00070\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"LINE_COMMENT_TYPES", "", "Lcom/intellij/sql/psi/impl/SqlTokenType;", "kotlin.jvm.PlatformType", "getLINE_COMMENT_TYPES", "()Ljava/util/Set;", "MEANINGLESS_TYPES", "Lcom/intellij/psi/tree/IElementType;", "getMEANINGLESS_TYPES", "MUST_FOLLOWED_NL_TYPES", "commonSpacing", "Lcom/intellij/formatting/Spacing;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "createDefaultBlock", "node", "Lcom/intellij/lang/ASTNode;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "collapse", "", "makeNL", "makeNoSpace", "keepLineBreaks", "makeSafeSpace", "makeSpace", "space", "n", "", "makeSpacingBeforeComment", "makeSpacingPreserveNL", "makeSpacingWhenItMustNL", "c", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "child", "childType", "createChildWrap", "type", "Lcom/intellij/formatting/WrapType;", "wrapFirst", "determineCanItFitIn", "limit", "isComplex", "isKeyWord", "text", "", "isSubQuery", "isSymbol", "symbols", "", "", "isWhitespace", "isWhitespaceOrComment", "intellij.database.sql.impl"})
@JvmName(name="SqlFormatting")
public final class SqlFormatting {
    @NotNull
    private static final Set<IElementType> MEANINGLESS_TYPES = SetsKt.setOf((Object[])new IElementType[]{SqlTokens.SQL_WHITE_SPACE, (IElementType)SqlTokens.SQL_BLOCK_COMMENT, (IElementType)SqlTokens.SQL_LINE_COMMENT, (IElementType)SqlTokens.MYSQL_LINE_COMMENT, (IElementType)SqlTokens.ORAP_LINE_COMMENT, (IElementType)SqlTokens.ORAP_DELIMITER_TOKEN});
    @NotNull
    private static final Set<SqlTokenType> LINE_COMMENT_TYPES = SetsKt.setOf((Object[])new SqlTokenType[]{SqlTokens.SQL_LINE_COMMENT, SqlTokens.MYSQL_LINE_COMMENT, SqlTokens.ORAP_LINE_COMMENT});
    @JvmField
    @NotNull
    public static final Set<IElementType> MUST_FOLLOWED_NL_TYPES;

    @JvmOverloads
    @NotNull
    public static final SqlBlock createDefaultBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean collapse) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (SqlFormatting.isKeyWord(node)) {
            sqlBlock = new SqlWord(node, context, wrap, alignment, indent, 0);
        } else if (SqlFormatting.isSymbol(node)) {
            sqlBlock = new SqlSymbol(node, context, wrap, alignment, indent);
        } else {
            IElementType iElementType = node.getElementType();
            if (iElementType instanceof SqlKeywordTokenType) {
                sqlBlock = new SqlWord(node, context, wrap, alignment, indent, 0);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                sqlBlock = new SqlIdentifierWord(node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION)) {
                sqlBlock = new SqlBlockSubquery(node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION)) {
                IElementType iElementType2 = SqlFormatting.childType(node, 2);
                sqlBlock = Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION) ? (SqlBlock)new SqlBlockSubquery(node, context, wrap, alignment, indent) : SqlExpressionBlock.Companion.create(node, context, wrap, alignment, indent, collapse);
                if (sqlBlock == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.formatter.SqlBlock");
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_SELECT_STATEMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION)) {
                sqlBlock = new SqlBlockQuery(SqlQueryCategory.QUERY_SELECT, node, context, wrap, alignment, indent, collapse, collapse);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_INSERT_STATEMENT)) {
                sqlBlock = new SqlBlockQuery(SqlQueryCategory.QUERY_INSERT, node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_UPDATE_STATEMENT)) {
                sqlBlock = new SqlBlockQuery(SqlQueryCategory.QUERY_UPDATE, node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_DELETE_STATEMENT)) {
                sqlBlock = new SqlBlockQuery(SqlQueryCategory.QUERY_DELETE, node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_LINE_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.MYSQL_LINE_COMMENT)) {
                sqlBlock = new SqlLineCommentBlock(node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_BLOCK_COMMENT)) {
                sqlBlock = new SqlBlockCommentBlock(node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_REFERENCE_LIST)) {
                sqlBlock = new SqlCortegeBlock(node, context, wrap, alignment, indent);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL_CONCATENATION)) {
                sqlBlock = new SlqStringLiteralConcatenationBlock(node, context, wrap, alignment, indent, collapse);
            } else {
                ASTNode aSTNode = node;
                if ((aSTNode instanceof SqlLiteralExpression ? (SqlBlock)new SqlTerminal(node, context, wrap, alignment, indent) : (sqlBlock = aSTNode instanceof SqlExpression ? SqlExpressionBlock.Companion.create(node, context, wrap, alignment, indent, collapse) : (SqlBlock)new SqlFormattingBlock(node, context, wrap, alignment, null, indent))) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.formatter.SqlBlock");
                }
            }
        }
        return sqlBlock;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ SqlBlock createDefaultBlock$default(ASTNode aSTNode, SqlFormattingContext sqlFormattingContext, Wrap wrap, Alignment alignment, Indent indent, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return SqlFormatting.createDefaultBlock(aSTNode, sqlFormattingContext, wrap, alignment, indent, bl);
    }

    @JvmOverloads
    @NotNull
    public static final SqlBlock createDefaultBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        return SqlFormatting.createDefaultBlock$default(node, context, wrap, alignment, indent, false, 32, null);
    }

    public static final boolean isSubQuery(@Nullable ASTNode $receiver) {
        ASTNode p;
        ASTNode aSTNode = $receiver;
        Object object = p = aSTNode != null ? aSTNode.getTreeParent() : null;
        while (p != null) {
            IElementType t = p.getElementType();
            if (t == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION || t == SqlCompositeElementTypes.SQL_SELECT_CLAUSE || t == SqlCompositeElementTypes.SQL_FROM_CLAUSE || t == SqlCompositeElementTypes.SQL_WHERE_CLAUSE || t == SqlCompositeElementTypes.SQL_VALUES_EXPRESSION || t == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT) {
                return true;
            }
            p = p.getTreeParent();
        }
        return false;
    }

    public static final boolean isComplex(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ASTNode aSTNode = $receiver.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode child1 = aSTNode;
        if (child1.getTreeNext() != null) {
            return true;
        }
        return SqlFormatting.isComplex(child1);
    }

    public static final boolean isKeyWord(@Nullable ASTNode $receiver) {
        if ($receiver == null) {
            return false;
        }
        IElementType type = $receiver.getElementType();
        IElementType iElementType = type;
        if (iElementType instanceof SqlKeywordTokenType) {
            return true;
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_BLOCK_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_LINE_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.MYSQL_LINE_COMMENT)) {
            return false;
        }
        ASTNode aSTNode = $receiver.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode child1 = aSTNode;
        ASTNode child2 = child1.getTreeNext();
        if (child2 != null) {
            return false;
        }
        return SqlFormatting.isKeyWord(child1);
    }

    public static final boolean isKeyWord(@Nullable ASTNode $receiver, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return $receiver != null && SqlFormatting.isKeyWord($receiver) && StringsKt.equals((String)$receiver.getText(), (String)text2, (boolean)true);
    }

    public static final boolean isSymbol(@Nullable ASTNode $receiver) {
        String text2;
        if ($receiver == null) {
            return false;
        }
        if (MEANINGLESS_TYPES.contains($receiver.getElementType())) {
            return false;
        }
        int n = $receiver.getTextLength();
        if (n == 1) {
            char c = $receiver.getText().charAt(0);
            return SqlFormatting.isSymbol(c);
        }
        if ($receiver.getFirstChildNode() != null) {
            return false;
        }
        String string = text2 = $receiver.getText();
        int n2 = string.length();
        for (int j = 0; j < n2; ++j) {
            char c = string.charAt(j);
            if (SqlFormatting.isSymbol(c)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSymbol(@Nullable ASTNode $receiver, char ... symbols) {
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        if ($receiver == null) {
            return false;
        }
        if (MEANINGLESS_TYPES.contains($receiver.getElementType())) {
            return false;
        }
        int n = $receiver.getTextLength();
        if (n == 1) {
            char c = $receiver.getText().charAt(0);
            for (char symbol : symbols) {
                if (c != symbol) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isSymbol(char $receiver) {
        char c = $receiver;
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        return $receiver != '_';
    }

    @Nullable
    public static final ASTNode child(@NotNull ASTNode $receiver, int n) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ASTNode c = $receiver.getFirstChildNode();
        int k = 0;
        while (c != null) {
            if (SqlFormatting.isWhitespaceOrComment(c)) {
                c = c.getTreeNext();
                continue;
            }
            if (++k == n) {
                return c;
            }
            c = c.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static final IElementType childType(@NotNull ASTNode $receiver, int n) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ASTNode aSTNode = SqlFormatting.child($receiver, n);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    public static final boolean isWhitespace(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getTextLength() <= 0 || Intrinsics.areEqual((Object)$receiver.getElementType(), (Object)SqlTokens.ORAP_DELIMITER_TOKEN) || $receiver.getPsi() instanceof PsiWhiteSpace;
    }

    public static final boolean isWhitespaceOrComment(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SqlFormatting.isWhitespace($receiver) || MEANINGLESS_TYPES.contains($receiver.getElementType());
    }

    public static final boolean determineCanItFitIn(@NotNull ASTNode $receiver, int limit) {
        Iterator iterator2;
        TreeTraversal.It iterator3;
        TextRange range;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        TextRange textRange = range = $receiver.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
        if (textRange.getLength() <= limit) {
            return true;
        }
        int length = 0;
        TreeTraversal.It it = iterator3 = TreeTraversal.LEAVES_DFS.createIterator((Iterable)CollectionsKt.listOf((Object)$receiver), (Function)determineCanItFitIn.iterator.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"iterator");
        Iterator iterator4 = iterator2 = (Iterator)it;
        while (iterator4.hasNext()) {
            ASTNode node;
            ASTNode aSTNode = node = (ASTNode)iterator4.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
            if (SqlFormatting.isWhitespace(aSTNode)) continue;
            IElementType type = node.getElementType();
            if (CollectionsKt.contains((Iterable)LINE_COMMENT_TYPES, (Object)type)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_BLOCK_COMMENT) && node.textContains('\n')) {
                return false;
            }
            if ((length += node.getTextLength() + 1) <= limit) continue;
            return false;
        }
        return length <= limit;
    }

    @Nullable
    public static final Spacing commonSpacing(@NotNull SqlFormattingContext context, @NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        CommonCodeStyleSettings c = context.commonSettings;
        SqlCodeStyleSettings s = context.customSettings;
        IElementType type1 = block1.getElementType();
        IElementType type2 = block2.getElementType();
        if (CollectionsKt.contains((Iterable)MUST_FOLLOWED_NL_TYPES, (Object)type1)) {
            CommonCodeStyleSettings commonCodeStyleSettings = c;
            Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"c");
            return SqlFormatting.makeSpacingWhenItMustNL(commonCodeStyleSettings, block1);
        }
        TextRange conditionalRange = block2.getConditionalWrappingRange();
        if (conditionalRange != null) {
            TextRange textRange = block1.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"block1.textRange");
            int p1 = textRange.getEndOffset();
            TextRange textRange2 = block2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"block2.textRange");
            int p2 = textRange2.getStartOffset();
            ArrayList<TextRange> region = new ArrayList<TextRange>(2);
            if (conditionalRange.intersects(p1, p2)) {
                if (conditionalRange.getStartOffset() < p1) {
                    region.add(new TextRange(conditionalRange.getStartOffset(), p1));
                }
                if (conditionalRange.getEndOffset() > p2) {
                    region.add(new TextRange(p2, conditionalRange.getEndOffset()));
                }
            } else {
                region.add(conditionalRange);
            }
            return Spacing.createDependentLFSpacing((int)1, (int)1, (List)region, (boolean)c.KEEP_LINE_BREAKS, (int)0);
        }
        Spacing x = block1 instanceof SqlLineCommentBlock ? SqlFormatting.makeNL() : (block2 instanceof SqlBlockCommentBlock || block2 instanceof SqlLineCommentBlock ? SqlFormatting.makeSpacingBeforeComment() : (block1 instanceof SqlBlockCommentBlock ? null : (block1 instanceof SqlWord && block2 instanceof SqlWord && ((SqlWord)block1).mySequentialPosition > 0 && ((SqlWord)block1).mySequentialPosition + 1 == ((SqlWord)block2).mySequentialPosition ? SqlFormatting.makeSpace$default(false, false, 3, null) : (block2 instanceof SqlCortegeBlock ? SqlFormatting.makeSpace$default(s.CORTEGE_SPACE_BEFORE_L_PAREN, false, 2, null) : (type1 == null || type2 == null ? null : (Intrinsics.areEqual((Object)type1, (Object)SqlTokens.SQL_LEFT_PAREN) ? SqlFormatting.makeSpace$default(block2 instanceof SqlBlockQuery ? s.SUBQUERY_PAR_SPACE_INSIDE : c.SPACE_WITHIN_PARENTHESES, false, 2, null) : (Intrinsics.areEqual((Object)type2, (Object)SqlTokens.SQL_RIGHT_PAREN) ? SqlFormatting.makeSpace$default(block1 instanceof SqlBlockQuery ? s.SUBQUERY_PAR_SPACE_INSIDE : c.SPACE_WITHIN_PARENTHESES, false, 2, null) : (Intrinsics.areEqual((Object)type1, (Object)SqlTokens.SQL_COMMA) ? SqlFormatting.makeSpace$default(c.SPACE_AFTER_COMMA, false, 2, null) : (Intrinsics.areEqual((Object)type2, (Object)SqlTokens.SQL_COMMA) ? SqlFormatting.makeSpace$default(c.SPACE_BEFORE_COMMA, false, 2, null) : (Intrinsics.areEqual((Object)type1, (Object)SqlCommonTokens.SQL_PERIOD) || Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_PERIOD) ? SqlFormatting.makeNoSpace$default(false, 1, null) : SqlFormatting.makeSafeSpace(c.KEEP_LINE_BREAKS)))))))))));
        return x;
    }

    @Nullable
    public static final Spacing makeSpacingWhenItMustNL(@NotNull CommonCodeStyleSettings c, @NotNull SqlBlock block1) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        if (Intrinsics.areEqual((Object)block1.getElementType(), (Object)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN)) {
            return null;
        }
        int keepBlankLines = c.KEEP_BLANK_LINES_IN_CODE;
        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)keepBlankLines);
    }

    @NotNull
    public static final Spacing makeNoSpace(boolean keepLineBreaks) {
        Spacing spacing = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(0, 0, 0, keepLineBreaks, 0)");
        return spacing;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Spacing makeNoSpace$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SqlFormatting.makeNoSpace(bl);
    }

    @NotNull
    public static final Spacing makeSpace(boolean space, boolean keepLineBreaks) {
        Spacing spacing = Spacing.createSpacing((int)(space ? 1 : 0), (int)0, (int)0, (boolean)keepLineBreaks, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(if\u2026 0, 0, keepLineBreaks, 0)");
        return spacing;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Spacing makeSpace$default(boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return SqlFormatting.makeSpace(bl, bl2);
    }

    @NotNull
    public static final Spacing makeSpace(int n, boolean keepLineBreaks) {
        Spacing spacing = Spacing.createSpacing((int)n, (int)0, (int)0, (boolean)keepLineBreaks, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(n, 0, 0, keepLineBreaks, 0)");
        return spacing;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Spacing makeSpace$default(int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return SqlFormatting.makeSpace(n, bl);
    }

    @NotNull
    public static final Spacing makeNL() {
        Spacing spacing = Spacing.createSpacing((int)1, (int)0, (int)1, (boolean)false, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSpacing(1, 0, 1, false, 0)");
        return spacing;
    }

    @NotNull
    public static final Spacing makeSafeSpace(boolean keepLineBreaks) {
        Spacing spacing = Spacing.createSafeSpacing((boolean)keepLineBreaks, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createSafeSpacing(keepLineBreaks, 0)");
        return spacing;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Spacing makeSafeSpace$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SqlFormatting.makeSafeSpace(bl);
    }

    @NotNull
    public static final Spacing makeSpacingPreserveNL(boolean keepLineBreaks) {
        return SqlFormatting.makeSafeSpace(keepLineBreaks);
    }

    @NotNull
    public static final Spacing makeSpacingBeforeComment() {
        Spacing spacing = Spacing.createKeepingFirstColumnSpacing((int)0, (int)1000, (boolean)true, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)spacing, (String)"Spacing.createKeepingFir\u2026Spacing(0, 1000, true, 0)");
        return spacing;
    }

    @NotNull
    public static final Wrap createChildWrap(@Nullable Wrap $receiver, @NotNull WrapType type, boolean wrapFirst) {
        Wrap wrap;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if ($receiver != null) {
            Wrap wrap2 = Wrap.createChildWrap((Wrap)$receiver, (WrapType)type, (boolean)wrapFirst);
            wrap = wrap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)wrap2, (String)"Wrap.createChildWrap(this, type, wrapFirst)");
        } else {
            Wrap wrap3 = Wrap.createWrap((WrapType)type, (boolean)wrapFirst);
            wrap = wrap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)wrap3, (String)"Wrap.createWrap(type, wrapFirst)");
        }
        return wrap;
    }

    @NotNull
    public static final Set<IElementType> getMEANINGLESS_TYPES() {
        return MEANINGLESS_TYPES;
    }

    @NotNull
    public static final Set<SqlTokenType> getLINE_COMMENT_TYPES() {
        return LINE_COMMENT_TYPES;
    }

    static {
        Object[] objectArray = new IElementType[5];
        SqlTokenType sqlTokenType = SqlTokens.SQL_LINE_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_LINE_COMMENT");
        objectArray[0] = (IElementType)sqlTokenType;
        SqlTokenType sqlTokenType2 = SqlTokens.MYSQL_LINE_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType2, (String)"MYSQL_LINE_COMMENT");
        objectArray[1] = (IElementType)sqlTokenType2;
        SqlTokenType sqlTokenType3 = SqlTokens.ORAP_LINE_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType3, (String)"ORAP_LINE_COMMENT");
        objectArray[2] = (IElementType)sqlTokenType3;
        SqlTokenType sqlTokenType4 = SqlTokens.PG_COPY_TERMINATOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType4, (String)"PG_COPY_TERMINATOR");
        objectArray[3] = (IElementType)sqlTokenType4;
        SqlTokenType sqlTokenType5 = SqlTokens.ORAP_SLASH_DELIMITER_TOKEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType5, (String)"ORAP_SLASH_DELIMITER_TOKEN");
        objectArray[4] = (IElementType)sqlTokenType5;
        MUST_FOLLOWED_NL_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

