/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.BasicDataSourceManager;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceStorage;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.DatabaseIcons;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceManager
extends BasicDataSourceManager<SqlDataSourceImpl> {
    private final SqlDataSourceStorage myStorage;
    private final MergingUpdateQueue myQueue;

    @NotNull
    public static SqlDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceManager.$$$reportNull$$$0(0);
        }
        SqlDataSourceManager sqlDataSourceManager = (SqlDataSourceManager)((Object)ObjectUtils.notNull((Object)ContainerUtil.findInstance((Object[])EP_NAME.getExtensions((AreaInstance)project), SqlDataSourceManager.class)));
        if (sqlDataSourceManager == null) {
            SqlDataSourceManager.$$$reportNull$$$0(1);
        }
        return sqlDataSourceManager;
    }

    public SqlDataSourceManager(Project project, final SqlDataSourceStorage storage) {
        super(project, storage.getDataSources());
        this.myStorage = storage;
        this.myQueue = new MergingUpdateQueue(((Object)((Object)this)).getClass().getSimpleName(), 200, true, null, (Disposable)project);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){
            FileDocumentManager docManager = FileDocumentManager.getInstance();

            public void documentChanged(DocumentEvent event) {
                VirtualFile file = this.docManager.getFile(event.getDocument());
                if (file != null && file.getFileType() == SqlFileType.INSTANCE && !(file.getFileSystem() instanceof NonPhysicalFileSystem)) {
                    SmartHashSet set = new SmartHashSet();
                    set.add((Object)file);
                    class U
                    extends Update {
                        SmartHashSet<VirtualFile> files;

                        U(SmartHashSet<VirtualFile> files) {
                            super(files);
                            this.files = files;
                        }

                        public void run() {
                            if (this.files.isEmpty()) {
                                return;
                            }
                            JBIterable sources = JBIterable.from(SqlDataSourceManager.this.myStorage.getDataSources());
                            Set ids = (Set)JBIterable.from(this.files).flatten(file -> sources.filterMap(o -> o.containsFile(file) ? o.getUniqueId() : null)).addAllTo((Collection)ContainerUtil.newHashSet());
                            if (ids.isEmpty()) {
                                return;
                            }
                            SqlDataSourceManager.this.clearCaches(SqlDataSourceManager.this.getDataSources(), ids, false);
                        }

                        public boolean canEat(Update update2) {
                            if (update2 instanceof U) {
                                this.files.addAll(((U)update2).files);
                                return true;
                            }
                            return false;
                        }
                    }
                    SqlDataSourceManager.this.myQueue.queue((Update)new U((SmartHashSet<VirtualFile>)set));
                }
            }
        }, (Disposable)project);
        MessageBusConnection prjConnection = project.getMessageBus().connect((Disposable)project);
        prjConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                SmartHashSet files;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((files = (SmartHashSet)JBIterable.from(events).filterMap(o -> o.getFile()).filter(o -> FileTypeRegistry.getInstance().getFileTypeByFileName(o.getName()) == SqlFileType.INSTANCE).addAllTo((Collection)new SmartHashSet())).isEmpty()) {
                    return;
                }
                SqlDataSourceManager.this.myQueue.queue((Update)new U((SmartHashSet<VirtualFile>)files));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/sql/database/SqlDataSourceManager$2", "after"));
            }
        });
        prjConnection.subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.process(dataSource, true);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.process(dataSource, true);
            }

            @Override
            public void dataSourceChanged(LocalDataSource dataSource) {
                this.process(dataSource, false);
            }

            void process(AbstractDataSource dataSource, boolean force) {
                if (dataSource == null) {
                    SqlDataSourceManager.this.resetElementMap(storage.getDataSources());
                } else {
                    SqlDataSourceManager.this.clearCaches(dataSource, force);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void clearCaches(DasDataSource info, boolean force) {
        this.clearCaches(this.getDataSources(), ContainerUtil.newHashSet((Object[])new String[]{info.getUniqueId()}), force);
    }

    private void clearCaches(List<SqlDataSourceImpl> dataSourceElements, Set<String> uniqueIdsToClean, boolean force) {
        for (int i2 = 0; i2 < dataSourceElements.size(); ++i2) {
            boolean changed = false;
            for (SqlDataSource sqlDataSource : dataSourceElements) {
                String parentID;
                if (uniqueIdsToClean.contains(sqlDataSource.getUniqueId()) || !StringUtil.isNotEmpty((String)(parentID = ((SqlDataSourceImpl)sqlDataSource).getParentUniqueId())) || !uniqueIdsToClean.contains(parentID)) continue;
                uniqueIdsToClean.add(sqlDataSource.getUniqueId());
                changed = true;
            }
            if (!changed) break;
        }
        for (SqlDataSourceImpl element : dataSourceElements) {
            if (!uniqueIdsToClean.contains(element.getUniqueId())) continue;
            if (!force) {
                this.updateDataSource(element);
            }
            element.resetCaches();
        }
        if (force) {
            this.updateDataSource(null);
        }
    }

    public void addDataSource(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceManager.$$$reportNull$$$0(2);
        }
        this.myStorage.addDataSource(dataSource);
        this.attachDataSource(dataSource);
        this.clearCaches(dataSource, true);
    }

    public void removeDataSource(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(3);
        }
        this.myStorage.removeDataSource(element);
        this.detachDataSource(element);
        this.clearCaches(element, true);
    }

    public void renameDataSource(@NotNull SqlDataSourceImpl element, @NotNull String name) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(4);
        }
        if (name == null) {
            SqlDataSourceManager.$$$reportNull$$$0(5);
        }
        element.setName(name);
        this.updateDataSource(element);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(6);
        }
        SqlDataSourceConfigurable sqlDataSourceConfigurable = new SqlDataSourceConfigurable(this, element, this.myProject, false);
        if (sqlDataSourceConfigurable == null) {
            SqlDataSourceManager.$$$reportNull$$$0(7);
        }
        return sqlDataSourceConfigurable;
    }

    @NotNull
    public AnAction getCreateDataSourceAction(final @NotNull Consumer<SqlDataSourceImpl> consumer2) {
        if (consumer2 == null) {
            SqlDataSourceManager.$$$reportNull$$$0(8);
        }
        DumbAwareAction dumbAwareAction = new DumbAwareAction(SqlMessages.message("action.text.create.sql.datasource", new Object[0]), null, DatabaseIcons.DdlDbms){

            public void actionPerformed(AnActionEvent e) {
                Project project = (Project)ObjectUtils.notNull((Object)e.getProject());
                SqlDataSourceImpl result2 = new SqlDataSourceImpl(DasUtil.NO_NAME, project, null);
                result2.setName("DDL data source");
                consumer2.consume((Object)result2);
            }
        };
        if (dumbAwareAction == null) {
            SqlDataSourceManager.$$$reportNull$$$0(9);
        }
        return dumbAwareAction;
    }

    @NotNull
    public SqlDataSourceImpl copyDataSource(@NotNull String newName, @NotNull SqlDataSourceImpl copyFrom) {
        if (newName == null) {
            SqlDataSourceManager.$$$reportNull$$$0(10);
        }
        if (copyFrom == null) {
            SqlDataSourceManager.$$$reportNull$$$0(11);
        }
        SqlDataSourceImpl result2 = copyFrom.copy();
        result2.setName(StringUtil.notNullize((String)newName, (String)"DDL data source"));
        SqlDataSourceImpl sqlDataSourceImpl = result2;
        if (sqlDataSourceImpl == null) {
            SqlDataSourceManager.$$$reportNull$$$0(12);
        }
        return sqlDataSourceImpl;
    }

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            SqlDataSourceManager.$$$reportNull$$$0(13);
        }
        for (VirtualFile file : files) {
            if (file.getFileType() != SqlFileType.INSTANCE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<SqlDataSourceImpl> createDataSourceByFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            SqlDataSourceManager.$$$reportNull$$$0(14);
        }
        ArrayList<VirtualFile> sqlFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (virtualFile.getFileType() != SqlFileType.INSTANCE) continue;
            sqlFiles.add(virtualFile);
        }
        if (sqlFiles.isEmpty()) {
            List<SqlDataSourceImpl> list = Collections.emptyList();
            if (list == null) {
                SqlDataSourceManager.$$$reportNull$$$0(15);
            }
            return list;
        }
        String defaultName = DbUtil.generateUniqueDataSourceName((Project)this.myProject, (String)((VirtualFile)sqlFiles.get(0)).getNameWithoutExtension());
        SqlDataSourceImpl dataSource = new SqlDataSourceImpl(defaultName, this.myProject, null);
        dataSource.setFiles(sqlFiles.toArray(VirtualFile.EMPTY_ARRAY));
        this.addDataSource(dataSource);
        List<SqlDataSourceImpl> list = Collections.singletonList(dataSource);
        if (list == null) {
            SqlDataSourceManager.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static List<String> getFileUrls(DnDEvent aEvent) {
        try {
            PsiElement[] elements = AbstractProjectViewPane.getTransferedPsiElements((Transferable)aEvent);
            if (elements != null) {
                ArrayList<String> result2 = new ArrayList<String>();
                for (PsiElement element : elements) {
                    VirtualFile file;
                    if (!(element instanceof PsiFile) || (file = ((PsiFile)element).getVirtualFile()) == null || file.getFileType() != SqlFileType.INSTANCE) continue;
                    result2.add(file.getUrl());
                }
                return result2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(17);
        }
        return element.getDatabaseDialect();
    }

    @Override
    @Nullable
    public SqlLanguageDialect getSqlDialect(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(18);
        }
        return element.getSqlDialect();
    }

    @Nullable
    public DnDTarget createDnDTarget(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(19);
        }
        return new MyDnDTarget(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateDataSourceAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDnDTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDnDTarget
    implements DnDTarget {
        final SqlDataSourceImpl element;

        MyDnDTarget(SqlDataSourceImpl element) {
            this.element = element;
        }

        public boolean update(DnDEvent aEvent) {
            List files = SqlDataSourceManager.getFileUrls(aEvent);
            return !files.isEmpty();
        }

        public void drop(DnDEvent aEvent) {
            List files = SqlDataSourceManager.getFileUrls(aEvent);
            ArrayList<String> newList = new ArrayList<String>();
            SqlDataSourceImpl sqlDataSource = this.element;
            ContainerUtil.addAll(newList, sqlDataSource.getUrls());
            newList.removeAll(files);
            newList.addAll(files);
            if (!SqlDataSourceConfigurable.checkGenericDialectUsage(SqlDataSourceManager.this.myProject, newList)) {
                return;
            }
            sqlDataSource.setUrls(newList);
            SqlDataSourceManager.this.clearCaches(sqlDataSource, false);
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }
}

