/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import javax.swing.JComponent;

public class ChangeDialectToolbarAction
extends AlignedIconWithTextAction
implements DumbAware {
    public void update(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Condition<VirtualFile> condition = ChangeDialectAction.FILE_FILTER(e.getProject());
        VirtualFile file = psiFile != null ? psiFile.getVirtualFile() : null;
        boolean isSqlFile = file != null && condition.value((Object)file);
        boolean isConsole = file != null && DbConsoleRootType.isConsoleFile(file);
        Presentation presentation = e.getPresentation();
        boolean notMenuOrSearch = !ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        boolean enabledAndVisible = notMenuOrSearch && isSqlFile && !isConsole && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsole.findConsole(e) == null;
        presentation.setEnabledAndVisible(enabledAndVisible);
        if (!enabledAndVisible) {
            return;
        }
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((PsiElement)psiFile);
        presentation.setText(dialect == null ? "<dialect>" : dialect.getDisplayName());
        DbUIUtil.updateComboboxToolbarAction(e, "Change Dialect");
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile virtualFile;
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project = e.getProject();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : file.getVirtualFile();
        if (virtualFile == null || project == null) {
            return;
        }
        ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<VirtualFile>)JBIterable.of((Object)virtualFile));
        JComponent button = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (button == null) {
            popup.showInBestPositionFor(e.getDataContext());
            return;
        }
        popup.showUnderneathOf((Component)button);
    }
}

