/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectImplUtil {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.sql.dialects.DialectSupport");

    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class dialectClass, @NonNls String name) throws IOException {
        String text2;
        String resourceName = null;
        InputStream zipIs = null;
        for (Class c = dialectClass; c != null; c = c.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c) + "-help.zip";
            zipIs = c.getClassLoader().getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlMessages.message("help.file.0.not.found", resourceName));
        }
        try {
            text2 = SqlDialectImplUtil.loadFileFromZip(zipIs, name);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlMessages.message("help.file.0.not.found", name) + "\n" + e.getMessage(), e);
        }
        if (text2 == null) {
            throw new IOException(SqlMessages.message("help.file.0.not.found", resourceName + "!/" + name));
        }
        String string = text2;
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(zip)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    public static Set<String> getAllKeywordsFromDefinition(Collection<SqlFunctionDefinition> definitions, Set<String> keywords) {
        for (SqlFunctionDefinition definition : definitions) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlDialectImplUtil.getAllKeywordsFromDefinition(prototype, keywords);
            }
        }
        return keywords;
    }

    public static void getAllKeywordsFromDefinition(SqlFunctionDefinition.ParameterBlock block, Set<String> keywords) {
        for (SqlFunctionDefinition.Parameter parameter : block.getParams()) {
            if (parameter instanceof SqlFunctionDefinition.Keyword) {
                keywords.add(((SqlFunctionDefinition.Keyword)parameter).getName());
                continue;
            }
            if (!(parameter instanceof SqlFunctionDefinition.ParameterBlock)) continue;
            SqlDialectImplUtil.getAllKeywordsFromDefinition((SqlFunctionDefinition.ParameterBlock)parameter, keywords);
        }
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(1);
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()).toLowerCase(Locale.ENGLISH);
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Map<String, DasObject> buildEntities(@NotNull ObjectKind kind, String ... names) {
        if (kind == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(3);
        }
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (String name : names) {
            result2.put(name, new ReservedEntity(name, kind));
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(4);
        }
        return linkedHashMap;
    }

    public static boolean checkImports(@NotNull SqlImportState checker, @Nullable DbDataSource dataSource, DasObject object) {
        if (checker == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(5);
        }
        return checker.isImported(dataSource, SqlDialectImplUtil.trace(object));
    }

    @NotNull
    public static SqlImportState getImportCheckerAt(SqlFile sqlFile, @Nullable PsiElement place) {
        SqlImportState sqlImportState = SqlDialectImplUtil.getNearestImportState(place, SqlDialectImplUtil.buildImports(sqlFile));
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(6);
        }
        return sqlImportState;
    }

    @NotNull
    public static SqlImportState getNearestImportState(PsiElement place, SqlImportState state) {
        PsiElement p;
        if (state.prevState == null) {
            SqlImportState sqlImportState = state;
            if (sqlImportState == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(7);
            }
            return sqlImportState;
        }
        for (p = place; p != null; p = p.getContext()) {
            if (SqlPsiElementFactory.isROFile(p)) continue;
            if (p instanceof StubBasedPsiElement && ((StubBasedPsiElement)p).getStub() != null || p instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)p).getStubTree() != null) break;
            if (!(p instanceof PsiFile)) continue;
            p = null;
            break;
        }
        if (p == null) {
            p = place;
        }
        while (state.prevState != null) {
            if (SqlDialectImplUtil.placeBefore(state.element, p)) {
                SqlImportState sqlImportState = state;
                if (sqlImportState == null) {
                    SqlDialectImplUtil.$$$reportNull$$$0(8);
                }
                return sqlImportState;
            }
            state = state.prevState;
        }
        SqlImportState sqlImportState = state;
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(9);
        }
        return sqlImportState;
    }

    public static boolean placeBefore(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s1 = ((StubBasedPsiElement)p1).getStub();
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            if (s1 != null && s2 != null) {
                StubElement e;
                ArrayList<StubElement> parents1 = new ArrayList<StubElement>();
                for (e = s1; e != null; e = e.getParentStub()) {
                    parents1.add(e);
                }
                StubElement prevE = null;
                for (e = s2; e != null; e = e.getParentStub()) {
                    if (e == s1) {
                        return true;
                    }
                    int idx = parents1.indexOf(e);
                    if (idx != -1) {
                        if (idx == 0 || prevE == null) {
                            return true;
                        }
                        StubElement prev1 = (StubElement)parents1.get(idx - 1);
                        for (StubElement element : e.getChildrenStubs()) {
                            if (element == prev1) {
                                return true;
                            }
                            if (element != prevE) continue;
                            return false;
                        }
                        throw new AssertionError();
                    }
                    prevE = e;
                }
            }
        }
        TextRange r1 = p1.getTextRange();
        TextRange r2 = p2.getTextRange();
        return (r1 == null ? 0 : r1.getStartOffset()) < (r2 == null ? 0 : r2.getStartOffset());
    }

    @Nullable
    public static String getUserName(@Nullable RawConnectionConfig config) {
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)config);
        if (ds == null || !ds.isAuthRequired()) {
            return null;
        }
        String username = StringUtil.nullize((String)ds.getUsername());
        if (username != null) {
            return username;
        }
        JdbcUrlParser parser = SqlDialectImplUtil.getParsed(config);
        return parser == null ? null : StringUtil.nullize((String)parser.getParameter("user"));
    }

    @Nullable
    public static JdbcUrlParser getParsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser statefull = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(config));
        if (statefull != null) {
            statefull.setUrlText(config.getUrl());
            return statefull;
        }
        return null;
    }

    @Nullable
    public static String getDatabaseName(@Nullable RawConnectionConfig config) {
        JdbcUrlParser statefull = SqlDialectImplUtil.getParsed(config);
        return statefull != null ? StringUtil.nullize((String)statefull.getParameter("database")) : null;
    }

    @NotNull
    public static SqlImportState buildImports(SqlFile sqlFile) {
        SqlImportState sqlImportState = (SqlImportState)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtil.calcImports(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(10);
        }
        return sqlImportState;
    }

    @Nullable
    public static TreePattern buildOverlayPattern(SqlFile sqlFile) {
        return (TreePattern)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtil.calcOverlayPattern(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
    }

    @Contract(value="null,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @Nullable DasObject object, TreePatternNode.Group ... tail) {
        if (object == null && dsNames == null) {
            return null;
        }
        List kinds = ContainerUtil.newSmartList();
        List names = ContainerUtil.newSmartList();
        SqlImportState.getPartialTrace(SqlDialectImplUtil.trace(object), kinds, names, null);
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtil.createPattern(names, kinds, tail);
    }

    @Contract(value="null,_,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @NotNull DatabaseDialectEx dialect, @Nullable ObjectPath object, TreePatternNode.Group ... tail) {
        List<ObjectKind> path;
        if (dialect == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(11);
        }
        if (object == null && dsNames == null) {
            return null;
        }
        List kinds = ContainerUtil.newSmartList();
        List names = ContainerUtil.newSmartList();
        if (object != null && (path = SqlImportUtil.getSingleRootPath(object.kind, dialect)) != null) {
            int e = path.size() - 1;
            for (int i2 = 0; i2 < e; ++i2) {
                kinds.add(path.get(i2));
                if (object != null) {
                    names.add(new ObjectName(object.name, object.isQuoted()));
                } else {
                    names.add(ObjectName.quoted((String)""));
                }
                object = object == null ? null : object.parent;
            }
        }
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtil.createPattern(names, kinds, tail);
    }

    protected static TreePattern calcOverlayPattern(SqlFile sqlFile) {
        if (DbSrcUtils.isDbSrcFile(sqlFile.getVirtualFile())) {
            return null;
        }
        SearchPath searchPath = DatabaseEditorHelper.getSearchPath((PsiFile)sqlFile);
        DbDataSource dataSource = DbImplUtil.getForcedDataSource((PsiFile)sqlFile);
        return ((SqlLanguageDialectEx)sqlFile.getSqlLanguage()).forcedContextPattern(dataSource, searchPath);
    }

    @NotNull
    protected static SqlImportState calcImports(SqlFile sqlFile) {
        SqlImportState.Shared shared = new SqlImportState.Shared(sqlFile, SqlDialectImplUtil.buildOverlayPattern(sqlFile));
        SqlImportState current = new SqlImportState(null, shared, SqlDialectImplUtil.calcInitialImportState(sqlFile), null);
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        for (SqlUseDatabaseStatement statement : JBIterable.from((Iterable)sqlFile.getDdl()).filter(SqlUseDatabaseStatement.class)) {
            current = new SqlImportState((PsiElement)statement, shared, language.processImports(statement, current.state), current);
        }
        SqlImportState sqlImportState = current;
        if (sqlImportState == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(12);
        }
        return sqlImportState;
    }

    @NotNull
    private static TreePattern calcInitialImportState(@NotNull SqlFile sqlFile) {
        TreePattern resolvePattern;
        VirtualFile vfile;
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(13);
        }
        if (DbSrcUtils.isDbSrcFile(vfile = sqlFile.getVirtualFile())) {
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
            String dataSourceId = DbSrcUtils.getDataSource(vfile);
            DbDataSource ds2 = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)sqlFile.getProject()).findDataSource(dataSourceId);
            SearchPath searchPath = DatabaseEditorHelper.dbSrcSearchPath(sqlFile.getProject(), vfile, true);
            TreePattern treePattern = searchPath != null ? language.srcFilePattern(ds2, searchPath) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(14);
            }
            return treePattern;
        }
        if (vfile instanceof DatabaseElementVirtualFileImpl) {
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
            DbElement o = ((DatabaseElementVirtualFileImpl)vfile).findElement(sqlFile.getProject());
            SearchPath searchPath = ObjectPaths.searchPathOf((DasObject)DbImplUtil.getSearchPathObject(language.getDatabaseDialect(), (DasObject)o));
            TreePattern treePattern = searchPath != null && o != null ? language.srcFilePattern(o.getDataSource(), searchPath) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(15);
            }
            return treePattern;
        }
        JdbcConsole console = JdbcConsole.findConsole(sqlFile.getProject(), vfile);
        TreePattern treePattern = resolvePattern = console == null ? SqlImportUtil.getResolveScopePattern(sqlFile) : null;
        if (resolvePattern == null || TreePatternUtils.isWildcard(resolvePattern.root.getGroup(SqlImportUtil.DATA_SOURCE))) {
            TreePattern treePattern2 = SqlDialectImplUtil.getDefaultInitialPattern(sqlFile, null);
            if (treePattern2 == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(16);
            }
            return treePattern2;
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources2 = SqlDialectImplUtil.getFilteredDataSources(sqlFile, resolvePattern);
        TreePattern defaultPattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources2.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language)));
        resolvePattern = TreePatternUtils.union(resolvePattern, new TreePattern(SqlImportUtil.createDataSources(null, new TreePatternNode.Group[0])));
        TreePattern pattern = SqlImportUtil.processResolveScopePattern(resolvePattern, defaultPattern);
        pattern = (TreePattern)dataSources2.reduce((Object)pattern, (p, ds) -> language.applyImplicitImports(SqlImportUtil.getRealDsNames(ds), (TreePattern)p));
        TreePattern treePattern3 = TreePatternUtils.union(pattern, SqlImportUtil.createDefaultScopePattern(null, language));
        if (treePattern3 == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(17);
        }
        return treePattern3;
    }

    @NotNull
    private static JBIterable<DbDataSource> getFilteredDataSources(@NotNull SqlFile sqlFile, @Nullable TreePattern filter) {
        boolean all;
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(18);
        }
        TreePatternNode.Group group2 = filter == null ? null : filter.root.getGroup(SqlImportUtil.DATA_SOURCE);
        boolean bl = all = filter == null || TreePatternUtils.isWildcard(group2);
        if (!all && group2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(19);
            }
            return jBIterable;
        }
        JBIterable res = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)sqlFile));
        if (!all) {
            res = res.filter(ds -> {
                SqlDataSource sql;
                if (sqlFile == null) {
                    SqlDialectImplUtil.$$$reportNull$$$0(28);
                }
                return (sql = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class)) != null && sql.containsFile(sqlFile.getVirtualFile()) || group2.matchedChildren(SqlImportUtil.getDataSourceName((DasDataSource)ds), Casing.EXACT, null);
            });
        }
        JBIterable jBIterable = res;
        if (jBIterable == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    public static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(21);
        }
        TreePattern treePattern = SqlDialectImplUtil.getDefaultInitialPattern(sqlFile, SqlImportUtil.getResolveScopePattern(sqlFile));
        if (treePattern == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(22);
        }
        return treePattern;
    }

    @NotNull
    private static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile, @Nullable TreePattern filter) {
        if (sqlFile == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(23);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources2 = SqlDialectImplUtil.getFilteredDataSources(sqlFile, filter);
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources2.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language)).append((Object)SqlImportUtil.createDefaultScopePattern(null, language)));
        if (treePattern == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(24);
        }
        return treePattern;
    }

    public static Set<String> loadSystemVars(SqlLanguageDialect dialect) {
        return SqlDialectImplUtil.loadTokens(dialect, "systemVars.txt");
    }

    public static <T> JBIterable<T> staticFields(@NotNull Class<?> clazz, @NotNull Class<T> fieldC) {
        if (clazz == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(25);
        }
        if (fieldC == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(26);
        }
        return JBIterable.of((Object[])clazz.getFields()).filter(field -> {
            if (fieldC == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(27);
            }
            return Modifier.isStatic(field.getModifiers()) && fieldC.isAssignableFrom(field.getType());
        }).transform(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(Conditions.notNull()).filter(fieldC);
    }

    public static List<ReservedEntity.Typed> loadEntities(SqlLanguageDialectEx dialect) {
        ArrayList result2 = ContainerUtil.newArrayList();
        String invalid = null;
        THashMap kindMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (ObjectKind kind : SqlDialectImplUtil.staticFields(SqlDbElementType.class, ObjectKind.class)) {
            kindMap.put(kind.name(), kind);
        }
        THashMap typeMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(((Object)((Object)dialect)).getClass(), "simpleEntities.txt");
            if (StringUtil.isNotEmpty((String)tokens)) {
                for (String typed : tokens.split("(?m)\\n")) {
                    String[] split = typed.split(":");
                    String name = split[0].trim();
                    ObjectKind objectType = (ObjectKind)kindMap.get(split[1].trim());
                    String typeName = split.length < 3 ? null : split[2].trim();
                    SqlType type = null;
                    if (typeName != null) {
                        type = (SqlType)typeMap.get(typeName);
                        if (type == null) {
                            type = SqlTypeFactory.of(DataTypeFactory.of(typeName), dialect);
                            typeMap.put(typeName, type);
                        }
                        if (split.length != 3 || objectType == null) {
                            if (invalid != null) continue;
                            invalid = typed;
                            continue;
                        }
                    }
                    result2.add(new ReservedEntity.Typed(name, objectType, type));
                }
            }
            if (invalid != null) {
                LOG.error("Invalid entity: `" + invalid + "`");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<ReservedEntity> loadObjects(SqlLanguageDialect dialect, String fileName) {
        InputStream stream = SqlDialectImplUtil.openDialectResource(dialect.getClass(), fileName);
        if (stream == null) {
            return Collections.emptyList();
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(stream));){
            ArrayList res = ContainerUtil.newArrayList();
            String cur = r.readLine();
            while (cur != null) {
                if (StringUtil.isEmptyOrSpaces((String)cur)) {
                    cur = r.readLine();
                    continue;
                }
                ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(cur = StringUtil.trimEnd((String)cur, (String)":"));
                if (kind == null) {
                    kind = SqlDbElementType.ourSqlKinds.get(cur);
                }
                if (kind == null) {
                    LOG.error("Unknown kind: " + cur);
                }
                while ((cur = r.readLine()) != null && cur.startsWith(" - ")) {
                    if (kind == null) continue;
                    cur = StringUtil.trimStart((String)cur, (String)" - ");
                    res.add(new ReservedEntity(cur, kind));
                }
            }
            ArrayList arrayList = res;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Set<String> loadTokens(SqlLanguageDialect dialect, String fileName) {
        THashSet result2 = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), fileName);
            if (StringUtil.isNotEmpty((String)tokens)) {
                Collections.addAll(result2, tokens.split("(?m)\\s+"));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    public static String loadDialectResource(Class dialectClass, String name) throws IOException {
        InputStream xmlIs = SqlDialectImplUtil.openDialectResource(dialectClass, name);
        return xmlIs == null ? "" : FileUtil.loadTextAndClose((Reader)new InputStreamReader(xmlIs));
    }

    @Nullable
    private static InputStream openDialectResource(Class dialectClass, String name) {
        String dialectName = dialectClass.getName();
        String packageName = dialectName.substring(0, dialectName.lastIndexOf(46) + 1).replace('.', '/');
        String xmlResource = packageName + name;
        return dialectClass.getClassLoader().getResourceAsStream(xmlResource);
    }

    @Nullable
    public static ObjectTracer<DasObject> trace(@Nullable DasObject element) {
        return element == null || element.getKind() == ObjectKind.NONE || element.getKind() == ObjectKind.ROOT ? null : new DasObjectTracer(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldC";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectHelpResource";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntities";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportCheckerAt";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestImportState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImports";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitialImportState";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDataSources";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitialPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialectName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildEntities";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPattern";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcInitialImportState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDataSources";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInitialPattern";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "staticFields";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$staticFields$6";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilteredDataSources$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DasObjectTracer
    extends ObjectTracer<DasObject> {
        private final DasObject myElement;

        public DasObjectTracer(@NotNull DasObject element) {
            if (element == null) {
                DasObjectTracer.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<DasObject> trace() {
            return new ObjectTracer.ObjectTraceIt<DasObject>(DasUtil.dasParents((DasObject)this.myElement).filter(o -> o.getKind() != ObjectKind.ROOT).iterator()){
                private DasObject myCurrent;

                @Override
                public DasObject next() {
                    this.myCurrent = (DasObject)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.getKind();
                }

                @Override
                public String getName() {
                    return this.myCurrent.getName();
                }

                @Override
                public boolean isQuoted() {
                    return DbSqlUtil.isQuoted(this.myCurrent);
                }

                @Override
                public String getCorrectName() {
                    return this.myCurrent.getName();
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myElement.getKind();
        }

        @Override
        public String getName() {
            return this.myElement.getName();
        }

        @Override
        @Nullable
        public ObjectTracer<DasObject> getParent(int steps2) {
            if (steps2 == 0) {
                return this;
            }
            DasObject parent = this.myElement;
            for (int i2 = 0; i2 < steps2 && parent != null; parent = parent.getDasParent(), ++i2) {
            }
            return parent == null ? null : SqlDialectImplUtil.trace(parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlDialectImplUtil$DasObjectTracer", "<init>"));
        }
    }

    public static abstract class ObjectTracer<T> {
        public abstract ObjectTraceIt<T> trace();

        public abstract ObjectKind getKind();

        public abstract String getName();

        @Nullable
        public abstract ObjectTracer<T> getParent(int var1);

        public static abstract class ObjectTraceIt<T>
        implements Iterator<T> {
            private final JBIterator<? extends T> myIt;

            public ObjectTraceIt(Iterator<? extends T> it) {
                this.myIt = JBIterator.from(it);
            }

            @Override
            public boolean hasNext() {
                return this.myIt.hasNext();
            }

            @Override
            public T next() {
                return (T)this.myIt.next();
            }

            @Override
            public void remove() {
                this.myIt.remove();
            }

            public abstract ObjectKind getKind();

            public abstract String getName();

            public abstract boolean isQuoted();

            public abstract String getCorrectName();
        }
    }
}

