/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DbSchemasSelector;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveEditor
extends DbSchemasSelector {
    protected TreePattern mySelectedScope;
    protected TreePattern myPermStructure;

    public SqlResolveEditor(@NotNull Project project) {
        if (project == null) {
            SqlResolveEditor.$$$reportNull$$$0(0);
        }
        super(project);
        this.mySelectedScope = TreePattern.EMPTY;
        this.myPermStructure = TreePattern.EMPTY;
    }

    @Override
    @NotNull
    public MyTree createTree(@NotNull Project project) {
        if (project == null) {
            SqlResolveEditor.$$$reportNull$$$0(1);
        }
        MyTree myTree = new MyTree(this, project, new DbSchemasTree.MyNode(null, ObjectKind.NONE, null){

            @Override
            public ObjectKind getAllKind() {
                return SqlImportUtil.DATA_SOURCE;
            }
        });
        if (myTree == null) {
            SqlResolveEditor.$$$reportNull$$$0(2);
        }
        return myTree;
    }

    public void setPatterns(@Nullable TreePattern selection, @Nullable TreePattern structure) {
        boolean structChanged;
        boolean permStructChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean selChanged = selection != null && !selection.equals(this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        if (permStructChanged = structure != null && !structure.equals(this.myPermStructure)) {
            this.myPermStructure = structure;
        }
        boolean bl = structChanged = permStructChanged || selChanged;
        if (selChanged) {
            this.recheck(this.mySelectedScope);
        }
        DbUIUtil.invokeLater(() -> {
            if (structChanged) {
                TreePattern tempStructure = TreePatternUtils.union(this.myPermStructure, this.mySelectedScope);
                if (permStructChanged || tempStructure != this.myPermStructure) {
                    this.createShadowStructure((DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                    this.myTree.getSearchModel().updateStructure();
                }
            }
            this.recheck(this.mySelectedScope);
            this.onSetPatternReady();
        });
    }

    protected void onSetPatternReady() {
    }

    @NotNull
    protected Map<String, MultiMap<String, String>> getEditorState() {
        DbSchemasTree.MyNode root2 = (DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject();
        LinkedHashMap res = ContainerUtil.newLinkedHashMap();
        for (DbSchemasTree.MyNode node : root2.getChildNodes()) {
            String name = SqlResolveEditor.getNodeName(node);
            if (name == null || !node.isChecked()) continue;
            res.put(name, this.getEditorState(node));
        }
        LinkedHashMap linkedHashMap = res;
        if (linkedHashMap == null) {
            SqlResolveEditor.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    @NotNull
    protected MultiMap<String, String> getEditorState(@NotNull DbSchemasTree.MyNode root2) {
        if (root2 == null) {
            SqlResolveEditor.$$$reportNull$$$0(4);
        }
        MultiMap state = MultiMap.createLinkedSet();
        if (root2.getAllKind() == ObjectKind.SCHEMA) {
            Collection schemas = state.getModifiable((Object)"*");
            SqlResolveEditor.getNodeNames(root2.getChildNodes()).addAllTo(schemas);
        } else {
            for (DbSchemasTree.MyNode node : root2.getChildNodes()) {
                String name = SqlResolveEditor.getNodeName(node);
                if (name == null || !node.isChecked()) continue;
                SqlResolveEditor.getNodeNames(node.getChildNodes()).addAllTo(state.getModifiable((Object)name));
            }
        }
        MultiMap multiMap = state;
        if (multiMap == null) {
            SqlResolveEditor.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    private void createShadowStructure(@NotNull DbSchemasTree.MyNode root2, @NotNull TreePattern pattern) {
        TreePatternNode.Group group2;
        if (root2 == null) {
            SqlResolveEditor.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            SqlResolveEditor.$$$reportNull$$$0(7);
        }
        if ((group2 = pattern.root.getGroup(SqlImportUtil.DATA_SOURCE)) == null) {
            root2.purgeShadow();
            return;
        }
        this.fillShadowChildren(root2, group2);
    }

    private void fillShadowChildren(@NotNull DbSchemasTree.MyNode root2, TreePatternNode.Group group2) {
        if (root2 == null) {
            SqlResolveEditor.$$$reportNull$$$0(8);
        }
        List nodes2 = ContainerUtil.newSmartList();
        for (DbSchemasTree.MyNode node : root2.getChildNodes()) {
            nodes2.clear();
            if (group2.matchedChildren(ObjectName.quoted((String)SqlResolveEditor.getNodeName(node)), Casing.EXACT, nodes2)) {
                this.fillShadowObjects(node, ((TreePatternNode)nodes2.get(0)).getGroup(node.getAllKind()));
                continue;
            }
            node.purgeShadow();
        }
    }

    private void fillShadowObjects(@NotNull DbSchemasTree.MyNode p, @Nullable TreePatternNode.Group group2) {
        if (p == null) {
            SqlResolveEditor.$$$reportNull$$$0(9);
        }
        if (group2 == null) {
            p.purgeShadow();
            return;
        }
        ArrayList dbShadow = ContainerUtil.newArrayList();
        Map<String, DbSchemasTree.MyNode> schemaObjects = SqlResolveEditor.fillNodesCache(p.getChildren());
        Map<String, DbSchemasTree.MyNode> oldSchemasCache = SqlResolveEditor.fillNodesCache(p.getShadowChildren());
        for (ObjectName n2 : JBIterable.of((Object[])group2.positiveChildren).append(group2.negativeChild).flatten(n -> JBIterable.of((Object[])((TreePatternNode.BaseNaming)n.naming).names))) {
            if (schemaObjects.containsKey(n2.name)) continue;
            DbSchemasTree.MyNode schema = oldSchemasCache.get(n2.name);
            if (schema == null) {
                schema = new DbSchemasTree.MyNode(n2.name, group2.kind, n2.name);
                schemaObjects.put(n2.name, schema);
            }
            dbShadow.add(schema);
        }
        p.setShadowChildren(dbShadow);
        this.fillShadowChildren(p, group2);
    }

    private void recheck(@NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlResolveEditor.$$$reportNull$$$0(10);
        }
        FilteringTree.SearchTreeModel model = this.myTree.getSearchModel();
        DbSchemasTree.MyNode root2 = (DbSchemasTree.MyNode)model.getRootObject();
        ObjectKind childKind = root2.getAllKind();
        root2.setChecked(true);
        SqlResolveEditor.recheck(root2, childKind == null ? null : pattern.root.getGroup(childKind));
        this.myTree.getTree().updateFromNodes();
    }

    private static void recheck(@NotNull DbSchemasTree.MyNode node, @Nullable TreePatternNode.Group group2) {
        if (node == null) {
            SqlResolveEditor.$$$reportNull$$$0(11);
        }
        List nodes2 = ContainerUtil.newSmartList();
        DbSchemasTree.MyNode allNode = (DbSchemasTree.MyNode)node.getAllNode();
        if (allNode != null) {
            allNode.setChecked(group2 != null && group2.negativeChild != null);
        }
        for (DbSchemasTree.MyNode child : node.getSimpleChildNodes()) {
            nodes2.clear();
            if (group2 != null && node.getAllNodeState() != ThreeState.YES && group2.matchedChildren(ObjectName.quoted((String)SqlResolveEditor.getNodeName(child)), Casing.EXACT, nodes2)) {
                child.setChecked(true);
                ObjectKind childKind = child.getAllKind();
                SqlResolveEditor.recheck(child, childKind == null ? null : ((TreePatternNode)nodes2.get(0)).getGroup(childKind));
                continue;
            }
            child.setChecked(false);
            SqlResolveEditor.recheck(child, null);
        }
    }

    @NotNull
    public TreePattern getPattern(@NotNull Map<String, MultiMap<String, String>> state) {
        if (state == null) {
            SqlResolveEditor.$$$reportNull$$$0(12);
        }
        if (state.containsKey("*")) {
            TreePattern treePattern = new TreePattern(TreePatternUtils.create((ObjectName)null, SqlImportUtil.DATA_SOURCE, TreePatternNode.NO_GROUPS));
            if (treePattern == null) {
                SqlResolveEditor.$$$reportNull$$$0(13);
            }
            return treePattern;
        }
        ArrayList dsGroups = ContainerUtil.newArrayList();
        for (Map.Entry<String, MultiMap<String, String>> entry : state.entrySet()) {
            String id = entry.getKey();
            Boolean schema = this.myTree.isSchemaRoot(id);
            if (schema == null) continue;
            TreePatternNode.Group g = SqlImportUtil.getRootGroup(schema, entry.getValue(), false);
            dsGroups.add(TreePatternUtils.create(ObjectName.quoted((String)id), SqlImportUtil.DATA_SOURCE, SqlImportUtil.optAr(g)));
        }
        TreePattern treePattern = TreePatternUtils.sorted(new TreePattern(TreePatternUtils.UNION_PROCESSOR.mergeGroups(SqlImportUtil.DATA_SOURCE, dsGroups)));
        if (treePattern == null) {
            SqlResolveEditor.$$$reportNull$$$0(14);
        }
        return treePattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlResolveEditor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlResolveEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEditorState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createShadowStructure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillShadowChildren";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillShadowObjects";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "recheck";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTree
    extends DbSchemasSelector.TreeEditor {
        final /* synthetic */ SqlResolveEditor this$0;

        public MyTree(@NotNull SqlResolveEditor sqlResolveEditor, Project project, DbSchemasTree.MyNode root2) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            this(sqlResolveEditor, project, DbSchemasTree.createNode(root2));
        }

        private MyTree(@NotNull SqlResolveEditor sqlResolveEditor, Project project, CheckedTreeNode root2) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(1);
            }
            this.this$0 = sqlResolveEditor;
            super(project, (Tree)new DbSchemasTree(root2), root2);
        }

        @Override
        protected void createShadowStructure(@NotNull DbSchemasTree.MyNode root2) {
            if (root2 == null) {
                MyTree.$$$reportNull$$$0(2);
            }
            this.this$0.createShadowStructure(root2, TreePatternUtils.union(this.this$0.myPermStructure, this.this$0.mySelectedScope));
        }

        @Override
        @NotNull
        protected ObjectKind getDsKind() {
            ObjectKind objectKind = SqlImportUtil.DATA_SOURCE;
            if (objectKind == null) {
                MyTree.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @Override
        protected boolean hasAll(@Nullable Object obj) {
            if (obj == null) {
                return true;
            }
            if (obj instanceof DasDataSource) {
                return !DbSchemasSelector.isSingleRoot(this.getProject(), (DasDataSource)obj);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/SqlResolveEditor$MyTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/SqlResolveEditor$MyTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDsKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadowStructure";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

