/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.clickhouse.CHouseDdlParsing;
import com.intellij.sql.dialects.clickhouse.CHouseDialect;
import com.intellij.sql.dialects.clickhouse.CHouseDmlParsing;
import com.intellij.sql.dialects.clickhouse.CHouseExpressionParsing;
import com.intellij.sql.dialects.clickhouse.CHouseGeneratedParser;
import com.intellij.sql.dialects.clickhouse.CHouseGeneratedParserUtil;
import com.intellij.sql.dialects.clickhouse.CHouseTokens;
import com.intellij.sql.dialects.common.SqlGeneratedParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseParser
extends SqlParser {
    public static final SqlSuggestedInjection CH_INJECTION = new SqlSuggestedInjection("ClickHouse");

    public CHouseParser() {
        super(CHouseDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first) {
        return !first && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT_DELIMITED) || super.allowNoopStringConcatenation(builder, first);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, CHouseExpressionParsing::evaluable_expression);
    }

    @Override
    protected boolean parseDataTypeExt(PsiBuilder builder) {
        return SqlGeneratedParser.table_type(builder, 0) || this.parseDataType(builder, 0, true);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return CHouseGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return CHouseGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return CHouseDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return CHouseDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = CHouseExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiBuilder adaptBuilder(IElementType root2, PsiBuilder initialBuilder) {
        PsiBuilder psiBuilder = CHouseGeneratedParserUtil.adapt_builder_(root2, initialBuilder, this, this.getExtendsTokenSets());
        if (psiBuilder == null) {
            CHouseParser.$$$reportNull$$$0(0);
        }
        return psiBuilder;
    }

    @Override
    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        boolean res;
        boolean allowSplit;
        boolean bl = allowSplit = refType == SQL_COLUMN_REFERENCE || refType == SQL_COLUMN_SHORT_REFERENCE || refType == SQL_REFERENCE || refType == SQL_OPTIONAL_REFERENCE;
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)CHouseTokens.CH_DELIMITED_TOKEN_START)) {
            if (allowSplit) {
                builder.advanceLexer();
            } else {
                PsiBuilder.Marker m = builder.mark();
                CHouseGeneratedParserUtil.consumeDelimited(builder);
                m.done((IElementType)SQL_IDENTIFIER);
                return true;
            }
        }
        if ((res = super.parseIdentifierInner(builder, optional, allowKeywords, allowCharSetSpec, refType)) && allowSplit) {
            GeneratedParserUtilBase.consumeTokenFast((PsiBuilder)builder, (IElementType)CHouseTokens.CH_DELIMITED_TOKEN_END);
        }
        return res;
    }

    @Override
    protected boolean allowAnyIdentifierInOdbc() {
        return true;
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return CH_INJECTION;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, CHouseExpressionParsing::parenthesized_values_expr, CHouseDmlParsing::top_query_expression, CHouseParser::parseTopQueryExpressionTail, CHouseExpressionParsing::row_element_list, (b, l) -> CHouseExpressionParsing.root_expr_0(b, l, -1) && CHouseExpressionParsing.row_element_list_separator(b, l) && CHouseExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return CHouseDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (refType == SQL_PARTITION_REFERENCE) {
            return CHouseGeneratedParser.partition_reference(builder, 0);
        }
        return super.parseReferenceExpressionInner(builder, optional, force, refType);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res = super.parseFunctionCallTail(builder, level);
        if (res && SqlParserUtil.consumeToken(builder, true, (IElementType)SQL_LEFT_PAREN)) {
            SqlGeneratedParser.expression_list(builder, level);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
        }
        return res;
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean plain) {
        boolean done = false;
        if ("true".equals(definition.getDialectAttribute("aggregate"))) {
            assert (definition.getPrototypes().length == 1);
            SqlFunctionDefinition.Prototype proto = definition.getPrototypes()[0];
            if (proto.getHeadBlock() != null) {
                PsiBuilder.Marker outer = builder.mark();
                boolean opt = proto.getHeadBlock() instanceof SqlFunctionDefinition.ParameterBlock && ((SqlFunctionDefinition.ParameterBlock)proto.getHeadBlock()).getBlockType() == SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE;
                SqlParser.FunctionParsingContext context = new SqlParser.FunctionParsingContext();
                if (SqlParserUtil.consumeToken(builder, (IElementType)SQL_LEFT_PAREN)) {
                    PsiBuilder.Marker m = builder.mark();
                    int offset = builder.getCurrentOffset();
                    boolean ok = this.parseFunctionParameter(builder, level, proto.getHeadBlock(), context);
                    if (opt && offset == builder.getCurrentOffset()) {
                        m.drop();
                        outer.rollbackTo();
                    } else {
                        if (!ok || !SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_RIGHT_PAREN)) {
                            this.parseSimpleArguments(builder, level, context);
                        }
                        SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
                        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_PAREN) && opt) {
                            m.drop();
                            outer.rollbackTo();
                        } else {
                            m.done((IElementType)SQL_EXPRESSION_LIST);
                            outer.drop();
                            done = true;
                        }
                    }
                } else {
                    outer.drop();
                }
            }
        }
        return super.parseFunctionParametersAndParens(builder, level, functionName, definition, plain) || done;
    }

    @Override
    protected Boolean parseSimpleParameter(PsiBuilder builder, int level, SqlFunctionDefinition.Type type) {
        if (type == CHouseDialect.ANY_NA) {
            return CHouseExpressionParsing.value_expression_na(builder, level);
        }
        if (type == CHouseDialect.STRING_OR_TOKEN || type == CHouseDialect.STRING_OR_SCHEMA) {
            PsiBuilder.Marker mark2 = builder.mark();
            if (this.consumeIdentifier(builder, true, false) && (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) || SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_RIGHT_PAREN) || SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_COMMA))) {
                if (type == CHouseDialect.STRING_OR_SCHEMA) {
                    mark2.done((IElementType)SQL_SCHEMA_REFERENCE);
                } else {
                    mark2.drop();
                }
                return true;
            }
            mark2.rollbackTo();
            return CHouseExpressionParsing.value_expression_na(builder, level);
        }
        return super.parseSimpleParameter(builder, level, type);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        CHouseDmlParsing.query_expression_0(builder, level, -1);
        return CHouseDmlParsing.left_inner_table_op_tail(builder, level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/clickhouse/CHouseParser", "adaptBuilder"));
    }
}

