/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseColumnDefinition
extends SqlColumnDefinitionImpl {
    public CHouseColumnDefinition(@NotNull ASTNode node) {
        if (node == null) {
            CHouseColumnDefinition.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public CHouseColumnDefinition(SqlColumnStub stub) {
        super(stub);
    }

    @Override
    @Nullable
    protected String calcName() {
        boolean qualified;
        SqlNameElement element = this.getNameElement();
        if (element == null) {
            return null;
        }
        String outer = this.getOuterName();
        boolean bl = qualified = element instanceof SqlReferenceExpression && ((SqlReferenceExpression)element).getQualifierExpression() != null;
        if (outer == null && !qualified) {
            return element.getName();
        }
        StringBuilder name = new StringBuilder();
        if (outer != null) {
            name.append(outer);
        }
        CHouseColumnDefinition.appendQualification(name, element);
        return name.toString();
    }

    private static void appendQualification(StringBuilder name, SqlNameElement element) {
        SqlNameElement qualifier;
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element, SqlReferenceExpression.class);
        SqlNameElement sqlNameElement = qualifier = ref != null ? (SqlNameElement)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlNameElement.class) : null;
        if (qualifier != null) {
            CHouseColumnDefinition.appendQualification(name, qualifier);
        }
        if (name.length() != 0) {
            name.append(".");
        }
        name.append(element.getName());
    }

    @Nullable
    private String getOuterName() {
        PsiElement parent = this.getParent();
        parent = parent == null ? null : parent.getParent();
        SqlColumnDefinition def2 = (SqlColumnDefinition)ObjectUtils.tryCast((Object)parent, SqlColumnDefinition.class);
        return def2 == null ? null : def2.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/clickhouse/psi/CHouseColumnDefinition", "<init>"));
    }
}

