/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.exasol.ExasolDialect;
import com.intellij.sql.dialects.exasol.ExasolElementTypes;
import com.intellij.sql.dialects.exasol.ExasolOptionalKeywords;
import com.intellij.sql.dialects.exasol.ExasolReservedKeywords;
import com.intellij.sql.dialects.exasol.ExasolTokens;
import com.intellij.sql.dialects.exasol.ExasolTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import com.intellij.sql.psi.impl.lexer._ExasolLexer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExasolLexer
extends SqlLexer {
    protected boolean myScriptState = false;
    private final Set<IElementType> ALLOWED_RESERVED_KW = ContainerUtil.immutableSet((Object[])new IElementType[]{ExasolTypes.EXA_RETURNS, ExasolTypes.EXA_EMITS, ExasolTypes.EXA_TABLE, ExasolTypes.EXA_ORDER, ExasolTypes.EXA_BY, ExasolTypes.EXA_AS, ExasolTypes.EXA_ASC, ExasolTypes.EXA_DESC, ExasolTypes.EXA_FIRST, ExasolTypes.EXA_LAST, ExasolTypes.EXA_ARRAY, ExasolTypes.EXA_BIGINT, ExasolTypes.EXA_BOOL, ExasolTypes.EXA_BOOLEAN, ExasolTypes.EXA_CHAR, ExasolTypes.EXA_CHARACTER, ExasolTypes.EXA_CLOB, ExasolTypes.EXA_DATE, ExasolTypes.EXA_DAY, ExasolTypes.EXA_DEC, ExasolTypes.EXA_DECIMAL, ExasolTypes.EXA_DOUBLE, ExasolTypes.EXA_FLOAT, ExasolTypes.EXA_GEOMETRY, ExasolTypes.EXA_HOUR, ExasolTypes.EXA_INT, ExasolTypes.EXA_INTEGER, ExasolTypes.EXA_INTERVAL, ExasolTypes.EXA_LARGE, ExasolTypes.EXA_MINUTE, ExasolTypes.EXA_MONTH, ExasolTypes.EXA_NCHAR, ExasolTypes.EXA_NUMBER, ExasolTypes.EXA_NUMERIC, ExasolTypes.EXA_NVARCHAR, ExasolTypes.EXA_NVARCHAR2, ExasolTypes.EXA_OBJECT, ExasolTypes.EXA_REAL, ExasolTypes.EXA_SECOND, ExasolTypes.EXA_SHORTINT, ExasolTypes.EXA_SMALLINT, ExasolTypes.EXA_TIMESTAMP, ExasolTypes.EXA_TINYINT, ExasolTypes.EXA_TO, ExasolTypes.EXA_VARCHAR, ExasolTypes.EXA_VARCHAR2, ExasolTypes.EXA_YEAR});
    private final Set<IElementType> LOOKAHEAD_BREAKERS_KW = ContainerUtil.immutableSet((Object[])new IElementType[]{SqlTokens.SQL_SEMICOLON, SqlTokens.SQL_OP_DIV});

    public ExasolLexer() {
        super(ExasolTokens.class, ExasolReservedKeywords.class, new _ExasolLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            ExasolLexer.$$$reportNull$$$0(0);
        }
        boolean bl = this.myScriptState = initialState < 0;
        if (this.myScriptState) {
            initialState = -initialState - 1;
        }
        super.start(buffer, startOffset, endOffset, initialState);
    }

    protected void addToken(IElementType type) {
        super.addToken(type);
        this.updateScriptState(type);
    }

    public int getState() {
        return this.myScriptState ? -super.getState() - 1 : super.getState();
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadRangeOperator(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    @Override
    protected void lookSqlKeyword(Lexer baseLexer) {
        IElementType type = this.getSqlTokenType(baseLexer);
        if (this.myScriptState && type == ExasolTypes.EXA_AS) {
            this.advanceAs(baseLexer, type);
            while (SqlTokens.WS_TOKENS.contains(baseLexer.getTokenType())) {
                this.advanceLexer(baseLexer);
            }
            this.createScriptToken(baseLexer);
            return;
        }
        this.advanceAs(baseLexer, type);
    }

    private void updateScriptState(IElementType type) {
        if (!this.myScriptState) {
            if (type == ExasolTypes.EXA_SCRIPT) {
                this.myScriptState = true;
            }
            return;
        }
        if (!ExasolDialect.INSTANCE.isReservedKeyword(type)) {
            this.myScriptState = !this.LOOKAHEAD_BREAKERS_KW.contains(type);
            return;
        }
        if (this.ALLOWED_RESERVED_KW.contains(type)) {
            return;
        }
        this.myScriptState = false;
    }

    private void createScriptToken(Lexer baseLexer) {
        int start = baseLexer.getTokenStart();
        int term = ExasolLexer.findScriptTerminator(baseLexer.getBufferSequence(), start, baseLexer.getBufferEnd());
        if (term == start) {
            return;
        }
        this.addToken(term, this.getScriptTokenType());
        baseLexer.start(baseLexer.getBufferSequence(), term, baseLexer.getBufferEnd(), baseLexer.getState());
    }

    protected IElementType getScriptTokenType() {
        return SqlTokens.SQL_RAW_INPUT;
    }

    private static int findScriptTerminator(@NotNull CharSequence text2, int start, int end) {
        if (text2 == null) {
            ExasolLexer.$$$reportNull$$$0(1);
        }
        int i2;
        while ((i2 = StringUtil.indexOf((CharSequence)text2, (char)'/', (int)start, (int)end)) != -1) {
            int prev;
            int pi = i2 - 1;
            int n = prev = pi < start ? 13 : (int)text2.charAt(pi);
            if (pi < start) {
                pi = i2;
            }
            if (prev == 10 && pi > start && text2.charAt(pi - 1) == '\r') {
                --pi;
            }
            if (prev == 10 || prev == 13) {
                int next;
                int ni;
                for (ni = i2 + 1; ni < end && text2.charAt(ni) == ' '; ++ni) {
                }
                int n2 = next = ni < end ? (int)text2.charAt(ni) : 13;
                if (next == 10 || next == 13) {
                    return pi;
                }
            }
            start = i2 + 1;
        }
        return end;
    }

    public void advance() {
        if (this.myScriptState && this.getTokenType() == ExasolTypes.EXA_AS) {
            this.myScriptState = false;
        }
        super.advance();
    }

    static {
        ExasolLexer.initTokensAndFunctions(ExasolElementTypes.EXASOL_SQL_FILE, ExasolTokens.class, ExasolReservedKeywords.class, ExasolOptionalKeywords.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/exasol/ExasolLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findScriptTerminator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

