/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.refactoring;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleExtractVariableHelper
extends SqlExtractVariableHelper {
    @Override
    @Nullable
    public PsiElement createDeclaration(@NotNull Project project, @NotNull String name, @NotNull String type) {
        if (project == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(0);
        }
        if (name == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(1);
        }
        if (type == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(2);
        }
        String text2 = name + " " + type + " ";
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)OracleDialect.INSTANCE, (CharSequence)("declare " + text2 + "; begin end"));
        return PsiTreeUtil.getChildOfType((PsiElement)fileFromText.getFirstChild(), SqlVariableDefinition.class);
    }

    @Override
    @Nullable
    public PsiElement createInitializerDeclaration(@NotNull Project project, @NotNull String name, @NotNull String text2) {
        if (project == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(3);
        }
        if (name == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(5);
        }
        String allText = name + " := " + text2;
        return SqlPsiElementFactory.createStatementFromText(allText, OracleDialect.INSTANCE, project, null);
    }

    @Override
    public SqlTypeElement getTypeElement(@NotNull PsiElement target) {
        if (target == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(6);
        }
        return (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)target, SqlTypeElement.class);
    }

    @Override
    public PsiElement addDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement block) {
        PsiElement first;
        if (declaration == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(7);
        }
        if (block == null) {
            OracleExtractVariableHelper.$$$reportNull$$$0(8);
        }
        if ((first = block.getFirstChild()) != null && first.getNode().getElementType() != OraTypes.ORA_DECLARE) {
            PsiElement declare = SqlPsiElementFactory.createLeafFromText(declaration.getProject(), OracleDialect.INSTANCE, "declare");
            first = block.addBefore(declare, first);
        }
        PsiElement element = block.addAfter(declaration, first);
        PsiElement semi = SqlPsiElementFactory.createLeafFromText(declaration.getProject(), OracleDialect.INSTANCE, ";");
        block.addAfter(semi, element);
        block.addBefore(SqlPsiElementFactory.newLine(block.getProject()), element);
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/oracle/refactoring/OracleExtractVariableHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeclaration";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitializerDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

