/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sql92;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sql92.Sql92ReservedKeywords;
import com.intellij.sql.dialects.sql92.Sql92Tokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Sql92Dialect
extends SqlLanguageDialectEx {
    public static final Sql92Dialect INSTANCE = new Sql92Dialect();

    public Sql92Dialect() {
        super("SQL92");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        GenericDialect genericDialect = GenericDialect.INSTANCE;
        if (genericDialect == null) {
            Sql92Dialect.$$$reportNull$$$0(0);
        }
        return genericDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            Sql92Dialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(Sql92Tokens.class);
        if (set == null) {
            Sql92Dialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            Sql92Dialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (PsiUtilCore.getElementType((PsiElement)o.getFirstChild()) == SqlTokens.SQL_MODULE) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            Sql92Dialect.$$$reportNull$$$0(4);
        }
        return element == SqlCompositeElementTypes.SQL_STRING_LITERAL || element == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element == SqlCompositeElementTypes.SQL_IDENTIFIER || element == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            Sql92Dialect.$$$reportNull$$$0(5);
        }
        if ("character".equals(name = super.getNormalizedTypeName(name))) {
            if ("char" == null) {
                Sql92Dialect.$$$reportNull$$$0(6);
            }
            return "char";
        }
        if ("char varying".equals(name)) {
            if ("varchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(7);
            }
            return "varchar";
        }
        if ("character varying".equals(name)) {
            if ("varchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(8);
            }
            return "varchar";
        }
        if ("national char".equals(name)) {
            if ("nchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(9);
            }
            return "nchar";
        }
        if ("national character".equals(name)) {
            if ("nchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(10);
            }
            return "nchar";
        }
        if ("national char varying".equals(name)) {
            if ("nchar varying" == null) {
                Sql92Dialect.$$$reportNull$$$0(11);
            }
            return "nchar varying";
        }
        if ("national character varying".equals(name)) {
            if ("nchar varying" == null) {
                Sql92Dialect.$$$reportNull$$$0(12);
            }
            return "nchar varying";
        }
        if ("dec".equals(name)) {
            if ("decimal" == null) {
                Sql92Dialect.$$$reportNull$$$0(13);
            }
            return "decimal";
        }
        if ("int".equals(name)) {
            if ("integer" == null) {
                Sql92Dialect.$$$reportNull$$$0(14);
            }
            return "integer";
        }
        String string = name;
        if (string == null) {
            Sql92Dialect.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            Sql92Dialect.$$$reportNull$$$0(16);
        }
        if ("bit".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(17);
            }
            return category;
        }
        if ("bit varying".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(18);
            }
            return category;
        }
        if ("numeric".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(19);
            }
            return category;
        }
        if ("decimal".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(20);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            Sql92Dialect.$$$reportNull$$$0(21);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sql92/Sql92Dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sql92/Sql92Dialect";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(Sql92ReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_OVERLAPS, SqlTokens.SQL_MATCH, SqlTokens.SQL_AT, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR});

        private LazyData() {
        }
    }
}

