/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public SqlQuoteHandler() {
        super(new IElementType[]{SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_UNCLOSED_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN, SqlTokens.SQL_CUSTOM_LQUOTE});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator2, int offset) {
        char q;
        if (super.isOpeningQuote(iterator2, offset)) {
            return true;
        }
        IElementType type = iterator2.getTokenType();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE && offset == iterator2.getEnd() - 1) {
            return true;
        }
        if (SqlTokens.SQL_UNCLOSED_TOKEN != type && SqlTokens.SQL_STRING_TOKEN != type) {
            return false;
        }
        int s = iterator2.getStart();
        int e = Math.min(s + 4, offset + 1);
        CharSequence chars = iterator2.getDocument().getCharsSequence();
        char c = q = e - 2 < s ? (char)'\u0000' : chars.charAt(e - 2);
        if (q == 'q' || q == 'Q') {
            return false;
        }
        return StringUtil.indexOf((CharSequence)chars, (char)'\'', (int)s, (int)e) == offset;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator2, CharSequence chars) {
        if (StringUtil.indexOf((CharSequence)chars.subSequence(iterator2.getStart(), iterator2.getEnd()), (char)'\n') > -1) {
            return true;
        }
        IElementType type = iterator2.getTokenType();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE) {
            if (iterator2.atEnd()) {
                return false;
            }
            iterator2.advance();
            type = iterator2.getTokenType();
            iterator2.retreat();
            return type != SqlTokens.SQL_CUSTOM_RQUOTE && type != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
        }
        return type == SqlTokens.SQL_UNCLOSED_TOKEN || super.isNonClosedLiteral(iterator2, chars);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator2, int offset) {
        IElementType type;
        boolean move;
        if (iterator2 == null) {
            SqlQuoteHandler.$$$reportNull$$$0(0);
        }
        boolean bl = move = (type = iterator2.getTokenType()) != SqlTokens.SQL_CUSTOM_LQUOTE;
        if (move) {
            if (iterator2.getStart() == 0) {
                return null;
            }
            iterator2.retreat();
            type = iterator2.getTokenType();
        }
        int s = iterator2.getStart();
        int e = iterator2.getEnd();
        if (move) {
            iterator2.advance();
        }
        if (type != SqlTokens.SQL_CUSTOM_LQUOTE || offset != e) {
            return null;
        }
        CharSequence seq = iterator2.getDocument().getCharsSequence();
        if (seq.charAt(s) == '$') {
            return seq.subSequence(s, e);
        }
        if (e - 3 < s) {
            return null;
        }
        char q = seq.charAt(e - 3);
        if (q != 'q' && q != 'Q') {
            return null;
        }
        q = seq.charAt(e - 2);
        if (q != '\'') {
            return null;
        }
        q = seq.charAt(e - 1);
        switch (q) {
            case '(': {
                q = ')';
                break;
            }
            case '<': {
                q = '>';
                break;
            }
            case '{': {
                q = '}';
                break;
            }
            case '[': {
                q = ']';
            }
        }
        return q + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/sql/editor/SqlQuoteHandler", "getClosingQuote"));
    }

    public static class Plus
    extends Concat {
        @Override
        public String getStringConcatenationOperatorRepresentation() {
            return "+";
        }
    }

    public static class Concat
    extends SqlQuoteHandler
    implements JavaLikeQuoteHandler {
        private static final TokenSet CONCAT_SET = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_STRING_TOKEN});

        public TokenSet getConcatenatableStringTokenTypes() {
            return CONCAT_SET;
        }

        public String getStringConcatenationOperatorRepresentation() {
            return "||";
        }

        public TokenSet getStringTokenTypes() {
            return null;
        }

        public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                Concat.$$$reportNull$$$0(0);
            }
            return true;
        }

        public boolean needParenthesesAroundConcatenation(PsiElement element) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/sql/editor/SqlQuoteHandler$Concat", "isAppropriateElementTypeForLiteral"));
        }
    }
}

