/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlCortegeBlock;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.SlqStringLiteralConcatenationBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlBlockCommentBlock;
import com.intellij.sql.formatter.SqlBlockQuery;
import com.intellij.sql.formatter.SqlBlockSubquery;
import com.intellij.sql.formatter.SqlExpressionBlock;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlIdentifierWord;
import com.intellij.sql.formatter.SqlLineCommentBlock;
import com.intellij.sql.formatter.SqlQueryCategory;
import com.intellij.sql.formatter.SqlSymbol;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSqlBlock
extends AbstractBlock
implements SqlBlock,
SettingsAwareBlock {
    @NotNull
    protected final TextRange myTextRange;
    @NotNull
    protected final SqlFormattingContext myContext;
    @Nullable
    public final PsiElement myElement;
    @NotNull
    public final IElementType myElementType;
    @Nullable
    public final Indent myIndent;
    @Nullable
    public TextRange myConditionalWrappingRange;

    public AbstractSqlBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            AbstractSqlBlock.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractSqlBlock.$$$reportNull$$$0(1);
        }
        this(node, node.getTextRange(), context, wrap, alignment, indent);
    }

    public AbstractSqlBlock(@NotNull ASTNode node, @NotNull TextRange textRange, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            AbstractSqlBlock.$$$reportNull$$$0(2);
        }
        if (textRange == null) {
            AbstractSqlBlock.$$$reportNull$$$0(3);
        }
        if (context == null) {
            AbstractSqlBlock.$$$reportNull$$$0(4);
        }
        super(node, wrap, alignment);
        this.myElement = node.getPsi();
        this.myElementType = node.getElementType();
        this.myIndent = indent;
        this.myContext = context;
        this.myTextRange = textRange;
    }

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        SqlFormattingContext sqlFormattingContext = this.myContext;
        if (sqlFormattingContext == null) {
            AbstractSqlBlock.$$$reportNull$$$0(5);
        }
        return sqlFormattingContext;
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        IElementType iElementType = this.myElementType;
        if (iElementType == null) {
            AbstractSqlBlock.$$$reportNull$$$0(6);
        }
        return iElementType;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            AbstractSqlBlock.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    protected List<Block> buildChildren() {
        ASTNode firstChildNode = this.myNode.getFirstChildNode();
        if (firstChildNode == null) {
            List list = EMPTY;
            if (list == null) {
                AbstractSqlBlock.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList builtBlocks = ContainerUtil.newArrayList();
        this.buildBlocks(this.myNode, builtBlocks);
        ArrayList arrayList = builtBlocks;
        if (arrayList == null) {
            AbstractSqlBlock.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(this.getChildIndent(), this.getChildAlignment());
        if (childAttributes == null) {
            AbstractSqlBlock.$$$reportNull$$$0(10);
        }
        return childAttributes;
    }

    protected Alignment getChildAlignment() {
        return null;
    }

    protected abstract void buildBlocks(@NotNull ASTNode var1, @NotNull ArrayList<Block> var2);

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            AbstractSqlBlock.$$$reportNull$$$0(11);
        }
        if (!(child1 instanceof SqlBlock)) {
            return null;
        }
        if (!(child2 instanceof SqlBlock)) {
            return null;
        }
        SqlBlock block1 = (SqlBlock)child1;
        SqlBlock block2 = (SqlBlock)child2;
        IElementType type1 = block1.getElementType();
        if (type1 != null && SqlFormatting.MUST_FOLLOWED_NL_TYPES.contains(type1)) {
            return SqlFormatting.makeSpacingWhenItMustNL(this.myContext.commonSettings, block1);
        }
        return this.getSpacingInner(block1, block2);
    }

    @NotNull
    protected SqlBlock createNestedBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            AbstractSqlBlock.$$$reportNull$$$0(12);
        }
        SqlBlock sqlBlock = this.createNestedBlock(node, node.getElementType(), wrap, null, alignment, indent);
        if (sqlBlock == null) {
            AbstractSqlBlock.$$$reportNull$$$0(13);
        }
        return sqlBlock;
    }

    @NotNull
    protected SqlBlock createNestedBlock(@NotNull ASTNode node, @NotNull IElementType elementType, @Nullable Wrap wrap, @Nullable AlignmentStrategy alignmentStrategy, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            AbstractSqlBlock.$$$reportNull$$$0(14);
        }
        if (elementType == null) {
            AbstractSqlBlock.$$$reportNull$$$0(15);
        }
        if (elementType instanceof SqlKeywordTokenType) {
            SqlWord sqlWord = new SqlWord(node, this.myContext, wrap, alignment, indent, 0);
            if (sqlWord == null) {
                AbstractSqlBlock.$$$reportNull$$$0(16);
            }
            return sqlWord;
        }
        if (elementType == SqlCompositeElementTypes.SQL_IDENTIFIER) {
            SqlIdentifierWord sqlIdentifierWord = new SqlIdentifierWord(node, this.myContext, wrap, alignment, indent);
            if (sqlIdentifierWord == null) {
                AbstractSqlBlock.$$$reportNull$$$0(17);
            }
            return sqlIdentifierWord;
        }
        if (elementType == SqlTokens.SQL_COMMA) {
            SqlSymbol sqlSymbol = new SqlSymbol(node, this.myContext, wrap, alignment, indent);
            if (sqlSymbol == null) {
                AbstractSqlBlock.$$$reportNull$$$0(18);
            }
            return sqlSymbol;
        }
        if (elementType == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) {
            SqlBlockSubquery sqlBlockSubquery = new SqlBlockSubquery(node, this.myContext, wrap, alignment, indent);
            if (sqlBlockSubquery == null) {
                AbstractSqlBlock.$$$reportNull$$$0(19);
            }
            return sqlBlockSubquery;
        }
        if (elementType == SqlCompositeElementTypes.SQL_SELECT_STATEMENT || elementType == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION) {
            SqlBlockQuery sqlBlockQuery = new SqlBlockQuery(SqlQueryCategory.QUERY_SELECT, node, this.myContext, wrap, alignment, indent);
            if (sqlBlockQuery == null) {
                AbstractSqlBlock.$$$reportNull$$$0(20);
            }
            return sqlBlockQuery;
        }
        if (elementType == SqlCompositeElementTypes.SQL_INSERT_STATEMENT) {
            SqlBlockQuery sqlBlockQuery = new SqlBlockQuery(SqlQueryCategory.QUERY_INSERT, node, this.myContext, wrap, alignment, indent);
            if (sqlBlockQuery == null) {
                AbstractSqlBlock.$$$reportNull$$$0(21);
            }
            return sqlBlockQuery;
        }
        if (elementType == SqlCompositeElementTypes.SQL_UPDATE_STATEMENT) {
            SqlBlockQuery sqlBlockQuery = new SqlBlockQuery(SqlQueryCategory.QUERY_UPDATE, node, this.myContext, wrap, alignment, indent);
            if (sqlBlockQuery == null) {
                AbstractSqlBlock.$$$reportNull$$$0(22);
            }
            return sqlBlockQuery;
        }
        if (elementType == SqlCompositeElementTypes.SQL_DELETE_STATEMENT) {
            SqlBlockQuery sqlBlockQuery = new SqlBlockQuery(SqlQueryCategory.QUERY_DELETE, node, this.myContext, wrap, alignment, indent);
            if (sqlBlockQuery == null) {
                AbstractSqlBlock.$$$reportNull$$$0(23);
            }
            return sqlBlockQuery;
        }
        if (elementType == SqlTokens.SQL_LINE_COMMENT || elementType == SqlTokens.MYSQL_LINE_COMMENT) {
            SqlLineCommentBlock sqlLineCommentBlock = new SqlLineCommentBlock(node, this.myContext, wrap, alignment, indent);
            if (sqlLineCommentBlock == null) {
                AbstractSqlBlock.$$$reportNull$$$0(24);
            }
            return sqlLineCommentBlock;
        }
        if (elementType == SqlCompositeElementTypes.SQL_STRING_LITERAL_CONCATENATION) {
            SlqStringLiteralConcatenationBlock slqStringLiteralConcatenationBlock = new SlqStringLiteralConcatenationBlock(node, this.myContext, wrap, alignment, indent, false);
            if (slqStringLiteralConcatenationBlock == null) {
                AbstractSqlBlock.$$$reportNull$$$0(25);
            }
            return slqStringLiteralConcatenationBlock;
        }
        if (elementType instanceof SqlExpression) {
            SqlBlock sqlBlock = SqlExpressionBlock.create(node, this.myContext, wrap, alignment, indent, false);
            if (sqlBlock == null) {
                AbstractSqlBlock.$$$reportNull$$$0(26);
            }
            return sqlBlock;
        }
        SqlFormattingBlock sqlFormattingBlock = new SqlFormattingBlock(node, this.myContext, wrap, alignment, alignmentStrategy, indent);
        if (sqlFormattingBlock == null) {
            AbstractSqlBlock.$$$reportNull$$$0(27);
        }
        return sqlFormattingBlock;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        if (block1 == null) {
            AbstractSqlBlock.$$$reportNull$$$0(28);
        }
        if (block2 == null) {
            AbstractSqlBlock.$$$reportNull$$$0(29);
        }
        IElementType type1 = block1.getElementType();
        IElementType type2 = block2.getElementType();
        PsiElement element1 = block1.getElement();
        PsiElement element2 = block2.getElement();
        if (element1 == null || element2 == null) {
            return null;
        }
        if (type1 instanceof SqlKeywordTokenType && type2 == SqlTokens.SQL_LEFT_PAREN && !(element1.getParent() instanceof SqlTypeElement) && block1.getNode().getTreeParent() != SqlCompositeElementTypes.SQL_SPECIAL_LITERAL) {
            return this.createSpaces(1);
        }
        if (element1 instanceof SqlStatement && type2 == SqlTokens.SQL_SEMICOLON) {
            if (this.myContext.customSettings.NEW_LINE_AROUND_SEMICOLON) {
                return this.createLineBreak();
            }
            return AbstractSqlBlock.createHardSpace(0);
        }
        if (block1 instanceof SqlBlockCommentBlock || block2 instanceof SqlBlockCommentBlock) {
            return null;
        }
        if (block2 instanceof SqlLineCommentBlock) {
            return null;
        }
        if (block2 instanceof SqlCortegeBlock) {
            return SqlFormatting.makeSpace(this.myContext.customSettings.CORTEGE_SPACE_BEFORE_L_PAREN, false);
        }
        if (block1 instanceof SqlWord && block2 instanceof SqlWord) {
            return AbstractSqlBlock.createHardSpace();
        }
        Spacing spacing = this.myContext.spacingBuilder.getSpacing((Block)this, (Block)block1, (Block)block2);
        if (spacing != null) {
            return spacing;
        }
        if (SqlTokens.COMMENT_TOKENS.contains(type1)) {
            return null;
        }
        if (type1 == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && element1.getParent() instanceof SqlNAryExpression || type2 == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && element2.getParent() instanceof SqlNAryExpression) {
            return this.createSpaces(1);
        }
        if (!(!(type1 instanceof SqlKeywordTokenType) && !(type2 instanceof SqlKeywordTokenType) || element1.getParent() instanceof SqlTypeElement && element2 instanceof SqlTypeElement || element1.getParent().getNode().getElementType() == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL)) {
            return this.createSpaces(1);
        }
        if (element2 instanceof SqlStatement) {
            return this.createSpaces(1);
        }
        if (AbstractSqlBlock.isOperator(block1.getNode()) && AbstractSqlBlock.inExpressionOrStatementOrDefinition(element1)) {
            if (element1.getParent() instanceof SqlUnaryExpression) {
                return this.createSpaces(0);
            }
            return this.createSpacingAroundOperator();
        }
        if (AbstractSqlBlock.isOperator(block2.getNode()) && AbstractSqlBlock.inExpressionOrStatementOrDefinition(element2)) {
            return this.createSpacingAroundOperator();
        }
        if (this.myContext.customSettings.NEW_LINE_BEFORE_QUERY_INSIDE_DML && type2 == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION && (element2.getParent() instanceof SqlDmlInstruction || element2.getParent() instanceof SqlDmlStatement)) {
            return this.createLineBreak();
        }
        if (AbstractSqlBlock.isIdentifierOrExpression(element1) && AbstractSqlBlock.isIdentifierOrExpression(element2)) {
            return this.createSpaces(1);
        }
        return null;
    }

    protected Spacing createSpacingAroundOperator() {
        int d = this.myContext.customSettings.EXPR_SPACE_AROUND_OPERATOR;
        boolean klb = this.myContext.commonSettings.KEEP_LINE_BREAKS;
        switch (d) {
            case 1: {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)klb, (int)0);
            }
            case 2: {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)klb, (int)0);
            }
        }
        return Spacing.createSafeSpacing((boolean)klb, (int)0);
    }

    protected Spacing createLineBreak() {
        return Spacing.createSpacing((int)1, (int)0, (int)1, (boolean)this.myContext.commonSettings.KEEP_LINE_BREAKS, (int)this.myContext.commonSettings.KEEP_BLANK_LINES_IN_CODE);
    }

    protected Spacing createSpaces(int spaces) {
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myContext.commonSettings.KEEP_LINE_BREAKS, (int)this.myContext.commonSettings.KEEP_BLANK_LINES_IN_CODE);
    }

    protected static Spacing createHardSpace() {
        return AbstractSqlBlock.createHardSpace(1);
    }

    protected static Spacing createHardSpace(int spaces) {
        return Spacing.createSpacing((int)spaces, (int)0, (int)0, (boolean)false, (int)0);
    }

    @NotNull
    protected Wrap createWrap(@Nullable WrapType wrapType, boolean wrapFirstElement) {
        WrapType type = wrapType != null ? wrapType : WrapType.NONE;
        Wrap wrap = this.myWrap != null ? Wrap.createChildWrap((Wrap)this.myWrap, (WrapType)type, (boolean)wrapFirstElement) : Wrap.createWrap((WrapType)type, (boolean)wrapFirstElement);
        if (wrap == null) {
            AbstractSqlBlock.$$$reportNull$$$0(30);
        }
        return wrap;
    }

    @NotNull
    protected Alignment createLeftAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.LEFT);
        if (alignment == null) {
            AbstractSqlBlock.$$$reportNull$$$0(31);
        }
        return alignment;
    }

    @NotNull
    protected Alignment createLeftAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        if (alignment == null) {
            AbstractSqlBlock.$$$reportNull$$$0(32);
        }
        return alignment;
    }

    @Nullable
    protected static PsiElement getFirstChildLike(@NotNull PsiElement element, @NotNull Predicate<PsiElement> predicate) {
        if (element == null) {
            AbstractSqlBlock.$$$reportNull$$$0(33);
        }
        if (predicate == null) {
            AbstractSqlBlock.$$$reportNull$$$0(34);
        }
        for (PsiElement x = element.getFirstChild(); x != null; x = x.getNextSibling()) {
            if (!predicate.apply((Object)x)) continue;
            return x;
        }
        return null;
    }

    @Nullable
    protected static <E extends PsiElement> E getPrevSiblingLike(@NotNull PsiElement element, @NotNull Class<E> clazz) {
        if (element == null) {
            AbstractSqlBlock.$$$reportNull$$$0(35);
        }
        if (clazz == null) {
            AbstractSqlBlock.$$$reportNull$$$0(36);
        }
        for (PsiElement x = element.getPrevSibling(); x != null; x = x.getPrevSibling()) {
            if (!clazz.isAssignableFrom(x.getClass())) continue;
            return (E)x;
        }
        return null;
    }

    @Nullable
    protected static PsiElement getPrevSiblingLike(@NotNull PsiElement element, @NotNull IElementType elementType) {
        if (element == null) {
            AbstractSqlBlock.$$$reportNull$$$0(37);
        }
        if (elementType == null) {
            AbstractSqlBlock.$$$reportNull$$$0(38);
        }
        for (PsiElement x = element.getPrevSibling(); x != null; x = x.getPrevSibling()) {
            if (SqlImplUtil.getElementType(x) != elementType) continue;
            return x;
        }
        return null;
    }

    @Nullable
    protected static PsiElement getNextSiblingLike(@NotNull PsiElement element, @NotNull Predicate<PsiElement> predicate) {
        if (element == null) {
            AbstractSqlBlock.$$$reportNull$$$0(39);
        }
        if (predicate == null) {
            AbstractSqlBlock.$$$reportNull$$$0(40);
        }
        for (PsiElement x = element.getNextSibling(); x != null; x = x.getNextSibling()) {
            if (!predicate.apply((Object)x)) continue;
            return x;
        }
        return null;
    }

    protected static int countChildren(@NotNull ASTNode node, @NotNull IElementType elementType, int limit) {
        if (node == null) {
            AbstractSqlBlock.$$$reportNull$$$0(41);
        }
        if (elementType == null) {
            AbstractSqlBlock.$$$reportNull$$$0(42);
        }
        int n = 0;
        for (ASTNode x = node.getFirstChildNode(); x != null && n < limit; x = x.getTreeNext()) {
            IElementType type = x.getElementType();
            if (type == elementType) {
                ++n;
                continue;
            }
            if (type != SqlElementTypes.SQL_DUMMY_BLOCK) continue;
            n += AbstractSqlBlock.countChildren(x, elementType, limit - n);
        }
        return n;
    }

    protected static boolean inExpressionOrStatementOrDefinition(@NotNull PsiElement psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            AbstractSqlBlock.$$$reportNull$$$0(43);
        }
        return (parent = psiElement.getParent()) instanceof SqlExpression || parent instanceof SqlStatement || parent instanceof SqlDefinition || parent instanceof SqlClause && parent.getNode().getElementType() == SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE;
    }

    protected static boolean isIdentifierOrExpression(@Nullable PsiElement psiElement) {
        return psiElement instanceof SqlExpression || psiElement instanceof SqlIdentifier;
    }

    protected static boolean isOperator(@NotNull ASTNode node) {
        if (node == null) {
            AbstractSqlBlock.$$$reportNull$$$0(44);
        }
        PsiElement psi = node.getPsi();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(psi);
        PsiElement parent = psi.getParent();
        PsiElement op = dialect.getFamilyId().isPostgres() && parent instanceof SqlOperatorExpression ? ((SqlOperatorExpression)parent).getOpSignElement() : null;
        return dialect.isOperatorSupported(node.getElementType()) || op == psi;
    }

    protected static boolean isWhitespace(ASTNode node, PsiElement element, IElementType elementType) {
        return element instanceof PsiWhiteSpace || node.getTextLength() <= 0 || elementType == SqlTokens.ORAP_DELIMITER_TOKEN;
    }

    @Override
    @Nullable
    public TextRange getConditionalWrappingRange() {
        return this.myConditionalWrappingRange;
    }

    @Override
    public void setConditionalWrappingRange(@Nullable TextRange range) {
        this.myConditionalWrappingRange = range;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/AbstractSqlBlock";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 15: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/AbstractSqlBlock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedBlock";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrap";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftAlignment";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftAlignmentBS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNestedBlock";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingInner";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildLike";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingLike";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingLike";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "countChildren";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "inExpressionOrStatementOrDefinition";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isOperator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

