/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlExpressionBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlSymbol;
import com.intellij.sql.psi.SqlElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/SqlBinaryExpressionBlock;", "Lcom/intellij/sql/formatter/SqlExpressionBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "forceCollapse", "", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Z)V", "operandAlignment", "operandIndent", "operandWrap", "operatorIndent", "operatorText", "", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "makeBlock", "whetherToFlatten", "type", "Lcom/intellij/psi/tree/IElementType;", "intellij.database.sql.impl"})
public final class SqlBinaryExpressionBlock
extends SqlExpressionBlock {
    private final String operatorText;
    private final Wrap operandWrap;
    private final Alignment operandAlignment;
    private final Indent operandIndent;
    private final Indent operatorIndent;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean whetherToFlatten(@NotNull ASTNode node, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (!Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_BINARY_EXPRESSION)) return false;
        if (this.operatorText == null) return false;
        ASTNode aSTNode = SqlFormatting.child(node, 2);
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getText() : null), (Object)this.operatorText)) return false;
        return true;
    }

    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        boolean isOperator;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        boolean bl = isOperator = this.operatorText != null && node.getTextLength() == this.operatorText.length() && Intrinsics.areEqual((Object)node.getText(), (Object)this.operatorText);
        if (isOperator) {
            SqlFormattingContext sqlFormattingContext = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
            sqlBlock = SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, null, null, this.operatorIndent, false, 32, null);
        } else {
            SqlFormattingContext sqlFormattingContext = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
            sqlBlock = SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, this.operandWrap, this.operandAlignment, this.operandIndent, false, 32, null);
        }
        return sqlBlock;
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        if (block1 instanceof SqlSymbol || block2 instanceof SqlSymbol) {
            boolean keepLineBreaks = this.myContext.commonSettings.KEEP_LINE_BREAKS;
            switch (this.myContext.customSettings.EXPR_SPACE_AROUND_OPERATOR) {
                case 1: {
                    spacing = SqlFormatting.makeSpace$default(false, keepLineBreaks, 1, null);
                    break;
                }
                case 2: {
                    spacing = SqlFormatting.makeNoSpace(keepLineBreaks);
                    break;
                }
                default: {
                    spacing = SqlFormatting.makeSafeSpace(keepLineBreaks);
                    break;
                }
            }
        } else {
            SqlFormattingContext sqlFormattingContext = this.myContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"myContext");
            spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
        }
        return spacing;
    }

    public SqlBinaryExpressionBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(node, context, wrap, alignment, indent, forceCollapse, null);
        ASTNode aSTNode = SqlFormatting.child(node, 2);
        this.operatorText = aSTNode != null ? aSTNode.getText() : null;
        this.operandWrap = this.getCollapse() ? null : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
        this.operandAlignment = context.customSettings.EXPR_BINARY_OP_ALIGN ? Alignment.createAlignment((boolean)false) : null;
        this.operandIndent = context.customSettings.EXPR_BINARY_OP_ALIGN ? null : Indent.getContinuationIndent((boolean)false);
        this.operatorIndent = context.commonSettings.KEEP_LINE_BREAKS ? Indent.getNormalIndent((boolean)true) : null;
    }
}

