/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.BaseSqlBlock;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlBlockFrom;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlIdentifierWord;
import com.intellij.sql.formatter.SqlQuerySectionFormatProcessor;
import com.intellij.sql.formatter.SqlSingleNodeSectionBlock;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.containers.FilteredTraverserBase;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0006\"#$%&'BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\n\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom;", "Lcom/intellij/sql/formatter/SqlSingleNodeSectionBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "queryContext", "Lcom/intellij/sql/com/intellij/sql/formatter/SqlQueryFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "continuous", "", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/sql/com/intellij/sql/formatter/SqlQueryFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Z)V", "containsPrimaryJoin", "containsSecondaryJoin", "myAliasAlign", "myJoinIndent", "kotlin.jvm.PlatformType", "myJoinTableAlign", "analyzeJoins", "", "createProcessor", "Lcom/intellij/sql/formatter/SqlQuerySectionFormatProcessor;", "getAliasAlign", "getJoinTableAlign", "whetherToFlatten", "element", "Lcom/intellij/psi/PsiElement;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "Companion", "JoinCondition", "JoinWord", "PrimaryTableExpression", "Processor", "TableItem", "intellij.database.sql.impl"})
public final class SqlBlockFrom
extends SqlSingleNodeSectionBlock {
    private boolean containsPrimaryJoin;
    private boolean containsSecondaryJoin;
    private Alignment myJoinTableAlign;
    private Alignment myAliasAlign;
    private final Indent myJoinIndent;
    private static final Set<SqlTokenType> JOIN_TOKENS;
    private static final Set<SqlCompositeElementType> JOIN_ELEMENT_TYPES;
    public static final Companion Companion;

    private final void analyzeJoins(ASTNode node) {
        FilteredTraverserBase filteredTraverserBase = ((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)node).expandAndFilter((Condition)analyzeJoins.joinNodes.1.INSTANCE)).filter((Condition)analyzeJoins.joinNodes.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)filteredTraverserBase, (String)"SyntaxTraverser\n        \u2026 == SQL_JOIN_EXPRESSION }");
        Iterable joinNodes2 = (Iterable)filteredTraverserBase;
        for (ASTNode n : joinNodes2) {
            if (Intrinsics.areEqual((Object)SqlFormatting.childType(n, 2), (Object)SqlElementTypes.SQL_COMMA)) {
                this.containsPrimaryJoin = true;
            } else {
                this.containsSecondaryJoin = true;
            }
            if (!this.containsPrimaryJoin || !this.containsSecondaryJoin) continue;
            break;
        }
    }

    @Override
    @NotNull
    protected SqlQuerySectionFormatProcessor createProcessor() {
        return new Processor();
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        return elementType == SqlElementTypes.SQL_JOIN_EXPRESSION && SqlFormatting.childType(node, 2) == SqlElementTypes.SQL_COMMA;
    }

    private final Alignment getJoinTableAlign() {
        Alignment a = this.myJoinTableAlign;
        if (a == null) {
            this.myJoinTableAlign = a = this.createLeftAlignmentBS();
        }
        return a;
    }

    private final Alignment getAliasAlign() {
        if (!this.getContext().customSettings.FROM_ALIGN_ALIASES) {
            return null;
        }
        Alignment a = this.myAliasAlign;
        if (a == null) {
            this.myAliasAlign = a = this.createLeftAlignmentBS();
        }
        return a;
    }

    public SqlBlockFrom(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @NotNull SqlQueryFormattingContext queryContext, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean continuous) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)queryContext, (String)"queryContext");
        super(node, context, queryContext, wrap, alignment, indent, continuous);
        this.myJoinIndent = this.getContext().customSettings.FROM_INDENT_JOIN ? Indent.getNormalIndent((boolean)true) : Indent.getNoneIndent();
        this.analyzeJoins(node);
        SqlCodeStyleSettings s = this.myContext.customSettings;
        if (this.containsPrimaryJoin && this.containsSecondaryJoin) {
            this.myProcessor.setupLook(s.QUERY_EL_LINE, 1, s.FROM_EL_COMMA, false, false);
        } else {
            this.myProcessor.setupLook(s.QUERY_EL_LINE, s.FROM_EL_WRAP, s.FROM_EL_COMMA, false);
        }
        this.myProcessor.prepare(node);
    }

    static {
        Companion = new Companion(null);
        JOIN_TOKENS = SetsKt.setOf((Object[])new SqlTokenType[]{SqlElementTypes.SQL_CROSS, SqlElementTypes.SQL_NATURAL, SqlElementTypes.SQL_LEFT, SqlElementTypes.SQL_RIGHT, SqlElementTypes.SQL_INNER, SqlElementTypes.SQL_OUTER, SqlElementTypes.SQL_JOIN});
        JOIN_ELEMENT_TYPES = SetsKt.setOf((Object[])new SqlCompositeElementType[]{SqlElementTypes.SQL_FROM_CLAUSE, SqlElementTypes.SQL_JOIN_EXPRESSION, SqlElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION});
    }

    @NotNull
    public static final /* synthetic */ Set access$getJOIN_ELEMENT_TYPES$cp() {
        return JOIN_ELEMENT_TYPES;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom$Processor;", "Lcom/intellij/sql/formatter/SqlQuerySectionFormatProcessor;", "(Lcom/intellij/sql/formatter/SqlBlockFrom;)V", "checkIsChild", "", "element", "Lcom/intellij/psi/PsiElement;", "type", "Lcom/intellij/psi/tree/IElementType;", "createChildBlock", "Lcom/intellij/sql/com/intellij/sql/formatter/BaseSqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "intellij.database.sql.impl"})
    private final class Processor
    extends SqlQuerySectionFormatProcessor {
        @Override
        public boolean checkIsChild(@NotNull PsiElement element, @NotNull IElementType type) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return type == SqlElementTypes.SQL_TABLE_REFERENCE || type == SqlElementTypes.SQL_AS_EXPRESSION || type == SqlElementTypes.SQL_JOIN_EXPRESSION;
        }

        @Override
        @NotNull
        public BaseSqlBlock createChildBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            IElementType iElementType = node.getElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_JOIN_EXPRESSION) ? (BaseSqlBlock)new PrimaryTableExpression(node, context, wrap, alignment, indent) : (BaseSqlBlock)new TableItem(node, context, wrap, alignment, indent);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J \u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom$PrimaryTableExpression;", "Lcom/intellij/sql/com/intellij/sql/formatter/BaseSqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/sql/formatter/SqlBlockFrom;Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;)V", "joinAlign", "joinPosition", "", "joinWordNr", "joinWrap", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "makeBlock", "element", "Lcom/intellij/psi/PsiElement;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "whetherToFlatten", "", "intellij.database.sql.impl"})
    private final class PrimaryTableExpression
    extends BaseSqlBlock {
        private final Wrap joinWrap;
        private final Alignment joinAlign;
        private int joinPosition;
        private int joinWordNr;

        @Override
        protected boolean whetherToFlatten(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            return elementType == SqlElementTypes.SQL_JOIN_EXPRESSION;
        }

        @Override
        @NotNull
        protected SqlBlock makeBlock(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
            SqlBlock sqlBlock;
            boolean isTable;
            boolean isJoinWord;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Wrap theWrap = null;
            Alignment theAlign = null;
            Indent theIndent = null;
            boolean isWord = SqlFormatting.isKeyWord(node);
            boolean bl = isJoinWord = isWord && CollectionsKt.contains((Iterable)JOIN_TOKENS, (Object)elementType);
            if (isJoinWord) {
                int n = this.joinWordNr;
                this.joinWordNr = n + 1;
            } else {
                this.joinWordNr = 0;
            }
            boolean bl2 = isTable = Intrinsics.areEqual((Object)elementType, (Object)SqlElementTypes.SQL_AS_EXPRESSION) || Intrinsics.areEqual((Object)elementType, (Object)SqlElementTypes.SQL_TABLE_REFERENCE);
            if (this.joinWordNr == 1) {
                int n = this.joinPosition;
                this.joinPosition = n + 1;
                theWrap = this.joinWrap;
            }
            if (this.joinWordNr > 0) {
                theAlign = this.joinAlign;
                theIndent = SqlBlockFrom.this.myJoinIndent;
            }
            if (isTable && element.getPrevSibling() != null && this.getCustom().FROM_ALIGN_JOIN_TABLES) {
                theAlign = SqlBlockFrom.this.getJoinTableAlign();
            }
            if (elementType == SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE) {
                boolean always = this.getCustom().FROM_WRAP_ON;
                WrapType theWrapType = always ? WrapType.ALWAYS : WrapType.NORMAL;
                theWrap = SqlFormatting.createChildWrap(this.joinWrap, theWrapType, true);
                theIndent = Indent.getContinuationIndent((boolean)true);
            }
            if (isJoinWord) {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
                sqlBlock = new JoinWord(node, sqlFormattingContext, theWrap, theAlign, theIndent, this.joinWordNr, this.joinPosition);
            } else if (isWord) {
                sqlBlock = new SqlWord(node, this.getContext(), theWrap, theAlign, theIndent, 0);
            } else if (isTable) {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
                sqlBlock = new TableItem(node, sqlFormattingContext, theWrap, theAlign, theIndent);
            } else if (elementType == SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE) {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
                sqlBlock = new JoinCondition(node, sqlFormattingContext, theWrap, theAlign, theIndent);
            } else {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
                sqlBlock = SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, theWrap, theAlign, theIndent, false, 32, null);
            }
            return sqlBlock;
        }

        @Override
        @Nullable
        protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Spacing spacing;
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            IElementType t1 = block1.getElementType();
            IElementType t2 = block2.getElementType();
            if (block2 instanceof JoinWord && ((JoinWord)block2).mySequentialPosition == 1) {
                switch (((JoinWord)block2).getJoinOrder()) {
                    case 0: {
                        spacing = SqlFormatting.makeSpace$default(false, false, 3, null);
                        break;
                    }
                    case 1: {
                        if (this.getCustom().FROM_WRAP_JOIN_1) {
                            spacing = SqlFormatting.makeNL();
                            break;
                        }
                        spacing = SqlFormatting.makeSpace$default(false, false, 3, null);
                        break;
                    }
                    default: {
                        if (this.getCustom().FROM_WRAP_JOIN_2) {
                            spacing = SqlFormatting.makeNL();
                            break;
                        }
                        spacing = SqlFormatting.makeSpace$default(false, false, 3, null);
                        break;
                    }
                }
            } else if (t1 == SqlCommonTokens.SQL_LEFT_PAREN || t1 == SqlElementTypes.SQL_COMMA) {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
                spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
            } else if (t2 == SqlElementTypes.SQL_COMMA || t2 == SqlCommonTokens.SQL_RIGHT_PAREN) {
                SqlFormattingContext sqlFormattingContext = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
                spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
            } else {
                spacing = t2 == SqlCommonTokens.SQL_LEFT_PAREN ? SqlFormatting.makeSafeSpace$default(false, 1, null) : SqlFormatting.makeSpace$default(false, false, 3, null);
            }
            return spacing;
        }

        public PrimaryTableExpression(@NotNull ASTNode node, @Nullable SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, Indent indent) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(node, context, wrap, alignment, indent);
            this.joinWrap = SqlFormatting.createChildWrap(this.myWrap, this.getCustom().FROM_WRAP_JOIN_2 ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, this.getCustom().FROM_WRAP_JOIN_1);
            this.joinAlign = this.createLeftAlignment();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom$TableItem;", "Lcom/intellij/sql/com/intellij/sql/formatter/BaseSqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/sql/formatter/SqlBlockFrom;Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;)V", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "makeBlock", "element", "Lcom/intellij/psi/PsiElement;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "intellij.database.sql.impl"})
    private final class TableItem
    extends BaseSqlBlock {
        @Override
        @NotNull
        protected SqlBlock makeBlock(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            return this.myElementType == SqlElementTypes.SQL_AS_EXPRESSION && elementType == SqlElementTypes.SQL_IDENTIFIER ? (SqlBlock)new SqlIdentifierWord(node, this.getContext(), null, SqlBlockFrom.this.getAliasAlign(), null) : super.makeBlock(node, element, elementType);
        }

        @Override
        @Nullable
        protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            if (block1.getElementType() == SqlElementTypes.SQL_IDENTIFIER && Intrinsics.areEqual((Object)block2.getElementType(), (Object)SqlCommonTokens.SQL_LEFT_PAREN)) {
                return SqlFormatting.makeSpace$default(this.myContext.customSettings.CORTEGE_SPACE_BEFORE_L_PAREN, false, 2, null);
            }
            return super.getSpacingInner(block1, block2);
        }

        public TableItem(@NotNull ASTNode node, @Nullable SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, Indent indent) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(node, context, wrap, alignment, indent);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom$JoinCondition;", "Lcom/intellij/sql/com/intellij/sql/formatter/BaseSqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;)V", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "intellij.database.sql.impl"})
    private static final class JoinCondition
    extends BaseSqlBlock {
        @Override
        @NotNull
        protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
            return SqlFormatting.makeSpace$default(false, false, 3, null);
        }

        public JoinCondition(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(node, context, wrap, alignment, indent);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom$JoinWord;", "Lcom/intellij/sql/formatter/SqlWord;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "sequentialPosition", "", "joinOrder", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;II)V", "getJoinOrder", "()I", "intellij.database.sql.impl"})
    private static final class JoinWord
    extends SqlWord {
        private final int joinOrder;

        public final int getJoinOrder() {
            return this.joinOrder;
        }

        public JoinWord(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, int sequentialPosition, int joinOrder) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(node, context, wrap, alignment, indent, sequentialPosition);
            this.joinOrder = joinOrder;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/SqlBlockFrom$Companion;", "", "()V", "JOIN_ELEMENT_TYPES", "", "Lcom/intellij/sql/psi/SqlCompositeElementType;", "kotlin.jvm.PlatformType", "JOIN_TOKENS", "Lcom/intellij/sql/psi/impl/SqlTokenType;", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

