/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.formatter.AbstractSqlBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlBlockFrom;
import com.intellij.sql.formatter.SqlBlockGroupOrder;
import com.intellij.sql.formatter.SqlBlockInto;
import com.intellij.sql.formatter.SqlBlockSelect;
import com.intellij.sql.formatter.SqlBlockSet;
import com.intellij.sql.formatter.SqlBlockUnspecified;
import com.intellij.sql.formatter.SqlBlockValues;
import com.intellij.sql.formatter.SqlBlockWhere;
import com.intellij.sql.formatter.SqlBlockWith;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlQueryCategory;
import com.intellij.sql.formatter.SqlSingleNodeSectionBlock;
import com.intellij.sql.formatter.SqlSymbol;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBlockQuery
extends AbstractSqlBlock {
    private final SqlQueryFormattingContext myQueryContext;
    @Nullable
    private final Wrap myPrimaryWrap;
    @Nullable
    private final Alignment myPrimaryAlignment1;
    @Nullable
    private final Alignment myPrimaryAlignment2;
    @Nullable
    private final Indent myPrimaryIndent1;
    @Nullable
    private final Indent myPrimaryIndent2;
    @Nullable
    private Wrap myInnerWrap;
    @Nullable
    private Indent myInnerIndent;
    private boolean begin;
    private boolean wasUnion;

    public SqlBlockQuery(@NotNull SqlQueryCategory category, @NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (category == null) {
            SqlBlockQuery.$$$reportNull$$$0(0);
        }
        if (node == null) {
            SqlBlockQuery.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SqlBlockQuery.$$$reportNull$$$0(2);
        }
        this(category, node, context, wrap, alignment, indent, false, false);
    }

    public SqlBlockQuery(@NotNull SqlQueryCategory category, @NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean isSubQuery, boolean collapse) {
        if (category == null) {
            SqlBlockQuery.$$$reportNull$$$0(3);
        }
        if (node == null) {
            SqlBlockQuery.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlBlockQuery.$$$reportNull$$$0(5);
        }
        super(node, context, wrap, alignment, indent);
        this.myInnerWrap = null;
        this.myInnerIndent = null;
        this.begin = true;
        this.wasUnion = false;
        boolean itIsSubQuery = isSubQuery || SqlFormatting.isSubQuery(node);
        boolean itIsPossibleToCollapse = collapse || SqlBlockQuery.checkWhetherPossibleToCollapse(node, context, itIsSubQuery);
        this.myQueryContext = new SqlQueryFormattingContext(node.getTextRange(), category, itIsSubQuery, itIsPossibleToCollapse, SqlBlockQuery.makeFirstWordAlignment(context, node));
        SqlCodeStyleSettings s = context.customSettings;
        switch (s.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: {
                this.myPrimaryAlignment1 = this.myPrimaryAlignment2 = this.createLeftAlignment();
                this.myPrimaryIndent1 = this.myPrimaryIndent2 = Indent.getNoneIndent();
                break;
            }
            case 2: {
                this.myPrimaryAlignment1 = this.createLeftAlignment();
                this.myPrimaryAlignment2 = this.createLeftAlignment();
                this.myPrimaryIndent1 = Indent.getNoneIndent();
                this.myPrimaryIndent2 = Indent.getNormalIndent((boolean)true);
                break;
            }
            default: {
                this.myPrimaryAlignment2 = null;
                this.myPrimaryAlignment1 = null;
                this.myPrimaryIndent2 = null;
                this.myPrimaryIndent1 = null;
            }
        }
        this.myPrimaryWrap = this.createWrap(itIsPossibleToCollapse ? WrapType.CHOP_DOWN_IF_LONG : WrapType.ALWAYS, false);
        if (category == SqlQueryCategory.QUERY_DELETE) {
            this.myInnerWrap = Wrap.createChildWrap((Wrap)this.myPrimaryWrap, (WrapType)WrapType.NORMAL, (boolean)false);
            this.myInnerIndent = Indent.getContinuationIndent();
        }
    }

    private static boolean checkWhetherPossibleToCollapse(@NotNull ASTNode node, @NotNull SqlFormattingContext context, boolean isItSubQuery) {
        int q1s;
        boolean allowToCollapse;
        if (node == null) {
            SqlBlockQuery.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SqlBlockQuery.$$$reportNull$$$0(7);
        }
        boolean bl = allowToCollapse = (q1s = context.customSettings.QUERY_IN_ONE_STRING) == 3 || q1s == 2 && isItSubQuery;
        if (allowToCollapse) {
            int limit = context.getRightMargin();
            if (isItSubQuery) {
                limit -= 7;
            }
            allowToCollapse = SqlFormatting.determineCanItFitIn(node, limit);
        }
        return allowToCollapse;
    }

    @Nullable
    private static Alignment makePrimaryAlignment(SqlCodeStyleSettings customSettings) {
        switch (customSettings.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: 
            case 2: {
                return Alignment.createAlignment();
            }
        }
        return null;
    }

    private static Indent makePrimaryIndent(SqlCodeStyleSettings customSettings) {
        switch (customSettings.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: 
            case 2: {
                return Indent.getNoneIndent();
            }
        }
        return null;
    }

    private static Alignment makeFirstWordAlignment(@NotNull SqlFormattingContext context, ASTNode node) {
        if (context == null) {
            SqlBlockQuery.$$$reportNull$$$0(8);
        }
        switch (context.customSettings.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 8: {
                boolean shift = false;
                return Alignment.createAlignment((boolean)shift, (Alignment.Anchor)Alignment.Anchor.RIGHT);
            }
        }
        return null;
    }

    @Override
    protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
        if (blockNode == null) {
            SqlBlockQuery.$$$reportNull$$$0(9);
        }
        if (builtBlocks == null) {
            SqlBlockQuery.$$$reportNull$$$0(10);
        }
        SqlCodeStyleSettings s = this.myContext.customSettings;
        boolean alignRight = s.QUERY_SECTION_1ST_WORD_ALIGN == 8;
        for (ASTNode node = blockNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            PsiElement element1;
            IElementType elementType;
            PsiElement element = node.getPsi();
            if (SqlBlockQuery.isWhitespace(node, element, elementType = node.getElementType())) continue;
            if (elementType == SqlElementTypes.SQL_DUMMY_BLOCK || elementType == SqlCompositeElementTypes.SQL_TABLE_EXPRESSION || elementType == SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION || elementType == SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION || elementType == SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION || elementType == SqlCompositeElementTypes.SQL_DML_INSTRUCTION || elementType == SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION || elementType == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION || elementType == SqlCompositeElementTypes.SQL_UNION_EXPRESSION) {
                this.buildBlocks(node, builtBlocks);
                continue;
            }
            if (element instanceof IsExternal) {
                builtBlocks.add((Block)new SqlFormattingBlock.ReadOnlyBlock(node));
                continue;
            }
            Wrap wrap = null;
            Alignment alignment = null;
            Indent indent = null;
            boolean continuous = false;
            boolean isKeyWord = elementType instanceof SqlKeywordTokenType;
            int kwn = 0;
            boolean began = false;
            if (elementType == SqlCommonKeywords.SQL_INSERT || elementType == SqlCommonKeywords.SQL_UPDATE || elementType == SqlCommonKeywords.SQL_DELETE || elementType == SqlCommonKeywords.SQL_REPLACE || elementType == SqlCommonKeywords.SQL_EXPLAIN) {
                began = this.begin;
                wrap = this.myPrimaryWrap;
                alignment = this.myPrimaryAlignment1 != null ? this.myPrimaryAlignment1 : this.myQueryContext.firstWordAlign;
                indent = this.myPrimaryIndent1;
            } else if (elementType == SqlCompositeElementTypes.SQL_VALUES_EXPRESSION || elementType == SqlCompositeElementTypes.SQL_SET_CLAUSE || elementType == SqlCompositeElementTypes.SQL_SELECT_CLAUSE || elementType == SqlCompositeElementTypes.SQL_FROM_CLAUSE || elementType == SqlCompositeElementTypes.SQL_HAVING_CLAUSE || elementType == SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE || elementType == SqlCompositeElementTypes.SQL_CLAUSE || elementType == SqlCompositeElementTypes.SQL_WHERE_CLAUSE || elementType == SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE) {
                began = this.begin;
                wrap = this.myPrimaryWrap;
                alignment = this.begin ? this.myPrimaryAlignment1 : this.myPrimaryAlignment2;
                indent = this.begin ? this.myPrimaryIndent1 : this.myPrimaryIndent2;
            } else if (elementType == SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE) {
                wrap = this.myPrimaryWrap;
                alignment = this.wasUnion ? this.myPrimaryAlignment1 : this.myPrimaryAlignment2;
                indent = this.wasUnion ? this.myPrimaryIndent1 : this.myPrimaryIndent2;
            } else if (elementType == SqlCommonKeywords.SQL_UNION || elementType == SqlCommonKeywords.SQL_INTERSECT || elementType == SqlCommonKeywords.SQL_MINUS) {
                this.begin = true;
                began = false;
                wrap = this.myPrimaryWrap;
                alignment = this.myPrimaryAlignment1 != null ? this.myPrimaryAlignment1 : this.myQueryContext.firstWordAlign;
                indent = this.myPrimaryIndent1;
                kwn = 1;
                this.wasUnion = true;
            } else if (elementType == SqlCompositeElementTypes.SQL_WITH_CLAUSE) {
                wrap = this.myPrimaryWrap;
                alignment = alignRight ? null : this.myPrimaryAlignment1;
                indent = alignRight ? Indent.getSpaceIndent((int)2) : this.myPrimaryIndent1;
            } else if (elementType == SqlCommonKeywords.SQL_ALL) {
                kwn = 2;
                continuous = true;
            }
            if (this.myQueryContext.category == SqlQueryCategory.QUERY_DELETE && elementType == SqlCompositeElementTypes.SQL_FROM_CLAUSE && ((element1 = element.getFirstChild()) == null || SqlImplUtil.getElementType(element1) != SqlCommonKeywords.SQL_FROM)) {
                continuous = true;
            }
            if (this.myQueryContext.category == SqlQueryCategory.QUERY_INSERT) {
                if (elementType == SqlCommonKeywords.SQL_INTO) {
                    switch (s.INSERT_INTO_NL) {
                        case 1: {
                            began = this.begin;
                            wrap = this.myPrimaryWrap;
                            alignment = this.myPrimaryAlignment2;
                            indent = this.myPrimaryIndent2;
                            break;
                        }
                        case 2: {
                            wrap = this.createWrap(WrapType.NONE, false);
                        }
                    }
                } else if (elementType == SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST) {
                    continuous = true;
                }
            }
            if (continuous) {
                wrap = this.createWrap(WrapType.NONE, false);
                alignment = null;
                indent = Indent.getNoneIndent();
            }
            SqlBlock formattingBlock = isKeyWord ? new SqlWord(node, this.myContext, wrap, alignment, indent, kwn) : (elementType == SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST ? new SqlBlockInto(node, this.myContext, this.myQueryContext, wrap, alignment, indent, continuous) : (elementType == SqlCompositeElementTypes.SQL_VALUES_EXPRESSION ? new SqlBlockValues(node, this.myContext, this.myQueryContext, wrap, alignment, indent) : (elementType == SqlCompositeElementTypes.SQL_SET_CLAUSE ? new SqlBlockSet(node, this.myContext, this.myQueryContext, wrap, alignment, indent) : (elementType == SqlCompositeElementTypes.SQL_WITH_CLAUSE ? new SqlBlockWith(node, this.myContext, this.myQueryContext, wrap, alignment, indent) : (elementType == SqlCompositeElementTypes.SQL_SELECT_CLAUSE ? new SqlBlockSelect(node, this.myContext, this.myQueryContext, wrap, alignment, indent, this.myQueryContext.isSubquery) : (elementType == SqlCompositeElementTypes.SQL_FROM_CLAUSE ? new SqlBlockFrom(node, this.myContext, this.myQueryContext, wrap, alignment, indent, continuous) : (elementType == SqlCompositeElementTypes.SQL_WHERE_CLAUSE || elementType == SqlCompositeElementTypes.SQL_HAVING_CLAUSE || elementType == SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE ? new SqlBlockWhere(node, this.myContext, this.myQueryContext, wrap, alignment, indent) : (elementType == SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE || elementType == SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE ? new SqlBlockGroupOrder(node, this.myContext, this.myQueryContext, wrap, alignment, indent) : (elementType == SqlCompositeElementTypes.SQL_CLAUSE ? new SqlBlockUnspecified(node, this.myContext, this.myQueryContext, wrap, alignment, indent) : (elementType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE || elementType == SqlCompositeElementTypes.SQL_AS_EXPRESSION ? new SmallInnerItem(node, this.myContext, this.myInnerWrap, null, this.myInnerIndent) : (elementType == SqlTokens.SQL_COMMA ? new SqlSymbol(node, this.myContext, null, null, null) : this.createNestedBlock(node, wrap, alignment, indent))))))))))));
            builtBlocks.add((Block)formattingBlock);
            if (!began) continue;
            this.begin = false;
        }
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        if (block1 == null) {
            SqlBlockQuery.$$$reportNull$$$0(11);
        }
        if (block2 == null) {
            SqlBlockQuery.$$$reportNull$$$0(12);
        }
        IElementType type1 = block1.getElementType();
        IElementType type2 = block2.getElementType();
        if (block2 instanceof SqlSingleNodeSectionBlock) {
            boolean inner = ((SqlSingleNodeSectionBlock)block2).myContinuous;
            boolean mayInline = this.myQueryContext.isPossibleToCollapse || inner;
            spacing = mayInline ? SqlBlockQuery.createHardSpace() : this.createLineBreak();
        } else {
            spacing = type1 == SqlTokens.SQL_COMMA && type2 == SqlCompositeElementTypes.SQL_TABLE_REFERENCE ? SqlBlockQuery.createHardSpace() : super.getSpacingInner(block1, block2);
        }
        return spacing;
    }

    public boolean isLeaf() {
        return false;
    }

    @Nullable
    protected Indent getChildIndent() {
        return this.myPrimaryIndent2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtBlocks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/formatter/SqlBlockQuery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWhetherPossibleToCollapse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "makeFirstWordAlignment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "buildBlocks";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacingInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SmallInnerItem
    extends AbstractSqlBlock {
        public SmallInnerItem(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
            if (node == null) {
                SmallInnerItem.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SmallInnerItem.$$$reportNull$$$0(1);
            }
            super(node, context, wrap, alignment, indent);
        }

        @Override
        protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
            if (blockNode == null) {
                SmallInnerItem.$$$reportNull$$$0(2);
            }
            if (builtBlocks == null) {
                SmallInnerItem.$$$reportNull$$$0(3);
            }
            for (ASTNode node = blockNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
                IElementType elementType;
                PsiElement element = node.getPsi();
                if (SmallInnerItem.isWhitespace(node, element, elementType = node.getElementType())) continue;
                if (elementType == SqlElementTypes.SQL_DUMMY_BLOCK) {
                    this.buildBlocks(node, builtBlocks);
                    continue;
                }
                if (element instanceof IsExternal) {
                    builtBlocks.add((Block)new SqlFormattingBlock.ReadOnlyBlock(node));
                    continue;
                }
                SqlBlock formattingBlock = this.createNestedBlock(node, null, null, null);
                builtBlocks.add((Block)formattingBlock);
            }
        }

        @Override
        @Nullable
        protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            if (block1 == null) {
                SmallInnerItem.$$$reportNull$$$0(4);
            }
            if (block2 == null) {
                SmallInnerItem.$$$reportNull$$$0(5);
            }
            return SqlFormatting.commonSpacing(this.myContext, block1, block2);
        }

        public boolean isLeaf() {
            return this.myNode.getFirstChildNode() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builtBlocks";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/formatter/SqlBlockQuery$SmallInnerItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildBlocks";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSpacingInner";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

