/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.google.common.collect.ImmutableSet;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlQuerySectionFormatProcessor;
import com.intellij.sql.formatter.SqlSingleNodeSectionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBlockSelect
extends SqlSingleNodeSectionBlock {
    private static final Set<? extends IElementType> NON_CHILD_TYPES = ImmutableSet.of((Object)SqlCompositeElementTypes.SQL_IDENTIFIER, (Object)SqlTokens.SQL_OP_EQ, (Object)SqlTokens.SQL_AS, (Object)SqlTokens.SQL_COMMA, (Object)SqlTokens.SQL_BLOCK_COMMENT, (Object)SqlTokens.SQL_LINE_COMMENT, (Object[])new IElementType[]{SqlTokens.MYSQL_LINE_COMMENT});

    public SqlBlockSelect(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @NotNull SqlQueryFormattingContext queryContext, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            SqlBlockSelect.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlBlockSelect.$$$reportNull$$$0(1);
        }
        if (queryContext == null) {
            SqlBlockSelect.$$$reportNull$$$0(2);
        }
        this(node, context, queryContext, wrap, alignment, indent, SqlFormatting.isSubQuery(node.getTreeParent()));
    }

    public SqlBlockSelect(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @NotNull SqlQueryFormattingContext queryContext, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean isSubQuery) {
        boolean canFitInOneLine;
        if (node == null) {
            SqlBlockSelect.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SqlBlockSelect.$$$reportNull$$$0(4);
        }
        if (queryContext == null) {
            SqlBlockSelect.$$$reportNull$$$0(5);
        }
        super(node, context, queryContext, wrap, alignment, indent);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(node.getPsi());
        SqlCodeStyleSettings customSettings = this.myContext.customSettings;
        CommonCodeStyleSettings commonSettings = this.myContext.commonSettings;
        int keepN = customSettings.SELECT_KEEP_N_ITEMS_IN_LINE;
        boolean bl = canFitInOneLine = customSettings.SELECT_EL_WRAP >= 2;
        if (!canFitInOneLine && customSettings.QUERY_IN_ONE_STRING >= 2) {
            boolean bl2 = canFitInOneLine = isSubQuery || customSettings.QUERY_IN_ONE_STRING == 3;
        }
        if (!canFitInOneLine && keepN > 0) {
            int limit = commonSettings.getRootSettings().getRightMargin((Language)dialect);
            boolean over = node.getTextLength() > limit * 2;
            over = over || SqlBlockSelect.countChildren(node, (IElementType)SqlTokens.SQL_COMMA, keepN) >= keepN;
            canFitInOneLine = !over;
        }
        this.myProcessor.setupLook(customSettings.QUERY_EL_LINE, customSettings.SELECT_EL_WRAP, customSettings.SELECT_EL_COMMA, customSettings.SELECT_ALIGN_AS, canFitInOneLine);
        this.myProcessor.prepare(node);
    }

    @Override
    @NotNull
    protected SqlQuerySectionFormatProcessor createProcessor() {
        Processor processor = new Processor();
        if (processor == null) {
            SqlBlockSelect.$$$reportNull$$$0(6);
        }
        return processor;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
        if (node == null) {
            SqlBlockSelect.$$$reportNull$$$0(7);
        }
        if (element == null) {
            SqlBlockSelect.$$$reportNull$$$0(8);
        }
        if (elementType == null) {
            SqlBlockSelect.$$$reportNull$$$0(9);
        }
        return elementType == SqlCompositeElementTypes.SQL_AS_EXPRESSION || elementType == SqlCompositeElementTypes.SQL_SELECT_OPTION || elementType == SqlCompositeElementTypes.SQL_CLAUSE;
    }

    @Override
    @Nullable
    protected Indent getChildIndent() {
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        if (lastChildNode == null) {
            return Indent.getNoneIndent();
        }
        if (lastChildNode instanceof PsiErrorElement && (lastChildNode = lastChildNode.getTreePrev()) == null) {
            return Indent.getNoneIndent();
        }
        if (lastChildNode.getTextLength() == 1) {
            String lastText = lastChildNode.getText();
            if (lastText.isEmpty()) {
                return null;
            }
            char lastChar = lastText.charAt(0);
            switch (lastChar) {
                case '*': {
                    return Indent.getNoneIndent();
                }
                case ',': {
                    return this.myProcessor.getIndent();
                }
                case '.': {
                    return Indent.getContinuationIndent();
                }
            }
        }
        SqlCodeStyleSettings s = this.myContext.customSettings;
        if (s.SELECT_EL_COMMA == 1) {
            return this.myProcessor.getIndent();
        }
        if (s.QUERY_EL_LINE == 101) {
            return this.myProcessor.getIndent();
        }
        return Indent.getNoneIndent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlBlockSelect";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlBlockSelect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "whetherToFlatten";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Processor
    extends SqlQuerySectionFormatProcessor {
        private Processor() {
        }

        @Override
        public boolean checkIsPrefixEntity(@NotNull ASTNode node, @NotNull IElementType type) {
            if (node == null) {
                Processor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Processor.$$$reportNull$$$0(1);
            }
            return type == SqlCompositeElementTypes.SQL_IDENTIFIER;
        }

        @Override
        public boolean checkIsPrefixDelimiter(@NotNull IElementType type) {
            if (type == null) {
                Processor.$$$reportNull$$$0(2);
            }
            return type == SqlTokens.SQL_OP_EQ;
        }

        @Override
        public boolean checkIsChild(@NotNull PsiElement element, @NotNull IElementType type) {
            if (element == null) {
                Processor.$$$reportNull$$$0(3);
            }
            if (type == null) {
                Processor.$$$reportNull$$$0(4);
            }
            return !NON_CHILD_TYPES.contains(type);
        }

        @Override
        public boolean checkIsMicroChild(@NotNull ASTNode node) {
            if (node == null) {
                Processor.$$$reportNull$$$0(5);
            }
            return node.getTextLength() == 1 && node.textContains('*');
        }

        @Override
        public boolean checkIsSuffixDelimiter(@NotNull IElementType type) {
            if (type == null) {
                Processor.$$$reportNull$$$0(6);
            }
            return type == SqlTokens.SQL_AS;
        }

        @Override
        public boolean checkIsSuffixEntity(@NotNull ASTNode node, @NotNull IElementType type) {
            if (node == null) {
                Processor.$$$reportNull$$$0(7);
            }
            if (type == null) {
                Processor.$$$reportNull$$$0(8);
            }
            return type == SqlCompositeElementTypes.SQL_IDENTIFIER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/formatter/SqlBlockSelect$Processor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsPrefixEntity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsPrefixDelimiter";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsChild";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsMicroChild";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsSuffixDelimiter";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsSuffixEntity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

