/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.formatter.AbstractSqlBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlBlockQuery;
import com.intellij.sql.formatter.SqlBlockValues;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlQueryCategory;
import com.intellij.sql.formatter.SqlSymbol;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBlockSubquery
extends AbstractSqlBlock {
    @NotNull
    private final Wrap mainWrap;
    @Nullable
    private final Alignment mainAlignment;
    @Nullable
    private final Indent contentIndent;
    private boolean inside;

    public SqlBlockSubquery(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            SqlBlockSubquery.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlBlockSubquery.$$$reportNull$$$0(1);
        }
        super(node, context, wrap, alignment, indent);
        this.inside = false;
        SqlCodeStyleSettings s = context.customSettings;
        int wrapPoints = 0;
        if (s.SUBQUERY_L_PAR_NL_OUTSIDE) {
            ++wrapPoints;
        }
        if (s.SUBQUERY_L_PAR_NL_INSIDE) {
            ++wrapPoints;
        }
        if (s.SUBQUERY_R_PAR_NL_INSIDE) {
            ++wrapPoints;
        }
        this.mainWrap = this.createWrap(wrapPoints > 0 ? WrapType.ALWAYS : WrapType.NONE, s.SUBQUERY_L_PAR_NL_OUTSIDE);
        this.mainAlignment = this.createLeftAlignment();
        this.contentIndent = s.SUBQUERY_INDENT_INSIDE ? Indent.getNormalIndent((boolean)true) : Indent.getNoneIndent();
    }

    @Override
    protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
        if (blockNode == null) {
            SqlBlockSubquery.$$$reportNull$$$0(2);
        }
        if (builtBlocks == null) {
            SqlBlockSubquery.$$$reportNull$$$0(3);
        }
        SqlCodeStyleSettings s = this.myContext.customSettings;
        for (ASTNode node = blockNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            boolean isQuery;
            PsiElement element = node.getPsi();
            IElementType elementType = node.getElementType();
            boolean isLP = elementType == SqlTokens.SQL_LEFT_PAREN;
            boolean isRP = elementType == SqlTokens.SQL_RIGHT_PAREN;
            boolean bl = isQuery = elementType == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION;
            if (isRP) {
                this.inside = false;
            }
            if (!SqlBlockSubquery.isWhitespace(node, element, elementType)) {
                if (elementType == SqlElementTypes.SQL_DUMMY_BLOCK || elementType == SqlCompositeElementTypes.SQL_EXPRESSION) {
                    this.buildBlocks(node, builtBlocks);
                } else if (element instanceof IsExternal) {
                    builtBlocks.add((Block)new SqlFormattingBlock.ReadOnlyBlock(node));
                } else {
                    SqlBlock block;
                    Indent indent;
                    boolean toAlign;
                    switch (s.SUBQUERY_R_PAR_ALIGN) {
                        case 1: {
                            toAlign = isLP || isRP || this.inside && !s.SUBQUERY_INDENT_INSIDE;
                            break;
                        }
                        case 3: {
                            toAlign = this.inside || isRP || isLP && s.SUBQUERY_L_PAR_NL_INSIDE && !s.SUBQUERY_INDENT_INSIDE;
                            break;
                        }
                        default: {
                            toAlign = !s.SUBQUERY_INDENT_INSIDE && (isLP || this.inside);
                        }
                    }
                    boolean toWrap = isLP || this.inside && s.SUBQUERY_L_PAR_NL_INSIDE || isRP && s.SUBQUERY_R_PAR_NL_INSIDE;
                    Wrap wrap = toWrap ? this.mainWrap : null;
                    Alignment alignment = toAlign ? this.mainAlignment : null;
                    Indent indent2 = indent = this.inside ? this.contentIndent : null;
                    if (elementType instanceof SqlKeywordTokenType) {
                        block = new SqlWord(node, this.myContext, wrap, alignment, indent, 0);
                    } else if (isQuery) {
                        block = new SqlBlockQuery(SqlQueryCategory.QUERY_SELECT, node, this.myContext, wrap, alignment, indent);
                    } else if (elementType == SqlCompositeElementTypes.SQL_VALUES_EXPRESSION) {
                        SqlQueryFormattingContext queryContext = new SqlQueryFormattingContext(node.getTextRange(), SqlQueryCategory.QUERY_VALUES, true, false, null);
                        block = new SqlBlockValues(node, this.myContext, queryContext, wrap, alignment, indent);
                    } else {
                        block = elementType == SqlTokens.SQL_LEFT_PAREN || elementType == SqlTokens.SQL_RIGHT_PAREN ? new SqlSymbol(node, this.myContext, wrap, alignment, indent) : this.createNestedBlock(node, wrap, alignment, indent);
                    }
                    builtBlocks.add((Block)block);
                }
            }
            if (!isLP) continue;
            this.inside = true;
        }
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        if (block1 == null) {
            SqlBlockSubquery.$$$reportNull$$$0(4);
        }
        if (block2 == null) {
            SqlBlockSubquery.$$$reportNull$$$0(5);
        }
        return SqlFormatting.commonSpacing(this.myContext, block1, block2);
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() != null;
    }

    @Nullable
    protected Indent getChildIndent() {
        return this.contentIndent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtBlocks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/formatter/SqlBlockSubquery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildBlocks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacingInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

