/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlQuerySectionFormatProcessor;
import com.intellij.sql.formatter.SqlSingleNodeSectionBlock;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.util.containers.Predicate;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBlockWhere
extends SqlSingleNodeSectionBlock {
    private final JK myTopJK;

    public SqlBlockWhere(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @NotNull SqlQueryFormattingContext queryContext, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            SqlBlockWhere.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlBlockWhere.$$$reportNull$$$0(1);
        }
        if (queryContext == null) {
            SqlBlockWhere.$$$reportNull$$$0(2);
        }
        super(node, context, queryContext, wrap, alignment, indent);
        SqlCodeStyleSettings customSettings = this.myContext.customSettings;
        PsiElement topBinaryExpression = SqlBlockWhere.getFirstChildLike(node.getPsi(), (Predicate<PsiElement>)((Predicate)SqlBlockWhere::isBinaryAndOrExpression));
        this.myTopJK = SqlBlockWhere.junctionKind(topBinaryExpression);
        this.myProcessor.setupLook(customSettings.QUERY_EL_LINE, customSettings.WHERE_EL_WRAP, customSettings.WHERE_EL_BOUND, false);
        this.myProcessor.setupBound(this.myTopJK.length);
        this.myProcessor.prepare(node);
    }

    @Override
    @NotNull
    protected SqlQuerySectionFormatProcessor createProcessor() {
        Processor processor = new Processor();
        if (processor == null) {
            SqlBlockWhere.$$$reportNull$$$0(3);
        }
        return processor;
    }

    private static boolean isBinaryAndOrExpression(PsiElement element) {
        return SqlBlockWhere.junctionKind(element) != JK.NONE;
    }

    private static JK junctionKind(PsiElement element) {
        PsiElement jkElement;
        if (SqlImplUtil.getElementType(element) == SqlCompositeElementTypes.SQL_BINARY_EXPRESSION && (jkElement = SqlBlockWhere.getFirstChildLike(element, (Predicate<PsiElement>)((Predicate)e -> {
            IElementType t = SqlImplUtil.getElementType(e);
            return t == SqlTokens.SQL_AND || t == SqlTokens.SQL_OR;
        }))) != null) {
            IElementType t = SqlImplUtil.getElementType(jkElement);
            if (t == SqlTokens.SQL_AND) {
                return JK.AND;
            }
            if (t == SqlTokens.SQL_OR) {
                return JK.OR;
            }
        }
        return JK.NONE;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
        if (node == null) {
            SqlBlockWhere.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SqlBlockWhere.$$$reportNull$$$0(5);
        }
        if (elementType == null) {
            SqlBlockWhere.$$$reportNull$$$0(6);
        }
        return this.myTopJK != JK.NONE && elementType == SqlCompositeElementTypes.SQL_BINARY_EXPRESSION && SqlBlockWhere.junctionKind(element) == this.myTopJK;
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        if (block1 == null) {
            SqlBlockWhere.$$$reportNull$$$0(7);
        }
        if (block2 == null) {
            SqlBlockWhere.$$$reportNull$$$0(8);
        }
        if (block2 instanceof SqlWord && ((SqlWord)block2).mySequentialPosition == 1) {
            return SqlFormatting.makeNL();
        }
        return super.getSpacingInner(block1, block2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlBlockWhere";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlBlockWhere";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "whetherToFlatten";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Processor
    extends SqlQuerySectionFormatProcessor {
        private Processor() {
        }

        @Override
        public boolean whetherToResetTheSection(@NotNull ASTNode node, @NotNull SqlKeywordTokenType type) {
            if (node == null) {
                Processor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Processor.$$$reportNull$$$0(1);
            }
            return type == SqlCommonKeywords.SQL_CONNECT || type == SqlCommonKeywords.SQL_START;
        }

        @Override
        public boolean checkIsBound(@NotNull IElementType type) {
            if (type == null) {
                Processor.$$$reportNull$$$0(2);
            }
            return SqlBlockWhere.this.myTopJK != JK.NONE && type == ((SqlBlockWhere)SqlBlockWhere.this).myTopJK.elementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/formatter/SqlBlockWhere$Processor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "whetherToResetTheSection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIsBound";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum JK {
        NONE(" ", null),
        AND("AND", (IElementType)SqlTokens.SQL_AND),
        OR("OR", (IElementType)SqlTokens.SQL_OR);

        public final String word;
        public final int length;
        @Nullable
        public final IElementType elementType;

        private JK(String word, IElementType type) {
            this.word = word;
            this.length = word.length();
            this.elementType = type;
        }

        @NotNull
        public static JK of(@NotNull String string) {
            if (string == null) {
                JK.$$$reportNull$$$0(0);
            }
            switch (string.toUpperCase(Locale.ROOT)) {
                case "AND": {
                    JK jK = AND;
                    if (jK == null) {
                        JK.$$$reportNull$$$0(1);
                    }
                    return jK;
                }
                case "OR": {
                    JK jK = OR;
                    if (jK == null) {
                        JK.$$$reportNull$$$0(2);
                    }
                    return jK;
                }
            }
            JK jK = NONE;
            if (jK == null) {
                JK.$$$reportNull$$$0(3);
            }
            return jK;
        }

        @NotNull
        public static JK of(@Nullable IElementType elementType) {
            if (elementType == SqlTokens.SQL_AND) {
                JK jK = AND;
                if (jK == null) {
                    JK.$$$reportNull$$$0(4);
                }
                return jK;
            }
            if (elementType == SqlTokens.SQL_OR) {
                JK jK = OR;
                if (jK == null) {
                    JK.$$$reportNull$$$0(5);
                }
                return jK;
            }
            JK jK = NONE;
            if (jK == null) {
                JK.$$$reportNull$$$0(6);
            }
            return jK;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/SqlBlockWhere$JK";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/SqlBlockWhere$JK";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

