/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlExpressionBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElementTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\rH\u0014J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/sql/formatter/SqlCaseBlock;", "Lcom/intellij/sql/formatter/SqlExpressionBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "forceCollapse", "", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Z)V", "caseAlign", "caseWrap", "restIndent", "thenAlign", "thenIndent", "whenAlign", "whenIndent", "whenWrap", "whenWrapping", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "makeBlock", "userAllowedToCollapse", "whetherToFlatten", "type", "Lcom/intellij/psi/tree/IElementType;", "intellij.database.sql.impl"})
public final class SqlCaseBlock
extends SqlExpressionBlock {
    private final boolean whenWrapping;
    private final Wrap caseWrap;
    private final Wrap whenWrap;
    private final Alignment caseAlign;
    private final Alignment whenAlign;
    private final Alignment thenAlign;
    private final Indent whenIndent;
    private final Indent thenIndent;
    private final Indent restIndent;

    @Override
    protected boolean userAllowedToCollapse() {
        SqlCodeStyleSettings s = this.myContext.customSettings;
        return s.EXPR_CASE_COLLAPSE || !s.EXPR_CASE_WHEN_WRAP && !s.EXPR_CASE_THEN_WRAP;
    }

    @Override
    public boolean whetherToFlatten(@NotNull ASTNode node, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_CASE_WHEN_THEN_CLAUSE) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_WHEN_CLAUSE) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_THEN_CLAUSE) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_ELSE_CLAUSE);
    }

    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        SqlCodeStyleSettings s = this.getContext().customSettings;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_CASE)) {
            sqlBlock = new SqlWord(node, this.getContext(), this.caseWrap, this.caseAlign, null, !this.whenWrapping ? 1 : 0);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_WHEN)) {
            sqlBlock = new SqlWord(node, this.getContext(), this.whenWrap, this.whenAlign, this.whenIndent, !this.whenWrapping ? 2 : 0);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_THEN)) {
            Wrap thenWrap = this.getCollapse() ? null : Wrap.createChildWrap((Wrap)this.whenWrap, (WrapType)(s.EXPR_CASE_THEN_WRAP ? WrapType.ALWAYS : WrapType.NORMAL), (boolean)true);
            sqlBlock = new SqlWord(node, this.getContext(), thenWrap, this.thenAlign, this.thenIndent, 0);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_ELSE)) {
            Alignment alignment;
            boolean bl = s.EXPR_CASE_ELSE_ALIGN_THEN;
            if (bl) {
                alignment = this.thenAlign;
            } else if (!bl) {
                alignment = this.whenAlign;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Alignment theAlign = alignment;
            sqlBlock = new SqlWord(node, this.getContext(), this.whenWrap, theAlign, this.whenIndent, 0);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_END)) {
            Alignment alignment;
            Wrap wrap;
            int x = s.EXPR_CASE_END;
            switch (x) {
                case 1: {
                    wrap = this.caseWrap;
                    break;
                }
                case 2: {
                    wrap = this.whenWrap;
                    break;
                }
                case 9: {
                    wrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                    break;
                }
                default: {
                    wrap = null;
                }
            }
            Wrap theEndWrap = wrap;
            switch (x) {
                case 1: {
                    alignment = this.caseAlign;
                    break;
                }
                case 2: {
                    alignment = this.whenAlign;
                    break;
                }
                default: {
                    alignment = null;
                }
            }
            Alignment theEndAlign = alignment;
            sqlBlock = new SqlWord(node, this.getContext(), theEndWrap, theEndAlign, null, 0);
        } else {
            SqlFormattingContext sqlFormattingContext = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"context");
            sqlBlock = SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, null, null, this.restIndent, false, 32, null);
        }
        return sqlBlock;
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        IElementType iElementType;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        if (this.getCollapse()) {
            return SqlFormatting.makeSpace$default(false, false, 3, null);
        }
        SqlCodeStyleSettings s = this.myContext.customSettings;
        Spacing spacing2 = null;
        if (block1 instanceof SqlWord) {
            IElementType iElementType2 = ((SqlWord)block1).getElementType();
            spacing2 = Intrinsics.areEqual((Object)iElementType2, (Object)SqlElementTypes.SQL_THEN) || Intrinsics.areEqual((Object)iElementType2, (Object)SqlElementTypes.SQL_ELSE) ? SqlFormatting.makeSpacingPreserveNL(s.EXPR_CASE_KEEP_NL_AFTER_THEN) : SqlFormatting.makeSpace$default(false, false, 3, null);
        } else if (block2 instanceof SqlWord && Intrinsics.areEqual((Object)(iElementType = ((SqlWord)block2).getElementType()), (Object)SqlElementTypes.SQL_END)) {
            switch (s.EXPR_CASE_END) {
                case 1: 
                case 2: {
                    TextRange textRange = this.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"this.textRange");
                    int n = textRange.getStartOffset();
                    TextRange textRange2 = block1.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"block1.textRange");
                    Spacing spacing3 = Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)new TextRange(n, textRange2.getEndOffset()), (boolean)false, (int)0);
                    break;
                }
                case 9: {
                    Spacing spacing3 = SqlFormatting.makeSpace$default(false, false, 3, null);
                    break;
                }
                default: {
                    Spacing spacing3 = spacing2 = SqlFormatting.makeSafeSpace(true);
                }
            }
        }
        if ((spacing = spacing2) == null) {
            spacing = super.getSpacingInner(block1, block2);
        }
        return spacing;
    }

    public SqlCaseBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(node, context, wrap, alignment, indent, forceCollapse, null);
        this.whenWrapping = context.customSettings.EXPR_CASE_WHEN_WRAP;
        if (this.getCollapse()) {
            this.caseWrap = null;
            this.whenWrap = null;
            this.caseAlign = null;
            this.whenAlign = null;
            this.thenAlign = null;
            this.whenIndent = null;
            this.thenIndent = null;
            this.restIndent = null;
        } else {
            WrapType mainWrapType;
            SqlCodeStyleSettings s = context.customSettings;
            boolean whenIndenting = s.EXPR_CASE_WHEN_INDENT;
            boolean whenUnderCase = this.whenWrapping && !whenIndenting;
            WrapType wrapType = mainWrapType = s.EXPR_CASE_COLLAPSE && !this.whenWrapping ? WrapType.CHOP_DOWN_IF_LONG : WrapType.ALWAYS;
            if (whenUnderCase) {
                this.whenWrap = this.caseWrap = Wrap.createWrap((WrapType)mainWrapType, (boolean)false);
            } else {
                this.caseWrap = Wrap.createWrap((WrapType)mainWrapType, (boolean)false);
                this.whenWrap = Wrap.createChildWrap((Wrap)this.caseWrap, (WrapType)mainWrapType, (boolean)s.EXPR_CASE_WHEN_WRAP);
            }
            this.caseAlign = this.createLeftAlignment();
            this.whenAlign = whenUnderCase ? this.caseAlign : this.createLeftAlignment();
            Alignment alignment2 = this.thenAlign = s.EXPR_CASE_THEN_ALIGN ? this.createLeftAlignmentBS() : null;
            this.whenIndent = whenUnderCase ? Indent.getNoneIndent() : (!this.whenWrapping ? Indent.getSpaceIndent((int)5, (boolean)true) : (whenIndenting ? Indent.getNormalIndent((boolean)true) : Indent.getNoneIndent()));
            this.thenIndent = whenUnderCase ? Indent.getContinuationIndent((boolean)true) : Indent.getSpaceIndent((int)10, (boolean)true);
            this.restIndent = Indent.getContinuationIndent((boolean)false);
        }
    }
}

