/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlCortegeBlock;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.AbstractSqlBlock;
import com.intellij.sql.formatter.SlqStringLiteralConcatenationBlock;
import com.intellij.sql.formatter.SqlAnotherExpressionBlock;
import com.intellij.sql.formatter.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlCaseBlock;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlFunctionCallBlock;
import com.intellij.sql.formatter.SqlParenExpressionBlock;
import com.intellij.sql.formatter.SqlUnaryExpressionBlock;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlElementTypes;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 !2\u00020\u0001:\u0001!B=\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\b\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\rH\u0014J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u000f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u0082\u0001\u0007\"#$%&'(\u00a8\u0006)"}, d2={"Lcom/intellij/sql/formatter/SqlExpressionBlock;", "Lcom/intellij/sql/formatter/AbstractSqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "forceCollapse", "", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Z)V", "collapse", "getCollapse", "()Z", "setCollapse", "(Z)V", "buildBlocks", "", "blockNode", "builtBlocks", "Ljava/util/ArrayList;", "Lcom/intellij/formatting/Block;", "isLeaf", "makeBlock", "Lcom/intellij/sql/formatter/SqlBlock;", "userAllowedToCollapse", "whetherToFlatten", "type", "Lcom/intellij/psi/tree/IElementType;", "Companion", "Lcom/intellij/sql/formatter/SqlBinaryExpressionBlock;", "Lcom/intellij/sql/formatter/SqlParenExpressionBlock;", "Lcom/intellij/sql/formatter/SqlCaseBlock;", "Lcom/intellij/sql/formatter/SqlFunctionCallBlock;", "Lcom/intellij/sql/formatter/SlqStringLiteralConcatenationBlock;", "Lcom/intellij/sql/formatter/SqlUnaryExpressionBlock;", "Lcom/intellij/sql/formatter/SqlAnotherExpressionBlock;", "intellij.database.sql.impl"})
public abstract class SqlExpressionBlock
extends AbstractSqlBlock {
    private boolean collapse;
    public static final Companion Companion = new Companion(null);

    protected final boolean getCollapse() {
        return this.collapse;
    }

    protected final void setCollapse(boolean bl) {
        this.collapse = bl;
    }

    protected boolean userAllowedToCollapse() {
        return true;
    }

    @Override
    protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)blockNode, (String)"blockNode");
        Intrinsics.checkParameterIsNotNull(builtBlocks, (String)"builtBlocks");
        if (this.isLeaf()) {
            return;
        }
        for (ASTNode node = blockNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType elementType;
            PsiElement element = node.getPsi();
            if (AbstractSqlBlock.isWhitespace(node, element, elementType = node.getElementType())) continue;
            if (elementType == SqlElementTypes.SQL_DUMMY_BLOCK || elementType == SqlElementTypes.SQL_GENERIC_ELEMENT) {
                this.buildBlocks(node, builtBlocks);
                continue;
            }
            IElementType iElementType = elementType;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"elementType");
            if (this.whetherToFlatten(node, iElementType)) {
                this.buildBlocks(node, builtBlocks);
                continue;
            }
            if (element instanceof IsExternal) {
                builtBlocks.add((Block)new SqlFormattingBlock.ReadOnlyBlock(node));
                continue;
            }
            SqlBlock block = this.makeBlock(node);
            builtBlocks.add((Block)block);
        }
    }

    public boolean whetherToFlatten(@NotNull ASTNode node, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return false;
    }

    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        SqlFormattingContext sqlFormattingContext = this.myContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"myContext");
        return SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, null, null, null, false, 32, null);
    }

    public boolean isLeaf() {
        return false;
    }

    private SqlExpressionBlock(ASTNode node, SqlFormattingContext context, Wrap wrap, Alignment alignment, Indent indent, boolean forceCollapse) {
        super(node, context, wrap, alignment, indent);
        boolean bl;
        if (forceCollapse) {
            bl = this.userAllowedToCollapse();
        } else {
            boolean hasUserBreaks = this.myContext.commonSettings.KEEP_LINE_BREAKS && node.textContains('\n');
            bl = !hasUserBreaks && this.userAllowedToCollapse() && SqlFormatting.determineCanItFitIn(node, context.getRightMargin() * 3 / 5);
        }
        this.collapse = bl;
    }

    public /* synthetic */ SqlExpressionBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse, DefaultConstructorMarker $constructor_marker) {
        this(node, context, wrap, alignment, indent, forceCollapse);
    }

    @JvmStatic
    @NotNull
    public static final SqlBlock create(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse) {
        return Companion.create(node, context, wrap, alignment, indent, forceCollapse);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/SqlExpressionBlock$Companion;", "", "()V", "create", "Lcom/intellij/sql/formatter/SqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "forceCollapse", "", "intellij.database.sql.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SqlBlock create(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse) {
            SqlBlock sqlBlock;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            IElementType iElementType = node.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_UNARY_EXPRESSION)) {
                sqlBlock = new SqlUnaryExpressionBlock(node, context, wrap, alignment, indent, forceCollapse);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_BINARY_EXPRESSION)) {
                sqlBlock = SqlFormatting.isKeyWord(node.getLastChildNode(), "null") ? (SqlExpressionBlock)new SqlUnaryExpressionBlock(node, context, wrap, alignment, indent, forceCollapse) : (SqlExpressionBlock)new SqlBinaryExpressionBlock(node, context, wrap, alignment, indent, forceCollapse);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_PARENTHESIZED_EXPRESSION)) {
                ASTNode aSTNode = SqlFormatting.child(node, 3);
                sqlBlock = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)SqlElementTypes.SQL_COMMA) ? (AbstractSqlBlock)new SqlCortegeBlock(node, context, wrap, alignment, indent) : (AbstractSqlBlock)new SqlParenExpressionBlock(node, context, wrap, alignment, indent, forceCollapse);
            } else {
                sqlBlock = Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_CASE_EXPRESSION) ? (SqlBlock)new SqlCaseBlock(node, context, wrap, alignment, indent, forceCollapse) : (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_STRING_LITERAL_CONCATENATION) ? (SqlBlock)new SlqStringLiteralConcatenationBlock(node, context, wrap, alignment, indent, forceCollapse) : (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_FUNCTION_CALL) ? (SqlBlock)new SqlFunctionCallBlock(node, context, wrap, alignment, indent, forceCollapse) : (SqlBlock)new SqlAnotherExpressionBlock(node, context, wrap, alignment, indent, forceCollapse)));
            }
            return sqlBlock;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

