/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.formatter.AbstractSqlBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlParameterListImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFormattingBlock
extends AbstractSqlBlock {
    public static final TokenSet CLAUSES_WITH_PERSONAL_SETTINGS = TokenSet.create((IElementType[])new IElementType[]{SqlElementTypes.SQL_FROM_CLAUSE, SqlElementTypes.SQL_WHERE_CLAUSE, SqlElementTypes.SQL_HAVING_CLAUSE, SqlElementTypes.SQL_SELECT_CLAUSE, SqlElementTypes.SQL_ORDER_BY_CLAUSE, SqlElementTypes.SQL_GROUP_BY_CLAUSE, SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE, SqlElementTypes.SQL_COLUMN_GENERATED_CLAUSE, SqlElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE, SqlElementTypes.SQL_ELSE_CLAUSE, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_AS_QUERY_CLAUSE});
    private static final TokenSet PROCEDURE_LIKE_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{SqlElementTypes.SQL_CREATE_FUNCTION_STATEMENT, SqlElementTypes.SQL_FUNCTION_DEFINITION, SqlElementTypes.SQL_CREATE_PROCEDURE_STATEMENT, SqlElementTypes.SQL_PROCEDURE_DEFINITION});
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final AlignmentStrategy myAlignmentStrategy;

    public SqlFormattingBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable AlignmentStrategy alignmentStrategy, @Nullable Indent indent) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlFormattingBlock.$$$reportNull$$$0(1);
        }
        super(node, context, wrap, alignment, indent);
        this.myAlignmentStrategy = alignmentStrategy;
        this.myIndent = indent;
    }

    SqlFormattingBlock(@NotNull ASTNode node, @NotNull TextRange textRange, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable AlignmentStrategy alignmentStrategy, @Nullable Indent indent) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(2);
        }
        if (textRange == null) {
            SqlFormattingBlock.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SqlFormattingBlock.$$$reportNull$$$0(4);
        }
        super(node, textRange, context, wrap, alignment, indent);
        this.myAlignmentStrategy = alignmentStrategy;
        this.myIndent = indent;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            SqlFormattingBlock.$$$reportNull$$$0(5);
        }
        return aSTNode;
    }

    @Override
    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
        if (blockNode == null) {
            SqlFormattingBlock.$$$reportNull$$$0(6);
        }
        if (builtBlocks == null) {
            SqlFormattingBlock.$$$reportNull$$$0(7);
        }
        ASTNode firstChildNode = blockNode.getFirstChildNode();
        Wrap chopDownIfLongWrap = null;
        Alignment baseAlignment = Alignment.createAlignment();
        AlignmentStrategy strategy = this.createOrGetAlignmentStrategy();
        for (ASTNode node = firstChildNode; node != null; node = node.getTreeNext()) {
            WrapType wrapType;
            boolean isWhitespace;
            PsiElement element = node.getPsi();
            IElementType elementType = node.getElementType();
            boolean bl = isWhitespace = element instanceof PsiWhiteSpace || node.getTextLength() <= 0 || elementType == SqlElementTypes.ORAP_DELIMITER_TOKEN;
            if (isWhitespace) continue;
            if (elementType == SqlElementTypes.SQL_DUMMY_BLOCK) {
                this.buildBlocks(node, builtBlocks);
                continue;
            }
            if (element instanceof IsExternal) {
                builtBlocks.add((Block)new ReadOnlyBlock(node));
                continue;
            }
            boolean indentsOnly = false;
            Alignment alignment = indentsOnly ? null : this.calculateAlignment(node, baseAlignment);
            WrapType wrapType2 = wrapType = indentsOnly ? null : SqlFormattingBlock.calculateWrapType(this.getNode(), node, this.myContext.customSettings);
            Wrap wrap = wrapType == WrapType.CHOP_DOWN_IF_LONG ? (chopDownIfLongWrap = chopDownIfLongWrap == null ? this.createWrap(wrapType, true) : chopDownIfLongWrap) : (wrapType == null ? null : this.createWrap(wrapType, true));
            Indent indent = this.getChildIndent(node);
            SqlBlock formattingBlock = this.createNestedBlock(node, elementType, wrap, strategy, alignment, indent);
            builtBlocks.add((Block)formattingBlock);
        }
    }

    @Nullable
    private AlignmentStrategy createOrGetAlignmentStrategy() {
        PsiElement psi = this.getNode().getPsi();
        if (psi instanceof SqlSelectClause) {
            return null;
        }
        if ((psi instanceof SqlCreateTableStatement || psi instanceof SqlCreateTypeStatement || psi instanceof SqlTypeElement) && this.myContext.customSettings.ALIGN_TYPE_IN_CREATE_STATEMENT) {
            List list = ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_TYPE_ELEMENT, SqlElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION, SqlElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION});
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)list, (IElementType)(psi instanceof SqlCreateTypeStatement ? SqlElementTypes.SQL_ATTRIBUTE_DEFINITION : SqlElementTypes.SQL_COLUMN_DEFINITION), (boolean)true);
        }
        if (psi instanceof SqlBlockStatementImpl && this.myContext.customSettings.ALIGN_TYPE_IN_BLOCK_STATEMENT) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_TYPE_ELEMENT}), (IElementType)SqlElementTypes.SQL_VARIABLE_DEFINITION, (boolean)true);
        }
        if (psi instanceof SqlProcedureDefinitionImpl && this.myContext.customSettings.ALIGN_TYPE_IN_ARGUMENT_DEFINITION) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_TYPE_ELEMENT}), (IElementType)SqlElementTypes.SQL_VARIABLE_DEFINITION, (boolean)true);
        }
        if (psi instanceof SqlParameterListImpl && this.myContext.customSettings.ALIGN_TYPE_IN_ARGUMENT_DEFINITION) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlElementTypes.SQL_IDENTIFIER, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_TYPE_ELEMENT}), (IElementType)SqlElementTypes.SQL_PARAMETER_DEFINITION, (boolean)true);
        }
        if (psi instanceof SqlSetClause && this.myContext.customSettings.ALIGN_EQ_INSIDE_SET_CLAUSE) {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ContainerUtil.list((Object[])new IElementType[]{SqlTokens.SQL_OP_EQ}), (IElementType)SqlElementTypes.SQL_SET_ASSIGNMENT, (boolean)true);
        }
        return null;
    }

    @Nullable
    private Alignment calculateAlignmentFromStrategy(@NotNull ASTNode child, @NotNull IElementType parentType, @NotNull IElementType childType) {
        if (child == null) {
            SqlFormattingBlock.$$$reportNull$$$0(8);
        }
        if (parentType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(9);
        }
        if (childType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(10);
        }
        if (this.myAlignmentStrategy != null) {
            Object childTypeReplacement = childType;
            IElementType parentTypeReplacement = parentType;
            if (childType == SqlElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION) {
                childTypeReplacement = SqlElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION;
            } else if (childType == SqlElementTypes.SQL_COLUMN_GENERATED_CLAUSE || childType == SqlElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) {
                childTypeReplacement = SqlElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION;
            } else if (parentType == SqlElementTypes.SQL_AS_EXPRESSION && child.equals(this.getNode().getFirstChildNode())) {
                childTypeReplacement = SqlElementTypes.SQL_EXPRESSION;
            } else if (parentType == SqlElementTypes.SQL_SELECT_CLAUSE && child.getPsi() instanceof SqlExpression) {
                childTypeReplacement = SqlElementTypes.SQL_EXPRESSION;
                parentTypeReplacement = SqlElementTypes.SQL_AS_EXPRESSION;
            } else if (childType == SqlCommonKeywords.SQL_OUT) {
                childTypeReplacement = SqlElementTypes.SQL_IN;
            } else if (childType == SqlElementTypes.SQL_OP_ASSIGN) {
                childTypeReplacement = SqlElementTypes.SQL_OP_EQ;
            }
            if (childTypeReplacement == SqlElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION && (FormatterUtil.isFollowedBy((ASTNode)child, (IElementType)SqlElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION) || FormatterUtil.isFollowedBy((ASTNode)child, (IElementType)SqlElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION))) {
                return null;
            }
            return this.myAlignmentStrategy.getAlignment(parentTypeReplacement, childTypeReplacement);
        }
        return null;
    }

    @Nullable
    public static WrapType calculateWrapType(@NotNull ASTNode parent, @NotNull ASTNode child, @NotNull SqlCodeStyleSettings settings) {
        if (parent == null) {
            SqlFormattingBlock.$$$reportNull$$$0(11);
        }
        if (child == null) {
            SqlFormattingBlock.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            SqlFormattingBlock.$$$reportNull$$$0(13);
        }
        IElementType childType = child.getElementType();
        ASTNode node = SqlFormattingBlock.getEffectiveNode(parent);
        IElementType parentType = node.getElementType();
        ASTNode grandpa = node.getTreeParent();
        IElementType grandpaType = grandpa == null ? null : grandpa.getElementType();
        WrapType none = WrapType.NONE;
        if (parentType == SqlElementTypes.SQL_PARAMETER_LIST && childType == SqlElementTypes.SQL_PARAMETER_DEFINITION) {
            return WrappingUtil.getWrapType((int)settings.WRAP_INSIDE_ARGUMENT_DEFINITION);
        }
        if (parentType == SqlElementTypes.SQL_EXPRESSION_LIST && grandpaType == SqlElementTypes.SQL_FUNCTION_CALL && SqlFormattingBlock.notComma(childType)) {
            return WrappingUtil.getWrapType((int)settings.WRAP_INSIDE_CALL_EXPRESSION);
        }
        if (parentType == SqlElementTypes.SQL_CREATE_TABLE_STATEMENT) {
            WrapType wrapType = WrappingUtil.getWrapType((int)settings.WRAP_INSIDE_CREATE_TABLE);
            if (SqlFormattingBlock.notComma(childType) && child.getPsi() instanceof SqlDefinition || childType == SqlElementTypes.SQL_RIGHT_PAREN && wrapType == WrapType.ALWAYS) {
                return wrapType;
            }
        }
        if (parentType == SqlElementTypes.SQL_BINARY_EXPRESSION) {
            return WrapType.NORMAL;
        }
        if (parentType == SqlElementTypes.SQL_VALUES_EXPRESSION && SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(childType)) {
            return WrappingUtil.getWrapType((int)settings.WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES);
        }
        if (childType == SqlElementTypes.SQL_VALUES_EXPRESSION) {
            return WrappingUtil.getWrapType((int)settings.WRAP_VALUES_EXPRESSION);
        }
        if (SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(parentType) && grandpaType == SqlElementTypes.SQL_VALUES_EXPRESSION && childType != SqlElementTypes.SQL_LEFT_PAREN && childType != SqlElementTypes.SQL_RIGHT_PAREN && childType != SqlElementTypes.SQL_COMMA) {
            return WrappingUtil.getWrapType((int)settings.WRAP_INSIDE_VALUES_EXPRESSION);
        }
        if (childType instanceof SqlReferenceElementType || childType == SqlElementTypes.SQL_PERIOD || child.getElementType() == SqlElementTypes.SQL_IDENTIFIER || child.getTreeParent().getElementType() == SqlElementTypes.SQL_IDENTIFIER) {
            return none;
        }
        return null;
    }

    private static boolean notKeyword(@NotNull IElementType childType) {
        if (childType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(14);
        }
        return !(childType instanceof SqlKeywordTokenType) && SqlFormattingBlock.notComma(childType);
    }

    private static boolean notComma(@NotNull IElementType childType) {
        if (childType == null) {
            SqlFormattingBlock.$$$reportNull$$$0(15);
        }
        return childType != SqlElementTypes.SQL_COMMA;
    }

    @Nullable
    private Alignment calculateAlignment(@NotNull ASTNode child, Alignment baseAlignment) {
        IElementType childType;
        IElementType parentType;
        Alignment alignment;
        if (child == null) {
            SqlFormattingBlock.$$$reportNull$$$0(16);
        }
        if ((alignment = this.calculateAlignmentFromStrategy(child, parentType = this.getNode().getElementType(), childType = child.getElementType())) != null) {
            return alignment;
        }
        if ((SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(parentType) || parentType == SqlElementTypes.SQL_REFERENCE_LIST) && childType != SqlElementTypes.SQL_LEFT_PAREN && childType != SqlElementTypes.SQL_RIGHT_PAREN && SqlFormattingBlock.notComma(childType)) {
            return SyntaxTraverser.psiApi().children((Object)this.getNode().getPsi()).filter(SqlElement.class).skip(1).isNotEmpty() ? baseAlignment : null;
        }
        if (parentType == SqlElementTypes.SQL_UNION_EXPRESSION || parentType == SqlElementTypes.SQL_CASE_EXPRESSION) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_AS_EXPRESSION && childType != SqlElementTypes.SQL_AS) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_JOIN_EXPRESSION) {
            return null;
        }
        if (parentType == SqlElementTypes.SQL_EXPRESSION_LIST && SqlFormattingBlock.notComma(childType)) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_QUERY_EXPRESSION && this.myContext.customSettings.ALIGN_INSIDE_QUERY_EXPRESSION && SqlFormattingBlock.notComma(childType)) {
            return baseAlignment;
        }
        if (parentType == SqlElementTypes.SQL_BINARY_EXPRESSION && this.myContext.customSettings.EXPR_BINARY_OP_ALIGN) {
            return baseAlignment;
        }
        return null;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public boolean isIncomplete() {
        if (super.isIncomplete()) {
            return true;
        }
        if (this.getNode().getTreeParent() == null) {
            for (ASTNode element = this.getNode().getLastChildNode(); element != null; element = element.getTreePrev()) {
                if (element.getElementType() != SqlElementTypes.SQL_SEMICOLON) continue;
                return true;
            }
            return false;
        }
        if (this.getNode().getFirstChildNode() != null && this.getNode().getFirstChildNode().getElementType() == SqlElementTypes.SQL_BEGIN) {
            return this.getNode().getLastChildNode().getElementType() != SqlElementTypes.SQL_END;
        }
        return false;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent indent;
        boolean beforeComma;
        List subBlocks = this.getSubBlocks();
        Block prevBlock = newChildIndex > 0 && newChildIndex <= subBlocks.size() ? (Block)subBlocks.get(newChildIndex - 1) : null;
        Block nextBlock = newChildIndex < subBlocks.size() ? (Block)subBlocks.get(newChildIndex) : null;
        ASTNode prevNode = prevBlock instanceof SqlFormattingBlock ? ((SqlFormattingBlock)prevBlock).getNode() : null;
        ASTNode nextNode = nextBlock instanceof SqlFormattingBlock ? ((SqlFormattingBlock)nextBlock).getNode() : null;
        ASTNode astNode = this.getNode();
        IElementType nodeType = astNode.getElementType();
        PsiElement nodePsi = astNode.getPsi();
        PsiElement basePsi = prevNode != null ? prevNode.getPsi() : nodePsi;
        PsiElement deepestLast = basePsi == null ? null : PsiTreeUtil.getDeepestLast((PsiElement)basePsi);
        SqlBinaryExpression binaryExpression = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)basePsi, SqlBinaryExpression.class, (boolean)false);
        ASTNode opSignNode = binaryExpression != null ? binaryExpression.getOpSignElement().getNode() : null;
        boolean afterComma = prevNode != null && prevNode.getElementType() == SqlElementTypes.SQL_COMMA;
        boolean bl = beforeComma = nextNode != null && nextNode.getElementType() == SqlElementTypes.SQL_COMMA;
        if (prevNode != null && TreeUtil.getLastChild((ASTNode)prevNode) instanceof PsiErrorElement) {
            indent = Indent.getContinuationWithoutFirstIndent();
        } else if (nodeType == SqlElementTypes.SQL_SELECT_CLAUSE && (afterComma || beforeComma)) {
            indent = Indent.getNormalIndent();
        } else if (nodeType == SqlElementTypes.SQL_VALUES_EXPRESSION) {
            indent = Indent.getNormalIndent();
        } else if (nodeType == SqlElementTypes.SQL_SET_CLAUSE || basePsi instanceof SqlSetClause) {
            indent = Indent.getNormalIndent();
        } else if (opSignNode != null && (opSignNode == prevNode || opSignNode == nextNode) || !(basePsi instanceof SqlDefinition) && (nodePsi == basePsi || !(nodePsi instanceof SqlDefinition)) && afterComma || beforeComma) {
            indent = Indent.getNormalIndent();
        } else if ((nodePsi instanceof SqlFile || nodePsi instanceof SqlQueryExpression || nodeType == SqlElementTypes.SQL_DUMMY_BLOCK || nodeType == SqlElementTypes.SQL_BATCH_BLOCK) && (basePsi instanceof SqlSelectStatement || basePsi instanceof SqlSelectClause) && PsiTreeUtil.getParentOfType((PsiElement)deepestLast, SqlSelectClause.class) != null) {
            IElementType deepestElementType = deepestLast == null ? null : deepestLast.getNode().getElementType();
            indent = deepestElementType == SqlElementTypes.SQL_SELECT ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else {
            indent = nodeType == SqlElementTypes.SQL_WITH_CLAUSE ? Indent.getNoneIndent() : (PsiTreeUtil.getParentOfType((PsiElement)basePsi, SqlQueryExpression.class, (boolean)false) != null ? Indent.getNormalIndent() : (PsiTreeUtil.getParentOfType((PsiElement)basePsi, SqlBlockStatementImpl.class, (boolean)false) != null && PsiTreeUtil.getParentOfType((PsiElement)nodePsi, SqlBlockStatementImpl.class, (boolean)false) != null ? Indent.getNormalIndent() : (basePsi instanceof SqlDefinition || nodePsi != basePsi && nodePsi instanceof SqlDefinition ? Indent.getNormalIndent() : (basePsi instanceof SqlExpression || nodePsi != basePsi && nodePsi instanceof SqlExpression ? Indent.getContinuationWithoutFirstIndent() : Indent.getNoneIndent()))));
        }
        ChildAttributes childAttributes = new ChildAttributes(indent, null);
        if (childAttributes == null) {
            SqlFormattingBlock.$$$reportNull$$$0(17);
        }
        return childAttributes;
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        if (block1 == null) {
            SqlFormattingBlock.$$$reportNull$$$0(18);
        }
        if (block2 == null) {
            SqlFormattingBlock.$$$reportNull$$$0(19);
        }
        ASTNode node1 = block1.getNode();
        ASTNode node2 = block2.getNode();
        IElementType type1 = node1.getElementType();
        IElementType type2 = node2.getElementType();
        PsiElement psi1 = node1.getPsi();
        PsiElement psi2 = node2.getPsi();
        if (type1 instanceof SqlKeywordTokenType && type2 == SqlElementTypes.SQL_LEFT_PAREN && !(psi1.getParent() instanceof SqlTypeElement) && node1.getTreeParent() != SqlElementTypes.SQL_SPECIAL_LITERAL) {
            return this.createSpaces(1);
        }
        if (psi1 instanceof SqlStatement && type2 == SqlElementTypes.SQL_SEMICOLON) {
            if (this.myContext.customSettings.NEW_LINE_AROUND_SEMICOLON) {
                return this.createLineBreak();
            }
            return SqlFormattingBlock.createHardSpace(0);
        }
        ASTNode parent = node2.getTreeParent();
        IElementType parentType = parent.getElementType();
        if (psi2 instanceof SqlAlterInstruction) {
            return this.createLineBreak();
        }
        Spacing spacing = this.myContext.spacingBuilder.getSpacing((Block)this, this.getElementType(), type1, type2);
        if (spacing != null) {
            return spacing;
        }
        if (type2 == SqlElementTypes.SQL_PARAMETER_LIST && PROCEDURE_LIKE_TOKEN_SET.contains(parentType)) {
            ASTNode first = node2.getFirstChildNode();
            IElementType firstType = first == null ? null : first.getElementType();
            return firstType == SqlElementTypes.SQL_LEFT_PAREN ? this.createSpaces(0) : this.createSpaces(1);
        }
        if (SqlTokens.COMMENT_TOKENS.contains(type1)) {
            return null;
        }
        if (type1 == SqlElementTypes.ORAP_SLASH_DELIMITER_TOKEN) {
            return null;
        }
        if (type1 == SqlElementTypes.SQL_GENERIC_ELEMENT && psi1.getParent() instanceof SqlNAryExpression || type2 == SqlElementTypes.SQL_GENERIC_ELEMENT && psi2.getParent() instanceof SqlNAryExpression) {
            return this.createSpaces(1);
        }
        if (!(!(type1 instanceof SqlKeywordTokenType) && !(type2 instanceof SqlKeywordTokenType) || psi1.getParent() instanceof SqlTypeElement && psi2 instanceof SqlTypeElement || psi1.getParent().getNode().getElementType() == SqlElementTypes.SQL_SPECIAL_LITERAL)) {
            return this.createSpaces(1);
        }
        if (psi2 instanceof SqlStatement) {
            return this.createSpaces(1);
        }
        if (SqlFormattingBlock.isOperator(node1) && SqlFormattingBlock.inExpressionOrStatementOrDefinition(psi1)) {
            if (psi1.getParent() instanceof SqlUnaryExpression) {
                return this.createSpaces(0);
            }
            return this.createSpacingAroundOperator();
        }
        if (SqlFormattingBlock.isOperator(node2) && SqlFormattingBlock.inExpressionOrStatementOrDefinition(psi2)) {
            return this.createSpacingAroundOperator();
        }
        if (this.myContext.customSettings.NEW_LINE_BEFORE_QUERY_INSIDE_DML && type2 == SqlElementTypes.SQL_QUERY_EXPRESSION && (psi2.getParent() instanceof SqlDmlInstruction || psi2.getParent() instanceof SqlDmlStatement)) {
            return this.createLineBreak();
        }
        if (SqlFormattingBlock.isIdentifierOrExpression(psi1) && SqlFormattingBlock.isIdentifierOrExpression(psi2)) {
            return this.createSpaces(1);
        }
        if (psi2 instanceof SqlClause && !CLAUSES_WITH_PERSONAL_SETTINGS.contains(type2)) {
            return this.myContext.customSettings.NEW_LINE_BEFORE_OTHER_CLAUSES ? this.createLineBreak() : this.createSpaces(1);
        }
        if (psi1 instanceof SqlClause) {
            return this.createSpaces(1);
        }
        return null;
    }

    @NotNull
    private static ASTNode getEffectiveNode(@NotNull ASTNode node) {
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(20);
        }
        while (node.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
            node = node.getTreeParent();
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            SqlFormattingBlock.$$$reportNull$$$0(21);
        }
        return aSTNode;
    }

    private Indent getChildIndent(@NotNull ASTNode node) {
        IElementType grandpaType;
        if (node == null) {
            SqlFormattingBlock.$$$reportNull$$$0(22);
        }
        IElementType elementType = node.getElementType();
        ASTNode parent = SqlFormattingBlock.getEffectiveNode(node.getTreeParent());
        IElementType parentType = parent != null ? parent.getElementType() : null;
        PsiElement elementPsi = node.getPsi();
        PsiElement parentPsi = parent != null ? parent.getPsi() : null;
        ASTNode grandpa = parent == null ? null : parent.getTreeParent();
        IElementType iElementType = grandpaType = grandpa == null ? null : grandpa.getElementType();
        if (parent == null || grandpa == null) {
            return Indent.getNoneIndent();
        }
        SqlCodeStyleSettings sql = this.myContext.customSettings;
        if (this.myContext.commonSettings.KEEP_FIRST_COLUMN_COMMENT && SqlTokens.COMMENT_TOKENS.contains(elementType)) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (SqlElementTypes.SQL_PARENTHESIZED_EXPRESSIONS.contains(parentType) || parentType == SqlElementTypes.SQL_REFERENCE_LIST || parentType == SqlElementTypes.SQL_PARAMETER_LIST || parentType == SqlElementTypes.SQL_CLAUSE && (elementType == SqlElementTypes.SQL_LEFT_PAREN || elementType == SqlElementTypes.SQL_RIGHT_PAREN)) {
            if (elementType == SqlElementTypes.SQL_LEFT_PAREN) {
                return Indent.getNoneIndent();
            }
            if (elementType == SqlElementTypes.SQL_RIGHT_PAREN) {
                boolean inJoin = grandpaType == SqlElementTypes.SQL_JOIN_EXPRESSION || grandpaType == SqlElementTypes.SQL_JOIN_CONDITION_CLAUSE;
                return inJoin ? Indent.getNormalIndent() : Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_QUERY_EXPRESSION) {
            return sql.INDENT_SELECT_INTO_CLAUSE && elementType == SqlElementTypes.SQL_SELECT_INTO_CLAUSE ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (sql.INDENT_SELECT_INTO_CLAUSE && parentType == SqlElementTypes.SQL_SELECT_STATEMENT && elementType == SqlElementTypes.SQL_SELECT_INTO_CLAUSE) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_NAMED_QUERY_DEFINITION && elementType == SqlElementTypes.SQL_QUERY_EXPRESSION) {
            return Indent.getContinuationIndent();
        }
        if (parentPsi instanceof SqlDefinition && (elementPsi instanceof SqlDefinition || elementPsi instanceof PsiComment)) {
            if (elementPsi instanceof PsiComment) {
                for (PsiElement e = elementPsi; e == null || e instanceof PsiWhiteSpace || e instanceof PsiComment; e = e.getPrevSibling()) {
                    if (e != null) continue;
                    return Indent.getNoneIndent();
                }
            }
            return Indent.getNormalIndent();
        }
        if (elementType == SqlElementTypes.SQL_CUSTOM_LQUOTE || elementType == SqlElementTypes.SQL_CUSTOM_RQUOTE || elementType instanceof SqlLazyElementType) {
            return Indent.getNoneIndent();
        }
        if (parentType == SqlElementTypes.SQL_BLOCK_STATEMENT) {
            if (elementType == SqlElementTypes.SQL_BEGIN || elementType == SqlElementTypes.SQL_END || elementType == SqlElementTypes.SQL_LABEL_DEFINITION || elementType instanceof SqlKeywordTokenType && elementPsi.equals(parentPsi.getFirstChild())) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if ((parentType == SqlElementTypes.SQL_LOOP_STATEMENT || parentType == SqlElementTypes.SQL_FOR_LOOP_STATEMENT) && (elementPsi instanceof SqlStatement || !this.myContext.commonSettings.KEEP_FIRST_COLUMN_COMMENT && SqlTokens.COMMENT_TOKENS.contains(elementType))) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_FUNCTION_CALL && elementType == SqlElementTypes.SQL_EXPRESSION_LIST) {
            return Indent.getContinuationIndent();
        }
        if (parentType == SqlElementTypes.SQL_AS_EXPRESSION && (elementType == SqlElementTypes.SQL_AS || elementType == SqlElementTypes.SQL_IDENTIFIER)) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_BINARY_EXPRESSION) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (parentType == SqlElementTypes.SQL_TYPE_ELEMENT && elementType == SqlElementTypes.SQL_COLUMN_DEFINITION) {
            return Indent.getNormalIndent();
        }
        if (parentPsi instanceof SqlDefinition && parentType != SqlElementTypes.SQL_AS_EXPRESSION && parentType != SqlElementTypes.SQL_COLUMN_DEFINITION && parentType != SqlElementTypes.SQL_ATTRIBUTE_DEFINITION && parentType != SqlElementTypes.SQL_VARIABLE_DEFINITION && parentType != SqlElementTypes.SQL_VARIABLE_DEFINITION && parentType != SqlElementTypes.SQL_PARAMETER_DEFINITION && parentType != SqlElementTypes.SQL_LABEL_DEFINITION && !(elementType instanceof SqlKeywordTokenType) && elementType != SqlElementTypes.SQL_RIGHT_PAREN && elementType != SqlElementTypes.SQL_LEFT_PAREN) {
            return Indent.getNormalIndent();
        }
        if (elementPsi instanceof SqlTypeElement) {
            return Indent.getNormalIndent();
        }
        if (parentType == SqlElementTypes.SQL_SET_ASSIGNMENT) {
            return Indent.getNoneIndent();
        }
        if (parentPsi instanceof SqlClause && !(elementType instanceof SqlKeywordTokenType)) {
            return Indent.getNormalIndent();
        }
        if (parentPsi instanceof SqlDmlInstruction) {
            if (elementPsi instanceof SqlValuesExpression) {
                return Indent.getNoneIndent();
            }
            if (elementPsi instanceof SqlExpression) {
                return Indent.getNormalIndent();
            }
        } else if (parentPsi instanceof SqlAlterInstruction) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 17: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 5: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlFormattingBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtBlocks";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlFormattingBlock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 17: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildBlocks";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateAlignmentFromStrategy";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculateWrapType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notKeyword";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notComma";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateAlignment";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingInner";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReadOnlyBlock
    extends AbstractBlock {
        public ReadOnlyBlock(@NotNull ASTNode node) {
            if (node == null) {
                ReadOnlyBlock.$$$reportNull$$$0(0);
            }
            super(node, null, null);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                ReadOnlyBlock.$$$reportNull$$$0(1);
            }
            return null;
        }

        public Indent getIndent() {
            return Indent.getNoneIndent();
        }

        public boolean isLeaf() {
            return true;
        }

        @NotNull
        protected List<Block> buildChildren() {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                ReadOnlyBlock.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/SqlFormattingBlock$ReadOnlyBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/SqlFormattingBlock$ReadOnlyBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

