/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TextWithRanges;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings) {
        PsiFile file;
        CodeStyleSettings settings1;
        if (element == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if ((settings1 = SqlFormattingModelBuilder.findAppropriateCodeStyleSettings((PsiElement)(file = element.getContainingFile()))) == null) {
            settings1 = settings;
        }
        Language language = file instanceof SqlFile ? ((SqlFile)file).getSqlLanguage() : file.getLanguage();
        boolean readOnly = language == SqlDialects.getGenericDialect() || ((SqlCodeStyleSettings)settings1.getCustomSettings(SqlCodeStyleSettings.class)).DISABLE_FORMATTING;
        Block block = SqlFormattingModelBuilder.createRootBlock(settings1, file, !readOnly);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file, (Block)block, (CodeStyleSettings)settings1);
        if (formattingModel == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        return formattingModel;
    }

    @NotNull
    public static FormattingModel createModel(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CodeStyleSettings settings, @NotNull CharSequence text2, @NotNull Document document) {
        SqlFile file;
        CodeStyleSettings settings1;
        if (project == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        if (dialect == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        if (document == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        if ((settings1 = SqlFormattingModelBuilder.findAppropriateCodeStyleSettings((PsiElement)(file = SqlPsiFacade.getInstance((Project)project).createROFile(dialect, text2)))) == null) {
            settings1 = settings;
        }
        Block block = SqlFormattingModelBuilder.createRootBlock(settings1, (PsiFile)file, true);
        file.putUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        DocumentBasedFormattingModel documentBasedFormattingModel = new DocumentBasedFormattingModel(block, document, project, settings1, file.getFileType(), (PsiFile)file);
        if (documentBasedFormattingModel == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        return documentBasedFormattingModel;
    }

    @NotNull
    public static FormattingModel createDocumentFormattingModel(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CodeStyleSettings settings, @NotNull TextWithRanges textWithRanges) {
        if (project == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(11);
        }
        if (textWithRanges == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(12);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)textWithRanges.toString(), true);
        int offset = 0;
        for (TextWithRanges.Chunk chunk : textWithRanges.getChunks()) {
            int length = chunk.getText().length();
            if (chunk.readonly()) {
                document.createGuardedBlock(offset, offset + length);
            }
            offset += length;
        }
        String text2 = textWithRanges.toString();
        FormattingModel formattingModel = SqlFormattingModelBuilder.createModel(project, dialect, settings, text2, (Document)document);
        if (formattingModel == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(13);
        }
        return formattingModel;
    }

    @NotNull
    private static Block createRootBlock(@NotNull CodeStyleSettings settings, @NotNull PsiFile file, boolean modifiable) {
        if (settings == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(14);
        }
        if (file == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(15);
        }
        SqlFormattingBlock.ReadOnlyBlock readOnlyBlock = modifiable ? SqlFormattingModelBuilder.createModifiableRootBlock(settings, file) : SqlFormattingModelBuilder.createReadOnlyRootBlock(file);
        if (readOnlyBlock == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(16);
        }
        return readOnlyBlock;
    }

    @NotNull
    private static Block createModifiableRootBlock(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(17);
        }
        if (file == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(18);
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)SqlLanguage.INSTANCE);
        SqlCodeStyleSettings customSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
        SpacingBuilder spacingBuilder = SqlFormattingModelBuilder.createSpacingBuilder(commonSettings, customSettings);
        SqlFormattingContext context = new SqlFormattingContext(settings, commonSettings, customSettings, spacingBuilder);
        SqlFormattingBlock sqlFormattingBlock = new SqlFormattingBlock((ASTNode)file.getNode(), context, null, null, null, null);
        if (sqlFormattingBlock == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(19);
        }
        return sqlFormattingBlock;
    }

    @NotNull
    private static SqlFormattingBlock.ReadOnlyBlock createReadOnlyRootBlock(PsiFile file) {
        SqlFormattingBlock.ReadOnlyBlock readOnlyBlock = new SqlFormattingBlock.ReadOnlyBlock((ASTNode)file.getNode());
        if (readOnlyBlock == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(20);
        }
        return readOnlyBlock;
    }

    @Nullable
    static CodeStyleSettings findAppropriateCodeStyleSettings(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(21);
        }
        String name = SqlFormattingModelBuilder.findCodeStyleSchemeName(psiElement);
        return SqlFormattingModelBuilder.findAppropriateCodeStyleSettings(name);
    }

    @Nullable
    private static CodeStyleSettings findAppropriateCodeStyleSettings(@Nullable String name) {
        if (name == null) {
            return null;
        }
        CodeStyleSchemes css = CodeStyleSchemes.getInstance();
        CodeStyleScheme scheme = css.findSchemeByName(name);
        if (scheme == null) {
            return null;
        }
        return scheme.getCodeStyleSettings();
    }

    @Nullable
    private static String findCodeStyleSchemeName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(22);
        }
        List<DbDataSource> dataSources2 = SqlImplUtil.getDataSources(psiElement);
        for (DbDataSource d : dataSources2) {
            String name;
            DasDataSource ds = DbImplUtil.unwrapDS((DasDataSource)d);
            if (!(ds instanceof LocalDataSource) || (name = ((LocalDataSource)ds).getEffectiveCodeStyleName()) == null) continue;
            return name;
        }
        return null;
    }

    private static SpacingBuilder createSpacingBuilder(CommonCodeStyleSettings commonSettings, SqlCodeStyleSettings customSettings) {
        CommonCodeStyleSettings s = commonSettings;
        SqlCodeStyleSettings c = customSettings;
        SpacingBuilder builder = new SpacingBuilder(s).after((IElementType)SqlTokens.SQL_LINE_COMMENT).lineBreakInCode().after((IElementType)SqlTokens.MYSQL_LINE_COMMENT).lineBreakInCode().after((IElementType)SqlTokens.SQL_LEFT_PAREN).spaceIf(s.SPACE_WITHIN_PARENTHESES).before((IElementType)SqlTokens.SQL_RIGHT_PAREN).spaceIf(s.SPACE_WITHIN_PARENTHESES).betweenInside((IElementType)SqlTokens.SQL_OP_MINUS, (IElementType)SqlTokens.SQL_INTEGER_TOKEN, (IElementType)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL).none().betweenInside((IElementType)SqlTokens.SQL_OP_PLUS, (IElementType)SqlTokens.SQL_INTEGER_TOKEN, (IElementType)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL).none().aroundInside((IElementType)SqlTokens.SQL_OP_EQ, (IElementType)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT).spaces(1).aroundInside((IElementType)SqlTokens.SQL_OP_ASSIGN, (IElementType)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT).spaces(1).afterInside((IElementType)SqlCompositeElementTypes.SQL_TRIGGER_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT).lineBreakInCode().afterInside((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT).lineBreakInCode().beforeInside((IElementType)SqlCompositeElementTypes.SQL_SET_STATEMENT, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT).lineBreakInCode().beforeInside((IElementType)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT).lineBreakInCode().before((IElementType)SqlCompositeElementTypes.SQL_THEN_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_THEN).before((IElementType)SqlCompositeElementTypes.SQL_ELSE_CLAUSE).lineBreakInCodeIf(c.NEW_LINE_BEFORE_ELSE).beforeInside((IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSIONS).lineBreakInCodeIf(c.NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS).betweenInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION).none().before((IElementType)SqlTokens.SQL_OP_EQ).spacing(c.EXPR_SPACE_AROUND_OPERATOR == 1 ? 1 : 0, c.EXPR_SPACE_AROUND_OPERATOR == 2 ? 0 : 1, 0, s.KEEP_LINE_BREAKS, 0).after((IElementType)SqlTokens.SQL_OP_EQ).spacing(c.EXPR_SPACE_AROUND_OPERATOR == 1 ? 1 : 0, c.EXPR_SPACE_AROUND_OPERATOR == 2 ? 0 : 1, 0, s.KEEP_LINE_BREAKS, 0).beforeInside((IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE).lineBreakInCode().beforeInside((IElementType)SqlTokens.SQL_UNION, (IElementType)SqlCompositeElementTypes.SQL_UNION_EXPRESSION).lineBreakInCode();
        if (c.NEW_LINE_BEFORE_COMMA) {
            builder.beforeInside((IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE).lineBreakInCode();
            builder.afterInside((IElementType)SqlTokens.SQL_COMMA, (IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE).spacing(s.SPACE_AFTER_COMMA ? 1 : 0, 1, 0, false, 0);
        }
        if (c.NEW_LINE_AROUND_SEMICOLON) {
            builder.after((IElementType)SqlTokens.SQL_SEMICOLON).blankLines(1);
        } else {
            builder.between((IElementType)SqlTokens.SQL_SEMICOLON, (IElementType)SqlTokens.SQL_LINE_COMMENT).spacing(1, 0, 0, true, 1);
            builder.between((IElementType)SqlTokens.SQL_SEMICOLON, (IElementType)SqlTokens.MYSQL_LINE_COMMENT).spacing(1, 0, 0, true, 1);
            builder.after((IElementType)SqlTokens.SQL_SEMICOLON).lineBreakInCode();
        }
        builder.after((IElementType)SqlTokens.SQL_AT_SIGN).none().around((IElementType)SqlCommonKeywords.SQL_AS).spaces(1).after((IElementType)SqlCommonKeywords.SQL_DELIMITER).spaces(1).before((IElementType)SqlTokens.SQL_SEMICOLON).none().after((IElementType)SqlTokens.SQL_COMMA).spaceIf(s.SPACE_AFTER_COMMA).before((IElementType)SqlTokens.SQL_COMMA).spaceIf(s.SPACE_BEFORE_COMMA).around((IElementType)SqlTokens.SQL_PERIOD).none().after((IElementType)SqlTokens.SQL_LEFT_BRACE).none().before((IElementType)SqlTokens.SQL_RIGHT_BRACE).none().after((IElementType)SqlTokens.SQL_LEFT_BRACKET).none().before((IElementType)SqlTokens.SQL_RIGHT_BRACKET).none().before((IElementType)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT).spacing(1, 1, 0, true, s.KEEP_BLANK_LINES_IN_CODE).afterInside((IElementType)SqlTokens.SQL_BEGIN, (IElementType)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT).parentDependentLFSpacing(1, 1, s.KEEP_LINE_BREAKS, s.KEEP_BLANK_LINES_IN_CODE).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL).spaceIf(s.SPACE_BEFORE_METHOD_CALL_PARENTHESES).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARAMETER_LIST).spaceIf(s.SPACE_BEFORE_METHOD_PARENTHESES).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT).spaceIf(true).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT).spaceIf(true).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL).spaceIf(s.SPACE_WITHIN_METHOD_CALL_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARAMETER_LIST).spaceIf(s.SPACE_WITHIN_METHOD_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION).spaceIf(s.SPACE_WITHIN_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION).spaceIf(s.SPACE_WITHIN_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION).spaceIf(s.SPACE_WITHIN_PARENTHESES).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT).spaceIf(false).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT).spaceIf(false).withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST).spaceIf(false).beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).none().beforeInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CLAUSE).none().withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).none().withinPairInside((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CLAUSE).none().betweenInside((TokenSet)null, null, (IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER).none().after((IElementType)SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE).none().between((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST).spaces(1).betweenInside((IElementType)SqlTokens.SQL_VALUES, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION).spaces(1).between((IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).spaces(1).around((IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).spaces(1).betweenInside((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT).spaceIf(false).aroundInside((IElementType)SqlTokens.SQL_PERCENT_SIGN, (IElementType)SqlCompositeElementTypes.SQL_UNARY_EXPRESSION).none().aroundInside((IElementType)SqlTokens.SQL_PERCENT_SIGN, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT).none().after((IElementType)SqlTokens.SQL_AT_SIGN).none().after((IElementType)SqlTokens.SQL_COLON).none().between((IElementType)SqlCompositeElementTypes.SQL_TRIGGER_TIME_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE).spaces(1).between((IElementType)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE, (IElementType)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE).spaces(1);
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlFormattingModelBuilder";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithRanges";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlFormattingModelBuilder";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentFormattingModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootBlock";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiableRootBlock";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadOnlyRootBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFormattingModel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRootBlock";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createModifiableRootBlock";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateCodeStyleSettings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findCodeStyleSchemeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

