/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlExpressionBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.psi.SqlElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/SqlFunctionCallBlock;", "Lcom/intellij/sql/formatter/SqlExpressionBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "forceCollapse", "", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Z)V", "commaIndent", "parameterAlignment", "parameterIndent", "parameterWrap", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "makeBlock", "whetherToFlatten", "type", "Lcom/intellij/psi/tree/IElementType;", "intellij.database.sql.impl"})
public final class SqlFunctionCallBlock
extends SqlExpressionBlock {
    private final Wrap parameterWrap;
    private final Alignment parameterAlignment;
    private final Indent parameterIndent;
    private final Indent commaIndent;

    @Override
    public boolean whetherToFlatten(@NotNull ASTNode node, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_EXPRESSION_LIST);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        t = node.getElementType();
        if (t == SqlElementTypes.SQL_COMMA) ** GOTO lbl-1000
        v0 = node.getTreeParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"node.treeParent");
        if (v0.getElementType() == SqlElementTypes.SQL_EXPRESSION_LIST) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isParameter = v1;
        theWrap = null;
        theAlignment = null;
        theIndent = null;
        if (isParameter) {
            theWrap = this.parameterWrap;
            theAlignment = this.parameterAlignment;
            theIndent = this.parameterIndent;
        } else if (Intrinsics.areEqual((Object)t, (Object)SqlElementTypes.SQL_COMMA)) {
            theIndent = this.commaIndent;
        }
        v2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"context");
        return SqlFormatting.createDefaultBlock(node, v2, theWrap, theAlignment, theIndent, this.getCollapse());
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        IElementType t1 = block1.getElementType();
        IElementType t2 = block2.getElementType();
        if (Intrinsics.areEqual((Object)t2, (Object)SqlElementTypes.SQL_LEFT_PAREN)) {
            spacing = SqlFormatting.makeNoSpace$default(false, 1, null);
        } else if (Intrinsics.areEqual((Object)t2, (Object)SqlElementTypes.SQL_COMMA)) {
            spacing = SqlFormatting.makeNoSpace$default(false, 1, null);
        } else if (Intrinsics.areEqual((Object)t1, (Object)SqlElementTypes.SQL_LEFT_PAREN) || Intrinsics.areEqual((Object)t2, (Object)SqlElementTypes.SQL_RIGHT_PAREN)) {
            spacing = SqlFormatting.makeNoSpace(this.myContext.commonSettings.KEEP_LINE_BREAKS);
        } else if (Intrinsics.areEqual((Object)t1, (Object)SqlElementTypes.SQL_COMMA)) {
            spacing = SqlFormatting.makeSpace$default(false, this.myContext.commonSettings.KEEP_LINE_BREAKS, 1, null);
        } else {
            SqlFormattingContext sqlFormattingContext = this.myContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"myContext");
            spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
        }
        return spacing;
    }

    public SqlFunctionCallBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(node, context, wrap, alignment, indent, forceCollapse, null);
        this.parameterWrap = this.getCollapse() ? null : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
        this.parameterAlignment = Alignment.createAlignment((boolean)false);
        this.parameterIndent = Indent.getNormalIndent((boolean)true);
        this.commaIndent = context.commonSettings.KEEP_LINE_BREAKS ? Indent.getNormalIndent((boolean)true) : null;
    }
}

