/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.formatter.SectionEntityKind;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlBlockCommentBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlLineCommentBlock;
import com.intellij.sql.formatter.SqlQuerySectionFormatProcessor$WhenMappings;
import com.intellij.sql.formatter.SqlWord;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u0002072\u0006\u00103\u001a\u000204H\u0016J\u0010\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00042\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010<\u001a\u00020\u00042\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010=\u001a\u00020\u00042\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010>\u001a\u00020\u00042\u0006\u00103\u001a\u000204H\u0016J\u0018\u0010?\u001a\u00020\u00042\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u000204H\u0016J\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0A2\u0006\u00109\u001a\u00020:H\u0002J6\u0010B\u001a\u00020C2\u0006\u00109\u001a\u00020:2\u0006\u0010D\u001a\u00020\u00122\b\u0010E\u001a\u0004\u0018\u00010!2\b\u0010F\u001a\u0004\u0018\u00010\u00172\b\u0010G\u001a\u0004\u0018\u00010\u001fH\u0016J \u0010H\u001a\u00020I2\u0006\u00109\u001a\u00020:2\u0006\u00106\u001a\u0002072\u0006\u00103\u001a\u000204H\u0016J\b\u0010J\u001a\u00020\u0004H\u0002J\b\u0010K\u001a\u0004\u0018\u00010\u0017J\b\u0010L\u001a\u0004\u0018\u00010\u0017J\b\u0010M\u001a\u0004\u0018\u00010\u0017J\b\u0010N\u001a\u0004\u0018\u00010\u0017J\b\u0010O\u001a\u0004\u0018\u00010\u0017J\b\u0010P\u001a\u0004\u0018\u00010\u0017J\b\u0010Q\u001a\u0004\u0018\u00010\u0017J\n\u0010R\u001a\u0004\u0018\u00010&H\u0002J\u001a\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020CH\u0016J\b\u0010W\u001a\u0004\u0018\u00010\u001fJ\u001a\u0010X\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020CH\u0016J\u001a\u0010Y\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020CH\u0016J\"\u0010Z\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020C2\u0006\u0010[\u001a\u00020\u0004H\u0002J\n\u0010\\\u001a\u0004\u0018\u00010!H\u0002J*\u0010]\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020C2\u0006\u0010^\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u0004H\u0002J\b\u0010_\u001a\u00020\u0017H\u0002J\b\u0010`\u001a\u00020\u0017H\u0002J\b\u0010a\u001a\u00020\u0017H\u0002J\u000e\u0010b\u001a\u00020c2\u0006\u00109\u001a\u00020:J\u000e\u0010d\u001a\u00020C2\u0006\u00109\u001a\u00020:J\b\u0010e\u001a\u00020cH\u0002J\u0010\u0010f\u001a\u00020c2\b\b\u0002\u0010g\u001a\u00020\u000bJ\u0016\u0010h\u001a\u00020c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)J&\u0010i\u001a\u00020c2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0004J.\u0010i\u001a\u00020c2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010j\u001a\u00020\u00042\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020kH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/intellij/sql/formatter/SqlQuerySectionFormatProcessor;", "", "()V", "alignBound", "", "alignChild", "alignComment", "alignPrefix", "alignSuffix", "beginning", "boundLength", "", "childDone", "clauseCurrKeyWordNumber", "clauseKeyLength", "clauseKeyWords", "collapse", "commonContext", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "howBound", "howLine", "howWrap", "myAlignmentForBound", "Lcom/intellij/formatting/Alignment;", "myAlignmentForChild", "myAlignmentForComment", "myAlignmentForPrefixD", "myAlignmentForPrefixE", "myAlignmentForSuffixD", "myAlignmentForSuffixE", "myIndent", "Lcom/intellij/formatting/Indent;", "myWrap", "Lcom/intellij/formatting/Wrap;", "myWrapFirst", "myWrapType", "Lcom/intellij/formatting/WrapType;", "parentTextRange", "Lcom/intellij/openapi/util/TextRange;", "passedFirstWrap", "queryContext", "Lcom/intellij/sql/com/intellij/sql/formatter/SqlQueryFormattingContext;", "<set-?>", "ready", "getReady", "()Z", "setReady", "(Z)V", "tabify", "wrapped", "checkIsBound", "type", "Lcom/intellij/psi/tree/IElementType;", "checkIsChild", "element", "Lcom/intellij/psi/PsiElement;", "checkIsClauseKeyword", "node", "Lcom/intellij/lang/ASTNode;", "checkIsMicroChild", "checkIsPrefixDelimiter", "checkIsPrefixEntity", "checkIsSuffixDelimiter", "checkIsSuffixEntity", "countClauseKeyWords", "Lkotlin/Pair;", "createChildBlock", "Lcom/intellij/sql/formatter/SqlBlock;", "context", "wrap", "alignment", "indent", "determineEntityKind", "Lcom/intellij/sql/formatter/SectionEntityKind;", "firstWordRightAligned", "getAlignmentForBound", "getAlignmentForChild", "getAlignmentForComment", "getAlignmentForPrefixD", "getAlignmentForPrefixE", "getAlignmentForSuffixD", "getAlignmentForSuffixE", "getConditionalWrappingRange", "getDefaultSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "getIndent", "getSpacingInInnerBlock", "getSpacingInOuterBlock", "getSpacingOnTheEdge", "space", "getWrap", "makeDependentLFSpacing", "keepNL", "makeLeftAlignment", "makeLeftAlignmentBS", "makeRightAlignment", "prepare", "", "processOuterBlock", "resetTheSection", "setupBound", "length", "setupContext", "setupLook", "whetherToResetTheSection", "Lcom/intellij/sql/psi/impl/SqlKeywordTokenType;", "intellij.database.sql.impl"})
public class SqlQuerySectionFormatProcessor {
    private SqlFormattingContext commonContext;
    private SqlQueryFormattingContext queryContext;
    private TextRange parentTextRange;
    private int howLine;
    private int howWrap;
    private int howBound;
    private boolean tabify;
    private boolean collapse;
    private int boundLength = 1;
    private Wrap myWrap;
    private Indent myIndent;
    private boolean alignBound;
    private boolean alignPrefix;
    private boolean alignChild;
    private boolean alignSuffix;
    private boolean alignComment;
    private Alignment myAlignmentForBound;
    private Alignment myAlignmentForPrefixE;
    private Alignment myAlignmentForPrefixD;
    private Alignment myAlignmentForChild;
    private Alignment myAlignmentForSuffixD;
    private Alignment myAlignmentForSuffixE;
    private Alignment myAlignmentForComment;
    private WrapType myWrapType = WrapType.NONE;
    private boolean myWrapFirst;
    private int clauseKeyWords;
    private int clauseKeyLength;
    private boolean ready;
    private int clauseCurrKeyWordNumber;
    private boolean beginning = true;
    private boolean childDone;
    private boolean wrapped;
    private boolean passedFirstWrap;

    public final boolean getReady() {
        return this.ready;
    }

    private final void setReady(boolean bl) {
        this.ready = bl;
    }

    public final void setupContext(@NotNull SqlFormattingContext commonContext, @NotNull SqlQueryFormattingContext queryContext) {
        Intrinsics.checkParameterIsNotNull((Object)commonContext, (String)"commonContext");
        Intrinsics.checkParameterIsNotNull((Object)queryContext, (String)"queryContext");
        this.commonContext = commonContext;
        this.queryContext = queryContext;
    }

    public final void setupLook(int howLine, int howWrap, int howBound, boolean tabify) {
        this.setupLook(howLine, howWrap, howBound, tabify, howWrap == 2 || howWrap == 3);
    }

    public final void setupLook(int howLine, int howWrap, int howBound, boolean tabify, boolean collapse) {
        this.howLine = howLine;
        this.howWrap = howWrap;
        this.howBound = howBound;
        this.tabify = tabify;
        this.collapse = collapse;
    }

    public final void setupBound(int length) {
        this.boundLength = length;
    }

    public static /* bridge */ /* synthetic */ void setupBound$default(SqlQuerySectionFormatProcessor sqlQuerySectionFormatProcessor, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setupBound");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        sqlQuerySectionFormatProcessor.setupBound(n);
    }

    /*
     * WARNING - void declaration
     */
    public final void prepare(@NotNull ASTNode node) {
        WrapType wrapType;
        void m;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.parentTextRange = node.getTextRange();
        Pair<Integer, Integer> pair = this.countClauseKeyWords(node);
        int n = ((Number)pair.component1()).intValue();
        int n2 = ((Number)pair.component2()).intValue();
        this.clauseKeyWords = m;
        this.clauseKeyLength = n2;
        switch (this.howWrap) {
            case 1: {
                if (this.collapse) {
                    wrapType = WrapType.CHOP_DOWN_IF_LONG;
                    break;
                }
                wrapType = WrapType.ALWAYS;
                break;
            }
            case 2: {
                wrapType = WrapType.CHOP_DOWN_IF_LONG;
                break;
            }
            case 3: {
                wrapType = WrapType.NORMAL;
                break;
            }
            default: {
                wrapType = WrapType.NONE;
            }
        }
        this.myWrapType = wrapType;
        this.myWrapFirst = this.howLine == 101 || this.howBound == 1;
        this.alignBound = this.howBound == 1;
        this.alignChild = this.howWrap == 1 || this.howWrap == 2;
        this.alignPrefix = this.alignChild && this.tabify;
        this.alignSuffix = this.alignChild && this.tabify;
        boolean bl = this.alignComment = this.alignChild && this.tabify || this.myAlignmentForComment != null;
        if (this.howBound == 1 && this.firstWordRightAligned()) {
            SqlQueryFormattingContext sqlQueryFormattingContext = this.queryContext;
            if (sqlQueryFormattingContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryContext");
            }
            this.myAlignmentForBound = sqlQueryFormattingContext.firstWordAlign;
        }
        this.ready = true;
    }

    private final boolean firstWordRightAligned() {
        SqlFormattingContext sqlFormattingContext = this.commonContext;
        if (sqlFormattingContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
        }
        return sqlFormattingContext.customSettings.QUERY_SECTION_1ST_WORD_ALIGN == 8;
    }

    private final Pair<Integer, Integer> countClauseKeyWords(ASTNode node) {
        int m = 0;
        int n = 0;
        for (ASTNode c = node.getFirstChildNode(); c != null; c = c.getTreeNext()) {
            IElementType t = c.getElementType();
            if (Intrinsics.areEqual((Object)t, (Object)SqlTokens.SQL_WHITE_SPACE)) continue;
            if (!SqlFormatting.isKeyWord(c) || !this.checkIsClauseKeyword(node)) break;
            ++m;
            n = n == 0 ? c.getTextLength() : n + 1 + c.getTextLength();
        }
        return new Pair((Object)m, (Object)n);
    }

    private final Alignment makeLeftAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkExpressionValueIsNotNull((Object)alignment, (String)"Alignment.createAlignmen\u2026e, Alignment.Anchor.LEFT)");
        return alignment;
    }

    private final Alignment makeLeftAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkExpressionValueIsNotNull((Object)alignment, (String)"Alignment.createAlignmen\u2026e, Alignment.Anchor.LEFT)");
        return alignment;
    }

    private final Alignment makeRightAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkExpressionValueIsNotNull((Object)alignment, (String)"Alignment.createAlignmen\u2026, Alignment.Anchor.RIGHT)");
        return alignment;
    }

    @NotNull
    public SectionEntityKind determineEntityKind(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        boolean kw = SqlFormatting.isKeyWord(node);
        return Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_LINE_COMMENT) || Intrinsics.areEqual((Object)type, (Object)SqlTokens.MYSQL_LINE_COMMENT) ? SectionEntityKind.ENT_LINE_COMMENT : (this.beginning && kw && this.checkIsClauseKeyword(node) ? SectionEntityKind.ENT_CLAUSE_KEYWORD : (!this.childDone && this.checkIsPrefixDelimiter(type) ? SectionEntityKind.ENT_PREFIX_DELIMITER : (!this.childDone && this.checkIsPrefixEntity(node, type) ? SectionEntityKind.ENT_PREFIX_ENTITY : (this.childDone && this.checkIsSuffixDelimiter(type) ? SectionEntityKind.ENT_SUFFIX_DELIMITER : (this.childDone && this.checkIsSuffixEntity(node, type) ? SectionEntityKind.ENT_SUFFIX_ENTITY : (this.checkIsBound(type) ? SectionEntityKind.ENT_BOUND : (this.checkIsChild(element, type) ? (this.beginning && this.checkIsMicroChild(node) ? SectionEntityKind.ENT_MICRO_CHILD : SectionEntityKind.ENT_CHILD) : (kw ? SectionEntityKind.ENT_MIDDLE_KEYWORD : SectionEntityKind.ENT_UNSORTED))))))));
    }

    public boolean checkIsClauseKeyword(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.beginning;
    }

    public boolean checkIsBound(@NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_COMMA);
    }

    public boolean checkIsPrefixEntity(@NotNull ASTNode node, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return false;
    }

    public boolean checkIsPrefixDelimiter(@NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return false;
    }

    public boolean checkIsChild(@NotNull PsiElement element, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return element instanceof SqlExpression;
    }

    public boolean checkIsMicroChild(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return false;
    }

    public boolean checkIsSuffixDelimiter(@NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_AS);
    }

    public boolean checkIsSuffixEntity(@NotNull ASTNode node, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return false;
    }

    public boolean whetherToResetTheSection(@NotNull ASTNode node, @NotNull SqlKeywordTokenType type) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return false;
    }

    @NotNull
    public SqlBlock createChildBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return SqlFormatting.createDefaultBlock$default(node, context, wrap, alignment, indent, false, 32, null);
    }

    @NotNull
    public final SqlBlock processOuterBlock(@NotNull ASTNode node) {
        SqlBlock block;
        Alignment alignment;
        Wrap currWrap;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PsiElement element = node.getPsi();
        IElementType type = node.getElementType();
        PsiElement psiElement = element;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element");
        IElementType iElementType = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"type");
        SectionEntityKind kind = this.determineEntityKind(node, psiElement, iElementType);
        boolean bl2 = this.beginning = this.beginning && kind == SectionEntityKind.ENT_CLAUSE_KEYWORD;
        if ((kind == SectionEntityKind.ENT_CLAUSE_KEYWORD || kind == SectionEntityKind.ENT_MIDDLE_KEYWORD) && type instanceof SqlKeywordTokenType && this.clauseCurrKeyWordNumber > 0 && this.whetherToResetTheSection(node, (SqlKeywordTokenType)type)) {
            this.resetTheSection();
            kind = SectionEntityKind.ENT_CLAUSE_KEYWORD;
        }
        switch (SqlQuerySectionFormatProcessor$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                int n = this.clauseCurrKeyWordNumber;
                this.clauseCurrKeyWordNumber = n + 1;
                break;
            }
            case 2: {
                this.childDone = true;
                break;
            }
            case 3: {
                this.childDone = true;
                switch (this.howBound) {
                    case 1: {
                        this.myWrapFirst = true;
                        break;
                    }
                    case 2: {
                        this.myWrapFirst = false;
                        this.clauseKeyLength += 2 + node.getTextLength() + this.boundLength;
                    }
                }
                break;
            }
            case 4: {
                this.childDone = false;
            }
        }
        switch (this.howBound) {
            case 1: {
                if (kind == SectionEntityKind.ENT_BOUND) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = !this.wrapped && kind != SectionEntityKind.ENT_BOUND && kind != SectionEntityKind.ENT_CLAUSE_KEYWORD && kind != SectionEntityKind.ENT_LINE_COMMENT && kind != SectionEntityKind.ENT_MICRO_CHILD;
            }
        }
        boolean toWrap = bl;
        Wrap wrap = currWrap = toWrap ? this.getWrap() : null;
        Indent currIndent = toWrap ? this.getIndent() : (kind == SectionEntityKind.ENT_CLAUSE_KEYWORD && this.clauseCurrKeyWordNumber == 1 ? Indent.getNoneIndent() : null);
        this.wrapped = this.wrapped || currWrap != null;
        switch (SqlQuerySectionFormatProcessor$WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
            case 1: {
                if (this.clauseCurrKeyWordNumber == 1 && this.firstWordRightAligned()) {
                    SqlQueryFormattingContext sqlQueryFormattingContext = this.queryContext;
                    if (sqlQueryFormattingContext == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"queryContext");
                    }
                    alignment = sqlQueryFormattingContext.firstWordAlign;
                    break;
                }
                if (this.howBound == 1 && this.clauseCurrKeyWordNumber == this.clauseKeyWords) {
                    alignment = this.getAlignmentForBound();
                    break;
                }
                alignment = null;
                break;
            }
            case 2: {
                alignment = this.getAlignmentForPrefixE();
                break;
            }
            case 3: {
                alignment = this.getAlignmentForPrefixD();
                break;
            }
            case 4: {
                alignment = this.getAlignmentForChild();
                break;
            }
            case 5: {
                alignment = this.getAlignmentForSuffixD();
                break;
            }
            case 6: {
                alignment = this.getAlignmentForSuffixE();
                break;
            }
            case 7: {
                alignment = this.getAlignmentForBound();
                break;
            }
            case 8: {
                alignment = this.getAlignmentForComment();
                break;
            }
            default: {
                alignment = null;
            }
        }
        Alignment currAlign = alignment;
        switch (SqlQuerySectionFormatProcessor$WhenMappings.$EnumSwitchMapping$2[kind.ordinal()]) {
            case 1: 
            case 2: {
                SqlFormattingContext sqlFormattingContext = this.commonContext;
                if (sqlFormattingContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
                }
                SqlBlock sqlBlock = new SqlWord(node, sqlFormattingContext, currWrap, currAlign, currIndent, this.clauseCurrKeyWordNumber);
                break;
            }
            case 3: 
            case 4: {
                SqlFormattingContext sqlFormattingContext = this.commonContext;
                if (sqlFormattingContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
                }
                SqlBlock sqlBlock = this.createChildBlock(node, sqlFormattingContext, currWrap, currAlign, currIndent);
                break;
            }
            default: {
                SqlFormattingContext sqlFormattingContext = this.commonContext;
                if (sqlFormattingContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
                }
                SqlBlock sqlBlock = block = SqlFormatting.createDefaultBlock$default(node, sqlFormattingContext, currWrap, currAlign, currIndent, false, 32, null);
            }
        }
        if (toWrap) {
            block.setConditionalWrappingRange(this.getConditionalWrappingRange());
        }
        if (this.howBound != 1 && kind == SectionEntityKind.ENT_BOUND) {
            this.wrapped = false;
        }
        return block;
    }

    private final void resetTheSection() {
        this.beginning = true;
        this.wrapped = false;
        this.childDone = false;
        this.clauseCurrKeyWordNumber = 0;
        this.myWrap = null;
        this.passedFirstWrap = false;
    }

    private final Wrap getWrap() {
        if (this.myWrap != null) {
            return this.myWrap;
        }
        if (this.myWrapType == WrapType.NONE) {
            return null;
        }
        this.myWrap = Wrap.createWrap((WrapType)this.myWrapType, (boolean)this.myWrapFirst);
        return this.myWrap;
    }

    private final TextRange getConditionalWrappingRange() {
        if (this.myWrapType != WrapType.CHOP_DOWN_IF_LONG) {
            return null;
        }
        if (!this.myWrapFirst && !this.passedFirstWrap) {
            this.passedFirstWrap = true;
            return null;
        }
        SqlQueryFormattingContext sqlQueryFormattingContext = this.queryContext;
        if (sqlQueryFormattingContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queryContext");
        }
        return sqlQueryFormattingContext.textRange;
    }

    @Nullable
    public final Indent getIndent() {
        Object object;
        if (this.myIndent != null) {
            return this.myIndent;
        }
        if (this.howLine == 0) {
            return null;
        }
        if (this.howLine == 1) {
            int offset;
            int n = offset = this.howBound == 1 ? this.clauseKeyLength - this.boundLength : this.clauseKeyLength + this.boundLength;
            object = offset > 0 ? Indent.getSpaceIndent((int)offset, (boolean)true) : (offset == 0 ? Indent.getNoneIndent() : null);
        } else {
            object = Indent.getNormalIndent((boolean)true);
        }
        this.myIndent = object;
        return this.myIndent;
    }

    @Nullable
    public final Alignment getAlignmentForBound() {
        if (this.alignBound) {
            if (this.myAlignmentForBound == null) {
                this.myAlignmentForBound = this.makeRightAlignment();
            }
            return this.myAlignmentForBound;
        }
        return null;
    }

    @Nullable
    public final Alignment getAlignmentForPrefixE() {
        if (this.alignPrefix) {
            if (this.myAlignmentForPrefixE == null) {
                this.myAlignmentForPrefixE = this.makeLeftAlignment();
            }
            return this.myAlignmentForPrefixE;
        }
        return null;
    }

    @Nullable
    public final Alignment getAlignmentForPrefixD() {
        if (this.alignPrefix) {
            if (this.myAlignmentForPrefixD == null) {
                this.myAlignmentForPrefixD = this.makeLeftAlignmentBS();
            }
            return this.myAlignmentForPrefixD;
        }
        return null;
    }

    @Nullable
    public final Alignment getAlignmentForChild() {
        if (this.alignChild) {
            if (this.myAlignmentForChild == null) {
                this.myAlignmentForChild = this.makeLeftAlignment();
            }
            return this.myAlignmentForChild;
        }
        return null;
    }

    @Nullable
    public final Alignment getAlignmentForSuffixD() {
        if (this.alignSuffix) {
            if (this.myAlignmentForSuffixD == null) {
                this.myAlignmentForSuffixD = this.makeLeftAlignmentBS();
            }
            return this.myAlignmentForSuffixD;
        }
        return null;
    }

    @Nullable
    public final Alignment getAlignmentForSuffixE() {
        if (this.alignSuffix) {
            if (this.myAlignmentForSuffixE == null) {
                this.myAlignmentForSuffixE = this.makeLeftAlignmentBS();
            }
            return this.myAlignmentForSuffixE;
        }
        return null;
    }

    @Nullable
    public final Alignment getAlignmentForComment() {
        if (this.alignComment) {
            if (this.myAlignmentForComment == null) {
                this.myAlignmentForComment = this.makeLeftAlignmentBS();
            }
            return this.myAlignmentForComment;
        }
        return null;
    }

    @Nullable
    public Spacing getSpacingInOuterBlock(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        return this.getDefaultSpacing(block1, block2);
    }

    @Nullable
    public Spacing getSpacingInInnerBlock(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        return this.getDefaultSpacing(block1, block2);
    }

    @Nullable
    public Spacing getDefaultSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        if (block1 instanceof SqlLineCommentBlock) {
            return SqlFormatting.makeNL();
        }
        if (block1 instanceof SqlBlockCommentBlock || block2 instanceof SqlBlockCommentBlock || block2 instanceof SqlLineCommentBlock) {
            SqlFormattingContext sqlFormattingContext = this.commonContext;
            if (sqlFormattingContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
            }
            return SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
        }
        IElementType type1 = block1.getElementType();
        IElementType type2 = block2.getElementType();
        boolean comma1 = Intrinsics.areEqual((Object)type1, (Object)SqlTokens.SQL_COMMA);
        boolean comma2 = Intrinsics.areEqual((Object)type2, (Object)SqlTokens.SQL_COMMA);
        if (block1 instanceof SqlWord && !comma2) {
            return SqlFormatting.makeSpace$default(false, false, 3, null);
        }
        if (comma1 && this.howBound == 1) {
            spacing = SqlFormatting.makeSpace$default(false, false, 3, null);
        } else if (comma2 && this.howBound == 1) {
            spacing = this.getSpacingOnTheEdge(block1, block2, false);
        } else if (comma2 && this.howBound == 2) {
            spacing = SqlFormatting.makeNoSpace$default(false, 1, null);
        } else if (comma1 && this.howBound == 2) {
            spacing = this.getSpacingOnTheEdge(block1, block2, true);
        } else if ((comma1 || comma2) && this.howBound == 0 && this.howWrap == 0) {
            spacing = null;
        } else if (this.collapse) {
            spacing = Spacing.createSafeSpacing((boolean)false, (int)0);
        } else {
            SqlFormattingContext sqlFormattingContext = this.commonContext;
            if (sqlFormattingContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
            }
            spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
        }
        return spacing;
    }

    private final Spacing getSpacingOnTheEdge(SqlBlock block1, SqlBlock block2, boolean space) {
        Spacing spacing;
        if (this.myWrapType == WrapType.ALWAYS || this.myWrapType == WrapType.CHOP_DOWN_IF_LONG) {
            spacing = SqlFormatting.makeSpace$default(space, false, 2, null);
        } else if (this.howWrap == 0) {
            spacing = this.makeDependentLFSpacing(block1, block2, true, space);
        } else if (space) {
            SqlFormattingContext sqlFormattingContext = this.commonContext;
            if (sqlFormattingContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
            }
            spacing = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)sqlFormattingContext.commonSettings.KEEP_LINE_BREAKS, (int)0);
        } else {
            SqlFormattingContext sqlFormattingContext = this.commonContext;
            if (sqlFormattingContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
            }
            spacing = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)sqlFormattingContext.commonSettings.KEEP_LINE_BREAKS, (int)0);
        }
        return spacing;
    }

    private final Spacing makeDependentLFSpacing(SqlBlock block1, SqlBlock block2, boolean keepNL, boolean space) {
        TextRange r1 = block1.getTextRange();
        TextRange r2 = block2.getTextRange();
        if (this.parentTextRange != null) {
            TextRange textRange = this.parentTextRange;
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            int n = textRange.getStartOffset();
            TextRange textRange2 = block1.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"block1.textRange");
            r1 = new TextRange(n, textRange2.getEndOffset());
            TextRange textRange3 = block2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange3, (String)"block2.textRange");
            int n2 = textRange3.getStartOffset();
            TextRange textRange4 = this.parentTextRange;
            if (textRange4 == null) {
                Intrinsics.throwNpe();
            }
            r2 = new TextRange(n2, textRange4.getEndOffset());
        }
        TextRange textRange = r1;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"r1");
        int n = textRange.getLength();
        TextRange textRange5 = r2;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange5, (String)"r2");
        int n3 = n + textRange5.getLength();
        SqlFormattingContext sqlFormattingContext = this.commonContext;
        if (sqlFormattingContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commonContext");
        }
        return n3 > sqlFormattingContext.codeStyleSettings.getRightMargin((Language)SqlLanguage.INSTANCE) ? SqlFormatting.makeNL() : Spacing.createDependentLFSpacing((int)(space ? 1 : 0), (int)1, (List)CollectionsKt.listOf((Object[])new TextRange[]{r1, r2}), (boolean)keepNL, (int)0);
    }
}

