/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.com.intellij.sql.formatter.SqlQueryFormattingContext;
import com.intellij.sql.formatter.AbstractSqlBlock;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlFormattingBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlQuerySectionFormatProcessor;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlElementTypes;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlSingleNodeSectionBlock
extends AbstractSqlBlock {
    protected final SqlQueryFormattingContext myQueryContext;
    public final boolean myContinuous;
    @NotNull
    protected final SqlQuerySectionFormatProcessor myProcessor;

    protected SqlSingleNodeSectionBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @NotNull SqlQueryFormattingContext queryContext, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        if (node == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(1);
        }
        if (queryContext == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(2);
        }
        super(node, context, wrap, alignment, indent);
        this.myQueryContext = queryContext;
        this.myContinuous = false;
        this.myProcessor = this.createProcessor();
        this.myProcessor.setupContext(context, queryContext);
    }

    protected SqlSingleNodeSectionBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @NotNull SqlQueryFormattingContext queryContext, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean continuous) {
        if (node == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(4);
        }
        if (queryContext == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(5);
        }
        super(node, context, wrap, alignment, indent);
        this.myQueryContext = queryContext;
        this.myContinuous = continuous;
        this.myProcessor = this.createProcessor();
        this.myProcessor.setupContext(context, queryContext);
    }

    @NotNull
    protected SqlQuerySectionFormatProcessor createProcessor() {
        SqlQuerySectionFormatProcessor sqlQuerySectionFormatProcessor = new SqlQuerySectionFormatProcessor();
        if (sqlQuerySectionFormatProcessor == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(6);
        }
        return sqlQuerySectionFormatProcessor;
    }

    @Override
    protected void buildBlocks(@NotNull ASTNode blockNode, @NotNull ArrayList<Block> builtBlocks) {
        if (blockNode == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(7);
        }
        if (builtBlocks == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(8);
        }
        for (ASTNode node = blockNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType elementType;
            PsiElement element = node.getPsi();
            if (SqlSingleNodeSectionBlock.isWhitespace(node, element, elementType = node.getElementType())) continue;
            if (elementType == SqlElementTypes.SQL_DUMMY_BLOCK || this.whetherToFlatten(node, element, elementType)) {
                this.buildBlocks(node, builtBlocks);
                continue;
            }
            if (element instanceof IsExternal) {
                builtBlocks.add((Block)new SqlFormattingBlock.ReadOnlyBlock(node));
                continue;
            }
            Block block = this.produceBlock(node);
            builtBlocks.add(block);
        }
    }

    protected boolean whetherToFlatten(@NotNull ASTNode node, @NotNull PsiElement element, @NotNull IElementType elementType) {
        if (node == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(9);
        }
        if (element == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(10);
        }
        if (elementType == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(11);
        }
        return false;
    }

    @NotNull
    protected Block produceBlock(ASTNode node) {
        SqlBlock sqlBlock = this.myProcessor.processOuterBlock(node);
        if (sqlBlock == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(12);
        }
        return sqlBlock;
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        if (block1 == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(13);
        }
        if (block2 == null) {
            SqlSingleNodeSectionBlock.$$$reportNull$$$0(14);
        }
        return this.myProcessor.getSpacingInOuterBlock(block1, block2);
    }

    @Override
    protected Spacing createSpaces(int spaces) {
        return SqlFormatting.makeSpace(spaces, this.myContext.commonSettings.KEEP_LINE_BREAKS);
    }

    public boolean isLeaf() {
        return false;
    }

    @Nullable
    protected Indent getChildIndent() {
        return this.myProcessor.getIndent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryContext";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlSingleNodeSectionBlock";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtBlocks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlSingleNodeSectionBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "produceBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildBlocks";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "whetherToFlatten";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

