/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.sql.com.intellij.sql.formatter.SqlFormatting;
import com.intellij.sql.formatter.SqlBlock;
import com.intellij.sql.formatter.SqlExpressionBlock;
import com.intellij.sql.formatter.SqlFormattingContext;
import com.intellij.sql.formatter.SqlSymbol;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\rH\u0016R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/SqlUnaryExpressionBlock;", "Lcom/intellij/sql/formatter/SqlExpressionBlock;", "node", "Lcom/intellij/lang/ASTNode;", "context", "Lcom/intellij/sql/formatter/SqlFormattingContext;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "forceCollapse", "", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/sql/formatter/SqlFormattingContext;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Z)V", "isComplex", "()Z", "getSpacingInner", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/SqlBlock;", "block2", "isLeaf", "intellij.database.sql.impl"})
public final class SqlUnaryExpressionBlock
extends SqlExpressionBlock {
    private final boolean isComplex;

    public final boolean isComplex() {
        return this.isComplex;
    }

    @Override
    @Nullable
    protected Spacing getSpacingInner(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        SqlCodeStyleSettings s = this.myContext.customSettings;
        ASTNode node1 = block1.getNode();
        if (node1 != null && node1.getTreePrev() == null && SqlFormatting.isSymbol(node1, '+', '-', '!')) {
            spacing = SqlFormatting.makeNoSpace$default(false, 1, null);
        } else if (block1 instanceof SqlSymbol || block2 instanceof SqlSymbol && s.EXPR_SPACE_AROUND_OPERATOR != 0) {
            spacing = SqlFormatting.makeSpace$default(s.EXPR_SPACE_AROUND_OPERATOR == 1, false, 2, null);
        } else {
            SqlFormattingContext sqlFormattingContext = this.myContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFormattingContext, (String)"myContext");
            spacing = SqlFormatting.commonSpacing(sqlFormattingContext, block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean isLeaf() {
        return !this.isComplex;
    }

    public SqlUnaryExpressionBlock(@NotNull ASTNode node, @NotNull SqlFormattingContext context, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, boolean forceCollapse) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(node, context, wrap, alignment, indent, forceCollapse, null);
        this.isComplex = SqlFormatting.isComplex(node);
    }
}

