/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeGenerationMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlPreviewExamples;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    private static final SqlLanguageDialect PREVIEW_FILES_DIALECT = (SqlLanguageDialect)ObjectUtils.assertNotNull((Object)DbSqlUtil.getSqlDialect(PostgresDialect.INSTANCE));
    private final JBCheckBox myDisableCb = new JBCheckBox("Disable formatting");
    private final JPanel myWrapper = new JPanel(new BorderLayout());

    protected SqlCodeStyleMainPanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super((Language)SqlLanguage.INSTANCE, currentSettings, settings);
        final JComponent panel = super.getPanel();
        assert (panel != null);
        Color borderColor = JBColor.border();
        panel.setBorder(JBUI.Borders.customLine((Color)borderColor, (int)0, (int)0, (int)1, (int)0));
        this.myWrapper.add((Component)panel, "Center");
        this.myDisableCb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                UIUtil.setEnabled((Component)panel, (!SqlCodeStyleMainPanel.this.myDisableCb.isSelected() ? 1 : 0) != 0, (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$1", "stateChanged"));
            }
        });
        this.myDisableCb.setSelected(SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)this.getCurrentSettings()).DISABLE_FORMATTING);
        this.myDisableCb.setBorder(JBUI.Borders.empty((int)4));
        this.myWrapper.add((Component)this.myDisableCb, "South");
    }

    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        super.apply(settings);
        SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING = this.myDisableCb.isSelected();
        DatabaseSettings.fireSettingsChanged();
    }

    protected void initTabs(CodeStyleSettings settings) {
        IndentOptionsEditor indentOptionsEditor;
        this.addTab((CodeStyleAbstractPanel)new CasePanel(settings));
        this.addTab((CodeStyleAbstractPanel)new QueriesPanel(settings));
        this.addTab((CodeStyleAbstractPanel)new DdlPanel(settings));
        this.addTab((CodeStyleAbstractPanel)new ExpressionsPanel(settings));
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
        IndentOptionsEditor indentOptionsEditor2 = indentOptionsEditor = provider != null ? provider.getIndentOptionsEditor() : null;
        if (indentOptionsEditor != null) {
            this.addTab((CodeStyleAbstractPanel)new SqlIndentOptionsWrapper(settings, provider, indentOptionsEditor));
        }
        this.addTab((CodeStyleAbstractPanel)new SqlSpacesPanel(settings));
        this.addTab((CodeStyleAbstractPanel)new SqlWrappingAndBracesPanel(settings));
        this.addTab((CodeStyleAbstractPanel)new SqlBlankLinesPanel(settings));
        this.addTab(new SqlCodeGenerationMainPanel(settings));
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING != this.myDisableCb.isSelected();
    }

    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        this.myDisableCb.setSelected(SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING);
    }

    public JComponent getPanel() {
        return this.myWrapper;
    }

    @NotNull
    private static SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        return sqlCodeStyleSettings;
    }

    protected static PsiFile createSqlFile(Project project, String text2) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("preview.sql", (Language)PREVIEW_FILES_DIALECT, (CharSequence)text2, false, false);
    }

    private static EditorHighlighter createSqlHighlighter(EditorColorsScheme scheme) {
        return new LexerEditorHighlighter((SyntaxHighlighter)new SqlSyntaxHighlighter(PREVIEW_FILES_DIALECT, null), scheme);
    }

    private static void manuallyChanged(CodeStyleSettings settings) {
        SqlCodeStyleMainPanel.getSqlSettings(settings).manuallyChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSqlSettings";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExpressionsPanel
    extends OptionTableWithPreviewPanel {
        private static final String CORTEGE = "Cortege";
        private static final String BINARY_EXPRESSION = "Binary expression";
        private static final String CASE_CLAUSE = "CASE clause";
        private static final String NEW_LINE_BEFORE = "New line";

        public ExpressionsPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        protected void initTables() {
            this.showSqlCustomOption("CORTEGE_SPACE_BEFORE_L_PAREN", "Add space before `(`", CORTEGE);
            this.showSqlCustomOption("CORTEGE_COMMA_1ST", "Use leading commas", CORTEGE);
            this.showSqlCustomOption("CORTEGE_CLOSING", "Align `)`", CORTEGE, SqlCodeStyleConst.CORTEGE_CLOSING_NAMES, SqlCodeStyleConst.CORTEGE_CLOSING_VALUES);
            this.showSqlCustomOption("EXPR_SPACE_AROUND_OPERATOR", "Use spaces around operators", BINARY_EXPRESSION, SqlCodeStyleConst.NAMES_DONT_CHANGE_YES_NO, SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption("EXPR_BINARY_OP_ALIGN", "Align operands in binary expressions", BINARY_EXPRESSION);
            this.showSqlCustomOption("EXPR_CASE_WHEN_WRAP", "Wrap WHEN", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_WHEN_INDENT", "Indent WHEN if wrapped", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_THEN_WRAP", "Wrap THEN", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_THEN_ALIGN", "Align THEN", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_ELSE_ALIGN_THEN", "Align ELSE under THEN when THEN aligned", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_END", "Align END", CASE_CLAUSE, SqlCodeStyleConst.EXPR_CASE_END_ALIGN_NAMES, SqlCodeStyleConst.EXPR_CASE_END_ALIGN_VALUES);
            this.showSqlCustomOption("EXPR_CASE_KEEP_NL_AFTER_THEN", "Keep new line after THEN, ELSE", CASE_CLAUSE);
            this.showSqlCustomOption("EXPR_CASE_COLLAPSE", "Collapse short clause", CASE_CLAUSE);
            this.showSqlCustomOption("NEW_LINE_BEFORE_ELSE", "Put new line before ELSE", NEW_LINE_BEFORE);
            this.showSqlCustomOption("NEW_LINE_BEFORE_THEN", "Put new line before THEN", NEW_LINE_BEFORE);
            this.showSqlCustomOption("NEW_LINE_BEFORE_OTHER_CLAUSES", "Put new line before other clauses", NEW_LINE_BEFORE);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, new Object[0]);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName, String[] names, int[] values2) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, new Object[]{names, values2});
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read("expressions");
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
            if (provider != null) {
                provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
            }
        }

        protected String getTabTitle() {
            return "Expressions";
        }

        @Nullable
        public Language getDefaultLanguage() {
            return SqlLanguage.INSTANCE;
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }

        public void onSomethingChanged() {
            super.onSomethingChanged();
            SqlCodeStyleMainPanel.manuallyChanged(this.getSettings());
        }
    }

    public static class DdlPanel
    extends OptionTableWithPreviewPanel {
        private static final String ALIGNMENT = "Alignment";

        public DdlPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        protected void initTables() {
            this.showSqlCustomOption("ALIGN_TYPE_IN_CREATE_STATEMENT", "Types inside table definition", ALIGNMENT);
            this.showSqlCustomOption("ALIGN_TYPE_IN_ARGUMENT_DEFINITION", "Types in procedure definition", ALIGNMENT);
            this.showSqlCustomOption("ALIGN_TYPE_IN_BLOCK_STATEMENT", "Types in variable declarations", ALIGNMENT);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, new Object[0]);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName, String[] names, int[] values2) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, new Object[]{names, values2});
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read("ddl");
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
            if (provider != null) {
                provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
            }
        }

        protected String getTabTitle() {
            return "DDL";
        }

        @Nullable
        public Language getDefaultLanguage() {
            return SqlLanguage.INSTANCE;
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }

        public void onSomethingChanged() {
            super.onSomethingChanged();
            SqlCodeStyleMainPanel.manuallyChanged(this.getSettings());
        }
    }

    public static class QueriesPanel
    extends OptionTableWithPreviewPanel {
        private static final String SECTION_QUERY = "Common";
        private static final String SECTION_INSERT = "INSERT statement";
        private static final String SECTION_SET = "UPDATE statement";
        private static final String SECTION_WITH = "WITH clause";
        private static final String SECTION_SELECT = "SELECT clause";
        private static final String SECTION_FROM = "FROM clause";
        private static final String SECTION_WHERE = "WHERE and HAVING clauses";
        private static final String SECTION_ORDER = "GROUP BY and ORDER BY clauses";
        private static final String SECTION_SUBQUERY = "Subquery";

        public QueriesPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        protected void initTables() {
            this.showSqlCustomOption("QUERY_SECTION_1ST_WORD_ALIGN", "Align the first word of clause", SECTION_QUERY, SqlCodeStyleConst.QUERY_SECTION_1ST_WORD_ALIGN_NAMES, SqlCodeStyleConst.QUERY_SECTION_1ST_WORD_ALIGN_VALUES);
            this.showSqlCustomOption("QUERY_EL_LINE", "Place clause elements on", SECTION_QUERY, SqlCodeStyleConst.EL_LINE_NAMES, SqlCodeStyleConst.EL_LINE_VALUES);
            this.showSqlCustomOption("QUERY_IN_ONE_STRING", "Collapse short statement", SECTION_QUERY, SqlCodeStyleConst.QUERY_IN_ONE_STRING_NAMES, SqlCodeStyleConst.QUERY_IN_ONE_STRING_VALUES);
            this.showSqlCustomOption("NEW_LINE_AROUND_SEMICOLON", "Put new line around semicolon", SECTION_QUERY, new Object[0]);
            this.showSqlCustomOption("INSERT_INTO_NL", "Place INTO on the new line", SECTION_INSERT, SqlCodeStyleConst.NAMES_DONT_CHANGE_YES_NO, SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption("INSERT_COLLAPSE_MULTI_ROW_VALUES", "Collapse short multi-row values", SECTION_INSERT, new Object[0]);
            this.showSqlCustomOption("SET_EL_WRAP", "Wrap elements", SECTION_SET, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("SET_EL_COMMA", "Place comma", SECTION_SET, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("SET_ALIGN_EQUAL_SIGN", "Align `=`", SECTION_SET, new Object[0]);
            this.showSqlCustomOption("WITH_EL_WRAP", "Wrap subqueries", SECTION_WITH, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("WITH_EL_COMMA", "Place comma", SECTION_WITH, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("WITH_ALIGN_AS", "Align AS", SECTION_WITH, new Object[0]);
            this.showSqlCustomOption("SELECT_EL_WRAP", "Wrap elements", SECTION_SELECT, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("SELECT_EL_COMMA", "Place comma", SECTION_SELECT, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("SELECT_NEW_LINE_AFTER_ALL_DISTINCT", "New line after ALL, DISTINCT", SECTION_SELECT, new Object[0]);
            this.showSqlCustomOption("SELECT_KEEP_N_ITEMS_IN_LINE", "Number of inline elements", SECTION_SELECT, SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_NAMES, SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_VALUES);
            this.showSqlCustomOption("SELECT_USE_AS_WORD", "Use AS", SECTION_SELECT, SqlCodeStyleConst.SELECT_USE_AS_NAMES, SqlCodeStyleConst.SELECT_USE_AS_VALUES);
            this.showSqlCustomOption("SELECT_ALIGN_AS", "Align AS", SECTION_SELECT, new Object[0]);
            this.showSqlCustomOption("FROM_EL_WRAP", "Wrap elements", SECTION_FROM, SqlCodeStyleConst.EL_WRAP_NAMES_2, SqlCodeStyleConst.EL_WRAP_VALUES_2);
            this.showSqlCustomOption("FROM_EL_COMMA", "Place comma", SECTION_FROM, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("FROM_WRAP_JOIN_1", "Wrap the first JOIN", SECTION_FROM, new Object[0]);
            this.showSqlCustomOption("FROM_WRAP_JOIN_2", "Wrap the next JOIN", SECTION_FROM, new Object[0]);
            this.showSqlCustomOption("FROM_WRAP_ON", "Wrap ON", SECTION_FROM, new Object[0]);
            this.showSqlCustomOption("FROM_ALIGN_JOIN_TABLES", "Align joined tables", SECTION_FROM, new Object[0]);
            this.showSqlCustomOption("FROM_ALIGN_ALIASES", "Align table aliases", SECTION_FROM, new Object[0]);
            this.showSqlCustomOption("FROM_INDENT_JOIN", "Indent JOIN", SECTION_FROM, new Object[0]);
            this.showSqlCustomOption("WHERE_EL_WRAP", "Wrap elements", SECTION_WHERE, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("WHERE_EL_BOUND", "Place top-level AND/OR", SECTION_WHERE, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("ORDER_EL_WRAP", "Wrap elements", SECTION_ORDER, SqlCodeStyleConst.EL_WRAP_NAMES, SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption("ORDER_EL_COMMA", "Place comma", SECTION_ORDER, SqlCodeStyleConst.EL_COMMA_NAMES, SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption("ORDER_ALIGN_ASC_DESC", "Align ASC/DESC", SECTION_ORDER, new Object[0]);
            this.showSqlCustomOption("SUBQUERY_L_PAR_NL_OUTSIDE", "Wrap before `(`", SECTION_SUBQUERY, new Object[0]);
            this.showSqlCustomOption("SUBQUERY_L_PAR_NL_INSIDE", "Wrap after `(`", SECTION_SUBQUERY, new Object[0]);
            this.showSqlCustomOption("SUBQUERY_R_PAR_NL_INSIDE", "Wrap before `)`", SECTION_SUBQUERY, new Object[0]);
            this.showSqlCustomOption("SUBQUERY_R_PAR_ALIGN", "Align `)`", SECTION_SUBQUERY, SqlCodeStyleConst.SUBQUERY_R_PAR_ALIGN_NAMES, SqlCodeStyleConst.SUBQUERY_R_PAR_ALIGN_VALUES);
            this.showSqlCustomOption("SUBQUERY_INDENT_INSIDE", "Indent subquery inside parentheses when wrapped", SECTION_SUBQUERY, new Object[0]);
            this.showSqlCustomOption("SUBQUERY_PAR_SPACE_INSIDE", "Put spaces inside parentheses", SECTION_SUBQUERY, new Object[0]);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName, Object ... options) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, options);
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        public String getPreviewText() {
            return SqlPreviewExamples.read("queries");
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
            if (provider != null) {
                provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
            }
        }

        protected String getTabTitle() {
            return "Queries";
        }

        @Nullable
        public Language getDefaultLanguage() {
            return SqlLanguage.INSTANCE;
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }

        public void onSomethingChanged() {
            super.onSomethingChanged();
            SqlCodeStyleMainPanel.manuallyChanged(this.getSettings());
        }
    }

    public static class CasePanel
    extends OptionTableWithPreviewPanel {
        private static final String CASE_OPTIONS = "Word Case";
        private static final String QUOTATION_OPTIONS = "Quotation";

        public CasePanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        protected void initTables() {
            this.showSqlCustomOption("KEYWORD_CASE", "Keywords", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES, SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption("TYPE_CASE", "Types", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES_EXT, SqlCodeStyleConst.TOKEN_CASE_EXT);
            this.showSqlCustomOption("IDENTIFIER_CASE", "Identifiers", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES, SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption("ALIAS_CASE", "Aliases", CASE_OPTIONS, SqlCodeStyleConst.ALIAS_CASE_NAMES, SqlCodeStyleConst.ALIAS_CASE_EXT);
            this.showSqlCustomOption("QUOTED_IDENTIFIER_CASE", "Quoted identifiers", CASE_OPTIONS, SqlCodeStyleConst.TOKEN_CASE_NAMES, SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption("QUOTE_IDENTIFIER", "Identifier quotation", QUOTATION_OPTIONS, SqlCodeStyleConst.QUOTE_OPTIONS_NAMES, SqlCodeStyleConst.QUOTE_OPTIONS);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName, Object ... options) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, options);
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read("case");
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
            if (provider != null) {
                provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
            }
        }

        protected String getTabTitle() {
            return "Case";
        }

        @Nullable
        public Language getDefaultLanguage() {
            return SqlLanguage.INSTANCE;
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }

        public void onSomethingChanged() {
            super.onSomethingChanged();
            SqlCodeStyleMainPanel.manuallyChanged(this.getSettings());
        }
    }

    private class SqlWrappingAndBracesPanel
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel {
        private static final String WRAP_INSIDE = "Wrap inside";

        protected String getTabTitle() {
            return "Wrapping";
        }

        protected int getRightMargin() {
            return 80;
        }

        public SqlWrappingAndBracesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }

        private void showWrapOption(String fieldName, String title) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, WRAP_INSIDE, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
        }

        protected void initTables() {
            this.addOption("KEEP_LINE_BREAKS", ApplicationBundle.message((String)"wrapping.keep.line.breaks", (Object[])new Object[0]), WRAPPING_KEEP);
            this.addOption("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message((String)"wrapping.keep.comment.at.first.column", (Object[])new Object[0]), WRAPPING_KEEP);
            this.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
            this.showWrapOption("WRAP_INSIDE_CREATE_TABLE", "Create table");
            this.showWrapOption("WRAP_INSIDE_ARGUMENT_DEFINITION", "Definition");
            this.showWrapOption("WRAP_INSIDE_CALL_EXPRESSION", "Call expression");
            this.showWrapOption("WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES", "Groups inside values expression");
        }

        protected void customizeSettings() {
        }
    }

    private class SqlIndentOptionsWrapper
    extends TabbedLanguageCodeStylePanel.MyIndentOptionsWrapper {
        protected SqlIndentOptionsWrapper(CodeStyleSettings settings, LanguageCodeStyleSettingsProvider provider, IndentOptionsEditor editor) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings, provider, editor);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }

    private class SqlBlankLinesPanel
    extends TabbedLanguageCodeStylePanel.MyBlankLinesPanel {
        public SqlBlankLinesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }

    class SqlSpacesPanel
    extends TabbedLanguageCodeStylePanel.MySpacesPanel {
        public SqlSpacesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        protected void initTables() {
            Map settingsMap = CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
            for (Map.Entry entry : settingsMap.entrySet()) {
                String groupName = ((CodeStyleSettingPresentation.SettingsGroup)entry.getKey()).name;
                if (groupName == null || groupName.contains("Operators")) continue;
                for (CodeStyleSettingPresentation setting : (List)entry.getValue()) {
                    this.initBooleanField(setting.getFieldName(), setting.getUiName(), groupName);
                }
            }
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }
}

