/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlPreviewExamples;
import com.intellij.sql.psi.SqlLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return sqlLanguage;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text2) {
        return SqlCodeStyleMainPanel.createSqlFile(project, text2);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return SqlPreviewExamples.read(settingsType);
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings sqlSettings = new CommonCodeStyleSettings(this.getLanguage());
        sqlSettings.KEEP_FIRST_COLUMN_COMMENT = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = sqlSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.TAB_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        return sqlSettings;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer2 == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_PARENTHESES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA"});
            consumer2.showCustomOption(SqlCodeStyleSettings.class, "SPACES_AROUND_OPERATORS", "Spaces around operators", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer2.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", "Call parentheses");
            consumer2.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", "Call parentheses");
            consumer2.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", "Declaration parentheses");
            consumer2.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", "Declaration parentheses");
            consumer2.renameStandardOption("SPACE_WITHIN_PARENTHESES", "Parentheses expression");
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShortLowercaseCodeStyle
    extends PredefinedCodeStyle {
        public ShortLowercaseCodeStyle() {
            super("Short with Lowercase", (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
            sqlSettings.KEYWORD_CASE = 1;
        }
    }

    private static class ShortUppercaseCodeStyle
    extends PredefinedCodeStyle {
        public ShortUppercaseCodeStyle() {
            super("Short with Uppercase", (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
            sqlSettings.KEYWORD_CASE = 0;
        }
    }
}

