/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SqlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SqlAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof IsExternal) {
            holder.createInfoAnnotation(element, null).setTextAttributes(SqlSyntaxHighlighter.SQL_EXTERNAL_TOOL);
        } else if (element instanceof SqlElement) {
            ((SqlElement)element).accept((SqlVisitor)new Visitor(holder));
        }
    }

    @Nullable
    public static PsiElement getTargetElement(SqlIdentifier o) {
        PsiElement parent = o.getParent();
        PsiElement candidate = parent instanceof SqlDefinition && ((SqlDefinition)parent).getNameElement() == o ? parent : (parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).resolve() : null);
        return SqlAnnotator.getTargetElement(candidate);
    }

    private static PsiElement getTargetElement(PsiElement candidate) {
        DasObject result2;
        if (candidate instanceof DasSynonym && ((DasSynonym)candidate).getKind() == SqlDbElementType.SYNONYM && ((result2 = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)candidate))) == null || result2 instanceof PsiElement)) {
            return (PsiElement)result2;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/highlighting/SqlAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends SqlVisitor {
        private final AnnotationHolder myHolder;

        public Visitor(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        protected final void setHighlighting(@NotNull PsiElement element, TextAttributesKey key2) {
            ASTNode node;
            ASTNode firstChild;
            if (element == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            ASTNode aSTNode = firstChild = (node = element.getNode()) == null ? null : node.getFirstChildNode();
            if (firstChild != null && firstChild.getElementType() instanceof SqlKeywordTokenType) {
                this.myHolder.createInfoAnnotation(element, null).setEnforcedTextAttributes(TextAttributes.ERASE_MARKER);
            }
            this.myHolder.createInfoAnnotation(element, null).setTextAttributes(key2);
        }

        public void visitSqlIdentifier(SqlIdentifier o) {
            this.highlightDefinitionElement(SqlAnnotator.getTargetElement(o), (SqlElement)o);
        }

        public void visitSqlTypeElement(SqlTypeElement o) {
            for (ASTNode node : o.getNode().getChildren(null)) {
                if (node.getElementType() == SqlTokens.SQL_LEFT_PAREN) break;
                if (!(node.getElementType() instanceof SqlKeywordTokenType)) continue;
                PsiElement psi = node.getPsi();
                this.myHolder.createInfoAnnotation(psi, null).setEnforcedTextAttributes(TextAttributes.ERASE_MARKER);
                this.setHighlighting(psi, SqlSyntaxHighlighter.SQL_TYPE);
            }
        }

        public void visitSqlReferenceExpression(SqlReferenceExpression o) {
            SqlIdentifier identifier = o.getIdentifier();
            SqlExpression qualifier = o.getQualifierExpression();
            if (identifier == null && qualifier == null) {
                this.highlightDefinitionElement(SqlAnnotator.getTargetElement(o.resolve()), (SqlElement)o);
            }
        }

        public void visitSqlStringLiteralExpression(SqlStringLiteralExpression o) {
            PsiReference ref = o.getReference();
            if (ref != null) {
                this.highlightDefinitionElement(ref.resolve(), (SqlElement)o);
            }
        }

        public void visitSqlParameter(SqlParameter o) {
            this.highlightDefinitionElement((PsiElement)o, (SqlElement)o);
        }

        private void highlightDefinitionElement(PsiElement target, SqlElement elementToHighlight) {
            if (target == null) {
                return;
            }
            if (target instanceof SqlReferenceExpression) {
                if (elementToHighlight.getParent() == target) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_SYNTHETIC_ENTITY);
                } else if (DbImplUtil.isRoutine(((SqlReferenceExpression)target).getReferenceElementType().getTargetKind()) || DbImplUtil.isRoutine(SqlScopeProcessor.getElementType(((SqlReferenceExpression)target).resolve()))) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PROCEDURE);
                } else {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_DATABASE_OBJECT);
                }
            } else if (target instanceof PomTargetPsiElement) {
                PomTarget t = ((PomTargetPsiElement)target).getTarget();
                if (t instanceof BuiltinFunction) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PROCEDURE);
                } else {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_DATABASE_OBJECT);
                }
            } else if (target instanceof SqlDefinition) {
                ObjectKind definitionType = ((SqlDefinition)target).getKind();
                if (definitionType == SqlDbElementType.SCHEMA) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_SCHEMA);
                } else if (definitionType == SqlDbElementType.TABLE) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_TABLE);
                } else if (definitionType == SqlDbElementType.COLUMN) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_COLUMN);
                } else if (definitionType == SqlDbElementType.LOCAL_ALIAS) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_LOCAL_ALIAS);
                } else if (definitionType == SqlDbElementType.QUERY_PARAMETER) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PARAMETER);
                } else if (definitionType == SqlDbElementType.ARGUMENT) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_VARIABLE);
                } else if (definitionType == SqlDbElementType.VARIABLE) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_VARIABLE);
                } else if (definitionType == SqlDbElementType.LABEL) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_LABEL);
                } else if (DbImplUtil.isRoutine(definitionType)) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PROCEDURE);
                }
            } else if (target instanceof SqlFunctionCallExpression) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PROCEDURE);
            } else if (target instanceof SqlParameter) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PARAMETER);
            } else if (target instanceof DasColumn) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_COLUMN);
            } else if (target instanceof DasTable) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_TABLE);
            } else if (target instanceof DasRoutine) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_PROCEDURE);
            } else if (target instanceof DasNamespace) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_SCHEMA);
            } else if (target instanceof DasUserDefinedType) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_TYPE);
            } else {
                this.setHighlighting((PsiElement)elementToHighlight, SqlSyntaxHighlighter.SQL_DATABASE_OBJECT);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/highlighting/SqlAnnotator$Visitor", "setHighlighting"));
        }
    }
}

