/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.psi.DbPsiFacade;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinExpressionImpl
extends SqlBinaryExpressionImpl
implements SqlJoinExpression {
    private volatile CachedValue<SqlTableType> myType;

    public SqlJoinExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlJoinExpression((SqlJoinExpression)this);
    }

    @Override
    @NotNull
    public PsiElement getOpSignElement() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (!(type instanceof SqlKeywordTokenType) && type != SqlTokens.SQL_COMMA) continue;
            PsiElement psiElement = child.getPsi();
            if (psiElement == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public IElementType getOpSign() {
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_JOIN;
        if (sqlTokenType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(2);
        }
        return sqlTokenType;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myType = null;
    }

    @NotNull
    public SqlTableType getSqlType() {
        if (this.myType == null) {
            this.myType = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.calcType(null), (Object[])new Object[]{this, DbPsiFacade.getInstance((Project)this.getProject())}), false);
        }
        SqlTableType sqlTableType = (SqlTableType)this.myType.getValue();
        if (sqlTableType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(3);
        }
        return sqlTableType;
    }

    @NotNull
    public SqlTableType getSqlType(@Nullable PsiElement end) {
        if (end == null || !PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)end, (boolean)true)) {
            SqlTableType sqlTableType = this.getSqlType();
            if (sqlTableType == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = this.calcType(end);
        if (sqlTableType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(5);
        }
        return sqlTableType;
    }

    @NotNull
    public static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end) {
        if (expression == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(6);
        }
        if (expression instanceof SqlLateralAwareExpression) {
            SqlType sqlType = ((SqlLateralAwareExpression)expression).getSqlType(end);
            if (sqlType == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(7);
            }
            return sqlType;
        }
        Object object = expression == lastToCheck ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType();
        if (object == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    protected SqlTableType calcType(@Nullable PsiElement end) {
        PsiElement natural;
        SqlUsingClause using;
        SqlTableType expressionType;
        PsiElement lastToCheck = this.getLastToCheck(end);
        SqlExpression lOperand = this.getLOperand();
        SqlType lType = SqlJoinExpressionImpl.getTypeLateralAware(lOperand, lastToCheck, end);
        SqlTableType sqlTableType = expressionType = lType instanceof SqlTableType ? (SqlTableType)lType : SqlTableTypeBase.EMPTY_TABLE;
        if (lOperand != lastToCheck) {
            for (PsiElement child = lOperand.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (child instanceof SqlExpression) {
                    SqlExpression operand = (SqlExpression)child;
                    SqlType sqlType = SqlJoinExpressionImpl.getTypeLateralAware(operand, lastToCheck, end);
                    expressionType = expressionType.join(SqlTableTypeBase.ensureTableType(sqlType, (SqlElement)operand, (PsiElement)this));
                }
                if (child == lastToCheck) break;
            }
        }
        if ((using = (SqlUsingClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlUsingClause.class)) != null) {
            SqlReferenceList refList = using.getReferenceList();
            List list = refList != null ? refList.getReferenceList() : ContainerUtil.emptyList();
            for (SqlReferenceExpression expression : list) {
                PsiElement resolve = expression.resolve();
                if (resolve == null) continue;
                int count2 = expressionType.getColumnCount();
                ArrayList<PsiElement> unionColumns = new ArrayList<PsiElement>();
                for (int i2 = 0; i2 < count2; ++i2) {
                    PsiElement target;
                    PsiElement element = expressionType.getColumnElement(i2);
                    PsiElement psiElement = target = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
                    if (!resolve.isEquivalentTo(target)) continue;
                    unionColumns.add(element);
                    break;
                }
                for (PsiElement element : unionColumns) {
                    expressionType = expressionType.subtract(element);
                }
            }
        }
        if ((natural = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_NATURAL)) != null) {
            int count3 = expressionType.getColumnCount();
            MultiMap map = MultiMap.create((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (int i3 = 0; i3 < count3; ++i3) {
                String name = expressionType.getColumnName(i3);
                PsiElement element = expressionType.getColumnElement(i3);
                map.putValue((Object)StringUtil.notNullize((String)name), (Object)element);
            }
            for (Map.Entry entry : map.entrySet()) {
                Collection value = (Collection)entry.getValue();
                if (value.size() != 2) continue;
                expressionType = expressionType.subtract((PsiElement)ContainerUtil.getFirstItem((Collection)value));
            }
        }
        SqlTableType sqlTableType2 = expressionType;
        if (sqlTableType2 == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(9);
        }
        return sqlTableType2;
    }

    @Nullable
    protected PsiElement getLastToCheck(@Nullable PsiElement end) {
        PsiElement lastToCheck;
        for (lastToCheck = end; lastToCheck != null && lastToCheck.getContext() != this; lastToCheck = lastToCheck.getContext()) {
        }
        return lastToCheck;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        boolean fromAlias;
        if (processor == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(10);
        }
        if (state == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(12);
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)place, (boolean)false)) {
            return true;
        }
        boolean bl = fromAlias = lastParent instanceof SqlExpression && lastParent.getParent() == this;
        if (!fromAlias) {
            if (lastParent instanceof SqlUsingClause || lastParent instanceof SqlJoinConditionClause) {
                if (!SqlImplUtil.processDeclarationsInType(this.getLOperand(), processor, state, place)) {
                    return false;
                }
                SqlExpression rOperand = this.getROperand();
                if (rOperand != null && !SqlImplUtil.processDeclarationsInType(rOperand, processor, state, place)) {
                    return false;
                }
            } else if (!SqlImplUtil.processDeclarationsInType(this, processor, state, place)) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlJoinExpressionImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlJoinExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpSignElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpSign";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

