/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlScriptModel<E>
extends ScriptModel<E> {
    private final Script<E> myScript;

    public SqlScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            SqlScriptModel.$$$reportNull$$$0(0);
        }
        this(SqlScriptModel.newScriptFor(file));
    }

    private SqlScriptModel(@NotNull Script<E> script) {
        if (script == null) {
            SqlScriptModel.$$$reportNull$$$0(1);
        }
        this.myScript = script;
    }

    @NotNull
    private static <E> Script<E> newScriptFor(@NotNull PsiFile file) {
        Document document;
        if (file == null) {
            SqlScriptModel.$$$reportNull$$$0(2);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        Document document2 = document = SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null) {
            TrackingDocScript trackingDocScript = new TrackingDocScript(project, virtualFile, document);
            if (trackingDocScript == null) {
                SqlScriptModel.$$$reportNull$$$0(3);
            }
            return trackingDocScript;
        }
        FileScript fileScript = new FileScript(project, virtualFile, null);
        if (fileScript == null) {
            SqlScriptModel.$$$reportNull$$$0(4);
        }
        return fileScript;
    }

    @NotNull
    private Project getProject() {
        Project project = this.myScript.project;
        if (project == null) {
            SqlScriptModel.$$$reportNull$$$0(5);
        }
        return project;
    }

    public VirtualFile getVirtualFile() {
        return this.myScript.vFile;
    }

    public SqlScriptModel<E> subModel(@Nullable TextRange range) {
        return new SqlScriptModel<E>(this.myScript.subScript(range));
    }

    public JBIterable<? extends ScriptModel.StatementIt<E>> statements() {
        return new SIt(this.myScript.getScript(), this.TO_STATEMENTS()).cursor();
    }

    public JBIterable<? extends ScriptModel.ParamIt<E>> parameters() {
        return new PIt(this.myScript.getScript(), this.TO_PARAMETERS()).cursor();
    }

    public TextRange getTextRange() {
        return this.myScript.range;
    }

    public void dispose() {
        super.dispose();
        if (this.myScript instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myScript));
        }
    }

    @NotNull
    private <V> Function<SyntaxTraverser<V>, SyntaxTraverser<V>> TO_STATEMENTS() {
        Function function = s -> SqlScriptModel.statementsImpl(this.myScript, s);
        if (function == null) {
            SqlScriptModel.$$$reportNull$$$0(6);
        }
        return function;
    }

    @NotNull
    private <V> Function<SyntaxTraverser<V>, Iterable<V>> TO_PARAMETERS() {
        Function function = s -> SqlScriptModel.parametersImpl(this.myScript, s);
        if (function == null) {
            SqlScriptModel.$$$reportNull$$$0(7);
        }
        return function;
    }

    private static <V> SyntaxTraverser<V> statementsImpl(final Script script, final SyntaxTraverser<V> s) {
        if (script.range == null) {
            return s;
        }
        boolean positionOrChosen = script.range instanceof ScriptModel.PositionRange || script.range instanceof ScriptModel.ChosenRange;
        final SqlLanguageDialect dialect = script.getDialect();
        final int offset = ScriptModelUtil.getPartOffsetAsInt(s);
        final boolean leavesOnly = !positionOrChosen && script.range.getLength() > 0;
        Condition filter = Conditions.and2((Condition)Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class, SqlResultSetExpression.class}), (Condition)Conditions.not((Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.or2((Condition)Conditions.is((Object)SqlElementTypes.SQL_DUMMY_BLOCK), (Condition)Conditions.instanceOf((Class[])new Class[]{SqlLazyElementType.class, IsExternal.class})))));
        Condition<SqlStatement> fileFilter = ScriptModelUtil.wholeFileCondition(s.forceDisregardTypes(Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK)), script.range, (Condition<IElementType>)((Condition)type -> SqlTokens.WS_OR_COMMENTS.contains(type) || type == SqlCommonKeywords.SQL_GO), SqlStatement.class);
        final Condition resultFilter = Conditions.or2((Condition)filter, fileFilter);
        SyntaxTraverser adjusted = (SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).filter(resultFilter)).regard(filter)).regard((Condition)new FilteredTraverserBase.EdgeFilter<V>(){

            public boolean value(V v) {
                Object parent;
                IElementType type = s.api.typeOf(v);
                if (type == SqlCompositeElementTypes.SQL_BATCH_BLOCK && ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).withRoot(v)).expandAndSkip(Conditions.is(v))).filter(Conditions.instanceOf(SqlStatement.class))).traverse().take(2).size() < 2) {
                    return false;
                }
                Object object = parent = this.edgeSource != null && resultFilter.value(this.edgeSource) ? this.edgeSource : null;
                if (parent == null) {
                    return true;
                }
                TextRange vr = s.api.rangeOf(v);
                TextRange pr = s.api.rangeOf(parent);
                if (leavesOnly && v instanceof SqlResultSetExpression) {
                    return false;
                }
                if (type == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT && parent instanceof SqlDefinition && !dialect.getDatabaseDialect().getFamilyId().isTransactSql()) {
                    return false;
                }
                if (script.range.contains(pr.shiftRight(offset))) {
                    return false;
                }
                return !pr.equals((Object)vr);
            }
        });
        SyntaxTraverser ranged = ScriptModelUtil.inRange(adjusted, script.range);
        return (SyntaxTraverser)ranged.withTraversal(leavesOnly ? TreeTraversal.LEAVES_DFS : TreeTraversal.PRE_ORDER_DFS);
    }

    @NotNull
    protected static <V> JBIterable<V> parametersImpl(Script script, SyntaxTraverser<V> s) {
        DatabaseFamilyId familyId = script.getDialect().getDatabaseDialect().getFamilyId();
        Condition canHaveParams = v -> SqlScriptModel.canHaveParameters(v, s.api);
        Condition isParameter = v -> SqlScriptModel.isParameter(v, s, familyId);
        Function statementParams = v -> (SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).withRoot(v)).expand(canHaveParams)).filter(isParameter);
        JBIterable jBIterable = SqlScriptModel.statementsImpl(script, s).traverse().flatten(statement -> ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).withRoot(statement)).expand(Conditions.not((Condition)Conditions.and2((Condition)canHaveParams, (Condition)Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class, SqlResultSetExpression.class}))))).filter(canHaveParams)).traverse().flatten(statementParams).unique());
        if (jBIterable == null) {
            SqlScriptModel.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    private static SqlLanguageDialect getSqlDialect(@NotNull VirtualFile vFile, Project project) {
        Language language;
        if (vFile == null) {
            SqlScriptModel.$$$reportNull$$$0(9);
        }
        SqlLanguageDialect sqlLanguageDialect = (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)vFile)) instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : SqlLanguageSubstitutor.getSqlLanguage(vFile, project);
        if (sqlLanguageDialect == null) {
            SqlScriptModel.$$$reportNull$$$0(10);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public <EE> ScriptModel<EE> rawTransform(Function<SyntaxTraverser<E>, SyntaxTraverser<EE>> function) {
        class A
        extends Script<EE> {
            final Script<E> delegate;
            final /* synthetic */ Function val$function;
            final /* synthetic */ SqlScriptModel this$0;

            public A(Script<E> delegate) {
                this.this$0 = this$0;
                this.val$function = var3_3;
                super(delegate.project, delegate.vFile, delegate.range);
                this.delegate = delegate;
            }

            @Override
            JBIterable<SyntaxTraverser<EE>> getScript() {
                return this.delegate.getScript().transform(this.val$function);
            }

            @Override
            Script<EE> subScript(@Nullable TextRange range) {
                return new A(this.this$0, this.delegate.subScript(range), this.val$function);
            }

            @Override
            UserDataHolder getParamDataHolder() {
                return this.delegate.getParamDataHolder();
            }
        }
        SqlScriptModel<E> sqlScriptModel = new SqlScriptModel<E>(new A(this, this.myScript.subScript(this.myScript.range), function));
        if (sqlScriptModel == null) {
            SqlScriptModel.$$$reportNull$$$0(11);
        }
        return sqlScriptModel;
    }

    private static <V> boolean canHaveParameters(V node, SyntaxTraverser.Api<V> api) {
        IElementType type = api.typeOf(node);
        if (type instanceof SqlTokenType) {
            return false;
        }
        if (type == SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT) {
            return true;
        }
        return type != SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    private static <V> boolean isParameter(V node, SyntaxTraverser<V> s, DatabaseFamilyId familyId) {
        SyntaxTraverser.Api api = s.api;
        IElementType type = api.typeOf(node);
        boolean result2 = type == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
        if ((result2 |= type == SqlTokens.SQL_EXTERNAL_PARAM) && familyId.isOracle() && s.api.parents(node).transform(api.TO_TYPE).contains((Object)SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT)) {
            CharSequence text2 = api.textOf(node);
            return !"?".contentEquals(text2) && !StringUtil.startsWith((CharSequence)text2, (CharSequence)":");
        }
        return result2;
    }

    private Object statementType(@NotNull ScriptModel.StatementIt it, @NotNull JdbcConsole console) {
        if (it == null) {
            SqlScriptModel.$$$reportNull$$$0(12);
        }
        if (console == null) {
            SqlScriptModel.$$$reportNull$$$0(13);
        }
        return DbSqlUtil.parseQueryType(this.getProject(), this.myScript.getDialect(), DbSqlUtil.getDbDataSource(this.getProject(), console.getDataSource()), console.getSearchPath(), it.text(), this.myScript.getHostLanguage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/script/SqlScriptModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/script/SqlScriptModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newScriptFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "TO_STATEMENTS";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "TO_PARAMETERS";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parametersImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "rawTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newScriptFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "statementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PIt
    extends MIt<PIt>
    implements ScriptModel.ParamIt<E> {
        public PIt(JBIterable<SyntaxTraverser<E>> s, Function<SyntaxTraverser<E>, Iterable<E>> transform) {
            super(s, transform);
        }

        public String displayName() {
            String base = this.nameBase();
            return base != null ? base : this.adjustName(null);
        }

        public Iterable<String> description() {
            return ScriptModelUtil.getRelativeSnippet(this.current(), this.traverser.api);
        }

        public String name() {
            return this.adjustName(this.nameBase());
        }

        @NotNull
        protected String adjustName(String base) {
            String known = ScriptModelUtil.ParamHelper.getParameterId(this, base, SqlScriptModel.this.myScript.getParamDataHolder());
            String string = known != null ? known : (base != null ? base : this.text() + " #" + ((long)this.range().getStartOffset() + this.rangeOffset()));
            if (string == null) {
                PIt.$$$reportNull$$$0(0);
            }
            return string;
        }

        private String nameBase() {
            Object o = this.current();
            String name = o instanceof SqlParameter ? ((SqlParameter)o).getName() : null;
            return StringUtil.nullize((String)name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$PIt", "adjustName"));
        }
    }

    private class SIt
    extends MIt<SIt>
    implements ScriptModel.StatementIt<E> {
        SIt(JBIterable<SyntaxTraverser<E>> s, Function<SyntaxTraverser<E>, ? extends Iterable<E>> transform) {
            super(s, transform);
        }

        public String text(ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<E>> paramCondition) {
            return ScriptModelUtil.statementText(this, storage, paramCondition);
        }

        public Object resultType(Object target) {
            return SqlScriptModel.this.statementType(this, (JdbcConsole)target);
        }

        public JBIterable<? extends ScriptModel.ParamIt<E>> parameters() {
            return new PIt(JBIterable.of((Object)this.traverser.withRoot(this.current())), SqlScriptModel.this.TO_PARAMETERS()).cursor();
        }
    }

    private class MIt<Self extends MIt<Self>>
    extends ScriptModel.ModelItBase<E, Self> {
        long rangeOffset;
        JBIterator<E> vIt;
        SyntaxTraverser<E> nextTr;

        MIt(JBIterable<SyntaxTraverser<E>> s, Function<SyntaxTraverser<E>, ? extends Iterable<E>> transform) {
            this.vIt = JBIterator.from((Iterator)s.flatten(vs -> {
                this.nextTr = vs;
                return (Iterable)transform.fun(vs);
            }).iterator());
        }

        protected E nextImpl() {
            return this.vIt.hasNext() ? this.vIt.next() : this.stop();
        }

        protected void currentChanged() {
            if (this.nextTr == null) {
                return;
            }
            this.traverser = this.nextTr;
            this.nextTr = null;
            this.rangeOffset = ScriptModelUtil.getPartOffset(this.traverser);
        }

        public long rangeOffset() {
            return this.rangeOffset;
        }
    }

    private static class FileScript
    extends ScriptBase<PsiElement, FileScript>
    implements Disposable {
        FileScript(Project project, VirtualFile virtualFile, TextRange range) {
            super(project, virtualFile, range);
        }

        @Override
        FileScript subScript(@Nullable TextRange range) {
            return new FileScript(this.project, this.vFile, range);
        }

        @Override
        UserDataHolder getParamDataHolder() {
            return this.vFile;
        }

        @Override
        JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            boolean atPosition = this.range instanceof ScriptModel.PositionRange;
            boolean inRange = !atPosition && this.range != null && this.range.getLength() > 0;
            JBIterable result2 = SqlReaderImpl.parseSql(this.project, this.getDialect(), this.vFile, this);
            if (inRange) {
                result2 = result2.transform(ScriptModelUtil.LIMIT_TO_RANGE(this.range));
            }
            return result2;
        }

        public void dispose() {
        }
    }

    private static class SealedDocScript
    extends DocScript {
        final SealedDocScript parent;
        final SqlLanguageDialect dialect;
        final CharSequence text;
        final long timeStamp;
        final long settingsModificationCount;
        SyntaxTraverser<PsiElement> raw;
        JBIterable<SyntaxTraverser<PsiElement>> cached;

        SealedDocScript(Project project, VirtualFile file, Document document, SqlLanguageDialect dialect, long settingsModificationCount) {
            super(project, file, document);
            this.text = document.getImmutableCharSequence();
            this.timeStamp = document.getModificationStamp();
            this.dialect = dialect;
            this.settingsModificationCount = settingsModificationCount;
            this.parent = null;
        }

        SealedDocScript(SealedDocScript sealed, TextRange range) {
            super(sealed, range);
            this.text = sealed.text;
            this.timeStamp = sealed.timeStamp;
            this.dialect = sealed.dialect;
            this.parent = sealed;
            this.settingsModificationCount = sealed.settingsModificationCount;
        }

        @Override
        SqlLanguageDialect getDialect() {
            return this.dialect;
        }

        @Override
        @NotNull
        JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            JBIterable<SyntaxTraverser<PsiElement>> jBIterable = this.cached != null ? this.cached : (this.cached = this.getScriptImpl());
            if (jBIterable == null) {
                SealedDocScript.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        @Override
        DocScript subScript(@Nullable TextRange range) {
            SealedDocScript p = this.parent == null ? this : this.parent;
            return range == null ? p : new SealedDocScript(p, range);
        }

        @NotNull
        SyntaxTraverser<PsiElement> parseRaw() {
            SyntaxTraverser<PsiElement> syntaxTraverser;
            if (this.parent != null) {
                syntaxTraverser = this.parent.parseRaw();
            } else if (this.raw != null) {
                syntaxTraverser = this.raw;
            } else {
                this.raw = SealedDocScript.parseImpl(this.project, this.dialect, this.text, this.getHostLanguage());
                syntaxTraverser = this.raw;
            }
            if (syntaxTraverser == null) {
                SealedDocScript.$$$reportNull$$$0(1);
            }
            return syntaxTraverser;
        }

        @NotNull
        static SyntaxTraverser<PsiElement> parseImpl(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CharSequence documentText, @Nullable Language hostLanguage) {
            if (project == null) {
                SealedDocScript.$$$reportNull$$$0(2);
            }
            if (dialect == null) {
                SealedDocScript.$$$reportNull$$$0(3);
            }
            if (documentText == null) {
                SealedDocScript.$$$reportNull$$$0(4);
            }
            SqlFile file = SqlPsiElementFactory.createROFileFromText(documentText, dialect, project, hostLanguage);
            SyntaxTraverser syntaxTraverser = SqlReaderImpl.getStatementTraverser(SyntaxTraverser.psiTraverser((PsiElement)file));
            if (syntaxTraverser == null) {
                SealedDocScript.$$$reportNull$$$0(5);
            }
            return syntaxTraverser;
        }

        @NotNull
        JBIterable<SyntaxTraverser<PsiElement>> getScriptImpl() {
            boolean positionOrChosen = this.range instanceof ScriptModel.PositionRange || this.range instanceof ScriptModel.ChosenRange;
            boolean inRange = !positionOrChosen && this.range != null;
            Language hostLanguage = this.getHostLanguage();
            this.raw = this.parseRaw();
            if (inRange) {
                boolean justOne;
                boolean singleBatch;
                JBIterable adjusted = SqlScriptModel.statementsImpl(this, this.raw).traverse();
                boolean bl = singleBatch = this.dialect.getDatabaseDialect().getFamilyId().isTransactSql() && adjusted.filter(SqlBatchBlock.class).isEmpty();
                int selectionOption = this.range instanceof ScriptModel.StrictRange ? 1 : (this.range instanceof ScriptModel.SmartRange ? 3 : 2);
                boolean bl2 = justOne = selectionOption == 1 || selectionOption == 2 || adjusted.take(2).size() == 1 || singleBatch && adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtil.IN_RANGE(this.range))).isEmpty() || adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtil.CONTAINS_RANGE(this.range))).isEmpty();
                if (justOne) {
                    PsiElement first;
                    SyntaxTraverser<PsiElement> exact = SealedDocScript.parseImpl(this.project, this.dialect, this.range.subSequence(this.text), hostLanguage);
                    exact.putUserData(ScriptModelUtil.PART_OFFSET, (Object)this.range.getStartOffset());
                    if (selectionOption == 3 && adjusted.take(2).size() == 1 && ((first = (PsiElement)exact.traverse().first()) == null || first.getTextRange().getStartOffset() != 0)) {
                        JBIterable jBIterable = JBIterable.of(this.raw);
                        if (jBIterable == null) {
                            SealedDocScript.$$$reportNull$$$0(6);
                        }
                        return jBIterable;
                    }
                    JBIterable jBIterable = JBIterable.of(exact);
                    if (jBIterable == null) {
                        SealedDocScript.$$$reportNull$$$0(7);
                    }
                    return jBIterable;
                }
            }
            JBIterable jBIterable = JBIterable.of(this.raw);
            if (jBIterable == null) {
                SealedDocScript.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/script/SqlScriptModel$SealedDocScript";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documentText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScript";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseRaw";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/script/SqlScriptModel$SealedDocScript";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseImpl";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScriptImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "parseImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TrackingDocScript
    extends DocScript {
        SealedDocScript sealed;

        TrackingDocScript(Project project, VirtualFile file, Document document) {
            super(project, file, document);
        }

        @Override
        DocScript subScript(@Nullable TextRange range) {
            return this.getSealed().subScript(range);
        }

        @Override
        JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            return this.getSealed().getScript();
        }

        SealedDocScript getSealed() {
            SqlLanguageDialect dialect = this.getDialect();
            long settingsModificationCount = DatabaseSettings.getSettings().getModificationCount();
            if (this.sealed == null || this.sealed.timeStamp != this.document.getModificationStamp() || this.sealed.settingsModificationCount != settingsModificationCount || this.sealed.dialect != dialect) {
                this.sealed = new SealedDocScript(this.project, this.vFile, this.document, dialect, settingsModificationCount);
            }
            return this.sealed;
        }
    }

    private static abstract class DocScript
    extends ScriptBase<PsiElement, DocScript> {
        final Document document;

        DocScript(Project project, VirtualFile file, Document document) {
            super(project, file, null);
            this.document = document;
        }

        DocScript(DocScript script, TextRange range) {
            super(script.project, script.vFile, range);
            this.document = script.document;
        }

        @Override
        UserDataHolder getParamDataHolder() {
            return this.document;
        }
    }

    private static abstract class ScriptBase<V, Self extends ScriptBase<V, Self>>
    extends Script<V> {
        ScriptBase(Project project, VirtualFile file, TextRange range) {
            super(project, file, range);
        }

        @Override
        abstract JBIterable<SyntaxTraverser<V>> getScript();

        abstract Self subScript(@Nullable TextRange var1);
    }

    private static abstract class Script<V> {
        final Project project;
        final VirtualFile vFile;
        final TextRange range;

        private Script(Project project, VirtualFile vFile, TextRange range) {
            this.project = project;
            this.vFile = vFile;
            this.range = range;
        }

        SqlLanguageDialect getDialect() {
            return SqlScriptModel.getSqlDialect(this.vFile, this.project);
        }

        abstract JBIterable<SyntaxTraverser<V>> getScript();

        abstract Script<V> subScript(@Nullable TextRange var1);

        abstract UserDataHolder getParamDataHolder();

        @Nullable
        Language getHostLanguage() {
            VirtualFile virtualFile = this.vFile;
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            return Comparing.equal((Object)virtualFile, (Object)this.vFile) ? null : LanguageUtil.getFileLanguage((VirtualFile)virtualFile);
        }
    }
}

