/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.idea.RareLogger;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeJSRemoteSdkCredentials;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.remote.CreateRemoteNodeJSInterpreterDialog;
import com.jetbrains.nodejs.remote.NodeJSCredentialsContribution;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodeRemoteTransferImpl;
import com.jetbrains.nodejs.remote.RemoteInterpreters;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.MappingsGatherer;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsField;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRemoteInterpreterManagerImpl
extends NodeJSRemoteInterpreterManager {
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManagerImpl"), (boolean)false);
    public static final String NODE_JS = "NodeJS";
    private final RemoteInterpreters myInterpreters;

    public NodeJSRemoteInterpreterManagerImpl(RemoteInterpreters interpreters) {
        this.myInterpreters = interpreters;
    }

    public RemoteSdkCredentialsProducer<NodeJSRemoteSdkCredentials> getRemoteSdkCredentialsProducer(Function<RemoteCredentials, NodeJSRemoteSdkCredentials> credentialsTransformer, RemoteConnectionCredentialsWrapper connectionWrapper) {
        return new RemoteSdkCredentialsProducerImpl(credentialsTransformer, connectionWrapper, true);
    }

    @Nullable
    public String createRemoteInterpreter(Project project) {
        CreateRemoteNodeJSInterpreterDialog dialog = new CreateRemoteNodeJSInterpreterDialog(project);
        dialog.setExistingSdks(this.getRemoteInterpreters());
        if (dialog.showAndGet()) {
            NodeJSRemoteSdkAdditionalData data = dialog.getData();
            this.myInterpreters.add(data);
            return data.getSdkId();
        }
        return null;
    }

    public List<String> getRemoteInterpreters() {
        List<NodeJSRemoteSdkAdditionalData> interpreters = this.myInterpreters.getInterpreters();
        if (interpreters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            result.add(interpreter.getSdkId());
        }
        return result;
    }

    @Nullable
    public SemVer getNodeVersionCached(@NotNull NodeJsRemoteInterpreter interpreter) {
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        try {
            NodeJSRemoteSdkAdditionalData data = (NodeJSRemoteSdkAdditionalData)this.getRemoteSdkAdditionalData(null, interpreter.getRemoteUrl());
            return SemVer.parseFromText((String)data.getVersionString());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public SemVer getNodeVersion(@Nullable Project project, @NotNull NodeJSRemoteSdkCredentials credentials) throws RemoteSdkException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (credentials == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        if ((output = RemoteSdkUtil.getProcessOutput((Project)project, (RemoteSdkCredentials)credentials, (GeneralCommandLine)(command = new GeneralCommandLine(new String[]{credentials.getInterpreterPath(), "-v"})))).getExitCode() != 0) {
            LOG.info("Can not get node version for path: " + credentials.getInterpreterPath() + ", process exit code = " + output.getExitCode() + "\n" + output.getStderr());
            return null;
        }
        String stdout = output.getStdout().trim();
        return SemVer.parseFromText((String)StringUtil.trimStart((String)stdout, (String)"v"));
    }

    @NotNull
    public NodeJSRemoteSdkCredentials getCredentialsByInterpreter(@NotNull NodeJsRemoteInterpreter interpreter) throws RemoteSdkException, InterruptedException {
        NodeJSRemoteSdkCredentials nodeJSRemoteSdkCredentials;
        NodeJSRemoteSdkAdditionalData data;
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        if ((data = this.getRemoteSdkAdditionalDataImpl(interpreter.getRemoteUrl())) == null) {
            throw NodeJSRemoteInterpreterManagerImpl.remoteInterpreterNotFound(interpreter);
        }
        try {
            nodeJSRemoteSdkCredentials = data.getRemoteSdkCredentials();
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (nodeJSRemoteSdkCredentials == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        return nodeJSRemoteSdkCredentials;
    }

    @NotNull
    public RemoteSdkAdditionalData getRemoteSdkAdditionalData(@Nullable Project project, @NotNull String interpreterId) throws ExecutionException {
        NodeJSRemoteSdkAdditionalData data;
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if ((data = this.getRemoteSdkAdditionalDataImpl(interpreterId)) != null) {
            if (project != null && data.getRemoteConnectionType() == CredentialsType.WEB_DEPLOYMENT) {
                RemoteSdkAdditionalData remoteSdkAdditionalData = NodeJSRemoteInterpreterManagerImpl.checkDeploymentExists(project, interpreterId, (RemoteSdkAdditionalData)data);
                if (remoteSdkAdditionalData == null) {
                    NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
                }
                return remoteSdkAdditionalData;
            }
            NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData = data;
            if (nodeJSRemoteSdkAdditionalData == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
            }
            return nodeJSRemoteSdkAdditionalData;
        }
        throw NodeJSRemoteInterpreterManagerImpl.remoteInterpreterNotFound(interpreterId);
    }

    @NotNull
    private static RemoteSdkAdditionalData checkDeploymentExists(@Nullable Project project, @NotNull String interpreterId, RemoteSdkAdditionalData data) throws ExecutionException {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        final Ref holder = Ref.create();
        data.connectionCredentials().switchType(new CredentialsCase[]{new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder credentials) {
                holder.set((Object)credentials);
            }
        }});
        if (!holder.isNull()) {
            String serverConfigId = ((WebDeploymentCredentialsHolder)holder.get()).getWebServerConfigId();
            List list = RemoteSdkUtil.getSftpServerList((Project)project);
            for (WebServerConfig config : list) {
                if (!Comparing.equal((String)config.getId(), (String)serverConfigId)) continue;
                RemoteSdkAdditionalData remoteSdkAdditionalData = data;
                if (remoteSdkAdditionalData == null) {
                    NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
                }
                return remoteSdkAdditionalData;
            }
        }
        throw new RemoteSdkException("There is no deployment configuration for remote interpreter " + interpreterId);
    }

    @Nullable
    private NodeJSRemoteSdkAdditionalData getRemoteSdkAdditionalDataImpl(@NotNull String interpreterId) {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)interpreterId);
        for (NodeJSRemoteSdkAdditionalData data : this.myInterpreters.getInterpreters()) {
            if (!StringUtil.equals((CharSequence)FileUtil.toSystemIndependentName((String)data.getSdkId()), (CharSequence)systemIndependentId)) continue;
            return data;
        }
        return null;
    }

    @NotNull
    public OSProcessHandler createProcessHandler(@NotNull Project project, @NotNull GeneralCommandLine commandLine, @NotNull NodeJsRemoteInterpreter interpreter, int debugPort, int profilingPort) throws InterruptedException, RemoteSdkException {
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        SmartList ports = new SmartList();
        if (debugPort >= 0) {
            ports.add(debugPort);
        }
        if (profilingPort >= 0) {
            ports.add(profilingPort);
        }
        OSProcessHandler oSProcessHandler = this.createProcessHandler(project, commandLine, interpreter, (List<Integer>)ports);
        if (oSProcessHandler == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        return oSProcessHandler;
    }

    @NotNull
    public OSProcessHandler createProcessHandler(final @NotNull Project project, @NotNull GeneralCommandLine commandLine, @NotNull NodeJsRemoteInterpreter interpreter, final @NotNull List<Integer> ports) throws InterruptedException, RemoteSdkException {
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        if (commandLine == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        if (ports == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        NodeJSRemoteSdkCredentials credentials = this.getCredentialsByInterpreter(interpreter);
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, (Project)project);
        SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true).start(60);
        final SshSession runProcessSession = process.getSession();
        final KillableColoredProcessHandler handler = new KillableColoredProcessHandler((Process)process, commandLine.getCommandLineString());
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    for (Integer port : ports) {
                        runProcessSession.addLocalTunnel(port.intValue(), "localhost", port.intValue());
                    }
                }
                catch (SshTransportException e) {
                    String message = "Unable to forward port: " + e.getMessage();
                    NodeUIUtil.balloonInfo((Project)project, (String)message, null, (MessageType)MessageType.WARNING);
                    LOG.info(message, (Throwable)e);
                    handler.killProcess();
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                try {
                    for (Integer port : ports) {
                        runProcessSession.removeLocalTunnel(port.intValue());
                    }
                }
                catch (SshTransportException e) {
                    String message = "Unable to remove port forwarding: " + e.getMessage();
                    NodeUIUtil.balloonInfo((Project)project, (String)message, null, (MessageType)MessageType.WARNING);
                    LOG.info(message, (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        KillableColoredProcessHandler killableColoredProcessHandler = handler;
        if (killableColoredProcessHandler == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private static RemoteSdkException remoteInterpreterNotFound(@NotNull NodeJsRemoteInterpreter interpreter) {
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
        }
        RemoteSdkException remoteSdkException = NodeJSRemoteInterpreterManagerImpl.remoteInterpreterNotFound(interpreter.getRemoteUrl());
        if (remoteSdkException == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
        }
        return remoteSdkException;
    }

    @NotNull
    private static RemoteSdkException remoteInterpreterNotFound(@NotNull String interpreterId) {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(21);
        }
        RemoteSdkException remoteSdkException = new RemoteSdkException("Remote interpreter " + interpreterId + " is not found.");
        if (remoteSdkException == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(22);
        }
        return remoteSdkException;
    }

    @NotNull
    public PathMappingSettings setupMappings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) throws ExecutionException {
        List list;
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(23);
        }
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(24);
        }
        try {
            list = new MappingsGatherer(project, data, NODE_JS).addDisabled(false).addUserDefined(true).assemble();
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
        PathMappingSettings pathMappingSettings = new PathMappingSettings(list);
        if (pathMappingSettings == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(25);
        }
        return pathMappingSettings;
    }

    private static boolean notMappedInternally(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(26);
        }
        return CredentialsType.SSH_HOST.equals(data.getRemoteConnectionType()) || CredentialsType.WEB_DEPLOYMENT.equals(data.getRemoteConnectionType());
    }

    @NotNull
    public NodeFileTransfer getFileTransfer(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) throws ExecutionException {
        NodeRemoteTransferImpl nodeRemoteTransferImpl;
        block4: {
            if (project == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(27);
            }
            if (data == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(28);
            }
            try {
                PathMappingSettings pathMappingSettings = this.setupMappings(project, data);
                nodeRemoteTransferImpl = new NodeRemoteTransferImpl(project, null, RemoteSdkUtil.newHelpersTransferConfigFromRemoteCredentials((RemoteSdkCredentials)data.getRemoteSdkCredentials(project, false)), pathMappingSettings, !NodeJSRemoteInterpreterManagerImpl.notMappedInternally(data));
                if (nodeRemoteTransferImpl != null) break block4;
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(29);
        }
        return nodeRemoteTransferImpl;
    }

    @Nullable
    public String chooseRemoteFile(Project project, @NotNull String interpreterId, boolean foldersOnly) throws InterruptedException, ExecutionException {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(30);
        }
        return this.chooseRemoteFile(project, this.getRemoteSdkAdditionalData(project, interpreterId), foldersOnly);
    }

    @Nullable
    public String chooseRemoteFile(Project project, @NotNull RemoteSdkAdditionalData data, boolean foldersOnly) throws ExecutionException, InterruptedException {
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(31);
        }
        return RemoteSdkUtil.chooseRemoteFile((Project)project, (RemoteCredentials)data.getRemoteSdkCredentials(project, false), (boolean)foldersOnly);
    }

    public void deleteRemoteInterpreter(String id) {
        this.myInterpreters.delete(id);
    }

    public String editRemoteInterpreter(Project project, String id) {
        List<String> interpreters = this.getRemoteInterpreters();
        interpreters.remove(id);
        NodeJSRemoteSdkAdditionalData existing = this.getRemoteSdkAdditionalDataImpl(id);
        if (existing == null) {
            return null;
        }
        CredentialsType credentialsType = existing.connectionCredentials().getRemoteConnectionType();
        if (!RemoteSdkUtil.isCredentialsTypeSupportedForLanguage((CredentialsType)credentialsType, NodeJSCredentialsContribution.class)) {
            RemoteSdkUtil.showCannotLoadCredentialsErrorDialog((Project)project, (String)id, (CredentialsType)credentialsType);
            return null;
        }
        CreateRemoteNodeJSInterpreterDialog dialog = new CreateRemoteNodeJSInterpreterDialog(project);
        dialog.setExistingSdks(interpreters);
        if (!dialog.reset(existing)) {
            Disposer.dispose((Disposable)dialog.getDisposable());
            return null;
        }
        if (dialog.showAndGet()) {
            NodeJSRemoteSdkAdditionalData data = dialog.getData();
            this.myInterpreters.delete(existing.getSdkId());
            this.myInterpreters.add(data);
            return data.getSdkId();
        }
        return null;
    }

    public Pair<TextFieldWithBrowseButton, Consumer<NodeJsInterpreter>> createRemoteMappingsField(@NotNull Project project, @NotNull Disposable disposable, @NotNull Consumer<String> errorConsumer) {
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(32);
        }
        if (disposable == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(33);
        }
        if (errorConsumer == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(34);
        }
        RemoteMappingsField field = new RemoteMappingsField(project, NODE_JS, errorConsumer, disposable){

            @NotNull
            public JComponent getDescriptionComponent(@NotNull String serverId) {
                if (serverId == null) {
                    3.$$$reportNull$$$0(0);
                }
                JEditorPane jEditorPane = SwingHelper.createHtmlLabel((String)("<a href=\"#\">Path mappings</a> <font style=\"color:#" + Integer.toHexString(UIUtil.getInactiveTextColor().getRGB()).substring(2) + "\">for Run/Debug Configurations on " + serverId + "</font>"), null, s -> HelpManager.getInstance().invokeHelp("remote.mappings"));
                if (jEditorPane == null) {
                    3.$$$reportNull$$$0(1);
                }
                return jEditorPane;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescriptionComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDescriptionComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Consumer changesListener = interpreter -> {
            NodeJsRemoteInterpreter remoteInterpreter;
            if (project == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(35);
            }
            if (errorConsumer == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(36);
            }
            if ((remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter)) != null) {
                try {
                    RemoteSdkAdditionalData data = this.getRemoteSdkAdditionalData(project, remoteInterpreter.getRemoteUrl());
                    CredentialsType type = data.getRemoteConnectionType();
                    if (type instanceof CredentialsTypeEx && !((CredentialsTypeEx)type).isBrowsingAvailable()) {
                        field.clearAndHide();
                        return;
                    }
                    if (data.connectionCredentials() != null) {
                        field.updateServerId(data.connectionCredentials().getId(), data);
                    }
                }
                catch (ExecutionException e) {
                    errorConsumer.consume((Object)e.getMessage());
                }
            } else {
                field.clearAndHide();
            }
        };
        return Pair.create((Object)field.getField(), (Object)changesListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 10: 
            case 14: 
            case 23: 
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsByInterpreter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkAdditionalData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDeploymentExists";
                break;
            }
            case 13: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "remoteInterpreterNotFound";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setupMappings";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersionCached";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsByInterpreter";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkAdditionalDataImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "remoteInterpreterNotFound";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupMappings";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notMappedInternally";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFileTransfer";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFile";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteMappingsField";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRemoteMappingsField$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

