/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRemoteTransferImpl
extends RemoteTransfer
implements NodeFileTransfer {
    private final PathMappingSettings myPathMappingSettings;
    private final boolean myHasInternalMapping;

    protected NodeRemoteTransferImpl(@Nullable Project project, @Nullable Component component, @NotNull RemoteTransfer.HelpersTransferConfig helpersTransferConfig, PathMappingSettings pathMappingSettings, boolean hasInternalMapping) {
        if (helpersTransferConfig == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(0);
        }
        super(project, component, helpersTransferConfig);
        this.myPathMappingSettings = pathMappingSettings;
        this.myHasInternalMapping = hasInternalMapping;
    }

    public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
        if (remoteWorkingDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(1);
        }
        return (List)NodeRemoteTransferImpl.withHelper(this, "ListRemoteDir", "Preparing remote profiling context", helper -> {
            if (remoteWorkingDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(41);
            }
            return new Worker((Helper)helper).listDirectoryContents(remoteWorkingDir);
        });
    }

    public void copy(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(2);
        }
        if (names == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(3);
        }
        if (targetDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(4);
        }
        NodeRemoteTransferImpl.withHelper(this, "Copy Files", "Copy files", helper -> {
            if (sourceDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(38);
            }
            if (names == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(39);
            }
            if (targetDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(40);
            }
            new Worker((Helper)helper).copy(sourceDir, names, targetDir);
            return true;
        });
    }

    public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(5);
        }
        if (names == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(6);
        }
        if (targetDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(7);
        }
        NodeRemoteTransferImpl.withHelper(this, "Fetch Files from Remote", "Fetching files from remote", helper -> {
            if (sourceDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(35);
            }
            if (names == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(36);
            }
            if (targetDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(37);
            }
            new Worker((Helper)helper).fetch(sourceDir, names, targetDir);
            return true;
        });
    }

    public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
        if (sourcePath == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(8);
        }
        if (targetPath == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(9);
        }
        NodeRemoteTransferImpl.withHelper(this, "Fetch Files from Remote", "Fetching files from remote", helper -> {
            if (sourcePath == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(33);
            }
            if (targetPath == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(34);
            }
            new Worker((Helper)helper).fetch(sourcePath, targetPath);
            return true;
        });
    }

    public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
        if (remoteDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(10);
        }
        return (String)NodeRemoteTransferImpl.withHelper(this, "CopyProxy", "Copying file", helper -> {
            if (remoteDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(32);
            }
            return new Worker((Helper)helper).copyToRemoteTmpFile(remoteDir, localFileName, content);
        });
    }

    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(11);
        }
        return NodeRemoteTransferImpl.getMappingsStatic(localPath, this.myPathMappingSettings);
    }

    @NotNull
    private static FileObject createRemoteTmpFile(RemoteTransfer.RemoteSdkExecutionContext context, @NotNull String remoteDir, String localFileName) throws FileSystemException {
        FileObject remoteFile;
        if (remoteDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(12);
        }
        if ((remoteFile = context.findRemoteFile(new WebServerConfig.RemotePath(remoteDir + "/" + localFileName), false)).exists()) {
            for (int i = 0; i < 1000; ++i) {
                remoteFile = context.findRemoteFile(new WebServerConfig.RemotePath(remoteDir + "/" + i + localFileName), false);
                if (remoteFile.exists()) continue;
                FileObject fileObject = remoteFile;
                if (fileObject == null) {
                    NodeRemoteTransferImpl.$$$reportNull$$$0(13);
                }
                return fileObject;
            }
            throw new FileSystemException("Was not able to find path for remote temp file");
        }
        FileObject fileObject = remoteFile;
        if (fileObject == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(14);
        }
        return fileObject;
    }

    public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
        if (remoteDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(15);
        }
        return (String)NodeRemoteTransferImpl.withHelper(this, "FindTempPath", "Finding path for temp file", helper -> {
            if (remoteDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(31);
            }
            return new Worker((Helper)helper).getPathForTempFile(remoteDir, localFileName);
        });
    }

    public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
        if (title == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(17);
        }
        NodeRemoteTransferImpl.withHelper(this, title, title, helper -> {
            if (consumer == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(30);
            }
            consumer.consume((Object)new Worker((Helper)helper));
            return true;
        });
    }

    public void deleteRemote(@NotNull String path) throws IOException {
        if (path == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(18);
        }
        NodeRemoteTransferImpl.withHelper(this, "DeleteFile", "Delete file", helper -> {
            if (path == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(29);
            }
            new Worker((Helper)helper).deleteRemote(path);
            return true;
        });
    }

    public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
        if (dir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(19);
        }
        if (set == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(20);
        }
        NodeRemoteTransferImpl.withHelper(this, "DeleteFiles", "Delete files", helper -> {
            if (dir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(27);
            }
            if (set == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(28);
            }
            new Worker((Helper)helper).delete(dir, set);
            return true;
        });
    }

    public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
        if (remoteDir == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(21);
        }
        return (Boolean)NodeRemoteTransferImpl.withHelper(this, "CreateFolder", "Create folder", helper -> {
            if (remoteDir == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(26);
            }
            return new Worker((Helper)helper).mkDir(remoteDir, name);
        });
    }

    public boolean hasInternalMapping() {
        return this.myHasInternalMapping;
    }

    public boolean isLocal() {
        return false;
    }

    private static <T> T withHelper(NodeRemoteTransferImpl transfer, String name, String title, @NotNull ThrowableConvertor<Helper, T, IOException> consumer) throws IOException {
        if (consumer == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(22);
        }
        Helper helper = new Helper(transfer, name, title);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return (T)consumer.convert((Object)helper);
        }
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (consumer == null) {
                NodeRemoteTransferImpl.$$$reportNull$$$0(25);
            }
            return consumer.convert((Object)helper);
        }, title, true, transfer.getProject());
    }

    @NotNull
    private static String getMappingsStatic(@NotNull String localPath, PathMappingSettings mappings) throws ExecutionException {
        if (localPath == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(23);
        }
        if (!mappings.canReplaceLocal(localPath)) {
            throw new ExecutionException("Can not find mapping for " + localPath);
        }
        String string = mappings.convertToRemote(localPath);
        if (string == null) {
            NodeRemoteTransferImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersTransferConfig";
                break;
            }
            case 1: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteWorkingDir";
                break;
            }
            case 2: 
            case 5: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDir";
                break;
            }
            case 3: 
            case 6: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: 
            case 7: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 9: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 26: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteDir";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: 
            case 22: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteTmpFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsStatic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "listDirectoryContents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyToRemoteTmpFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteTmpFile";
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPathForTempFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "grouped";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemote";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mkDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withHelper";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsStatic";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$withHelper$10";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mkDir$9";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$delete$8";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deleteRemote$7";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$grouped$6";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPathForTempFile$5";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyToRemoteTmpFile$4";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetch$3";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetch$2";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copy$1";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$listDirectoryContents$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Helper {
        private final RemoteConnection myConnection;
        private final CredentialsDeployable myDeployable;
        private final NodeRemoteTransferImpl myTransfer;
        private ProgressIndicator myIndicator;

        private Helper(NodeRemoteTransferImpl transfer, String name, String title) throws FileSystemException {
            this.myTransfer = transfer;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            this.myDeployable = new CredentialsDeployable();
            this.myDeployable.setId(name + this.myDeployable.toString());
            transfer.getHelpersTransferConfig().createFileTransferConfig(this.myDeployable);
            this.myConnection = transfer.openConnection(title, (Deployable)this.myDeployable, indicator);
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            this.myIndicator = this.myIndicator == null ? new EmptyProgressIndicator() : this.myIndicator;
        }

        public RemoteConnection getConnection() {
            return this.myConnection;
        }

        public RemoteTransfer.RemoteSdkExecutionContext createContext() {
            return this.myTransfer.getRemoteSdkExecutionContext(this.myIndicator, this.myConnection, (Deployable)this.myDeployable);
        }

        public ProgressIndicator getIndicator() {
            return this.myIndicator;
        }

        public PathMappingSettings getPathMappings() {
            return this.myTransfer.myPathMappingSettings;
        }
    }

    private static class Worker
    implements NodeFileTransfer {
        private final Helper myHelper;

        private Worker(Helper helper) {
            this.myHelper = helper;
        }

        public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
            if (title == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                Worker.$$$reportNull$$$0(1);
            }
            consumer.consume((Object)this);
        }

        public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
            if (remoteWorkingDir == null) {
                Worker.$$$reportNull$$$0(2);
            }
            RemoteConnection connection = this.myHelper.getConnection();
            FileObject workingDirObj = connection.resolveFile(remoteWorkingDir);
            workingDirObj.refresh();
            Object[] children = workingDirObj.getChildren();
            return ContainerUtil.map((Object[])children, (Function)((NotNullFunction)object -> object.getName().getBaseName()));
        }

        public void copy(@NotNull String sourceDir, final @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
            if (sourceDir == null) {
                Worker.$$$reportNull$$$0(3);
            }
            if (names == null) {
                Worker.$$$reportNull$$$0(4);
            }
            if (targetDir == null) {
                Worker.$$$reportNull$$$0(5);
            }
            RemoteConnection connection = this.myHelper.getConnection();
            final FileObject sourceObject = connection.resolveFile(sourceDir);
            FileObject targetObject = connection.resolveFile(targetDir);
            targetObject.copyFrom(sourceObject, new FileSelector(){

                public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                    return names.contains(fileInfo.getFile().getName().getBaseName());
                }

                public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                    return fileInfo.getFile().getName().getPath().equals(sourceObject.getName().getPath());
                }
            });
        }

        public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
            if (sourceDir == null) {
                Worker.$$$reportNull$$$0(6);
            }
            if (names == null) {
                Worker.$$$reportNull$$$0(7);
            }
            if (targetDir == null) {
                Worker.$$$reportNull$$$0(8);
            }
            RemoteConnection connection = this.myHelper.getConnection();
            FileObject sourceObject = connection.resolveFile(sourceDir);
            sourceObject.refresh();
            String verifiedDir = targetDir.endsWith("/") || targetDir.endsWith("\\") ? targetDir.substring(0, targetDir.length() - 1) : targetDir;
            ArrayList operations = Lists.newArrayList();
            for (String name : names) {
                FileObject remote = sourceObject.resolveFile(name);
                FileObject local = DeploymentPathUtils.getLocalFile((String)(verifiedDir + File.separator + name));
                operations.add(new TransferOperation.Copy(remote, local));
            }
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            context.setServerSideModification(false);
            RemoteTransfer.executeOperationsBatch((ProgressIndicator)this.myHelper.getIndicator(), (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
        }

        public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
            FileObject sourceObject;
            if (sourcePath == null) {
                Worker.$$$reportNull$$$0(9);
            }
            if (targetPath == null) {
                Worker.$$$reportNull$$$0(10);
            }
            RemoteConnection connection = this.myHelper.getConnection();
            int dirIdx = sourcePath.replace('\\', '/').lastIndexOf(47);
            if (dirIdx > 0) {
                FileObject dir = connection.resolveFile(sourcePath.substring(0, dirIdx));
                dir.refresh();
            }
            if (!(sourceObject = connection.resolveFile(sourcePath)).exists()) {
                sourceObject.refresh();
            }
            ArrayList operations = Lists.newArrayList();
            operations.add(new TransferOperation.Copy(sourceObject, DeploymentPathUtils.getLocalFile((String)targetPath)));
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            context.setServerSideModification(false);
            RemoteTransfer.executeOperationsBatch((ProgressIndicator)this.myHelper.getIndicator(), (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
        }

        public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
            if (remoteDir == null) {
                Worker.$$$reportNull$$$0(11);
            }
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            context.setServerSideModification(true);
            FileObject remoteFile = NodeRemoteTransferImpl.createRemoteTmpFile(context, remoteDir, localFileName);
            new TransferOperation.CreateRemoteFile(content, remoteFile).execute((ExecutionContext)context);
            return remoteFile.getName().getPath();
        }

        public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
            if (remoteDir == null) {
                Worker.$$$reportNull$$$0(12);
            }
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            return NodeRemoteTransferImpl.createRemoteTmpFile(context, remoteDir, localFileName).getName().getPath();
        }

        public void deleteRemote(@NotNull String path) throws IOException {
            FileObject object;
            if (path == null) {
                Worker.$$$reportNull$$$0(13);
            }
            RemoteConnection connection = this.myHelper.getConnection();
            try {
                object = connection.resolveFile(path);
            }
            catch (FileSystemException e) {
                return;
            }
            object.delete();
        }

        public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
            FileObject object;
            if (dir == null) {
                Worker.$$$reportNull$$$0(14);
            }
            if (set == null) {
                Worker.$$$reportNull$$$0(15);
            }
            RemoteConnection connection = this.myHelper.getConnection();
            try {
                object = connection.resolveFile(dir);
            }
            catch (FileSystemException e) {
                return;
            }
            for (String name : set) {
                FileObject child;
                try {
                    child = object.resolveFile(name);
                }
                catch (FileSystemException e) {
                    continue;
                }
                child.delete();
            }
        }

        public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
            if (remoteDir == null) {
                Worker.$$$reportNull$$$0(16);
            }
            WebServerConfig.RemotePath path = new WebServerConfig.RemotePath(remoteDir + "/" + name);
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            FileObject remoteFile = context.findRemoteFile(path, false);
            if (remoteFile.exists()) {
                return true;
            }
            remoteFile.createFolder();
            return true;
        }

        public boolean isLocal() {
            return false;
        }

        public String getMappingFor(@NotNull String localPath) throws ExecutionException {
            if (localPath == null) {
                Worker.$$$reportNull$$$0(17);
            }
            PathMappingSettings mappings = this.myHelper.getPathMappings();
            return NodeRemoteTransferImpl.getMappingsStatic(localPath, mappings);
        }

        public boolean hasInternalMapping() {
            return this.myHelper.myTransfer.hasInternalMapping();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteWorkingDir";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceDir";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetDir";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePath";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPath";
                    break;
                }
                case 11: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteDir";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "grouped";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "listDirectoryContents";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "copy";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetch";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "copyToRemoteTmpFile";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathForTempFile";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteRemote";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delete";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mkDir";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMappingFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

