/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeJSRemoteInterpreters", storages={@Storage(value="nodeJsRemoteInterpreters.xml"), @Storage(value="other.xml", deprecated=true)})
public class RemoteInterpreters
implements PersistentStateComponent<Element> {
    @NonNls
    public static final String INTERPRETER_PATH = "node-remote-interpreter";
    private final List<NodeJSRemoteSdkAdditionalData> myInterpreters;
    private final Object myLock = new Object();

    public RemoteInterpreters() {
        this.myInterpreters = new ArrayList<NodeJSRemoteSdkAdditionalData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        List children;
        if (state == null) {
            RemoteInterpreters.$$$reportNull$$$0(0);
        }
        if ((children = state.getChildren()) != null) {
            ArrayList<NodeJSRemoteSdkAdditionalData> list = new ArrayList<NodeJSRemoteSdkAdditionalData>();
            for (Element child : children) {
                String path = child.getAttributeValue(INTERPRETER_PATH);
                if (path == null) continue;
                list.add(NodeJSRemoteSdkAdditionalData.load((Element)child, (String)path));
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myInterpreters.clear();
                this.myInterpreters.addAll(list);
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInterpreters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ArrayList<NodeJSRemoteSdkAdditionalData> interpreters;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInterpreters.isEmpty()) {
                return new Element("node-remote-interpreters");
            }
            interpreters = new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters);
        }
        Element rootElement = new Element("node-remote-interpreters");
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            Element element = new Element("interpreter");
            rootElement.addContent(element);
            element.setAttribute(INTERPRETER_PATH, interpreter.getSdkId());
            interpreter.save(element);
        }
        return rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myInterpreters.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeJSRemoteSdkAdditionalData> getInterpreters() {
        Object object = this.myLock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            RemoteInterpreters.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInterpreters.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(@NotNull String id) {
        if (id == null) {
            RemoteInterpreters.$$$reportNull$$$0(2);
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)id);
        Object object = this.myLock;
        synchronized (object) {
            Iterator<NodeJSRemoteSdkAdditionalData> iterator = this.myInterpreters.iterator();
            while (iterator.hasNext()) {
                NodeJSRemoteSdkAdditionalData data = iterator.next();
                if (!Comparing.equal((String)FileUtil.toSystemIndependentName((String)data.getSdkId()), (String)systemIndependentId)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/remote/RemoteInterpreters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

