/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.remote.docker.NodeJSDockerUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRunDockerContainerSettingsEditor<P extends NodeJsRunConfiguration>
extends SettingsEditor<P> {
    @NotNull
    private final Project myProject;
    private TextFieldWithBrowseButton myDockerContainerSettingsField;
    private JBLabel mySettingsLabel;
    private DockerContainerSettings myContainerSettings;
    private RemoteServer<?> myCurrentServer;
    private JBCheckBox myGenerateCheckbox;
    private JBLabel myExplainingImageLabel;

    public NodeJSRunDockerContainerSettingsEditor(P configuration, Consumer<NodeJsInterpreterChangeListener> registrar) {
        this.myProject = configuration.getProject();
        registrar.consume((Object)new NodeJsInterpreterChangeListener(){

            public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                if (newInterpreter == null) {
                    NodeJSRunDockerContainerSettingsEditor.this.setEnabled(false);
                    return;
                }
                NodeJSRunDockerContainerSettingsEditor.this.resetFromData(newInterpreter.getOldPath());
            }
        });
        this.myContainerSettings = NodeJSRunDockerContainerSettingsEditor.createSettings();
    }

    protected void resetEditorFrom(@NotNull P configuration) {
        if (configuration == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(0);
        }
        DockerContainerSettings data = (DockerContainerSettings)configuration.getCopyableUserData(DockerContainerSettings.KEY);
        Boolean generateImage = (Boolean)configuration.getCopyableUserData(NodeJSDockerUtil.GENERATE_IMAGE);
        this.myGenerateCheckbox.setSelected(Boolean.TRUE.equals(generateImage));
        DockerContainerSettings dockerContainerSettings = this.myContainerSettings = data == null ? NodeJSRunDockerContainerSettingsEditor.createSettings() : data.clone();
        if (Boolean.TRUE.equals(generateImage)) {
            this.addHardcodedMappings();
        }
        this.resetFromData(configuration.getRawExePath());
    }

    @NotNull
    private static DockerContainerSettings createSettings() {
        DockerContainerSettings settings = new DockerContainerSettings();
        settings.setVersion(1);
        DockerContainerSettings dockerContainerSettings = settings;
        if (dockerContainerSettings == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(1);
        }
        return dockerContainerSettings;
    }

    private void addHardcodedMappings() {
        for (DockerVolumeBindingImpl binding : this.myContainerSettings.getVolumeBindings()) {
            if (binding.isEditable()) continue;
            return;
        }
        DockerVolumeBindingImpl binding = NodeJSRunDockerContainerSettingsEditor.createHardcodedBinding(this.myProject);
        this.myContainerSettings.getVolumeBindings().add(binding);
    }

    @NotNull
    public static DockerVolumeBindingImpl createHardcodedBinding(@NotNull Project project) {
        if (project == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(2);
        }
        DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl();
        binding.setHostPath(FileUtil.toSystemDependentName((String)project.getBasePath()));
        binding.setContainerPath("/opt/project");
        binding.setEditable(false);
        DockerVolumeBindingImpl dockerVolumeBindingImpl = binding;
        if (dockerVolumeBindingImpl == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(3);
        }
        return dockerVolumeBindingImpl;
    }

    private void resetFromData(String rawExePath) {
        this.myCurrentServer = this.tryGetServer(rawExePath);
        if (this.myCurrentServer == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.myDockerContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)this.myContainerSettings));
        }
    }

    private void setEnabled(boolean flag) {
        this.mySettingsLabel.setVisible(flag);
        this.myDockerContainerSettingsField.setVisible(flag);
        this.myGenerateCheckbox.setVisible(flag);
        this.myExplainingImageLabel.setVisible(flag);
    }

    @Nullable
    private RemoteServer<?> tryGetServer(String rawExePath) {
        NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
        assert (manager != null);
        try {
            String accountName;
            RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(this.myProject, rawExePath);
            DockerCredentialsHolder credentials = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)data);
            if (credentials != null && StringUtil.isNotEmpty((String)(accountName = credentials.getAccountName()))) {
                return RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
            }
        }
        catch (ExecutionException e) {
            return null;
        }
        return null;
    }

    protected void applyEditorTo(@NotNull P configuration) throws ConfigurationException {
        if (configuration == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(4);
        }
        configuration.putCopyableUserData(DockerContainerSettings.KEY, (Object)this.filterOutHardcodedMappings());
        configuration.putCopyableUserData(NodeJSDockerUtil.GENERATE_IMAGE, (Object)this.myGenerateCheckbox.isSelected());
    }

    @NotNull
    private DockerContainerSettings filterOutHardcodedMappings() {
        DockerContainerSettings copy = NodeJSRunDockerContainerSettingsEditor.createSettings();
        this.myContainerSettings.copyTo(copy);
        Iterator iterator = copy.getVolumeBindings().iterator();
        while (iterator.hasNext()) {
            DockerVolumeBindingImpl next = (DockerVolumeBindingImpl)iterator.next();
            if (next.isEditable()) continue;
            iterator.remove();
        }
        DockerContainerSettings dockerContainerSettings = copy;
        if (dockerContainerSettings == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(5);
        }
        return dockerContainerSettings;
    }

    @NotNull
    protected JComponent createEditor() {
        NodeJSRemoteInterpreterManager remoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();
        this.myGenerateCheckbox = new JBCheckBox("Auto configure");
        String commentText = "Inside Docker container: install packages from package.json, map sources to volume";
        this.myGenerateCheckbox.setToolTipText("Inside Docker container: install packages from package.json, map sources to volume");
        this.myGenerateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NodeJSRunDockerContainerSettingsEditor.this.myGenerateCheckbox.isSelected()) {
                    NodeJSRunDockerContainerSettingsEditor.this.myContainerSettings = NodeJSRunDockerContainerSettingsEditor.this.filterOutHardcodedMappings();
                } else {
                    NodeJSRunDockerContainerSettingsEditor.this.addHardcodedMappings();
                }
                NodeJSRunDockerContainerSettingsEditor.this.myDockerContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)NodeJSRunDockerContainerSettingsEditor.this.myContainerSettings));
            }
        });
        this.myExplainingImageLabel = new JBLabel("Inside Docker container: install packages from package.json, map sources to volume");
        this.myExplainingImageLabel.setForeground(UIUtil.getInactiveTextColor());
        this.myExplainingImageLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)5, (int)0));
        this.mySettingsLabel = new JBLabel("Docker container settings:");
        assert (remoteInterpreterManager != null);
        this.myDockerContainerSettingsField = new TextFieldWithBrowseButton();
        this.myDockerContainerSettingsField.getTextField().setEditable(false);
        this.myDockerContainerSettingsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerContainerSettings clone = NodeJSRunDockerContainerSettingsEditor.this.myContainerSettings.clone();
                DockerInterpreterContainerSettingsEditorDialog myDialog = new DockerInterpreterContainerSettingsEditorDialog(NodeJSRunDockerContainerSettingsEditor.this.myProject, NodeJSRunDockerContainerSettingsEditor.this.myCurrentServer, clone);
                if (myDialog.showAndGet()) {
                    NodeJSRunDockerContainerSettingsEditor.this.myContainerSettings = clone;
                    NodeJSRunDockerContainerSettingsEditor.this.myDockerContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)NodeJSRunDockerContainerSettingsEditor.this.myContainerSettings));
                }
            }
        });
        FormBuilder builder = new FormBuilder();
        builder.addLabeledComponent((JComponent)this.mySettingsLabel, (JComponent)this.myDockerContainerSettingsField);
        builder.addComponent((JComponent)this.myGenerateCheckbox);
        builder.addComponent((JComponent)this.myExplainingImageLabel);
        JPanel jPanel = builder.getPanel();
        if (jPanel == null) {
            NodeJSRunDockerContainerSettingsEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/docker/NodeJSRunDockerContainerSettingsEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/docker/NodeJSRunDockerContainerSettingsEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardcodedBinding";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutHardcodedMappings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHardcodedBinding";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

