/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(RemoteTransfer.class);
    @NonNls
    private static final String VERSION_FILE = "build.txt";
    private static final Function<String, VirtualFile> PATH_TO_VFILE = path -> LocalFileSystem.getInstance().findFileByPath(path);
    @Nullable
    private final Project myProject;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    @Nullable
    private final RemoteSdkCredentials myRemoteSdkCredentials;
    @NotNull
    private final HelpersTransferConfig myHelpersTransferConfig;
    private boolean myTransferTaskModal;

    private RemoteTransfer(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull HelpersTransferConfig helpersTransferConfig, @Nullable RemoteSdkCredentials remoteSdkCredentials) {
        if (connectionOwner == null) {
            RemoteTransfer.$$$reportNull$$$0(0);
        }
        if (helpersTransferConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(1);
        }
        this.myTransferTaskModal = true;
        this.myProject = project;
        this.myConnectionOwner = connectionOwner;
        this.myRemoteSdkCredentials = remoteSdkCredentials;
        this.myHelpersTransferConfig = helpersTransferConfig;
    }

    @Deprecated
    protected RemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials remoteSdkCredentials) {
        if (remoteSdkCredentials == null) {
            RemoteTransfer.$$$reportNull$$$0(2);
        }
        this(project, ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project, (Component)component), RemoteSdkUtil.newHelpersTransferConfigFromRemoteCredentials(remoteSdkCredentials), remoteSdkCredentials);
    }

    protected RemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull HelpersTransferConfig helpersTransferConfig) {
        if (helpersTransferConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(3);
        }
        this(project, ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project, (Component)component), helpersTransferConfig, null);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Deprecated
    @NotNull
    public RemoteSdkCredentials getRemoteSdkCredentials() {
        if (this.myRemoteSdkCredentials == null) {
            throw new IllegalStateException("Remote SDK credentials are absent");
        }
        RemoteSdkCredentials remoteSdkCredentials = this.myRemoteSdkCredentials;
        if (remoteSdkCredentials == null) {
            RemoteTransfer.$$$reportNull$$$0(4);
        }
        return remoteSdkCredentials;
    }

    @NotNull
    public HelpersTransferConfig getHelpersTransferConfig() {
        HelpersTransferConfig helpersTransferConfig = this.myHelpersTransferConfig;
        if (helpersTransferConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(5);
        }
        return helpersTransferConfig;
    }

    protected void uploadHelpers(boolean uploadOnSnapshot, @NotNull Collection<String> helpersPaths, @NotNull String remoteHelperPath, @NotNull String title) {
        if (helpersPaths == null) {
            RemoteTransfer.$$$reportNull$$$0(6);
        }
        if (remoteHelperPath == null) {
            RemoteTransfer.$$$reportNull$$$0(7);
        }
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(8);
        }
        this.uploadHelpers(uploadOnSnapshot, helpersPaths, remoteHelperPath, title, false);
    }

    protected void uploadHelpers(boolean uploadOnSnapshot, @NotNull Collection<String> helpersPaths, @NotNull String remoteHelperPath, @NotNull String title, boolean cancellable) {
        if (helpersPaths == null) {
            RemoteTransfer.$$$reportNull$$$0(9);
        }
        if (remoteHelperPath == null) {
            RemoteTransfer.$$$reportNull$$$0(10);
        }
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(11);
        }
        if (this.myHelpersTransferConfig.isHelpersVersionChecked() && !uploadOnSnapshot) {
            return;
        }
        LOG.info("Uploading helpers to " + remoteHelperPath);
        Task process2 = this.createTask(this.myProject, title, cancellable, indicator -> {
            if (title == null) {
                RemoteTransfer.$$$reportNull$$$0(31);
            }
            if (helpersPaths == null) {
                RemoteTransfer.$$$reportNull$$$0(32);
            }
            if (remoteHelperPath == null) {
                RemoteTransfer.$$$reportNull$$$0(33);
            }
            this.doCopyHelpers(indicator, title, uploadOnSnapshot, helpersPaths, remoteHelperPath);
        });
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run(process2));
        } else {
            process2.run(ProgressManager.getInstance().getProgressIndicator());
        }
    }

    @NotNull
    protected Task createTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, final @NotNull Progressive progressive) {
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(12);
        }
        if (progressive == null) {
            RemoteTransfer.$$$reportNull$$$0(13);
        }
        if (this.isTransferTaskModal()) {
            Task.Modal modal = new Task.Modal(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    progressive.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$1", "run"));
                }
            };
            if (modal == null) {
                RemoteTransfer.$$$reportNull$$$0(14);
            }
            return modal;
        }
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, title, canBeCancelled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                progressive.run(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$2", "run"));
            }
        };
        if (backgroundable == null) {
            RemoteTransfer.$$$reportNull$$$0(15);
        }
        return backgroundable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyHelpers(ProgressIndicator indicator, String title, boolean uploadOnSnapshot, Collection<String> helpersPaths, String remoteHelperPath) {
        CredentialsDeployable deployable = new CredentialsDeployable((RemoteCredentials)new RemoteCredentialsHolder());
        deployable.setId("UploadHelpers" + deployable.toString());
        this.myHelpersTransferConfig.createFileTransferConfig(deployable);
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        RemoteConnection connection = null;
        try {
            indicator.setFraction(0.0);
            connection = this.openConnection(title, (Deployable)deployable, indicator);
            RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
            context.setPromptForOverwrite(true);
            if (RemoteTransfer.helpersUpdateNeeded(indicator, connection, this.getHelpersTransferConfig().getHelpersPath(), uploadOnSnapshot)) {
                context.getConfig().setPathMappings(deployable.getId(), RemoteTransfer.createMapping(helpersPaths, remoteHelperPath));
                context.getConfig().setExcludedPaths(deployable.getId(), this.getExcludedHelpersPaths(helpersPaths));
                try {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles((ExecutionContext)context, (Collection)Collections2.transform(helpersPaths, PATH_TO_VFILE));
                    ArrayList operations = Lists.newArrayList((Iterable)resultWithErrors.operations);
                    TransferOperation copyVersion = RemoteTransfer.writeHelpersVersion(connection, this.getHelpersTransferConfig().getHelpersPath());
                    if (copyVersion != null) {
                        operations.add(copyVersion);
                    }
                    RemoteTransfer.executeOperationsBatch(indicator, context, operations);
                }
                catch (ProcessCanceledException cancelled) {
                    throw cancelled;
                }
                catch (Exception e) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        LOG.error("Can't copy helpers", (Throwable)e);
                        Messages.showErrorDialog((String)e.getMessage(), (String)"Error Copying Helpers");
                    });
                }
            }
            LOG.info("Helpers upload successfully completed");
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        this.myHelpersTransferConfig.setHelpersVersionChecked(true);
        snapshot.logResponsivenessSinceCreation("Helpers uploaded");
    }

    protected final RemoteConnection openConnection(@NotNull String title, @NotNull Deployable webServerConfig, @Nullable ProgressIndicator indicator) throws FileSystemException {
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(16);
        }
        if (webServerConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(17);
        }
        return RemoteConnectionManager.getInstance().openConnection(this.myConnectionOwner, title, (Connectable)webServerConfig, FileTransferConfig.Origin.Default, null, indicator);
    }

    protected RemoteSdkExecutionContext getRemoteSdkExecutionContext(ProgressIndicator indicator, RemoteConnection connection, Deployable deployable) {
        return new RemoteSdkExecutionContext(this.myProject, indicator, deployable, connection);
    }

    private static boolean helpersUpdateNeeded(@NotNull ProgressIndicator indicator, @NotNull RemoteConnection connection, @NotNull String helpersPath, boolean updateOnSnapshot) throws FileSystemException {
        if (indicator == null) {
            RemoteTransfer.$$$reportNull$$$0(18);
        }
        if (connection == null) {
            RemoteTransfer.$$$reportNull$$$0(19);
        }
        if (helpersPath == null) {
            RemoteTransfer.$$$reportNull$$$0(20);
        }
        FileObject versionFile = RemoteTransfer.getVersionFileObject(connection, helpersPath);
        connection.resolveRoot().resolveFile(new RemoteFile(helpersPath, VERSION_FILE).getPath());
        try {
            String content = new String(FileTransferUtil.getContent((FileObject)versionFile, (ProgressIndicator)indicator));
            String localContent = RemoteTransfer.getLocalVersion();
            LOG.info("Remote helpers version is " + content + ", local helpers version is " + localContent);
            if (content.length() > 0) {
                return !localContent.equals(content) || localContent.endsWith(".SNAPSHOT") && updateOnSnapshot;
            }
        }
        catch (IOException e) {
            LOG.info("Failed to retrieve helpers version file", (Throwable)e);
        }
        return true;
    }

    private static String getLocalVersion() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    @Nullable
    private static TransferOperation writeHelpersVersion(@NotNull RemoteConnection connection, @NotNull String helpersPath) throws FileSystemException {
        if (connection == null) {
            RemoteTransfer.$$$reportNull$$$0(21);
        }
        if (helpersPath == null) {
            RemoteTransfer.$$$reportNull$$$0(22);
        }
        final FileObject target = RemoteTransfer.getVersionFileObject(connection, helpersPath);
        return new TransferOperation(){

            public String getProgressText(ExecutionContext context) {
                return "Writing version file";
            }

            public String getDetailedText(ExecutionContext context) {
                return "Writing to " + target.getName();
            }

            public void execute(ExecutionContext context) throws FileSystemException {
                if (!target.exists()) {
                    target.createFile();
                }
                try (PrintWriter pw = new PrintWriter(target.getContent().getOutputStream());){
                    pw.print(RemoteTransfer.getLocalVersion());
                }
            }

            public String getErrorMessage(ExecutionContext context, String reason) {
                return "Can't write helpers version";
            }

            public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
            }
        };
    }

    private static FileObject getVersionFileObject(@NotNull RemoteConnection connection, @NotNull String helpersPath) throws FileSystemException {
        if (connection == null) {
            RemoteTransfer.$$$reportNull$$$0(23);
        }
        if (helpersPath == null) {
            RemoteTransfer.$$$reportNull$$$0(24);
        }
        return connection.resolveRoot().resolveFile(helpersPath).resolveFile(VERSION_FILE);
    }

    @NotNull
    private static List<DeploymentPathMapping> createMapping(@NotNull Collection<String> paths, @NotNull String remotePath) {
        if (paths == null) {
            RemoteTransfer.$$$reportNull$$$0(25);
        }
        if (remotePath == null) {
            RemoteTransfer.$$$reportNull$$$0(26);
        }
        Collection mappings = Collections2.transform(paths, path -> {
            if (remotePath == null) {
                RemoteTransfer.$$$reportNull$$$0(30);
            }
            DeploymentPathMapping mapping = new DeploymentPathMapping();
            mapping.setLocalPath(path);
            mapping.setDeployPath(remotePath);
            return mapping;
        });
        ArrayList arrayList = Lists.newArrayList((Iterable)mappings);
        if (arrayList == null) {
            RemoteTransfer.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    public static void executeOperationsBatch(@NotNull ProgressIndicator indicator, RemoteSdkExecutionContext context, List<TransferOperation> operations) throws FileSystemException {
        if (indicator == null) {
            RemoteTransfer.$$$reportNull$$$0(28);
        }
        int complete = 0;
        for (TransferOperation operation : operations) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(operation.getProgressText((ExecutionContext)context));
            operation.execute((ExecutionContext)context);
            indicator.setFraction((double)(++complete) / (double)operations.size());
        }
    }

    @NotNull
    protected String[] getAdditionalExcludePatterns() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            RemoteTransfer.$$$reportNull$$$0(29);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean isTransferTaskModal() {
        return this.myTransferTaskModal;
    }

    public void setTransferTaskModal(boolean transferTaskModal) {
        this.myTransferTaskModal = transferTaskModal;
    }

    protected List<ExcludedPath> getExcludedHelpersPaths(Collection<String> helpersPaths) {
        return Lists.newArrayList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersTransferConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkCredentials";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteTransfer";
                break;
            }
            case 6: 
            case 9: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPaths";
                break;
            }
            case 7: 
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHelperPath";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressive";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerConfig";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteTransfer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkCredentials";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersTransferConfig";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapping";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalExcludePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 27: 
            case 29: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpers";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "openConnection";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "helpersUpdateNeeded";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeHelpersVersion";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFileObject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "executeOperationsBatch";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createMapping$4";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadHelpers$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HelpersTransferConfig {
        @NotNull
        public String getHelpersPath();

        public void createFileTransferConfig(@NotNull CredentialsDeployable var1);

        public boolean isHelpersVersionChecked();

        public void setHelpersVersionChecked(boolean var1);
    }

    protected final class RemoteSdkExecutionContext
    implements ExecutionContext {
        @Nullable
        private final Project myProject;
        private final ProgressIndicator myProgressIndicator;
        private final PublishConfig myPublishConfig;
        private final Deployable myWebServerConfig;
        private final RemoteConnection myConnection;
        private Boolean myPromptForOverwrite = null;
        private boolean myServerSideModification = true;

        private RemoteSdkExecutionContext(Project project, ProgressIndicator progressIndicator, Deployable webServerConfig, RemoteConnection connection) {
            this.myProject = project;
            this.myProgressIndicator = progressIndicator;
            this.myWebServerConfig = webServerConfig;
            this.myConnection = connection;
            this.myPublishConfig = new PublishConfig(project, UltimateVerifier.getInstance());
            this.myPublishConfig.setPromptOnRemoteOverwrite(PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP);
            this.myPublishConfig.setExcludeMask(StringUtil.join((String[])ArrayUtil.mergeArrays((String[])PublishConfig.DEFAULT_EXCLUDES, (String[])RemoteTransfer.this.getAdditionalExcludePatterns()), (String)";"));
        }

        public PublishConfig getConfig() {
            return this.myPublishConfig;
        }

        public void incCounter(String counterTitle) {
        }

        public void incBytesTransmitted(long bytes) {
        }

        public void console(String message, ConsoleViewContentType type) {
        }

        public boolean isMultipleOperations() {
            return true;
        }

        public void showBalloon(String message, MessageType type) {
        }

        public void setPromptForOverwrite(boolean promptForOverwrite) {
            this.myPromptForOverwrite = promptForOverwrite;
        }

        public boolean promptForOverwrite(@Nullable FileObject source, @NotNull FileObject target) throws IOException {
            if (target == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(0);
            }
            if (this.myPromptForOverwrite != null) {
                return this.myPromptForOverwrite;
            }
            return !TransferOperation.isUpToDate((FileObject)source, (FileObject)target, (Deployable)this.getServer());
        }

        public ProgressIndicator getProgressIndicator() {
            return this.myProgressIndicator;
        }

        public void addAffectedRoot(FileName fileName, boolean remote) {
        }

        public boolean isServerSideModification() {
            return this.myServerSideModification;
        }

        public void setServerSideModification(boolean serverSideModification) {
            this.myServerSideModification = serverSideModification;
        }

        public Deployable getServer() {
            return this.myWebServerConfig;
        }

        public FileObject findRemoteFile(WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
            FileObject file = PublishUtils.findFile((RemoteConnection)this.myConnection, (WebServerConfig.RemotePath)path, (Connectable)this.myWebServerConfig);
            if (refreshUpRecursively) {
                DeploymentPathUtils.refreshRemoteFile((FileObject)file, (ExecutionContextBase)this);
            } else {
                file.refresh();
            }
            return file;
        }

        public boolean isTolerateSetPermissionsErrors() {
            return true;
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        public boolean isCancellable() {
            return false;
        }

        public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
        }

        public void setCurrentFileFraction(double fraction) {
        }

        public void setIgnoreOverwritingStrategy(@NotNull IgnoreOverwritingStrategy strategy) {
            if (strategy == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(1);
            }
        }

        public DeploymentMode getDeploymentMode() {
            return DeploymentMode.CUSTOM;
        }

        public DeploymentRevisionTracker getRevisionTracker() {
            return DeploymentRevisionTracker.DEAF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteTransfer$RemoteSdkExecutionContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "promptForOverwrite";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setIgnoreOverwritingStrategy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

